/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Size2D;
import com.supermap.data.Toolkit;
import java.io.Serializable;

public class Rectangle2D
implements Serializable {
    private static final long serialVersionUID = 249971546790496737L;
    public Point2D leftBottom = new Point2D();
    public Point2D rightTop = new Point2D();

    public Rectangle2D() {
        this.leftBottom.x = -1.7976931348623157E308;
        this.rightTop.x = -1.7976931348623157E308;
        this.rightTop.y = -1.7976931348623157E308;
        this.leftBottom.y = -1.7976931348623157E308;
    }

    public Rectangle2D(Rectangle2D rect) {
        this(rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop());
    }

    public Rectangle2D(Point2D pntLeftBottom, double width, double height) {
        this.leftBottom.x = pntLeftBottom.getX();
        this.leftBottom.y = pntLeftBottom.getY();
        this.rightTop.x = this.leftBottom.x + width;
        this.rightTop.y = this.leftBottom.y + height;
    }

    public Rectangle2D(Point2D pntLeftBottom, Point2D pntRightTop) {
        this.leftBottom.x = pntLeftBottom.getX();
        this.leftBottom.y = pntLeftBottom.getY();
        this.rightTop.x = pntRightTop.getX();
        this.rightTop.y = pntRightTop.getY();
    }

    public Rectangle2D(double left, double bottom, double right, double top) {
        this.leftBottom.x = left;
        this.leftBottom.y = bottom;
        this.rightTop.x = right;
        this.rightTop.y = top;
    }

    public Rectangle2D(Point2D center, Size2D size) {
        if (size.getWidth() < 0.0 || size.getHeight() < 0.0) {
            String string = InternalResource.loadString("size", "Rectangle2DWidthAndHeightShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = center.getX() - size.getWidth() / 2.0;
        double d3 = center.getY() - size.getHeight() / 2.0;
        double d4 = center.getX() + size.getWidth() / 2.0;
        double d5 = center.getY() + size.getHeight() / 2.0;
        this.leftBottom.x = d2;
        this.leftBottom.y = d3;
        this.rightTop.x = d4;
        this.rightTop.y = d5;
    }

    public static final Rectangle2D getEMPTY() {
        return new Rectangle2D(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
    }

    public boolean isEmpty() {
        if (Double.isInfinite(this.leftBottom.x) || Double.isInfinite(this.rightTop.x) || Double.isInfinite(this.leftBottom.y) || Double.isInfinite(this.rightTop.y)) {
            return true;
        }
        return Toolkit.isZero(this.leftBottom.x - this.rightTop.x, -1.0E-10, 1.0E-10) || Toolkit.isZero(this.leftBottom.y - this.rightTop.y, -1.0E-10, 1.0E-10);
    }

    public Point2D getCenter() {
        Point2D point2D = new Point2D();
        point2D.setX((this.leftBottom.x + this.rightTop.x) / 2.0);
        point2D.setY((this.rightTop.y + this.leftBottom.y) / 2.0);
        return point2D;
    }

    public double getTop() {
        return this.rightTop.y;
    }

    public void setTop(double value) {
        this.rightTop.y = value;
    }

    public double getBottom() {
        return this.leftBottom.y;
    }

    public void setBottom(double value) {
        this.leftBottom.y = value;
    }

    public double getLeft() {
        return this.leftBottom.x;
    }

    public void setLeft(double value) {
        this.leftBottom.x = value;
    }

    public double getRight() {
        return this.rightTop.x;
    }

    public void setRight(double value) {
        this.rightTop.x = value;
    }

    public double getWidth() {
        return Math.abs(this.rightTop.x - this.leftBottom.x);
    }

    public double getHeight() {
        return Math.abs(this.rightTop.y - this.leftBottom.y);
    }

    public Rectangle2D clone() {
        return new Rectangle2D(this);
    }

    public static Rectangle2D ceiling(Rectangle2D rect) {
        Rectangle2D rectangle2D = new Rectangle2D(Math.ceil(rect.getLeft()), Math.ceil(rect.getBottom()), Math.ceil(rect.getRight()), Math.ceil(rect.getTop()));
        return rectangle2D;
    }

    public static Rectangle2D floor(Rectangle2D rect) {
        Rectangle2D rectangle2D = new Rectangle2D(Math.floor(rect.getLeft()), Math.floor(rect.getBottom()), Math.floor(rect.getRight()), Math.floor(rect.getTop()));
        return rectangle2D;
    }

    public static Rectangle2D round(Rectangle2D rect) {
        Rectangle2D rectangle2D = new Rectangle2D(Math.round(rect.getLeft()), Math.round(rect.getBottom()), Math.round(rect.getRight()), Math.round(rect.getTop()));
        return rectangle2D;
    }

    public boolean contains(Point2D pt) {
        return pt.getX() >= this.leftBottom.x && pt.getX() <= this.rightTop.x && pt.getY() <= this.rightTop.y && pt.getY() >= this.leftBottom.y;
    }

    public boolean contains(Rectangle2D rect) {
        return !(!(rect.getLeft() > this.getLeft()) && !Toolkit.isZero(rect.getLeft() - this.getLeft()) || !(rect.getTop() < this.getTop()) && !Toolkit.isZero(rect.getTop() - this.getTop()) || !(rect.getRight() < this.getRight()) && !Toolkit.isZero(rect.getRight() - this.getRight()) || !(rect.getBottom() > this.getBottom()) && !Toolkit.isZero(rect.getBottom() - this.getBottom()));
    }

    public boolean contains(double x, double y) {
        Point2D point2D = new Point2D(x, y);
        return this.contains(point2D);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D rectangle2D = (Rectangle2D)obj;
        return Toolkit.isZero(this.leftBottom.x - rectangle2D.getLeft()) && Toolkit.isZero(this.rightTop.x - rectangle2D.getRight()) && Toolkit.isZero(this.rightTop.y - rectangle2D.getTop()) && Toolkit.isZero(this.leftBottom.y - rectangle2D.getBottom());
    }

    public boolean equals(Rectangle2D rect) {
        if (rect == null) {
            return false;
        }
        return Toolkit.isZero(this.leftBottom.x - rect.getLeft()) && Toolkit.isZero(this.rightTop.x - rect.getRight()) && Toolkit.isZero(this.rightTop.y - rect.getTop()) && Toolkit.isZero(this.leftBottom.y - rect.getBottom());
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.getLeft());
        l += Double.doubleToLongBits(this.getBottom()) * 37L;
        l += Double.doubleToLongBits(this.getRight()) * 43L;
        return (int)(l += Double.doubleToLongBits(this.getTop()) * 47L) ^ (int)(l >> 32);
    }

    public void inflate(double x, double y) {
        this.leftBottom.x -= x;
        this.rightTop.x += x;
        this.rightTop.y += y;
        this.leftBottom.y -= y;
    }

    public void intersect(Rectangle2D rect) {
        if (this.hasIntersection(rect)) {
            this.leftBottom.x = Math.max(this.leftBottom.x, rect.getLeft());
            this.rightTop.y = Math.min(this.rightTop.y, rect.getTop());
            this.rightTop.x = Math.min(this.rightTop.x, rect.getRight());
            this.leftBottom.y = Math.max(this.leftBottom.y, rect.getBottom());
        } else {
            this.a();
        }
    }

    public boolean hasIntersection(Rectangle2D rect) {
        return this.rightTop.x >= rect.getLeft() && this.leftBottom.x <= rect.getRight() && this.rightTop.y >= rect.getBottom() && this.leftBottom.y <= rect.getTop();
    }

    public void offset(double dx, double dy) {
        this.leftBottom.x += dx;
        this.rightTop.x += dx;
        this.rightTop.y += dy;
        this.leftBottom.y += dy;
    }

    public String toString() {
        return "Left=" + this.leftBottom.x + ",Bottom=" + this.leftBottom.y + ",Right=" + this.rightTop.x + ",Top=" + this.rightTop.y;
    }

    public void union(Rectangle2D rect) {
        this.leftBottom.x = Math.min(this.leftBottom.x, rect.getLeft());
        this.rightTop.y = Math.max(this.rightTop.y, rect.getTop());
        this.rightTop.x = Math.max(this.rightTop.x, rect.getRight());
        this.leftBottom.y = Math.min(this.leftBottom.y, rect.getBottom());
    }

    private void a() {
        this.leftBottom.x = -1.7976931348623157E308;
        this.rightTop.x = -1.7976931348623157E308;
        this.rightTop.y = -1.7976931348623157E308;
        this.leftBottom.y = -1.7976931348623157E308;
    }
}

