/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetMosaic;
import com.supermap.data.DatasetMosaicNative;
import com.supermap.data.Enum;
import com.supermap.data.Environment;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalResource;
import com.supermap.data.MosaicPixelValues;
import com.supermap.data.MosaicProgress;
import com.supermap.data.MosaicSteppedListener;
import com.supermap.data.MosaicToolkitNative;
import com.supermap.data.PixelFormat;
import com.supermap.data.Point2D;
import com.supermap.data.PyramidResampleType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.TiffCompressType;
import com.supermap.data.Toolkit;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MosaicToolkit {
    public static HashMap<Integer, String> getAllFiles(DatasetMosaic datasetMosaic, Boolean containsOverviews) {
        MosaicToolkit.a(datasetMosaic);
        return MosaicToolkitNative.jni_GetMosaicFilePaths(datasetMosaic.getHandle(), containsOverviews, null, 0L);
    }

    public static HashMap<Integer, String> getFilesByBounds(DatasetMosaic datasetMosaic, Rectangle2D extractBounds, Boolean containsOverviews) {
        MosaicToolkit.a(datasetMosaic);
        if (extractBounds.isEmpty()) {
            String string = InternalResource.loadString("extractBounds", "GeometryShouldNotBeEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[]{extractBounds.getLeft(), extractBounds.getBottom(), extractBounds.getRight(), extractBounds.getTop()};
        return MosaicToolkitNative.jni_GetMosaicFilePaths(datasetMosaic.getHandle(), containsOverviews, dArray, 0L);
    }

    public static HashMap<Integer, String> getFilesByGeoRegion(DatasetMosaic datasetMosaic, GeoRegion extractRegion, Boolean containsOverviews) {
        MosaicToolkit.a(datasetMosaic);
        if (extractRegion.getHandle() == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MosaicToolkitNative.jni_GetMosaicFilePaths(datasetMosaic.getHandle(), containsOverviews, null, extractRegion.getHandle());
    }

    public static boolean hasPyramid(String filePath) {
        boolean bl = MosaicToolkit.b(filePath);
        if (!bl) {
            return false;
        }
        return MosaicToolkitNative.jni_HasPyramid(filePath);
    }

    @Deprecated
    public static boolean buildPyramid(String filePath, PyramidResampleType type) {
        return MosaicToolkit.buildPyramid(filePath, type, TiffCompressType.LZW);
    }

    public static boolean buildPyramid(String filePath, PyramidResampleType type, TiffCompressType compressType) {
        boolean bl = MosaicToolkit.b(filePath);
        if (!bl) {
            return false;
        }
        return MosaicToolkitNative.jni_BuildPyramid(filePath, "", "", type.getUGCValue(), compressType.getUGCValue());
    }

    public static boolean buildPyramid(String filePath, String rasterType, String rasterParams, PyramidResampleType type, TiffCompressType compressType) {
        return MosaicToolkit.b(filePath) && MosaicToolkitNative.jni_BuildPyramid(filePath, rasterType, rasterParams, type.getUGCValue(), compressType.getUGCValue());
    }

    public static boolean cleanPyramid(String filePath) {
        return MosaicToolkit.b(filePath) && MosaicToolkitNative.jni_CleanPyramid(filePath);
    }

    public static boolean forceRebuildPyramid(String filePath, PyramidResampleType type, TiffCompressType compressType) {
        return MosaicToolkit.b(filePath) && MosaicToolkitNative.jni_ForceRebuildPyramid(filePath, "", "", type.getUGCValue(), compressType.getUGCValue());
    }

    public static boolean forceRebuildPyramid(String filePath, String rasterType, String rasterParams, PyramidResampleType type, TiffCompressType compressType) {
        return MosaicToolkit.b(filePath) && MosaicToolkitNative.jni_ForceRebuildPyramid(filePath, rasterType, rasterParams, type.getUGCValue(), compressType.getUGCValue());
    }

    public static MosaicPixelValues getValue(DatasetMosaic datasetMosaic, Point2D point2D) {
        MosaicToolkit.a(datasetMosaic);
        double[] dArray = new double[]{point2D.x, point2D.y};
        double[] dArray2 = new double[15];
        MosaicPixelValues mosaicPixelValues = new MosaicPixelValues();
        mosaicPixelValues.d = MosaicToolkitNative.jni_GetValue(datasetMosaic.getHandle(), dArray, dArray2);
        if (mosaicPixelValues.d != null && mosaicPixelValues.d.length() > 1) {
            mosaicPixelValues.a = (int)dArray2[0];
            int n = (int)dArray2[1];
            mosaicPixelValues.f = (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
            mosaicPixelValues.c = new Point((int)dArray2[2], (int)dArray2[3]);
            mosaicPixelValues.b = (int)dArray2[4];
            mosaicPixelValues.e = new double[mosaicPixelValues.b];
            for (int i = 0; i < mosaicPixelValues.b; ++i) {
                mosaicPixelValues.e[i] = dArray2[i + 5];
            }
            return mosaicPixelValues;
        }
        return null;
    }

    public static String getFileInfo(String filePath) {
        if (filePath == null || filePath.length() < 1) {
            return null;
        }
        return MosaicToolkitNative.jni_GetFileInfo(filePath);
    }

    public static String checkMosaicFile(String filePath, boolean outputJsonOrXML) {
        MosaicToolkit.b(filePath);
        return MosaicToolkitNative.jni_CheckMosaicFile(filePath, outputJsonOrXML);
    }

    public static String checkDatasetMosaic(DatasetMosaic datasetMosaic, boolean outputJsonOrXML, MosaicSteppedListener listener) {
        MosaicToolkit.a(datasetMosaic);
        MosaicProgress mosaicProgress = new MosaicProgress();
        mosaicProgress.a(listener);
        return MosaicToolkitNative.jni_CheckDatasetMosaic(datasetMosaic.getHandle(), outputJsonOrXML, mosaicProgress.getHandle());
    }

    public static String checkDatasetMosaic(DatasetMosaic datasetMosaic, boolean outputJsonOrXML) {
        return MosaicToolkit.checkDatasetMosaic(datasetMosaic, outputJsonOrXML, null);
    }

    private static void a(DatasetMosaic datasetMosaic) {
        if (datasetMosaic == null) {
            String string = InternalResource.loadString("datasetMosaic", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetMosaic", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public static int defineOverview(DatasetMosaic datasetMosaic, String path, int maxWidth, int maxHeight, int ratio, boolean hasNoValue, double noValue, String defineFolder) {
        return MosaicToolkit.defineOverview(datasetMosaic, path, maxWidth, maxHeight, ratio, hasNoValue, noValue, defineFolder, null);
    }

    public static int defineOverview(DatasetMosaic datasetMosaic, String path, int maxWidth, int maxHeight, int ratio, boolean hasNoValue, double noValue, String defineFolder, MosaicSteppedListener listener) {
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("defineOverview()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (path == null || path.length() < 1) {
            String string = InternalResource.loadString("path", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxWidth <= 0) {
            String string = InternalResource.loadString("maxWidth", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxHeight <= 0) {
            String string = InternalResource.loadString("maxHeight", "DatasetGrid_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (ratio <= 0) {
            String string = InternalResource.loadString("ratio", "Argument_ShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + "/";
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        mosaicProgress.a(listener);
        return DatasetMosaicNative.jni_DefineOverview(datasetMosaic.getHandle(), path, maxWidth, maxHeight, ratio, hasNoValue, noValue, defineFolder, mosaicProgress.getHandle());
    }

    public static int createOverviewFile(String defineFile) {
        if (defineFile == null || defineFile.trim().length() < 1) {
            String string = InternalResource.loadString("defineFile", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!MosaicToolkit.b(defineFile)) {
            String string = InternalResource.loadString("defineFile", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return DatasetMosaicNative.jni_CreateOverviewFile(defineFile);
    }

    public static boolean createCOGCopy(String srcFile, String destFile, int resampleType, int nCompressType) {
        MosaicToolkit.a(srcFile, destFile, resampleType, nCompressType);
        return MosaicToolkitNative.jni_CreateCOG(srcFile, destFile, resampleType, nCompressType);
    }

    private static void a(String string, String string2, int n, int n2) {
        MosaicToolkit.a(string);
        if (string2 == null || string2.trim().length() < 1) {
            String string3 = InternalResource.loadString("destFile", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (n < 0) {
            String string4 = InternalResource.loadString("resampleType", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (n2 < 0) {
            String string5 = InternalResource.loadString("nCompressType", "DatasetGrid_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string5);
        }
    }

    public static boolean createCOGCopy(String srcFile, String destFile, int resampleType, int nCompressType, MosaicSteppedListener listener) {
        MosaicToolkit.a(srcFile, destFile, resampleType, nCompressType);
        MosaicProgress mosaicProgress = new MosaicProgress();
        mosaicProgress.a(listener);
        return MosaicToolkitNative.jni_CreateCOG(srcFile, destFile, resampleType, nCompressType, mosaicProgress.getHandle());
    }

    public static boolean isValidCOG(String srcFile) {
        MosaicToolkit.a(srcFile);
        return MosaicToolkitNative.jni_ValidateCOGFile(srcFile);
    }

    public static String testDataAccessSpeed(DatasetMosaic datasetMosaic, int tileCount, int pyramidLevel) {
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("defineOverview()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (tileCount != 3 && tileCount != 5) {
            String string = InternalResource.loadString("tileCount", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MosaicToolkitNative.jni_testFileAccessSpeed(datasetMosaic.getHandle(), tileCount, pyramidLevel);
    }

    public static String testSingleFileAccessSpeed(String srcFile, int testCount, int pyramidLevel) {
        MosaicToolkit.a(srcFile);
        if (testCount < 0) {
            String string = InternalResource.loadString("tileCount", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MosaicToolkitNative.jni_testSingleFileAccessSpeed(srcFile, testCount, pyramidLevel);
    }

    public static boolean refreshMetadata(DatasetMosaic datasetMosaic) {
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("defineOverview()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MosaicToolkitNative.jni_RefreshMetadata(datasetMosaic.getHandle());
    }

    public static boolean addMosaicFilesWithFile(DatasetMosaic sourceDataset, String filePath, String clipFileType) {
        boolean bl = MosaicToolkit.addMosaicFilesWithFile(sourceDataset, filePath, clipFileType, new StringBuilder());
        return bl;
    }

    public static boolean addMosaicFilesWithFile(DatasetMosaic sourceDataset, String filePath, String clipFileType, StringBuilder resultJson) {
        return MosaicToolkit.addMosaicFilesWithFile(sourceDataset, filePath, clipFileType, resultJson, null);
    }

    public static boolean addMosaicFilesWithFile(DatasetMosaic sourceDataset, String filePath, String clipFileType, StringBuilder resultJson, MosaicSteppedListener listener) {
        if (filePath == null || filePath.isEmpty()) {
            return false;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        String string = MosaicToolkit.getFileEncode(file);
        boolean bl = false;
        try {
            String string2;
            List<String> list = Files.readAllLines(Paths.get(filePath, new String[0]), Charset.forName(string));
            LinkedHashMap<String, Map<String, String>> linkedHashMap = new LinkedHashMap<String, Map<String, String>>();
            String string3 = filePath.substring(filePath.lastIndexOf(46));
            if (string3.equalsIgnoreCase(".csv") && (string2 = list.get(0)).contains(",")) {
                String[] stringArray = string2.split(",");
                if (stringArray.length < 1 || !stringArray[0].equalsIgnoreCase("smpath")) {
                    return false;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 1; i < list.size(); ++i) {
                    LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
                    String string4 = list.get(i);
                    String[] stringArray2 = string4.split(",");
                    String string5 = "";
                    for (int j = 0; j < stringArray2.length; ++j) {
                        if (j == 0) {
                            string5 = stringArray2[j].trim();
                            arrayList.add(string5);
                            continue;
                        }
                        linkedHashMap2.put(stringArray[j].trim(), stringArray2[j].trim());
                    }
                    linkedHashMap.put(string5, linkedHashMap2);
                }
                list.clear();
                list.addAll(arrayList);
            }
            bl = sourceDataset.addFilesWithReport(list.toArray(new String[list.size()]), null == clipFileType ? "" : clipFileType, linkedHashMap, resultJson, listener);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    public static String getFileEncode(File file) {
        String string = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            bufferedInputStream.mark(2);
            int n = (bufferedInputStream.read() << 8) + bufferedInputStream.read();
            switch (n) {
                case 65279: {
                    string = "UTF-16BE";
                    break;
                }
                case 65534: {
                    string = "Unicode";
                    break;
                }
                case 61371: {
                    string = "UTF-8";
                    break;
                }
                default: {
                    string = "GBK";
                }
            }
            if (string.equals("GBK")) {
                int n2;
                bufferedInputStream.reset();
                byte[] byArray = new byte[4096];
                while ((n2 = bufferedInputStream.read(byArray)) != -1 && !string.equals("UTF-8")) {
                    if (!MosaicToolkit.a(byArray, n2)) continue;
                    string = "UTF-8";
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    private static boolean a(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2;
            if ((byArray[i] & 0x80) == 0) continue;
            if ((byArray[i] & 0xE0) == 192) {
                n2 = 2;
            } else if ((byArray[i] & 0xF0) == 224) {
                n2 = 3;
            } else if ((byArray[i] & 0xF8) == 240) {
                n2 = 4;
            } else if ((byArray[i] & 0xFC) == 248) {
                n2 = 5;
            } else if ((byArray[i] & 0xFE) == 252) {
                n2 = 6;
            } else {
                return false;
            }
            while (--n2 > 0) {
                if (++i >= n) {
                    return false;
                }
                if ((byArray[i] & 0xC0) == 128) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean buildStatistics(String filePath) {
        boolean bl = MosaicToolkit.b(filePath);
        if (!bl) {
            return false;
        }
        return MosaicToolkitNative.jni_BuildStatistics(filePath);
    }

    public static boolean buildHistograms(String filePath, boolean rebuild) {
        if (filePath == null || filePath.length() == 0) {
            return false;
        }
        return MosaicToolkitNative.jni_BuildHistograms(filePath, rebuild);
    }

    static void a(String string) {
        String string2 = InternalResource.loadString("srcFile", "Global_FileNotExists", "data_resources");
        if (string == null) {
            throw new IllegalArgumentException(string2);
        }
        if (!MosaicToolkit.b(string)) {
            throw new IllegalArgumentException(string2);
        }
    }

    public static boolean RefreshPyramid(DatasetMosaic datasetMosaic) {
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("defineOverview()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MosaicToolkitNative.jni_RefreshPyramid(datasetMosaic.getHandle());
    }

    static boolean b(String string) {
        if (string == null || string.isEmpty()) {
            String string2 = InternalResource.loadString("filePath", "Global_StringIsEmpty", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (string.startsWith("/vsi")) {
            return Toolkit.isPathExists(string);
        }
        if (string.startsWith("ftp") || string.startsWith("http")) {
            String string3 = "/vsicurl/" + string;
            return Toolkit.isPathExists(string3);
        }
        File file = new File(string);
        if (file.isDirectory()) {
            String string4 = InternalResource.loadString("filePath", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        return file.exists();
    }

    static {
        Environment.LoadWrapJ();
    }
}

