/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Material3D;
import com.supermap.data.Model;
import com.supermap.data.ModelEntityManagerNative;
import com.supermap.data.Skeleton;
import com.supermap.data.TextureData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ModelEntityManager
extends InternalHandleDisposable {
    private DatasetVector a;

    public ModelEntityManager() {
        long l = ModelEntityManagerNative.jni_New();
        this.setHandle(l, true);
    }

    public ModelEntityManager(DatasetVector dataset) {
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        this.a = dataset;
        long l = dataset.getHandle();
        if (0L == l) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (dataset.getType() != DatasetType.MODEL) {
            String string = InternalResource.loadString("dataset", "Invalid_ArgumentValue", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l2 = ModelEntityManagerNative.jni_New(l);
        this.setHandle(l2, true);
    }

    public boolean isExisted(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return ModelEntityManagerNative.jni_IsExisted(this.getHandle(), name);
    }

    public ArrayList<String> getMaterialNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        String[] stringArray = ModelEntityManagerNative.jni_GetMaterialNames(this.getHandle());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray == null) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public ArrayList<String> getSkeletonNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        String[] stringArray = ModelEntityManagerNative.jni_GetSkeletonNames(this.getHandle());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray == null) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public ArrayList<String> getTextureNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        String[] stringArray = ModelEntityManagerNative.jni_GetTextureNames(this.getHandle());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray == null) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public String getAvailableName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return ModelEntityManagerNative.jni_GetAvailableName(this.getHandle(), name);
    }

    public Skeleton getSkeleton(String name) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l2 = 0L;
        if (this.a != null) {
            l2 = this.a.getHandle();
        }
        if ((l = ModelEntityManagerNative.jni_GetSkeleton(this.getHandle(), name, l2)) == 0L) {
            return null;
        }
        return new Skeleton(l, this);
    }

    public Material3D getMaterial(String name) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l2 = 0L;
        if (this.a != null) {
            l2 = this.a.getHandle();
        }
        if ((l = ModelEntityManagerNative.jni_GetMaterial(this.getHandle(), name, l2)) == 0L) {
            return null;
        }
        return new Material3D(l, this);
    }

    public TextureData getTextureData(String name) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l2 = 0L;
        if (this.a != null) {
            l2 = this.a.getHandle();
        }
        if ((l = ModelEntityManagerNative.jni_GetTextureData(this.getHandle(), name, l2)) == 0L) {
            return null;
        }
        return new TextureData(l);
    }

    public Skeleton append(Skeleton skeleton) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (skeleton == null) {
            String string = InternalResource.loadString("skeleton", "Global_ArgumentNull", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (skeleton.getHandle() == 0L) {
            String string = InternalResource.loadString("skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        Material3D material3D = skeleton.getMaterial();
        ArrayList<TextureData> arrayList = material3D.getTextures();
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            lArray[i] = arrayList.get(i).getHandle();
        }
        long l = ModelEntityManagerNative.jni_AppendSkeleton(this.getHandle(), skeleton.getHandle(), material3D.getHandle(), lArray);
        material3D.dispose();
        for (TextureData textureData : arrayList) {
            textureData.dispose();
        }
        arrayList.clear();
        return new Skeleton(l, this);
    }

    public Model append(Model model) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (model == null) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l = ModelEntityManagerNative.jni_AppendModel(this.getHandle(), model.getHandle());
        return new Model(l);
    }

    public Skeleton update(Skeleton skeleton) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (skeleton == null) {
            String string = InternalResource.loadString("skeleton", "Global_ArgumentNull", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l = skeleton.getMaterial().getHandle();
        ArrayList<TextureData> arrayList = skeleton.getMaterial().getTextures();
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            lArray[i] = arrayList.get(i).getHandle();
        }
        long l2 = ModelEntityManagerNative.jni_UpdateSkeleton(this.getHandle(), skeleton.getHandle(), l, lArray);
        return new Skeleton(l2, this);
    }

    public Model update(Model model) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (model == null) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l = ModelEntityManagerNative.jni_UpdateModel(this.getHandle(), model.getHandle());
        return new Model(l);
    }

    public boolean update(Material3D material3D) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("update", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (material3D == null) {
            String string = InternalResource.loadString("material3D", "Global_ArgumentNull", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l = InternalHandle.getHandle(material3D);
        long[] lArray = null;
        ArrayList<TextureData> arrayList = material3D.getTextureDatas();
        if (!arrayList.isEmpty()) {
            lArray = new long[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                TextureData textureData = arrayList.get(n);
                if (textureData == null) continue;
                lArray[n] = InternalHandle.getHandle(textureData);
            }
        }
        n = ModelEntityManagerNative.jni_UpdateMaterial3D(this.getHandle(), l, lArray);
        return n != 0;
    }

    public boolean update(TextureData textureData) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("update", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (textureData == null) {
            String string = InternalResource.loadString("material3D", "Global_ArgumentNull", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l = InternalHandle.getHandle(textureData);
        TextureData textureData2 = new TextureData(l);
        l = InternalHandle.getHandle(textureData2);
        boolean bl = ModelEntityManagerNative.jni_UpdateTextureData(this.getHandle(), l);
        return bl;
    }

    public boolean deleteSkeleton(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (name == null || name.equals("")) {
            String string = InternalResource.loadString("name", "Global_ArgumentNull", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return ModelEntityManagerNative.jni_DeleteSkeleton(this.getHandle(), name);
    }

    public boolean deleteMaterial(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (name == null || name.equals("")) {
            String string = InternalResource.loadString("name", "Global_ArgumentNull", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return ModelEntityManagerNative.jni_DeleteMaterial(this.getHandle(), name);
    }

    public boolean deleteTextureData(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (name == null || name.equals("")) {
            String string = InternalResource.loadString("name", "Global_ArgumentNull", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return ModelEntityManagerNative.jni_DeleteTextureData(this.getHandle(), name);
    }

    public void updateDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.a == null || this.a.getHandle() == 0L) {
            return;
        }
        ModelEntityManagerNative.jni_UpdateDataset(this.getHandle(), this.a.getHandle());
    }

    public boolean updateMaterialNames(HashMap<String, String> dic) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("updateMaterialNames", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.a == null || this.a.getHandle() == 0L || dic == null || dic.size() == 0) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Set<String> set = dic.keySet();
        for (String stringArray2 : set) {
            arrayList.add(stringArray2);
            arrayList2.add(dic.get(stringArray2));
        }
        String[] stringArray3 = arrayList.toArray(new String[arrayList.size()]);
        String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        return ModelEntityManagerNative.jni_UpdateMaterialNames(this.getHandle(), this.a.getHandle(), stringArray3, stringArray);
    }

    public void save() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.a == null || this.a.getHandle() == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        ModelEntityManagerNative.jni_Save(this.getHandle(), this.a.getHandle());
    }

    public void reset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("EntityManager", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.a == null || this.a.getHandle() == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        ModelEntityManagerNative.jni_Reset(this.getHandle(), this.a.getHandle());
    }

    @Override
    public void dispose() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        ModelEntityManagerNative.jni_Delete(this.getHandle());
        this.clearHandle();
    }

    public static boolean buildLOD(DatasetVector modelDataset, double[] ratios) {
        if (modelDataset == null) {
            return false;
        }
        long l = InternalHandle.getHandle(modelDataset);
        return ModelEntityManagerNative.jni_BuildLOD(l, ratios);
    }

    public static boolean removeLOD(DatasetVector modelDataset) {
        if (modelDataset == null) {
            return false;
        }
        long l = InternalHandle.getHandle(modelDataset);
        return ModelEntityManagerNative.jni_RemoveLOD(l);
    }

    public static boolean hasLOD(DatasetVector modelDataset) {
        if (modelDataset == null) {
            return false;
        }
        long l = InternalHandle.getHandle(modelDataset);
        return ModelEntityManagerNative.jni_HasLOD(l);
    }
}

