/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoModel3D;
import com.supermap.data.GeoTIMNative;
import com.supermap.data.GeoTetrahedron;
import com.supermap.data.Geometry;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

public class GeoTIM
extends Geometry3D {
    GeoTIM(long handle, boolean cloneable) {
        if (cloneable) {
            this.setHandle(GeoTIMNative.jni_Clone(handle), false);
        } else {
            this.setHandle(handle, false);
        }
    }

    public GeoTIM() {
        this.setHandle(GeoTIMNative.jni_New(), true);
    }

    public GeoTIM(GeoTIM geoTIM) {
        if (geoTIM == null) {
            String string = InternalResource.loadString("geoTIM", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoTIM);
        if (l == 0L) {
            String string = InternalResource.loadString("geoTIM", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoTIMNative.jni_Clone(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoTIM);
    }

    public GeoModel3D convertToModel3D() {
        GeoModel3D geoModel3D = null;
        long l = GeoTIMNative.jni_ConvertToModel3D(this.getHandle());
        if (l != 0L) {
            geoModel3D = new GeoModel3D(l);
        }
        return geoModel3D;
    }

    public ArrayList<GeoTetrahedron> getTetrahedrons() {
        ArrayList<GeoTetrahedron> arrayList = new ArrayList<GeoTetrahedron>();
        long[] lArray = GeoTIMNative.jni_GetTetrahedrons(this.getHandle());
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                arrayList.add(new GeoTetrahedron(lArray[i]));
            }
        }
        return arrayList;
    }

    @Override
    public Geometry clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoTIM", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoTIM(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoTIMNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

