/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoModel3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3DNative;
import com.supermap.data.Geometry;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import java.util.ArrayList;

public class GeoRegion3D
extends Geometry3D {
    private ArrayList<Point3Ds> a;

    public GeoRegion3D() {
        super.setHandle(GeoRegion3DNative.jni_New(), true);
        this.a = new ArrayList();
    }

    public GeoRegion3D(Point3Ds points) {
        this();
        this.addPart(points);
    }

    public GeoRegion3D(GeoRegion3D region3D) {
        if (region3D == null) {
            String string = InternalResource.loadString("region3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (region3D.getHandle() == 0L) {
            String string = InternalResource.loadString("region3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRegion3DNative.jni_Clone(region3D.getHandle());
        super.setHandle(l, true);
        this.a = new ArrayList();
        for (int i = 0; i < region3D.a().size(); ++i) {
            Point3Ds point3Ds = region3D.a().get(i);
            this.a.add(point3Ds.clone());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(region3D);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRegion3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetArea(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetPartCount(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetPerimeter(this.getHandle());
    }

    public int addPart(Point3Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = points.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
            dArray3[i] = points.getItem(i).getZ();
        }
        int n2 = GeoRegion3DNative.jni_AddPart(this.getHandle(), dArray, dArray2, dArray3);
        Point3Ds point3Ds = new Point3Ds(this.a(n2));
        Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
        this.a.add(point3Ds2);
        return n2;
    }

    public GeoLine3D convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLine3D geoLine3D = new GeoLine3D();
        for (int i = 0; i < this.getPartCount(); ++i) {
            geoLine3D.addPart(this.getPart(i));
        }
        geoLine3D.setIsDisposable(true);
        return geoLine3D;
    }

    public boolean removePart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart(index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoRegion3DNative.jni_RemovePart(this.getHandle(), index);
        if (bl) {
            this.a.remove(index);
        }
        return bl;
    }

    public Point3Ds getPart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(index);
    }

    public boolean insertPart(int index, Point3Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = points.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
            dArray3[i] = points.getItem(i).getZ();
        }
        if (index == this.getPartCount()) {
            int n2 = GeoRegion3DNative.jni_AddPart(this.getHandle(), dArray, dArray2, dArray3);
            Point3Ds point3Ds = new Point3Ds(this.a(n2));
            Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
            this.a.add(index, point3Ds2);
            return n2 != -1;
        }
        boolean bl = GeoRegion3DNative.jni_InsertPart(this.getHandle(), index, dArray, dArray2, dArray3);
        Point3Ds point3Ds = new Point3Ds(this.a(index));
        Point3Ds point3Ds3 = new Point3Ds(point3Ds, this);
        this.a.add(index, point3Ds3);
        return bl;
    }

    @Override
    public void offset(double dx, double dy, double dz) {
        super.offset(dx, dy, dz);
        this.b();
    }

    public boolean setPart(int index, Point3Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (points.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = points.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
            dArray3[i] = points.getItem(i).getZ();
        }
        boolean bl = GeoRegion3DNative.jni_SetPart(this.getHandle(), index, dArray, dArray2, dArray3);
        if (bl) {
            Point3Ds point3Ds = this.a.get(index);
            Point3Ds point3Ds2 = new Point3Ds(this.a(index));
            Point3Ds point3Ds3 = new Point3Ds(point3Ds2, this);
            this.a.set(index, point3Ds3);
            point3Ds.a(Point3Ds.a.a);
        }
        return bl;
    }

    boolean a(int n, Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (point3Ds.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point3Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        boolean bl = GeoRegion3DNative.jni_SetPart(this.getHandle(), n, dArray, dArray2, dArray3);
        return bl;
    }

    public int indexOf(Point3Ds part) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.indexOf(part);
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        this.setHandle(0L);
    }

    ArrayList<Point3Ds> a() {
        return this.a;
    }

    private Point3D[] a(int n) {
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = GeoRegion3DNative.jni_GetPartPointCount(this.getHandle(), n);
        if (n2 > 2) {
            Point3D[] point3DArray = new Point3D[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            GeoRegion3DNative.jni_GetPart(this.getHandle(), n, dArray, dArray2, dArray3);
            for (int i = 0; i < n2; ++i) {
                point3DArray[i] = new Point3D(dArray[i], dArray2[i], dArray3[i]);
            }
            return point3DArray;
        }
        return null;
    }

    @Override
    public GeoRegion3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRegion3D(this);
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion3DNative.jni_Clear(this.getHandle());
        this.a.clear();
    }

    GeoRegion3D(long handle) {
        this.setHandle(handle, false);
        this.a = new ArrayList();
        this.b();
    }

    void b() {
        int n = this.getPartCount();
        this.a.clear();
        for (int i = 0; i < n; ++i) {
            Point3Ds point3Ds = new Point3Ds(this.a(i));
            Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
            this.a.add(point3Ds2);
        }
    }

    public GeoModel3D convertToGeoModel3D(boolean bLonLat, ArrayList<Point3D> points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToGeoModel3D(boolean bLonLat,ArrayList<Point3D>)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null || points.isEmpty()) {
            return this.convertToGeoModel3D(bLonLat);
        }
        double[] dArray = new double[points.size() * 3];
        for (int i = 0; i < points.size(); ++i) {
            Point3D point3D = points.get(i);
            dArray[3 * i] = point3D.getX();
            dArray[3 * i + 1] = point3D.getY();
            dArray[3 * i + 2] = point3D.getZ();
        }
        GeoModel3D geoModel3D = null;
        long l = GeoRegion3DNative.jni_ConvertToGeoModel3D(this.getHandle(), bLonLat, dArray);
        if (l != 0L) {
            geoModel3D = (GeoModel3D)Geometry.internalCreateInstance(l);
            if (this.getStyle3D() != null && this.getStyle3D().getHandle() != 0L) {
                geoModel3D.setStyle3D(this.getStyle3D());
            }
            return geoModel3D;
        }
        return null;
    }

    public GeoRegion convertToRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToRegion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoRegion3DNative.jni_ConvertToRegion(this.getHandle());
        GeoRegion geoRegion = null;
        if (l != 0L) {
            geoRegion = (GeoRegion)Geometry.internalCreateInstance(l);
        }
        return geoRegion;
    }
}

