/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine3DNative;
import com.supermap.data.GeoLineNative;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import java.util.ArrayList;

public class GeoLine3D
extends Geometry3D {
    private ArrayList<Point3Ds> a;

    public GeoLine3D() {
        long l = GeoLine3DNative.jni_New();
        this.setHandle(l, true);
        this.a = new ArrayList();
    }

    public GeoLine3D(Point3Ds points) {
        this();
        this.addPart(points);
    }

    public GeoLine3D(GeoLine3D geoLine3D) {
        if (geoLine3D == null) {
            String string = InternalResource.loadString("geoLine3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLine3D.getHandle() == 0L) {
            String string = InternalResource.loadString("geoLine3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoLine3DNative.jni_Clone(geoLine3D.getHandle());
        this.setHandle(l, true);
        this.a = new ArrayList();
        for (int i = 0; i < geoLine3D.a().size(); ++i) {
            Point3Ds point3Ds = geoLine3D.a().get(i);
            this.a.add(point3Ds.clone());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLine3D);
    }

    GeoLine3D(long handle) {
        this(handle, false);
    }

    GeoLine3D(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
        this.a = new ArrayList();
        this.b();
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoLine3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLine3DNative.jni_GetLength(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLine3DNative.jni_GetPartCount(this.getHandle());
    }

    public int addPart(Point3Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = points.getCount();
        if (n < 2) {
            String string = InternalResource.loadString("points", "GeoLine3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
            dArray3[i] = points.getItem(i).getZ();
        }
        Point3Ds point3Ds = new Point3Ds(points, this);
        this.a.add(point3Ds);
        return GeoLine3DNative.jni_AddPart(this.getHandle(), dArray, dArray2, dArray3);
    }

    public boolean removePart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart(index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoLine3DNative.jni_RemovePart(this.getHandle(), index);
        if (bl) {
            this.a.remove(index);
        }
        return bl;
    }

    public Point3Ds getPart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(index);
    }

    public boolean insertPart(int index, Point3Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = this.getPartCount();
        if (n == index) {
            int n2 = this.addPart(points);
            boolean bl2 = bl = n2 == index;
            if (bl) {
                Point3Ds point3Ds = new Point3Ds(points, this);
                this.a.add(index, point3Ds);
            }
            return bl;
        }
        if (index < 0 || index > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = points.getCount();
        if (n3 < 2) {
            String string = InternalResource.loadString("Point2Ds", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
            dArray3[i] = points.getItem(i).getZ();
        }
        bl = GeoLine3DNative.jni_InsertPart(this.getHandle(), index, dArray, dArray2, dArray3);
        if (bl) {
            Point3Ds point3Ds = new Point3Ds(points, this);
            this.a.add(index, point3Ds);
        }
        return bl;
    }

    public boolean setPart(int index, Point3Ds points) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = points.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("points", "GeoLine3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = points.getItem(n).getX();
            dArray2[n] = points.getItem(n).getY();
            dArray3[n] = points.getItem(n).getZ();
        }
        n = GeoLine3DNative.jni_SetPart(this.getHandle(), index, dArray, dArray2, dArray3) ? 1 : 0;
        if (n == 1) {
            Point3Ds point3Ds = this.a.get(index);
            Point3Ds point3Ds2 = new Point3Ds(points, this);
            this.a.set(index, point3Ds2);
            point3Ds.a(Point3Ds.a.a);
        }
        return n != 0;
    }

    boolean a(int n, Point3Ds point3Ds) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPartJustToUGC(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = point3Ds.getCount();
        if (n3 < 2) {
            String string = InternalResource.loadString("points", "GeoLine3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = point3Ds.getItem(n2).getX();
            dArray2[n2] = point3Ds.getItem(n2).getY();
            dArray3[n2] = point3Ds.getItem(n2).getZ();
        }
        n2 = GeoLine3DNative.jni_SetPart(this.getHandle(), n, dArray, dArray2, dArray3) ? 1 : 0;
        return n2 != 0;
    }

    public int indexOf(Point3Ds part) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.indexOf(part);
    }

    public GeoRegion3D convertToRegion() {
        int n = this.getPartCount();
        GeoRegion3D geoRegion3D = new GeoRegion3D();
        for (int i = 0; i < n; ++i) {
            Object object;
            Point3Ds point3Ds = this.getPart(i);
            int n2 = point3Ds.getCount();
            if (n2 < 3) {
                object = InternalResource.loadString("convertToRegion()", "GeoLine3D_UnsupportOperation", "data_resources");
                throw new UnsupportedOperationException((String)object);
            }
            object = point3Ds.clone();
            if (point3Ds.getItem(0).equals(point3Ds.getItem(n2 - 1))) {
                geoRegion3D.addPart((Point3Ds)object);
                continue;
            }
            ((Point3Ds)object).add(point3Ds.getItem(0));
            geoRegion3D.addPart((Point3Ds)object);
        }
        return geoRegion3D;
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
    }

    ArrayList<Point3Ds> a() {
        return this.a;
    }

    void b() {
        int n = this.getPartCount();
        this.a.clear();
        for (int i = 0; i < n; ++i) {
            Point3Ds point3Ds = new Point3Ds(this.a(i));
            Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
            this.a.add(point3Ds2);
        }
    }

    private Point3D[] a(int n) {
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = GeoLine3DNative.jni_GetPartPointCount(this.getHandle(), n);
        if (n2 > 1) {
            Point3D[] point3DArray = new Point3D[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            GeoLine3DNative.jni_GetPart(this.getHandle(), n, dArray, dArray2, dArray3);
            for (int i = 0; i < n2; ++i) {
                point3DArray[i] = new Point3D(dArray[i], dArray2[i], dArray3[i]);
            }
            return point3DArray;
        }
        return null;
    }

    @Override
    public GeoLine3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoLine3D(this);
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineNative.jni_Clear(this.getHandle());
        this.a.clear();
    }

    protected static GeoLine3D creatInstance(long handle, boolean disposable) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoLine3D(handle, disposable);
    }
}

