/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoExtrudedBodyNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;

public class GeoExtrudedBody
extends Geometry3D {
    public GeoExtrudedBody() {
        long l = GeoExtrudedBodyNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoExtrudedBody(GeoExtrudedBody geoExtrudedBody) {
        if (geoExtrudedBody == null) {
            String string = InternalResource.loadString("GeoExtrudedBody", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoExtrudedBody.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoExtrudedBody", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoExtrudedBodyNative.jni_Clone(geoExtrudedBody.getHandle(), this.getHandle());
    }

    public GeoExtrudedBody(Point3D position, Point3Ds bottomRegion, Point3D extrudedDirection, double extrudedLength) {
        double[] dArray = new double[]{position.getX(), position.getY(), position.getZ()};
        double[] dArray2 = new double[bottomRegion.getCount() * 3];
        for (int i = 0; i < bottomRegion.getCount(); ++i) {
            dArray2[3 * i] = bottomRegion.getItem(i).getX();
            dArray2[3 * i + 1] = bottomRegion.getItem(i).getY();
            dArray2[3 * i + 2] = bottomRegion.getItem(i).getZ();
        }
        double[] dArray3 = new double[]{extrudedDirection.getX(), extrudedDirection.getY(), extrudedDirection.getZ()};
        long l = GeoExtrudedBodyNative.jni_New2(dArray, dArray2, dArray3, extrudedLength);
        this.setHandle(l, true);
    }

    @Override
    public GeoExtrudedBody clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoExtrudedBody(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("GeoExtrudedBody", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoExtrudedBodyNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public Point3Ds getBottomRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBottomRegion", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoExtrudedBodyNative.jni_GetBottomRegion(this.getHandle());
        if (dArray == null || dArray.length == 0) {
            return null;
        }
        Point3Ds point3Ds = new Point3Ds();
        for (int i = 0; i < dArray.length / 3; ++i) {
            Point3D point3D = new Point3D(dArray[3 * i], dArray[3 * i + 1], dArray[3 * i + 2]);
            point3Ds.add(point3D);
        }
        return point3Ds;
    }

    public void setBottomRegion(Point3Ds p3ds) {
        if (p3ds == null || p3ds.getCount() == 0) {
            return;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBottomRegion", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[p3ds.getCount() * 3];
        for (int i = 0; i < p3ds.getCount(); ++i) {
            dArray[3 * i] = p3ds.getItem(i).getX();
            dArray[3 * i + 1] = p3ds.getItem(i).getY();
            dArray[3 * i + 2] = p3ds.getItem(i).getZ();
        }
        GeoExtrudedBodyNative.jni_SetBottomRegion(this.getHandle(), dArray);
    }

    public Point3D getExtrudedDirection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtrudedDirection", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoExtrudedBodyNative.jni_GetExtrudedDirection(this.getHandle());
        if (dArray == null || dArray.length == 0) {
            return null;
        }
        if (dArray != null && dArray.length == 3) {
            Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
            return point3D;
        }
        return null;
    }

    public void setExtrudedDirection(Point3D p3d) {
        if (p3d == null) {
            return;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtrudedDirection", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{p3d.getX(), p3d.getY(), p3d.getZ()};
        GeoExtrudedBodyNative.jni_SetExtrudedDirection(this.getHandle(), dArray);
    }

    public double getExtrudedLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtrudedLength", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoExtrudedBodyNative.jni_GetExtrudedLength(this.getHandle());
    }

    public void setExtrudedLength(double length) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtrudedLength", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoExtrudedBodyNative.jni_SetExtrudedLength(this.getHandle(), length);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoExtrudedBodyNative.jni_GetCenter(this.getHandle());
        if (dArray != null && dArray.length == 3) {
            Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
            return point3D;
        }
        return null;
    }
}

