/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoEllipticArcNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;

public class GeoEllipticArc
extends Geometry {
    private double a;
    private double b;

    public GeoEllipticArc() {
        long l = GeoEllipticArcNative.jni_New();
        this.setHandle(l, true);
        this.a = 0.0;
        this.b = 180.0;
    }

    public GeoEllipticArc(GeoEllipticArc geoEllipticArc) {
        if (geoEllipticArc == null) {
            String string = InternalResource.loadString("geoEllipticArc", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoEllipticArc);
        if (l == 0L) {
            String string = InternalResource.loadString("geoEllipticArc", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a = geoEllipticArc.getStartAngle();
        this.b = geoEllipticArc.getSweepAngle();
        long l2 = GeoEllipticArcNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoEllipticArc);
    }

    public GeoEllipticArc(Point2D center, double semimajorAxis, double semiminorAxis, double startAngle, double sweepAngle, double rotation) {
        if (semimajorAxis <= 0.0) {
            String string = InternalResource.loadString("semimajorAxis", "GeoEllipticArc_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (semiminorAxis <= 0.0) {
            String string = InternalResource.loadString("semiminorAxis", "GeoEllipticArc_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sweepAngle <= -360.0 || sweepAngle >= 360.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoEllipticArc_SweepAngleRange(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sweepAngle == 0.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoEllipticArc_StartAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a = startAngle;
        this.b = sweepAngle;
        double d2 = 0.0;
        double d3 = 0.0;
        if (sweepAngle < 0.0) {
            d2 = startAngle + sweepAngle;
            d3 = startAngle;
        } else {
            d2 = startAngle;
            d3 = startAngle + sweepAngle;
        }
        long l = GeoEllipticArcNative.jni_New1(center.getX(), center.getY(), semimajorAxis, semiminorAxis, d2, d3, rotation);
        this.setHandle(l, true);
    }

    GeoEllipticArc(long handle) {
        this.setHandle(handle, false);
        this.a = GeoEllipticArcNative.jni_getStartAngle(handle);
        this.b = GeoEllipticArcNative.jni_getSweepAngle(handle);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoEllipticArcNative.jni_getCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetCenter(Point2D point2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipticArcNative.jni_setCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getSemimajorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetSemimajorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticArcNative.jni_getSemimajorAxis(this.getHandle());
    }

    public void setSemimajorAxis(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetSemimajorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoEllipse_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoEllipticArcNative.jni_setSemimajorAxis(this.getHandle(), value);
    }

    public double getSemiminorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetSemiminorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticArcNative.jni_getSemiminorAxis(this.getHandle());
    }

    public void setSemiminorAxis(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetSemiminorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoEllipse_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoEllipticArcNative.jni_setSemiminorAxis(this.getHandle(), value);
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetStartAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void setStartAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetStartAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = this.getSweepAngle();
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = GeoEllipticArc.valueToUGC(value, d2, d3, d4);
        GeoEllipticArcNative.jni_setStartAngle(this.getHandle(), dArray[0], dArray[1]);
        this.a = value;
    }

    public double getSweepAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSweepAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.b;
    }

    public void setSweepAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSweepAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= -360.0 || value >= 360.0) {
            String string = InternalResource.loadString("value", "GeoEllipticArc_SweepAngleRange(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (value == 0.0) {
            String string = InternalResource.loadString("value", "GeoEllipticArc_StartAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = this.getStartAngle();
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = GeoEllipticArc.valueToUGC(d2, value, d3, d4);
        GeoEllipticArcNative.jni_setStartAngle(this.getHandle(), dArray[0], dArray[1]);
        this.b = value;
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticArcNative.jni_getAngle(this.getHandle());
    }

    public void setRotation(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotation(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipticArcNative.jni_setAngle(this.getHandle(), value);
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticArcNative.jni_getLength(this.getHandle());
    }

    public GeoLine convertToLine(int segmentCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ConvertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoEllipticArcNative.jni_convertToLine(this.getHandle(), segmentCount);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setHandle(l, true);
        }
        return geoLine;
    }

    public Point2D findPointOnArc(double sweepAngle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FindPointOnArc(double sweepAngle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (sweepAngle > this.getSweepAngle() || sweepAngle < 0.0) {
            String string = InternalResource.loadString("FindPointOnArc(double sweepAngle)", "GeoEllipticArc_ArgumentOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoEllipticArcNative.jni_findPointOnArc(this.getHandle(), sweepAngle, dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    @Override
    public GeoEllipticArc clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoEllipticArc(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoEllipticArcNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected static double[] valueToUGC(double ugoStart, double ugoSweep, double ugcStart, double ugcEnd) {
        int n = (int)ugoStart;
        int n2 = n / 360;
        double d2 = ugoStart -= (double)(360 * n2);
        double d3 = ugoStart + ugoSweep;
        if (ugoSweep < 0.0) {
            d2 = ugoStart + ugoSweep;
            d3 = ugoStart;
        }
        double[] dArray = new double[]{d2, d3};
        return dArray;
    }
}

