/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoBezier3CurveNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;

public class GeoBezier3Curve
extends Geometry {
    public GeoBezier3Curve() {
        long l = GeoBezier3CurveNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoBezier3Curve(GeoBezier3Curve geoBCurve) {
        if (geoBCurve == null) {
            String string = InternalResource.loadString("GeoBezier3Curve", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoBCurve);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoBezier3Curve", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoBezier3CurveNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoBCurve);
    }

    public GeoBezier3Curve(Point2Ds controlPoints) {
        int n = controlPoints.getCount();
        if (n != 4) {
            String string = InternalResource.loadString("controlPoints", "GeoBezier3Curve_ControlPointsMustBeFour", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = controlPoints.getItem(i).getX();
            dArray2[i] = controlPoints.getItem(i).getY();
        }
        long l = GeoBezier3CurveNative.jni_New2(dArray, dArray2);
        this.setHandle(l, true);
    }

    GeoBezier3Curve(long handle) {
        this.setHandle(handle, false);
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoBezier3CurveNative.jni_GetLength(this.getHandle());
    }

    public Point2Ds getControlPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getControlPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoBezier3CurveNative.jni_GetPartPointCount(this.getHandle());
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        GeoBezier3CurveNative.jni_GetControlPoints(this.getHandle(), dArray, dArray2);
        Point2Ds point2Ds = new Point2Ds();
        for (int i = 0; i < n; ++i) {
            point2Ds.add(new Point2D(dArray[i], dArray2[i]));
        }
        return point2Ds;
    }

    public void setControlPoints(Point2Ds controlPoints) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setControlPoints(Point2Ds controlPoints)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = controlPoints.getCount();
        if (n != 4) {
            String string = InternalResource.loadString("controlPoints", "GeoBezier3Curve_ControlPointsMustBeFour", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray[i] = controlPoints.getItem(i).getX();
            dArray2[i] = controlPoints.getItem(i).getY();
        }
        GeoBezier3CurveNative.jni_SetControlPoints(this.getHandle(), dArray, dArray2);
    }

    public GeoLine convertToLine(int pointCountPerSegment) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoBezier3CurveNative.jni_ConvertToLine(this.getHandle(), pointCountPerSegment);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    @Override
    public Geometry clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoBezier3Curve(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoBezier3CurveNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }
}

