/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoBendingCylinderNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoBendingCylinder
extends Geometry3D {
    public GeoBendingCylinder() {
        long l = GeoBendingCylinderNative.jni_New1();
        this.setHandle(l, true);
    }

    public GeoBendingCylinder(GeoBendingCylinder geoBendingCylinder) {
        if (geoBendingCylinder == null) {
            String string = InternalResource.loadString("GeoBendingCylinder", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoBendingCylinder.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBendingCylinder", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoBendingCylinderNative.jni_Clone(geoBendingCylinder.getHandle(), this.getHandle());
    }

    public GeoBendingCylinder(Point3D position, double radius, double length, double angle) {
        double[] dArray = new double[]{position.getX(), position.getY(), position.getZ()};
        long l = GeoBendingCylinderNative.jni_New3(dArray, radius, length, angle);
        this.setHandle(l, true);
    }

    @Override
    public GeoBendingCylinder clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoBendingCylinder(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("GeoBendingCylinder", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoBendingCylinderNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRadius", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoBendingCylinderNative.jni_GetRadius(this.getHandle());
    }

    public void setRadius(double radius) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRadius", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoBendingCylinderNative.jni_SetRadius(this.getHandle(), radius);
    }

    public double getAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAngle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoBendingCylinderNative.jni_GetAngle(this.getHandle());
    }

    public void setAngle(double angle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAngle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoBendingCylinderNative.jni_SetAngle(this.getHandle(), angle);
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoBendingCylinderNative.jni_GetLength(this.getHandle());
    }

    public void setLength(double length) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLength", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoBendingCylinderNative.jni_SetLength(this.getHandle(), length);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoBendingCylinderNative.jni_GetCenter(this.getHandle());
        if (dArray != null && dArray.length == 3) {
            Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
            return point3D;
        }
        return null;
    }
}

