/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoArcNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;

public class GeoArc
extends Geometry {
    private double a;
    private double b;

    public GeoArc() {
        long l = GeoArcNative.jni_New();
        this.setHandle(l, true);
        this.a = 0.0;
        this.b = 180.0;
    }

    public GeoArc(GeoArc geoArc) {
        if (geoArc == null) {
            String string = InternalResource.loadString("geoArc", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoArc);
        if (l == 0L) {
            String string = InternalResource.loadString("geoArc", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoArcNative.jni_Clone(l);
        this.a = geoArc.getStartAngle();
        this.b = geoArc.getSweepAngle();
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoArc);
    }

    GeoArc(long handle) {
        this.setHandle(handle, false);
        this.a = GeoArcNative.jni_GetStartAngle(handle);
        this.b = GeoArcNative.jni_GetSweepAngle(handle);
    }

    public GeoArc(Point2D center, double radius, double startAngle, double sweepAngle) {
        double d2;
        if (radius <= 0.0) {
            String string = InternalResource.loadString("radius", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sweepAngle <= -360.0 || sweepAngle >= 360.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoArc_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sweepAngle == 0.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoArc_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = GeoArc.valueToUGC(startAngle, sweepAngle, d3, d4);
        double d5 = center.getX();
        long l = GeoArcNative.jni_New2(d5, d2 = center.getY(), radius, dArray[0], dArray[1]);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoArc(Point2D startPoint,Point2D middlePoint,Point2D endPoint)", "ThreePointsAreInOneLine", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a = startAngle;
        this.b = sweepAngle;
        this.setHandle(l, true);
    }

    public GeoArc(Point2D startPoint, Point2D middlePoint, Point2D endPoint) {
        double d2 = startPoint.getX();
        double d3 = startPoint.getY();
        double d4 = middlePoint.getX();
        double d5 = middlePoint.getY();
        double d6 = endPoint.getX();
        double d7 = endPoint.getY();
        long l = GeoArcNative.jni_New3(d2, d3, d4, d5, d6, d7);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoArc(Point2D startPoint,Point2D middlePoint,Point2D endPoint)", "ThreePointsAreInOneLine", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d8 = GeoArcNative.jni_GetStartAngle(l);
        double d9 = GeoArcNative.jni_GetEndAngle(l);
        if (d9 - d8 < 0.0) {
            this.a = d9;
            this.b = -(360.0 - (d8 - d9));
        } else {
            this.a = d8;
            this.b = d9 - d8;
        }
        this.setHandle(l, true);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoArcNative.jni_GetCenter(this.getHandle(), dArray);
        Point2D point2D = new Point2D();
        point2D.setX(dArray[0]);
        point2D.setY(dArray[1]);
        return point2D;
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D point2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = this.getRadius();
        double d5 = this.getStartAngle();
        double d6 = this.getSweepAngle();
        double d7 = 0.0;
        double d8 = 0.0;
        double[] dArray = GeoArc.valueToUGC(d5, d6, d7, d8);
        boolean bl = GeoArcNative.jni_SetArc(this.getHandle(), d2, d3, d4, dArray[0], dArray[1]);
        if (!bl) {
            String string = InternalResource.loadString("setCenter(Point2D point2D)", "GeoArc_FailConstruct", "data_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public double getRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRadius()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoArcNative.jni_GetRadius(this.getHandle());
    }

    public void setRadius(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRadius(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point2D point2D = this.getCenter();
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = this.getStartAngle();
        double d5 = this.getSweepAngle();
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = GeoArc.valueToUGC(d4, d5, d6, d7);
        boolean bl = GeoArcNative.jni_SetArc(this.getHandle(), d2, d3, value, dArray[0], dArray[1]);
        if (!bl) {
            String string = InternalResource.loadString("setRadius(double value)", "GeoArc_FailConstruct", "data_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void setStartAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point2D point2D = this.getCenter();
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = this.getRadius();
        double d5 = this.getSweepAngle();
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = GeoArc.valueToUGC(value, d5, d6, d7);
        boolean bl = GeoArcNative.jni_SetArc(this.getHandle(), d2, d3, d4, dArray[0], dArray[1]);
        if (!bl) {
            String string = InternalResource.loadString("setStartAngle(double value)", "GeoArc_FailConstruct", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a = value;
    }

    public double getSweepAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSweepAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.b;
    }

    public void setSweepAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSweepAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= -360.0 || value >= 360.0) {
            String string = InternalResource.loadString("value", "GeoArc_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (value == 0.0) {
            String string = InternalResource.loadString("setSweepAngle(double value)", "GeoArc_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2D point2D = this.getCenter();
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = this.getRadius();
        double d5 = this.getStartAngle();
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = GeoArc.valueToUGC(d5, value, d6, d7);
        boolean bl = GeoArcNative.jni_SetArc(this.getHandle(), d2, d3, d4, dArray[0], dArray[1]);
        if (!bl) {
            String string = InternalResource.loadString("setSweepAngle(double value)", "GeoArc_FailConstruct", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.b = value;
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoArcNative.jni_GetLength(this.getHandle());
    }

    public GeoLine convertToLine(int segmentCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoArcNative.jni_ConvertToLine(this.getHandle(), segmentCount);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    public Point2D findPointOnArc(double sweepAngle) {
        if (this.getSweepAngle() < 0.0 && (sweepAngle < this.getSweepAngle() || sweepAngle > 0.0)) {
            String string = InternalResource.loadString("findPointOnArc(double sweepAngle)", "GeoArc_SweepAngleOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getSweepAngle() > 0.0 && (sweepAngle > this.getSweepAngle() || sweepAngle < 0.0)) {
            String string = InternalResource.loadString("findPointOnArc(double sweepAngle)", "GeoArc_SweepAngleOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = (int)this.getStartAngle();
        int n2 = n / 360;
        double d2 = this.getStartAngle() - (double)(360 * n2);
        double d3 = d2 + sweepAngle;
        double d4 = d3 / 180.0 * Math.PI;
        Point2D point2D = this.getCenter();
        double d5 = point2D.getX() + Math.cos(d4) * this.getRadius();
        double d6 = point2D.getY() + Math.sin(d4) * this.getRadius();
        Point2D point2D2 = new Point2D(d5, d6);
        return point2D2;
    }

    @Override
    public GeoArc clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoArc(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoArcNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    protected static double[] valueToUGC(double ugoStart, double ugoSweep, double ugcStart, double ugcEnd) {
        int n = (int)ugoStart;
        int n2 = n / 360;
        double d2 = ugoStart -= (double)(360 * n2);
        double d3 = ugoStart + ugoSweep;
        if (ugoSweep < 0.0) {
            d2 = ugoStart + ugoSweep;
            d3 = ugoStart;
        }
        double[] dArray = new double[]{d2, d3};
        return dArray;
    }
}

