/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BlockSizeOption;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetImageInfoNative;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;

public class DatasetImageInfo
extends InternalHandleDisposable {
    public DatasetImageInfo() {
        this.setHandle(DatasetImageInfoNative.jni_New(1), true);
        this.a();
    }

    public DatasetImageInfo(DatasetImageInfo datasetImageInfo) {
        if (datasetImageInfo == null) {
            String string = InternalResource.loadString("datasetImageInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetImageInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetImageInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetImageInfoNative.jni_Clone(datasetImageInfo.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(datasetImageInfo);
    }

    public DatasetImageInfo(String name, int width, int height, PixelFormat pixelFormat, EncodeType encodeType, BlockSizeOption option, int bandCount) {
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (pixelFormat == null) {
            String string = InternalResource.loadString("pixelFormat", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (encodeType == null) {
            String string = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        this.setHandle(DatasetImageInfoNative.jni_New(bandCount), true);
        this.a();
        this.setName(name);
        this.setWidth(width);
        this.setHeight(height);
        this.setPixelFormat(pixelFormat);
        this.setBlockSizeOption(option);
        this.setEncodeType(encodeType);
    }

    public DatasetImageInfo(String name, DatasetImage templateDataset) {
        if (templateDataset == null) {
            String string = InternalResource.loadString("templateDataset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = templateDataset.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("templateDataset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = DatasetImageInfoNative.jni_New2(l);
        this.setHandle(l2, true);
        this.setName(name);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageInfoNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        InternalInvalidState internalInvalidState = Dataset.b(value);
        if (internalInvalidState != null) {
            String string = "";
            if (internalInvalidState.equals(InternalInvalidState.ISEMPTY)) {
                string = "Dataset_NameIsEmpty";
            } else if (internalInvalidState.equals(InternalInvalidState.AGAINSYSTEMNAME)) {
                string = "Dataset_NameAgainstSys";
            } else if (internalInvalidState.equals(InternalInvalidState.BEYONDLIMIT)) {
                string = "Dataset_NameBeyondLimit";
            } else if (internalInvalidState.equals(InternalInvalidState.INVALIDCHAR)) {
                string = "Dataset_NameIncludeInvalidChar";
            } else if (internalInvalidState.equals(InternalInvalidState.PREFIXERROR)) {
                string = "Dataset_NameErrorPrefix";
            }
            String string2 = InternalResource.loadString("value", string, "data_resources");
            throw new IllegalArgumentException(string2);
        }
        DatasetImageInfoNative.jni_SetName(this.getHandle(), value);
    }

    public int getBandCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageInfoNative.jni_GetBandCount(this.getHandle());
    }

    public void setBandCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "DatasetImage_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetImageInfoNative.jni_SetBandCount(this.getHandle(), value);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DatasetImageInfoNative.jni_GetBounds(this.getHandle(), dArray);
        return new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public void setBounds(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetImageInfoNative.jni_SetBounds(this.getHandle(), value.getLeft(), value.getBottom(), value.getRight(), value.getTop());
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageInfoNative.jni_GetWidth(this.getHandle());
    }

    public void setWidth(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0) {
            String string = InternalResource.loadString("value", "DatasetImage_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetImageInfoNative.jni_SetWidth(this.getHandle(), value);
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageInfoNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0) {
            String string = InternalResource.loadString("value", "DatasetImage_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetImageInfoNative.jni_SetHeight(this.getHandle(), value);
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageInfoNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public void setPixelFormat(PixelFormat value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetImageInfoNative.jni_SetPixelFormat(this.getHandle(), value.getUGCValue());
    }

    public BlockSizeOption getBlockSizeOption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageInfoNative.jni_GetBlockSize(this.getHandle());
        return (BlockSizeOption)Enum.parseUGCValue(BlockSizeOption.class, n);
    }

    public void setBlockSizeOption(BlockSizeOption option) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetImageInfoNative.jni_SetBlockSize(this.getHandle(), option.getUGCValue());
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageInfoNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n);
    }

    public void setEncodeType(EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (encodeType == null) {
            String string = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetImageInfoNative.jni_SetEncodeType(this.getHandle(), encodeType.getUGCValue());
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            DatasetImageInfoNative.jni_Delete(super.getHandle());
            this.clearHandle();
        }
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Nmae = ");
        stringBuffer.append(this.getName());
        stringBuffer.append(",Bounds = {");
        stringBuffer.append(this.getBounds().toString());
        stringBuffer.append("},Width = ");
        stringBuffer.append(this.getWidth());
        stringBuffer.append(",Height = ");
        stringBuffer.append(this.getHeight());
        stringBuffer.append(",PixelFormat = ");
        stringBuffer.append(this.getPixelFormat().name());
        stringBuffer.append(",BlockSize = ");
        stringBuffer.append(this.getBlockSizeOption());
        stringBuffer.append(",EncodeType = ");
        stringBuffer.append(this.getEncodeType().name());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    void a() {
        if (this.getHandle() != 0L) {
            DatasetImageInfoNative.jni_Reset(this.getHandle());
        }
    }
}

