/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGroupItemAddedEvent;
import com.supermap.data.DatasetGroupItemAddedListener;
import com.supermap.data.DatasetGroupItemRemovedEvent;
import com.supermap.data.DatasetGroupItemRemovedListener;
import com.supermap.data.DatasetGroupItemRemovingEvent;
import com.supermap.data.DatasetGroupItemRemovingListener;
import com.supermap.data.DatasetGroupNative;
import com.supermap.data.DatasetGroupRenamedEvent;
import com.supermap.data.DatasetGroupRenamedListener;
import com.supermap.data.DatasetGroupRenamingEvent;
import com.supermap.data.DatasetGroupRenamingListener;
import com.supermap.data.DatasetGroups;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalResource;
import java.util.Vector;

public class DatasetGroup
extends InternalHandle {
    private DatasetGroup a;
    private DatasetGroups b;
    private Datasource c;
    private Vector<DatasetGroupRenamedListener> d;
    private Vector<DatasetGroupRenamingListener> e;
    private Vector<DatasetGroupItemAddedListener> f;
    private Vector<DatasetGroupItemRemovingListener> g;
    private Vector<DatasetGroupItemRemovedListener> h;

    DatasetGroup(long handle, Datasource datasource, DatasetGroup parent) {
        this.setHandle(handle);
        this.c = datasource;
        this.a = parent;
    }

    public DatasetGroup getParent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void refreshChildGroups() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.getChildGroups().RefreshGroups();
    }

    public DatasetGroups getChildGroups() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.b == null) {
            this.b = new DatasetGroups(this);
        }
        return this.b;
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGroupNative.jni_GetName(this.getHandle());
    }

    public void setName(String newName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a != null && this.a.getChildGroups().contains(newName)) {
            String string = InternalResource.loadString("name", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getName();
        DatasetGroupRenamingEvent datasetGroupRenamingEvent = new DatasetGroupRenamingEvent(this, string, newName, false);
        this.fireRenaming(datasetGroupRenamingEvent);
        if (!datasetGroupRenamingEvent.isCancel()) {
            DatasetGroupNative.jni_SetName(this.getHandle(), newName);
            this.fireRenamed(new DatasetGroupRenamedEvent(this, string, newName));
        }
    }

    public Dataset get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DatasetGroupNative.jni_GetDataset(this.getHandle(), index);
        if (l == 0L) {
            return null;
        }
        return new DatasetVector(l, this.c);
    }

    public Datasource getDatasource() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.c;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGroupNative.jni_GetDatasetCount(this.getHandle());
    }

    public int add(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.indexOf(dataset.getName()) != -1) {
            String string = InternalResource.loadString("", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.getDatasource() != this.getDatasource()) {
            String string = InternalResource.loadString("", "DatasetGroup_AndDatasetMustBeInTheSameDatasource", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = DatasetGroupNative.jni_AddDataset(this.getHandle(), dataset.getHandle());
        this.fireAdded(new DatasetGroupItemAddedEvent(this, dataset.getName()));
        return n;
    }

    public boolean remove(String datasetName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetGroupItemRemovingEvent datasetGroupItemRemovingEvent = new DatasetGroupItemRemovingEvent(this, datasetName, false);
        this.fireRemoving(datasetGroupItemRemovingEvent);
        boolean bl = false;
        if (!datasetGroupItemRemovingEvent.isCancel()) {
            bl = DatasetGroupNative.jni_RemoveDataset(this.getHandle(), datasetName);
            this.fireRemoved(new DatasetGroupItemRemovedEvent(this, datasetName));
        }
        return bl;
    }

    public int indexOf(String datasetName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        String string = "";
        Dataset dataset = this.a.getDatasource().getDatasets().get(datasetName);
        if (dataset != null) {
            string = dataset.getTableName();
            n = DatasetGroupNative.jni_IndexOfDataset(this.getHandle(), string);
        }
        return n;
    }

    public int indexOf(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            return -1;
        }
        return DatasetGroupNative.jni_IndexOfDataset(this.getHandle(), dataset.getTableName());
    }

    @Override
    protected void clearHandle() {
        this.a = null;
        this.c = null;
        if (this.b != null) {
            this.b.clearHandle();
            this.b = null;
        }
        this.setHandle(0L);
    }

    public synchronized void addRenamedListener(DatasetGroupRenamedListener l) {
        if (this.d == null) {
            this.d = new Vector();
        }
        if (!this.d.contains(l)) {
            this.d.insertElementAt(l, 0);
        }
    }

    public synchronized void removeRenamedListener(DatasetGroupRenamedListener l) {
        if (this.d != null && this.d.contains(l)) {
            this.d.remove(l);
        }
    }

    public synchronized void addRenamingListener(DatasetGroupRenamingListener l) {
        if (this.e == null) {
            this.e = new Vector();
        }
        if (!this.e.contains(l)) {
            this.e.insertElementAt(l, 0);
        }
    }

    public synchronized void removeRenamingListener(DatasetGroupRenamingListener l) {
        if (this.e != null && this.e.contains(l)) {
            this.e.remove(l);
        }
    }

    protected void fireRenaming(DatasetGroupRenamingEvent event) {
        if (this.e != null) {
            Vector<DatasetGroupRenamingListener> vector = this.e;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupRenaming(event);
            }
        }
    }

    protected void fireRenamed(DatasetGroupRenamedEvent event) {
        if (this.d != null) {
            Vector<DatasetGroupRenamedListener> vector = this.d;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupRenamed(event);
            }
        }
    }

    public synchronized void addAddedListener(DatasetGroupItemAddedListener l) {
        if (this.f == null) {
            this.f = new Vector();
        }
        if (!this.f.contains(l)) {
            this.f.insertElementAt(l, 0);
        }
    }

    public synchronized void removeAddedListener(DatasetGroupItemAddedListener l) {
        if (this.f != null && this.f.contains(l)) {
            this.f.remove(l);
        }
    }

    protected void fireAdded(DatasetGroupItemAddedEvent event) {
        if (this.f != null) {
            Vector<DatasetGroupItemAddedListener> vector = this.f;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupItemAdded(event);
            }
        }
    }

    public synchronized void addRemovingListener(DatasetGroupItemRemovingListener l) {
        if (this.g == null) {
            this.g = new Vector();
        }
        if (!this.g.contains(l)) {
            this.g.insertElementAt(l, 0);
        }
    }

    public synchronized void removeRemovingListener(DatasetGroupItemRemovingListener l) {
        if (this.g != null && this.g.contains(l)) {
            this.g.remove(l);
        }
    }

    protected void fireRemoving(DatasetGroupItemRemovingEvent event) {
        if (this.g != null) {
            Vector<DatasetGroupItemRemovingListener> vector = this.g;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupItemRemoving(event);
            }
        }
    }

    public synchronized void addRemovedListener(DatasetGroupItemRemovedListener l) {
        if (this.h == null) {
            this.h = new Vector();
        }
        if (!this.h.contains(l)) {
            this.h.insertElementAt(l, 0);
        }
    }

    public synchronized void removeRemovedListener(DatasetGroupItemRemovedListener l) {
        if (this.h != null && this.h.contains(l)) {
            this.h.remove(l);
        }
    }

    protected void fireRemoved(DatasetGroupItemRemovedEvent e2) {
        if (this.h != null) {
            Vector<DatasetGroupItemRemovedListener> vector = this.h;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupItemRemoved(e2);
            }
        }
    }
}

