/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetCollectionChangeOrderEvent;
import com.supermap.data.DatasetCollectionChangeOrderListener;
import com.supermap.data.DatasetCollectionEvent;
import com.supermap.data.DatasetCollectionListener;
import com.supermap.data.DatasetCollectionRemoveAllEvent;
import com.supermap.data.DatasetCollectionRemoveAllListener;
import com.supermap.data.DatasetCollectionRenameEvent;
import com.supermap.data.DatasetCollectionRenameListener;
import com.supermap.data.DatasetCollectionRequireRefreshEvent;
import com.supermap.data.DatasetCollectionRequireRefreshListener;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridCollectionNative;
import com.supermap.data.DatasetImageCollectionNative;
import com.supermap.data.DatasetNative;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import java.util.Map;
import java.util.Vector;

@Deprecated
public class DatasetGridCollection
extends Dataset {
    private Vector<DatasetCollectionRenameListener> e;
    private Vector<DatasetCollectionRenameListener> f;
    private Vector<DatasetCollectionListener> g;
    private Vector<DatasetCollectionListener> h;
    private Vector<DatasetCollectionListener> i;
    private Vector<DatasetCollectionChangeOrderListener> j;
    private Vector<DatasetCollectionRemoveAllListener> k;
    private Vector<DatasetCollectionRemoveAllListener> l;
    private Vector<DatasetCollectionRequireRefreshListener> m;
    private GeoRegion n = null;
    private Colors o = null;

    protected DatasetGridCollection() {
        m_senderMethodName = "buildPyramid";
    }

    DatasetGridCollection(long handle, Datasource datasource) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle);
        this.m_datasource = datasource;
        this.m_ugcRawPointerHandle = DatasetNative.jni_GetRawPointerHandle(handle);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridCollectionNative.jni_GetCount(this.getHandle());
    }

    public DatasetGrid getDataset(String aliasName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DatasetGridCollectionNative.jni_GetSubDataset(this.getHandle(), aliasName);
        DatasetGrid datasetGrid = null;
        if (l != 0L) {
            datasetGrid = new DatasetGrid(l, this.m_datasource);
        }
        return datasetGrid;
    }

    public String get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetGridCollectionNative.jni_GetAliasName(this.getHandle(), index);
    }

    private String[] a() {
        return DatasetGridCollectionNative.jni_GetAliasNames(this.getHandle());
    }

    protected static String[] getAliasNames(DatasetGridCollection gridCollection) {
        if (gridCollection != null && gridCollection.getHandle() != 0L) {
            return gridCollection.a();
        }
        return null;
    }

    public int indexOf(String aliasName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(String aliasName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridCollectionNative.jni_GetSubDatasetOrder(this.getHandle(), aliasName);
    }

    public DatasetVector getAttributeDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAttributeTable()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DatasetGridCollectionNative.jni_GetAttributeDataset(this.getHandle());
        DatasetVector datasetVector = null;
        if (l != 0L) {
            datasetVector = new DatasetVector(l, this.m_datasource);
        }
        return datasetVector;
    }

    public double getNoValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridCollectionNative.jni_GetNoValue(this.getHandle());
    }

    public void setNoValue(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetGridCollectionNative.jni_SetNoValue(this.getHandle(), value);
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetGridCollectionNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public boolean getHasPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridCollectionNative.jni_GetHasPyramid(this.getHandle());
    }

    public GeoRegion getClipRegion() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.n == null && (l = DatasetGridCollectionNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this.n = new GeoRegion(l);
        }
        return this.n;
    }

    public void setClipRegion(GeoRegion value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            if (this.n != null) {
                this.n.clearHandle();
                this.n = null;
            }
            DatasetGridCollectionNative.jni_SetClipRegion(this.getHandle(), 0L);
        } else {
            if (value.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetGridCollectionNative.jni_SetClipRegion(this.getHandle(), value.getHandle());
            if (this.n != null) {
                this.n.fromXML(value.toXML());
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public Colors getColorTable() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorTable()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.o == null && (l = DatasetGridCollectionNative.jni_GetColorTable(this.getHandle())) != 0L) {
            this.o = Colors.createInstance(l, false);
        }
        return this.o;
    }

    public void setColorTable(Colors colors) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorTable(Colors colors)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (colors == null) {
            String string = InternalResource.loadString("colors", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(colors);
        if (l == 0L) {
            String string = InternalResource.loadString("colors", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Colors colors2 = new Colors(colors);
        long l2 = InternalHandleDisposable.getHandle(colors2);
        DatasetGridCollectionNative.jni_SetColorTable(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive(colors2);
    }

    public boolean add(String name, String aliasName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(String name,String aliasName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name.equals("") || aliasName.equals("")) {
            String string = InternalResource.loadString("params", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getCount();
        boolean bl = DatasetGridCollectionNative.jni_Add(this.getHandle(), name, aliasName);
        if (bl) {
            this.fireAdded(new DatasetCollectionEvent(this, aliasName, n, false));
        }
        return bl;
    }

    public boolean add(String name, String aliasName, boolean isTop) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(String name,String aliasName ,boolean isTop)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name.equals("") || aliasName.equals("")) {
            String string = InternalResource.loadString("params", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        if (!isTop) {
            n = this.getCount();
        }
        if (bl = DatasetGridCollectionNative.jni_Add1(this.getHandle(), name, aliasName, isTop)) {
            this.fireAdded(new DatasetCollectionEvent(this, aliasName, n, false));
        }
        return bl;
    }

    public boolean add(Map<String, String> aliasNameAndName) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Map<String, String> values)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object[] objectArray = aliasNameAndName.keySet().toArray();
        int n2 = objectArray.length;
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = (String)objectArray[n];
            stringArray2[n] = aliasNameAndName.get(stringArray[n]);
        }
        n = DatasetGridCollectionNative.jni_Add2(this.getHandle(), stringArray, stringArray2) ? 1 : 0;
        if (n != 0) {
            this.fireRequireRefresh(new DatasetCollectionRequireRefreshEvent(this));
        }
        return n != 0;
    }

    public boolean insert(String name, String aliasName, int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(String name, String aliasName, int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name.equals("") || aliasName.equals("")) {
            String string = InternalResource.loadString("params", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = DatasetGridCollectionNative.jni_Insert(this.getHandle(), name, aliasName, index);
        if (bl) {
            this.fireAdded(new DatasetCollectionEvent(this, aliasName, index, false));
        }
        return bl;
    }

    public boolean append(DatasetGridCollection datasetGridCollection) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("append(DatasetGridCollection datasetCollection)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (datasetGridCollection.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetCollection", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = DatasetGridCollectionNative.jni_Append(this.getHandle(), datasetGridCollection.getHandle());
        if (bl) {
            this.fireRequireRefresh(new DatasetCollectionRequireRefreshEvent(this));
        }
        return bl;
    }

    public boolean remove(String aliasName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(String aliasName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = DatasetImageCollectionNative.jni_GetSubDatasetOrder(this.getHandle(), aliasName);
        DatasetCollectionEvent datasetCollectionEvent = new DatasetCollectionEvent(this, aliasName, n, false);
        this.fireRemoving(datasetCollectionEvent);
        if (!datasetCollectionEvent.isCancel()) {
            bl = DatasetGridCollectionNative.jni_Remove(this.getHandle(), aliasName);
            this.fireRemoved(new DatasetCollectionEvent(this, aliasName, n, false));
        }
        return bl;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        String string = DatasetImageCollectionNative.jni_GetAliasName(this.getHandle(), index);
        DatasetCollectionEvent datasetCollectionEvent = new DatasetCollectionEvent(this, string, index, false);
        this.fireRemoving(datasetCollectionEvent);
        if (!datasetCollectionEvent.isCancel()) {
            bl = DatasetGridCollectionNative.jni_Remove1(this.getHandle(), index);
            this.fireRemoved(new DatasetCollectionEvent(this, string, index, false));
        }
        return bl;
    }

    public boolean removeAll() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeAll()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        DatasetCollectionRemoveAllEvent datasetCollectionRemoveAllEvent = new DatasetCollectionRemoveAllEvent(this, false);
        this.fireRemovingAll(datasetCollectionRemoveAllEvent);
        if (!datasetCollectionRemoveAllEvent.isCancel()) {
            bl = DatasetGridCollectionNative.jni_RemoveAll(this.getHandle());
            this.fireRemovedAll(new DatasetCollectionRemoveAllEvent(this, false));
        }
        return bl;
    }

    public boolean synchronize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("synchronize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = DatasetGridCollectionNative.jni_Synchronize(this.getHandle());
        if (bl) {
            this.fireRequireRefresh(new DatasetCollectionRequireRefreshEvent(this));
        }
        return bl;
    }

    public boolean changeOrder(String aliasName, int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("changeOrder(String aliasName, int position)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetGridCollectionNative.jni_GetSubDatasetOrder(this.getHandle(), aliasName);
        boolean bl = DatasetGridCollectionNative.jni_ChangeOrder(this.getHandle(), aliasName, index);
        if (bl) {
            this.fireOrderChanged(new DatasetCollectionChangeOrderEvent(this, aliasName, n, index));
        }
        return bl;
    }

    public boolean buildPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.getHasPyramid()) {
            bl = true;
        } else {
            this.m_selfEventHandle = DatasetGridCollectionNative.jni_NewSelfEventHandle(this);
            bl = DatasetGridCollectionNative.jni_BuildPyramid(this.getHandle(), this.m_selfEventHandle);
            this.clearSelfEventHandle();
        }
        return bl;
    }

    public boolean removePyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridCollectionNative.jni_RemovePyramid(this.getHandle());
    }

    public boolean updatePyramid(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = DatasetGridCollectionNative.jni_UpdatePyramid(this.getHandle(), value.getLeft(), value.getBottom(), value.getRight(), value.getTop());
        return bl;
    }

    public boolean isAvailableAliasName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAvailableAliasName(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridCollectionNative.jni_IsAvailableAliasName(this.getHandle(), this.m_datasource.getHandle(), name);
    }

    public String getAvailableAliasName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAvailableAliasName(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridCollectionNative.jni_GetAvailableAliasName(this.getHandle(), this.m_datasource.getHandle(), name);
    }

    public boolean rename(String aliasName, String newAliasName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rename(String aliasName,String newAliasName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (aliasName.equals("") || newAliasName.equals("")) {
            String string = InternalResource.loadString("params", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        DatasetCollectionRenameEvent datasetCollectionRenameEvent = new DatasetCollectionRenameEvent(this, aliasName, newAliasName, false);
        this.fireRenaming(datasetCollectionRenameEvent);
        if (!datasetCollectionRenameEvent.isCancel()) {
            bl = DatasetGridCollectionNative.jni_Rename(this.getHandle(), aliasName, newAliasName);
            this.fireRenamed(new DatasetCollectionRenameEvent(this, aliasName, newAliasName, false));
        }
        return bl;
    }

    @Override
    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DatasetGridCollectionNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    @Override
    protected void clearHandle() {
        if (this.n != null) {
            this.n.clearHandle();
            this.n = null;
        }
        if (this.o != null) {
            this.o.clearHandle();
            this.o = null;
        }
        this.setHandle(0L);
    }

    public synchronized void addRenamingListener(DatasetCollectionRenameListener l) {
        if (this.f == null) {
            this.f = new Vector();
        }
        if (!this.f.contains(l)) {
            this.f.add(l);
        }
    }

    public synchronized void removeRenamingListener(DatasetCollectionRenameListener l) {
        if (this.f != null && this.f.contains(l)) {
            this.f.remove(l);
        }
    }

    public synchronized void addRenamedListener(DatasetCollectionRenameListener l) {
        if (this.e == null) {
            this.e = new Vector();
        }
        if (!this.e.contains(l)) {
            this.e.add(l);
        }
    }

    public synchronized void removeRenamedListener(DatasetCollectionRenameListener l) {
        if (this.e != null && this.e.contains(l)) {
            this.e.remove(l);
        }
    }

    protected void fireRenaming(DatasetCollectionRenameEvent event) {
        if (this.f != null) {
            Vector<DatasetCollectionRenameListener> vector = this.f;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollectionRename(event);
            }
        }
    }

    protected void fireRenamed(DatasetCollectionRenameEvent event) {
        if (this.e != null) {
            Vector<DatasetCollectionRenameListener> vector = this.e;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollectionRename(event);
            }
        }
    }

    public synchronized void addRemovingListener(DatasetCollectionListener l) {
        if (this.h == null) {
            this.h = new Vector();
        }
        if (!this.h.contains(l)) {
            this.h.add(l);
        }
    }

    public synchronized void removeRemovingListener(DatasetCollectionListener l) {
        if (this.h != null && this.h.contains(l)) {
            this.h.remove(l);
        }
    }

    public synchronized void addRemovedListener(DatasetCollectionListener l) {
        if (this.i == null) {
            this.i = new Vector();
        }
        if (!this.i.contains(l)) {
            this.i.add(l);
        }
    }

    public synchronized void removeRemovedListener(DatasetCollectionListener l) {
        if (this.i != null && this.i.contains(l)) {
            this.i.remove(l);
        }
    }

    protected void fireRemoving(DatasetCollectionEvent event) {
        if (this.h != null) {
            Vector<DatasetCollectionListener> vector = this.h;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollection(event);
            }
        }
    }

    protected void fireRemoved(DatasetCollectionEvent event) {
        if (this.i != null) {
            Vector<DatasetCollectionListener> vector = this.i;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollection(event);
            }
        }
    }

    public synchronized void addRemovingAllListener(DatasetCollectionRemoveAllListener l) {
        if (this.k == null) {
            this.k = new Vector();
        }
        if (!this.k.contains(l)) {
            this.k.add(l);
        }
    }

    public synchronized void removeRemovingAllListener(DatasetCollectionRemoveAllListener l) {
        if (this.k != null && this.k.contains(l)) {
            this.k.remove(l);
        }
    }

    public synchronized void addRemovedAllListener(DatasetCollectionRemoveAllListener l) {
        if (this.l == null) {
            this.l = new Vector();
        }
        if (!this.l.contains(l)) {
            this.l.add(l);
        }
    }

    public synchronized void removeRemovedAllListener(DatasetCollectionRemoveAllListener l) {
        if (this.l != null && this.l.contains(l)) {
            this.l.remove(l);
        }
    }

    protected void fireRemovingAll(DatasetCollectionRemoveAllEvent event) {
        if (this.k != null) {
            Vector<DatasetCollectionRemoveAllListener> vector = this.k;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollectionRemoveAll(event);
            }
        }
    }

    protected void fireRemovedAll(DatasetCollectionRemoveAllEvent event) {
        if (this.l != null) {
            Vector<DatasetCollectionRemoveAllListener> vector = this.l;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollectionRemoveAll(event);
            }
        }
    }

    public synchronized void addAddedListener(DatasetCollectionListener l) {
        if (this.g == null) {
            this.g = new Vector();
        }
        if (!this.g.contains(l)) {
            this.g.add(l);
        }
    }

    public synchronized void removeAddedListener(DatasetCollectionListener l) {
        if (this.g != null && this.g.contains(l)) {
            this.g.remove(l);
        }
    }

    protected void fireAdded(DatasetCollectionEvent event) {
        if (this.g != null) {
            Vector<DatasetCollectionListener> vector = this.g;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollection(event);
            }
        }
    }

    public synchronized void addOrderChangedListener(DatasetCollectionChangeOrderListener l) {
        if (this.j == null) {
            this.j = new Vector();
        }
        if (!this.j.contains(l)) {
            this.j.add(l);
        }
    }

    public synchronized void removeOrderChangedListener(DatasetCollectionChangeOrderListener l) {
        if (this.j != null && this.j.contains(l)) {
            this.j.remove(l);
        }
    }

    protected void fireOrderChanged(DatasetCollectionChangeOrderEvent event) {
        if (this.j != null) {
            Vector<DatasetCollectionChangeOrderListener> vector = this.j;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollectionChangeOrder(event);
            }
        }
    }

    public synchronized void addRequireRefreshListener(DatasetCollectionRequireRefreshListener l) {
        if (this.m == null) {
            this.m = new Vector();
        }
        if (!this.m.contains(l)) {
            this.m.add(l);
        }
    }

    public synchronized void removeRequireRefreshListener(DatasetCollectionRequireRefreshListener l) {
        if (this.m != null && this.m.contains(l)) {
            this.m.remove(l);
        }
    }

    protected void fireRequireRefresh(DatasetCollectionRequireRefreshEvent event) {
        if (this.m != null) {
            Vector<DatasetCollectionRequireRefreshListener> vector = this.m;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).datasetCollectionRequireRefresh(event);
            }
        }
    }
}

