/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.SolarRadiationParameterNative;
import com.supermap.analyst.spatialanalyst.SolarTimeMode;
import com.supermap.data.InternalHandleDisposable;

public class SolarRadiationParameter
extends InternalHandleDisposable {
    public SolarRadiationParameter() {
        this.setHandle(SolarRadiationParameterNative.jni_New(), true);
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            SolarRadiationParameterNative.jni_Dispose(this.getHandle());
            this.setHandle(0L);
        }
    }

    public void setLatitude(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setLatitude", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value < -90.0 || value > 90.0) {
            String string = InternalResourceSpatialanalyst.loadString("Latitude", "IllegalLatitudeValue", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetLatitude(this.getHandle(), value);
    }

    public double getLatitude() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getLatitude", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetLatitude(this.getHandle());
    }

    public void setTimeMode(SolarTimeMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setTimeMode", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        SolarRadiationParameterNative.jni_SetTimeMode(this.getHandle(), value.value());
    }

    public SolarTimeMode getTimeMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getTimeMode", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n = SolarRadiationParameterNative.jni_GetTimeMode(this.getHandle());
        SolarTimeMode solarTimeMode = (SolarTimeMode)InternalEnum.parseUGCValue(SolarTimeMode.class, n);
        return solarTimeMode;
    }

    public void setDayStart(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setDayStart", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0 || value > 365) {
            String string = InternalResourceSpatialanalyst.loadString("DayStart", "IllegalDayValue", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetDayStart(this.getHandle(), value);
    }

    public int getDayStart() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getDayStart", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetDayStart(this.getHandle());
    }

    public void setDayEnd(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setDayEnd", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0 || value > 365) {
            String string = InternalResourceSpatialanalyst.loadString("DayEnd", "IllegalDayValue", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetDayEnd(this.getHandle(), value);
    }

    public int getDayEnd() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getDayEnd", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetDayEnd(this.getHandle());
    }

    public void setHourStart(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setHourStart", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0 || value > 24.0) {
            String string = InternalResourceSpatialanalyst.loadString("HourStart", "IllegalHourValue", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetHourStart(this.getHandle(), value);
    }

    public double getHourStart() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getHourStart", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetHourStart(this.getHandle());
    }

    public void setHourEnd(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setHourEnd", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0 || value > 24.0) {
            String string = InternalResourceSpatialanalyst.loadString("HourEnd", "IllegalHourValue", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetHourEnd(this.getHandle(), value);
    }

    public double getHourEnd() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getHourEnd", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetHourEnd(this.getHandle());
    }

    public void setDayInterval(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setDayInterval", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0) {
            String string = InternalResourceSpatialanalyst.loadString("DayInterval", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetDayInterval(this.getHandle(), value);
    }

    public int getDayInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getDayInterval", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetDayInterval(this.getHandle());
    }

    public void setHourInterval(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setHourInterval", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0 || value > 24.0) {
            String string = InternalResourceSpatialanalyst.loadString("HourInterval", "IllegalHourValue", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetHourInterval(this.getHandle(), value);
    }

    public double getHourInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getHourInterval", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetHourInterval(this.getHandle());
    }

    public void setTransmittance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setTransmittance", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0 || value > 1.0) {
            String string = InternalResourceSpatialanalyst.loadString("Transmittance", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetTransmittance(this.getHandle(), value);
    }

    public double getTransmittance() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getTransmittance", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetTransmittance(this.getHandle());
    }

    public void setZFactor(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setZFactor", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("ZFactor", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetZFactor(this.getHandle(), value);
    }

    public double getZFactor() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getZFactor", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetZFactor(this.getHandle());
    }
}

