/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.CalibrateOptions;
import com.supermap.analyst.spatialanalyst.CreateMarkPointsParameter;
import com.supermap.analyst.spatialanalyst.EventDissolveType;
import com.supermap.analyst.spatialanalyst.EventOverlayType;
import com.supermap.analyst.spatialanalyst.GenerateEventTableParameter;
import com.supermap.analyst.spatialanalyst.GenerateRoutesParameter;
import com.supermap.analyst.spatialanalyst.GenerateSpatialDataParameter;
import com.supermap.analyst.spatialanalyst.GenerateType;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.LinearReferencingNative;
import com.supermap.analyst.spatialanalyst.RouteEventsParameter;
import com.supermap.analyst.spatialanalyst.StatisticsType;
import com.supermap.data.CalibrateMode;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.DynamicSegmentInfo;
import com.supermap.data.DynamicSegmentManager;
import com.supermap.data.FieldType;
import com.supermap.data.InternalHandle;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.util.Collection;
import java.util.Vector;

public class LinearReferencing {
    private static transient Vector a;

    private LinearReferencing() {
    }

    public static DatasetVector generateRoutes(DatasetVector referenceLine, GenerateRoutesParameter parameter) {
        return LinearReferencing.generateRoutes(referenceLine, parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector generateRoutes(DatasetVector referenceLine, GenerateRoutesParameter parameter, SteppedListener ... listeners) {
        try {
            String string;
            String string2;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (referenceLine == null) {
                String string3 = InternalResourceSpatialanalyst.loadString("referenceLine", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            if (parameter == null) {
                String string4 = InternalResourceSpatialanalyst.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string4);
            }
            Datasource datasource = null;
            datasource = parameter.getOutputDatasource() != null ? parameter.getOutputDatasource() : referenceLine.getDatasource();
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            String string5 = parameter.getOutputDatasetName();
            if (!datasource.getDatasets().isAvailableDatasetName(string5)) {
                String string6 = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)referenceLine);
            double d = parameter.getMeasureOffset();
            double d2 = parameter.getRatio();
            boolean bl = parameter.getIgnoringGaps();
            boolean bl2 = LinearReferencing.a();
            GenerateType generateType = parameter.getType();
            long l3 = 0L;
            if (generateType == GenerateType.BY_LENGTH) {
                l3 = LinearReferencingNative.jni_GenerateRoutesByLength(l2, l, string5, d, d2, bl, bl2);
            } else if (generateType == GenerateType.BY_SINGLE_FIELD) {
                string2 = parameter.getMeasureEndField();
                if (referenceLine.getFieldInfos().indexOf(string2) == -1) {
                    String string7 = InternalResourceSpatialanalyst.loadString("measureEndField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string7);
                }
                if (referenceLine.getFieldInfos().get(string2).getType() == FieldType.BOOLEAN || referenceLine.getFieldInfos().get(string2).getType() == FieldType.BYTE || referenceLine.getFieldInfos().get(string2).getType() == FieldType.DATETIME || referenceLine.getFieldInfos().get(string2).getType() == FieldType.LONGBINARY) {
                    String string8 = InternalResourceSpatialanalyst.loadString("measureEndField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string8);
                }
                string = parameter.getLineRouteIDField();
                if (referenceLine.getFieldInfos().indexOf(string) != -1) {
                    if (referenceLine.getFieldInfos().get(string).getType() == FieldType.BOOLEAN || referenceLine.getFieldInfos().get(string).getType() == FieldType.BYTE || referenceLine.getFieldInfos().get(string).getType() == FieldType.DATETIME || referenceLine.getFieldInfos().get(string).getType() == FieldType.LONGBINARY || referenceLine.getFieldInfos().get(string).getType() == FieldType.DOUBLE || referenceLine.getFieldInfos().get(string).getType() == FieldType.SINGLE) {
                        String string9 = InternalResourceSpatialanalyst.loadString("strFieldRoadRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string9);
                    }
                } else {
                    string = null;
                }
                l3 = LinearReferencingNative.jni_GenerateRoutesByField(l2, l, string5, string2, null, string, d, d2, bl, bl2);
            } else if (generateType == GenerateType.BY_DOUBLE_FIELDS) {
                string2 = parameter.getMeasureStartField();
                string = parameter.getMeasureEndField();
                if (referenceLine.getFieldInfos().indexOf(string2) == -1) {
                    String string10 = InternalResourceSpatialanalyst.loadString("measureStartField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string10);
                }
                if (referenceLine.getFieldInfos().indexOf(string) == -1) {
                    String string11 = InternalResourceSpatialanalyst.loadString("measureEndField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string11);
                }
                if (referenceLine.getFieldInfos().get(string2).getType() == FieldType.BOOLEAN || referenceLine.getFieldInfos().get(string2).getType() == FieldType.BYTE || referenceLine.getFieldInfos().get(string2).getType() == FieldType.DATETIME || referenceLine.getFieldInfos().get(string2).getType() == FieldType.LONGBINARY) {
                    String string12 = InternalResourceSpatialanalyst.loadString("measureStartField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string12);
                }
                if (referenceLine.getFieldInfos().get(string).getType() == FieldType.BOOLEAN || referenceLine.getFieldInfos().get(string).getType() == FieldType.BYTE || referenceLine.getFieldInfos().get(string).getType() == FieldType.DATETIME || referenceLine.getFieldInfos().get(string).getType() == FieldType.LONGBINARY) {
                    String string13 = InternalResourceSpatialanalyst.loadString("measureEndField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string13);
                }
                String string14 = parameter.getLineRouteIDField();
                if (referenceLine.getFieldInfos().indexOf(string14) != -1) {
                    if (referenceLine.getFieldInfos().get(string14).getType() == FieldType.BOOLEAN || referenceLine.getFieldInfos().get(string14).getType() == FieldType.BYTE || referenceLine.getFieldInfos().get(string14).getType() == FieldType.DATETIME || referenceLine.getFieldInfos().get(string14).getType() == FieldType.LONGBINARY || referenceLine.getFieldInfos().get(string14).getType() == FieldType.DOUBLE || referenceLine.getFieldInfos().get(string14).getType() == FieldType.SINGLE) {
                        String string15 = InternalResourceSpatialanalyst.loadString("strFieldRoadRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string15);
                    }
                } else {
                    string14 = null;
                }
                l3 = LinearReferencingNative.jni_GenerateRoutesByField(l2, l, string5, string2, string, string14, d, d2, bl, bl2);
            } else if (generateType == GenerateType.BY_POINT) {
                string2 = parameter.getDatasetPoint();
                if (string2 == null) {
                    String string16 = InternalResourceSpatialanalyst.loadString("referencePoint", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new NullPointerException(string16);
                }
                string = parameter.getMeasureField();
                if (string2.getFieldInfos().indexOf(string) == -1) {
                    String string17 = InternalResourceSpatialanalyst.loadString("measureField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string17);
                }
                if (string2.getFieldInfos().get(string).getType() == FieldType.BOOLEAN || string2.getFieldInfos().get(string).getType() == FieldType.BYTE || string2.getFieldInfos().get(string).getType() == FieldType.DATETIME || string2.getFieldInfos().get(string).getType() == FieldType.LONGBINARY) {
                    String string18 = InternalResourceSpatialanalyst.loadString("measureField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string18);
                }
                String string19 = parameter.getLineRouteIDField();
                if (referenceLine.getFieldInfos().indexOf(string19) == -1) {
                    String string20 = InternalResourceSpatialanalyst.loadString("strFieldRoadRouteID", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string20);
                }
                if (referenceLine.getFieldInfos().get(string19).getType() == FieldType.BOOLEAN || referenceLine.getFieldInfos().get(string19).getType() == FieldType.BYTE || referenceLine.getFieldInfos().get(string19).getType() == FieldType.DATETIME || referenceLine.getFieldInfos().get(string19).getType() == FieldType.LONGBINARY || referenceLine.getFieldInfos().get(string19).getType() == FieldType.DOUBLE || referenceLine.getFieldInfos().get(string19).getType() == FieldType.SINGLE) {
                    String string21 = InternalResourceSpatialanalyst.loadString("strFieldRoadRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string21);
                }
                String string22 = parameter.getPointRouteIDField();
                if (string2.getFieldInfos().indexOf(string22) == -1) {
                    String string23 = InternalResourceSpatialanalyst.loadString("strFieldPointRouteID", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string23);
                }
                if (string2.getFieldInfos().get(string22).getType() == FieldType.BOOLEAN || string2.getFieldInfos().get(string22).getType() == FieldType.BYTE || string2.getFieldInfos().get(string22).getType() == FieldType.DATETIME || string2.getFieldInfos().get(string22).getType() == FieldType.LONGBINARY || string2.getFieldInfos().get(string22).getType() == FieldType.DOUBLE || string2.getFieldInfos().get(string22).getType() == FieldType.SINGLE) {
                    String string24 = InternalResourceSpatialanalyst.loadString("strFieldPointRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string24);
                }
                long l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)string2);
                String string25 = parameter.getErrorInfoField();
                double d3 = parameter.getTolerance();
                if (parameter.getToleranceUnit() != null) {
                    d3 = d3 * (double)parameter.getToleranceUnit().value() / (double)referenceLine.getPrjCoordSys().getCoordUnit().value();
                }
                l3 = LinearReferencingNative.jni_GenerateRoutesByPoint(l2, string19, l4, string22, string, string25, l, string5, d, d2, bl, d3, bl2);
                string2.close();
                string2.open();
            }
            string2 = null;
            if (l3 != 0L) {
                string2 = InternalDatasetVector.createInstance(l3, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)string2);
            }
            string = string2;
            return string;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector calibrateRoutes(DatasetVector referenceLineM, String routeIDField, DatasetVector calibratePointDataset, String calibrateRouteID, String measureField, CalibrateOptions options, Datasource outputDatasource, String outputDatasetName) {
        return LinearReferencing.calibrateRoutes(referenceLineM, routeIDField, calibratePointDataset, calibrateRouteID, measureField, options, outputDatasource, outputDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector calibrateRoutes(DatasetVector referenceLineM, String routeIDField, DatasetVector calibratePointDataset, String calibrateRouteID, String measureField, CalibrateOptions options, Datasource outputDatasource, String outputDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (referenceLineM == null) {
                String string = InternalResourceSpatialanalyst.loadString("referenceLineM", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (calibratePointDataset == null) {
                String string = InternalResourceSpatialanalyst.loadString("calibratePointDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (referenceLineM.getFieldInfos().indexOf(routeIDField) == -1) {
                String string = InternalResourceSpatialanalyst.loadString("routeIDField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (referenceLineM.getFieldInfos().get(routeIDField).getType() == FieldType.BOOLEAN || referenceLineM.getFieldInfos().get(routeIDField).getType() == FieldType.BYTE || referenceLineM.getFieldInfos().get(routeIDField).getType() == FieldType.DATETIME || referenceLineM.getFieldInfos().get(routeIDField).getType() == FieldType.LONGBINARY || referenceLineM.getFieldInfos().get(routeIDField).getType() == FieldType.DOUBLE || referenceLineM.getFieldInfos().get(routeIDField).getType() == FieldType.SINGLE) {
                String string = InternalResourceSpatialanalyst.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (calibratePointDataset.getFieldInfos().indexOf(calibrateRouteID) == -1) {
                String string = InternalResourceSpatialanalyst.loadString("calibrateRouteID", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (calibratePointDataset.getFieldInfos().get(calibrateRouteID).getType() == FieldType.BOOLEAN || calibratePointDataset.getFieldInfos().get(calibrateRouteID).getType() == FieldType.BYTE || calibratePointDataset.getFieldInfos().get(calibrateRouteID).getType() == FieldType.DATETIME || calibratePointDataset.getFieldInfos().get(calibrateRouteID).getType() == FieldType.LONGBINARY || calibratePointDataset.getFieldInfos().get(calibrateRouteID).getType() == FieldType.DOUBLE || calibratePointDataset.getFieldInfos().get(calibrateRouteID).getType() == FieldType.SINGLE) {
                String string = InternalResourceSpatialanalyst.loadString("calibrateRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (calibratePointDataset.getFieldInfos().indexOf(measureField) == -1) {
                String string = InternalResourceSpatialanalyst.loadString("measureField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (calibratePointDataset.getFieldInfos().get(measureField).getType() == FieldType.BOOLEAN || calibratePointDataset.getFieldInfos().get(measureField).getType() == FieldType.BYTE || calibratePointDataset.getFieldInfos().get(measureField).getType() == FieldType.DATETIME || calibratePointDataset.getFieldInfos().get(measureField).getType() == FieldType.LONGBINARY) {
                String string = InternalResourceSpatialanalyst.loadString("measureField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (outputDatasource == null) {
                outputDatasource = referenceLineM.getDatasource();
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            CalibrateMode calibrateMode = options.getRouteCalibrationMode();
            int n = calibrateMode.value();
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)referenceLineM);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)calibratePointDataset);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            double d = options.getTolerance();
            boolean bl = options.getRetainingAllRoutes();
            String string = options.getErrorInfoField();
            boolean bl2 = options.getIgnoringGaps();
            boolean bl3 = LinearReferencing.a();
            if (options.getToleranceUnit() != null) {
                d = d * (double)options.getToleranceUnit().value() / (double)referenceLineM.getPrjCoordSys().getCoordUnit().value();
            }
            long l4 = LinearReferencingNative.jni_CalibrateRoutes(l, routeIDField, l2, calibrateRouteID, measureField, l3, outputDatasetName, d, n, bl, true, true, true, string, bl2, bl3);
            calibratePointDataset.close();
            calibratePointDataset.open();
            DatasetVector datasetVector = null;
            if (l4 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector generateEventTable(DatasetVector referenceLineM, GenerateEventTableParameter parameter) {
        return LinearReferencing.generateEventTable(referenceLineM, parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector generateEventTable(DatasetVector referenceLineM, GenerateEventTableParameter parameter, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (referenceLineM == null) {
                String string = InternalResourceSpatialanalyst.loadString("referenceLineM", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (parameter == null) {
                String string = InternalResourceSpatialanalyst.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (referenceLineM.getFieldInfos().indexOf(parameter.getRouteIDField()) == -1) {
                String string = InternalResourceSpatialanalyst.loadString("routeIDField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (referenceLineM.getFieldInfos().get(parameter.getRouteIDField()).getType() == FieldType.BOOLEAN || referenceLineM.getFieldInfos().get(parameter.getRouteIDField()).getType() == FieldType.BYTE || referenceLineM.getFieldInfos().get(parameter.getRouteIDField()).getType() == FieldType.DATETIME || referenceLineM.getFieldInfos().get(parameter.getRouteIDField()).getType() == FieldType.LONGBINARY || referenceLineM.getFieldInfos().get(parameter.getRouteIDField()).getType() == FieldType.DOUBLE || referenceLineM.getFieldInfos().get(parameter.getRouteIDField()).getType() == FieldType.SINGLE) {
                String string = InternalResourceSpatialanalyst.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            Datasource datasource = null;
            datasource = parameter.getOutputDatasource() != null ? parameter.getOutputDatasource() : referenceLineM.getDatasource();
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)referenceLineM);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getEventDataset());
            String string = parameter.getOutputDatasetName();
            if (!datasource.getDatasets().isAvailableDatasetName(string)) {
                String string2 = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string2);
            }
            String string3 = parameter.getOutputDatasetRouteField();
            String string4 = parameter.getMeasureStartField();
            String string5 = parameter.getMeasureEndField();
            String string6 = parameter.getMeasureField();
            String string7 = parameter.getRouteIDField();
            boolean bl = parameter.getRetainingAllFields();
            double d = parameter.getSearchRadius();
            boolean bl2 = parameter.hasDistanceField();
            boolean bl3 = parameter.getFindingClosestRoute();
            boolean bl4 = LinearReferencing.a();
            int n = 0;
            if (parameter.getEventDataset().getType() == DatasetType.POINT) {
                n = 1;
            } else if (parameter.getEventDataset().getType() == DatasetType.LINE) {
                n = 2;
            }
            d = d * (double)parameter.getSearchRadiusUnit().value() / (double)referenceLineM.getPrjCoordSys().getCoordUnit().value();
            if (n == 1) {
                // empty if block
            }
            if (n == 2) {
                // empty if block
            }
            long l4 = LinearReferencingNative.jni_GenerateEventTable(l, string7, l3, l2, string, n, string3, string4, string5, string6, bl, d, bl2, bl3, bl4);
            DatasetVector datasetVector = null;
            if (l4 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l4, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector generateSpatialData(GenerateSpatialDataParameter parameter) {
        return LinearReferencing.generateSpatialData(parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector generateSpatialData(GenerateSpatialDataParameter parameter, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (parameter == null) {
                String string = InternalResourceSpatialanalyst.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (parameter.getReferenceLineM() == null) {
                String string = InternalResourceSpatialanalyst.loadString("referenceLineM", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            String string = parameter.getRouteIDField();
            if (parameter.getReferenceLineM().getFieldInfos().indexOf(string) == -1) {
                String string2 = InternalResourceSpatialanalyst.loadString("RouteIDField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string2);
            }
            if (parameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.BOOLEAN || parameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.BYTE || parameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.DATETIME || parameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.LONGBINARY || parameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.DOUBLE || parameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.SINGLE) {
                String string3 = InternalResourceSpatialanalyst.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string3);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getReferenceLineM());
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getEventTable());
            if (parameter.getReferenceLineM().getDatasource() != parameter.getEventTable().getDatasource()) {
                String string4 = InternalResourceSpatialanalyst.loadString("ReferenceLineM and EventTable", "Datasource_MustBe_Same", "spatialanalyst_resources");
                throw new IllegalArgumentException(string4);
            }
            DynamicSegmentInfo[] dynamicSegmentInfoArray = DynamicSegmentManager.getDynamicSegmentInfos((DatasetVector)parameter.getEventTable());
            if (dynamicSegmentInfoArray != null) {
                String string5 = InternalResourceSpatialanalyst.loadString("EventTable", "Relation_Has_Exist", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            String string6 = parameter.getErrorInfoField();
            Datasource datasource = null;
            datasource = parameter.getReferenceLineM().getDatasource();
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            String string7 = parameter.getOutputDatasetName();
            if (!datasource.getDatasets().isAvailableDatasetName(string7)) {
                String string8 = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
            String string9 = parameter.getEventRouteIDField();
            String string10 = parameter.getMeasureStartField();
            String string11 = parameter.getMeasureEndField();
            String string12 = parameter.getMeasureField();
            String string13 = parameter.getMeasureOffsetField();
            if (!(string13 == null || string13.trim().equals("") || parameter.getEventTable().getFieldInfos().get(string13).getType() != FieldType.BOOLEAN && parameter.getEventTable().getFieldInfos().get(string13).getType() != FieldType.BYTE && parameter.getEventTable().getFieldInfos().get(string13).getType() != FieldType.DATETIME && parameter.getEventTable().getFieldInfos().get(string13).getType() != FieldType.LONGBINARY)) {
                String string14 = InternalResourceSpatialanalyst.loadString("MeasureOffsetField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string14);
            }
            boolean bl = true;
            if (string12 == null) {
                if (string10 == null || string11 == null) {
                    String string15 = InternalResourceSpatialanalyst.loadString("MeasureStartField or measureEndField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string15);
                }
                if (parameter.getEventTable().getFieldInfos().get(string10).getType() == FieldType.BOOLEAN || parameter.getEventTable().getFieldInfos().get(string10).getType() == FieldType.BYTE || parameter.getEventTable().getFieldInfos().get(string10).getType() == FieldType.DATETIME || parameter.getEventTable().getFieldInfos().get(string10).getType() == FieldType.LONGBINARY) {
                    String string16 = InternalResourceSpatialanalyst.loadString("MeasureStartField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string16);
                }
                if (parameter.getEventTable().getFieldInfos().get(string11).getType() == FieldType.BOOLEAN || parameter.getEventTable().getFieldInfos().get(string11).getType() == FieldType.BYTE || parameter.getEventTable().getFieldInfos().get(string11).getType() == FieldType.DATETIME || parameter.getEventTable().getFieldInfos().get(string11).getType() == FieldType.LONGBINARY) {
                    String string17 = InternalResourceSpatialanalyst.loadString("MeasureEndField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string17);
                }
                bl = false;
            } else {
                if (parameter.getEventTable().getFieldInfos().get(string12).getType() == FieldType.BOOLEAN || parameter.getEventTable().getFieldInfos().get(string12).getType() == FieldType.BYTE || parameter.getEventTable().getFieldInfos().get(string12).getType() == FieldType.DATETIME || parameter.getEventTable().getFieldInfos().get(string12).getType() == FieldType.LONGBINARY) {
                    String string18 = InternalResourceSpatialanalyst.loadString("MeasureField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string18);
                }
                bl = true;
            }
            String[] stringArray = parameter.getRetainedFields();
            boolean bl2 = LinearReferencing.a();
            long l4 = LinearReferencingNative.jni_GenerateSpatialData(l, l2, string6, l3, string7, string9, string10, string11, string12, string, string13, stringArray, bl2, bl);
            parameter.getEventTable().close();
            parameter.getEventTable().open();
            DatasetVector datasetVector = null;
            if (l4 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l4, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector dissolveRouteEvents(RouteEventsParameter inputEventsParameter, String[] dissolveFields, EventDissolveType eventDissolveType, Datasource outputDatasource, String outputDatasetName, RouteEventsParameter resultEventsParameter, String[] statisticFields, StatisticsType[] statisticModes, double tolerance) {
        return LinearReferencing.dissolveRouteEvents(inputEventsParameter, dissolveFields, eventDissolveType, outputDatasource, outputDatasetName, resultEventsParameter, statisticFields, statisticModes, tolerance, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector dissolveRouteEvents(RouteEventsParameter inputEventsParameter, String[] dissolveFields, EventDissolveType eventDissolveType, Datasource outputDatasource, String outputDatasetName, RouteEventsParameter resultEventsParameter, String[] statisticFields, StatisticsType[] statisticModes, double tolerance, SteppedListener ... listeners) {
        try {
            int n;
            int n2;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (inputEventsParameter == null) {
                String string = InternalResourceSpatialanalyst.loadString("routeEventsParameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (inputEventsParameter.getEventDataset() == null) {
                String string = InternalResourceSpatialanalyst.loadString("inputEventsParameter.getEventDataset()", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (outputDatasource == null) {
                outputDatasource = inputEventsParameter.getEventDataset().getDatasource();
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("datasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (dissolveFields.length < 1) {
                String string = InternalResourceSpatialanalyst.loadString("dissolveFields", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            String[] stringArray = new String[4];
            String[] stringArray2 = new String[4];
            int n3 = inputEventsParameter.getType().value();
            stringArray[0] = inputEventsParameter.getRouteIDField();
            stringArray[1] = inputEventsParameter.getMeasureField();
            stringArray[2] = inputEventsParameter.getMeasureStartField();
            stringArray[3] = inputEventsParameter.getMeasureEndField();
            for (n2 = 0; n2 < 4; ++n2) {
                if (n3 == 1 && (n2 == 2 || n2 == 3) || n3 == 2 && n2 == 1) continue;
                if (stringArray[n2] == null || stringArray[n2].trim().length() == 0) {
                    String string = InternalResourceSpatialanalyst.loadString(stringArray[n2], "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (inputEventsParameter.getEventDataset().getFieldInfos().indexOf(stringArray[n2]) == -1) {
                    String string = InternalResourceSpatialanalyst.loadString(stringArray[n2], "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (n2 == 0) {
                    if (inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.BOOLEAN && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.BYTE && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.DATETIME && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.LONGBINARY && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.DOUBLE && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.SINGLE) continue;
                    String string = InternalResourceSpatialanalyst.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.BOOLEAN && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.BYTE && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.DATETIME && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.LONGBINARY) continue;
                String string = InternalResourceSpatialanalyst.loadString(stringArray[n2], "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            n2 = eventDissolveType.value();
            stringArray2[0] = resultEventsParameter.getRouteIDField();
            stringArray2[1] = resultEventsParameter.getMeasureField();
            stringArray2[2] = resultEventsParameter.getMeasureStartField();
            stringArray2[3] = resultEventsParameter.getMeasureEndField();
            if (stringArray2[0].trim().equals("")) {
                stringArray2[0] = stringArray[0];
            }
            if (stringArray2[1].trim().equals("")) {
                stringArray2[1] = stringArray[1];
            }
            if (stringArray2[2].trim().equals("")) {
                stringArray2[2] = stringArray[2];
            }
            if (stringArray2[3].trim().equals("")) {
                stringArray2[3] = stringArray[3];
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)inputEventsParameter.getEventDataset());
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            int n4 = statisticModes.length;
            int[] nArray = new int[n4];
            for (n = 0; n < n4; n += 1) {
                nArray[n] = statisticModes[n].value();
            }
            n = LinearReferencing.a() ? 1 : 0;
            long l3 = LinearReferencingNative.jni_DissolveRouteEvents(l, dissolveFields, l2, outputDatasetName, stringArray, stringArray2, statisticFields, nArray, n2, tolerance, n3, n != 0);
            DatasetVector datasetVector = null;
            if (l3 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector overlayRouteEvents(RouteEventsParameter inputEventsParameter, RouteEventsParameter overlayEventParameter, EventOverlayType eventOverlayType, Datasource outputDatasource, String outputDatasetName, RouteEventsParameter resultEventsParameter, double tolerance, boolean isKeepField, boolean isKeepZeroLengthEvents) {
        return LinearReferencing.overlayRouteEvents(inputEventsParameter, overlayEventParameter, eventOverlayType, outputDatasource, outputDatasetName, resultEventsParameter, tolerance, isKeepField, isKeepZeroLengthEvents, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector overlayRouteEvents(RouteEventsParameter inputEventsParameter, RouteEventsParameter overlayEventParameter, EventOverlayType eventOverlayType, Datasource outputDatasource, String outputDatasetName, RouteEventsParameter resultEventsParameter, double tolerance, boolean isKeepField, boolean isKeepZeroLengthEvents, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (inputEventsParameter == null || overlayEventParameter == null) {
                DatasetVector datasetVector = null;
                return datasetVector;
            }
            if (inputEventsParameter.getEventDataset() == null) {
                String string = InternalResourceSpatialanalyst.loadString("inputEventsParameter.getEventDataset()", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (overlayEventParameter.getEventDataset() == null) {
                String string = InternalResourceSpatialanalyst.loadString("overlayEventParameter.getEventDataset()", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (outputDatasource == null) {
                outputDatasource = inputEventsParameter.getEventDataset().getDatasource();
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("datasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            String[] stringArray = new String[4];
            String[] stringArray2 = new String[4];
            String[] stringArray3 = new String[4];
            int n = 0;
            int n2 = eventOverlayType.value();
            int n3 = inputEventsParameter.getType().value();
            int n4 = overlayEventParameter.getType().value();
            stringArray[0] = inputEventsParameter.getRouteIDField();
            stringArray[1] = inputEventsParameter.getMeasureField();
            stringArray[2] = inputEventsParameter.getMeasureStartField();
            stringArray[3] = inputEventsParameter.getMeasureEndField();
            for (n = 0; n < 4; ++n) {
                if (n3 == 1 && (n == 2 || n == 3) || n3 == 2 && n == 1) continue;
                if (stringArray[n] == null || stringArray[n].trim().length() == 0) {
                    String string = InternalResourceSpatialanalyst.loadString(stringArray[n], "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (inputEventsParameter.getEventDataset().getFieldInfos().indexOf(stringArray[n]) == -1) {
                    String string = InternalResourceSpatialanalyst.loadString(stringArray[n], "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (n == 0) {
                    if (inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.BOOLEAN && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.BYTE && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.DATETIME && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.LONGBINARY && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.DOUBLE && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.SINGLE) continue;
                    String string = InternalResourceSpatialanalyst.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.BOOLEAN && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.BYTE && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.DATETIME && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.LONGBINARY) continue;
                String string = InternalResourceSpatialanalyst.loadString(stringArray[n], "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            stringArray2[0] = overlayEventParameter.getRouteIDField();
            stringArray2[1] = overlayEventParameter.getMeasureField();
            stringArray2[2] = overlayEventParameter.getMeasureStartField();
            stringArray2[3] = overlayEventParameter.getMeasureEndField();
            for (n = 0; n < 4; ++n) {
                if (n4 == 1 && (n == 2 || n == 3) || n4 == 2 && n == 1) continue;
                if (stringArray2[n] == null || stringArray2[n].trim().length() == 0) {
                    String string = InternalResourceSpatialanalyst.loadString(stringArray2[n], "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (overlayEventParameter.getEventDataset().getFieldInfos().indexOf(stringArray2[n]) == -1) {
                    String string = InternalResourceSpatialanalyst.loadString(stringArray2[n], "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (n == 0) {
                    if (overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.BOOLEAN && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.BYTE && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.DATETIME && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.LONGBINARY && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.DOUBLE && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.SINGLE) continue;
                    String string = InternalResourceSpatialanalyst.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.BOOLEAN && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.BYTE && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.DATETIME && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.LONGBINARY) continue;
                String string = InternalResourceSpatialanalyst.loadString(stringArray2[n], "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            stringArray3[0] = resultEventsParameter.getRouteIDField();
            stringArray3[1] = resultEventsParameter.getMeasureField();
            stringArray3[2] = resultEventsParameter.getMeasureStartField();
            stringArray3[3] = resultEventsParameter.getMeasureEndField();
            if (n3 == 1) {
                if (stringArray3[0].trim().equals("")) {
                    stringArray3[0] = stringArray2[0];
                }
                if (stringArray3[1].trim().equals("")) {
                    stringArray3[1] = stringArray2[1];
                }
                if (stringArray3[2].trim().equals("")) {
                    stringArray3[2] = stringArray2[2];
                }
                if (stringArray3[3].trim().equals("")) {
                    stringArray3[3] = stringArray2[3];
                }
            } else {
                if (stringArray3[0].trim().equals("")) {
                    stringArray3[0] = stringArray[0];
                }
                if (stringArray3[1].trim().equals("")) {
                    stringArray3[1] = stringArray[1];
                }
                if (stringArray3[2].trim().equals("")) {
                    stringArray3[2] = stringArray[2];
                }
                if (stringArray3[3].trim().equals("")) {
                    stringArray3[3] = stringArray[3];
                }
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)inputEventsParameter.getEventDataset());
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)overlayEventParameter.getEventDataset());
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            boolean bl = LinearReferencing.a();
            long l4 = LinearReferencingNative.jni_OverlayRouteEvents(l, l2, n2, l3, outputDatasetName, stringArray, stringArray2, stringArray3, tolerance, isKeepField, n3, n4, isKeepZeroLengthEvents, bl);
            DatasetVector datasetVector = null;
            if (l4 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static boolean rebuildSpatialData(DatasetVector eventTable) {
        return LinearReferencing.rebuildSpatialData(eventTable, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rebuildSpatialData(DatasetVector eventTable, SteppedListener ... listeners) {
        try {
            boolean bl;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (eventTable == null) {
                String string = InternalResourceSpatialanalyst.loadString("eventTable", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)eventTable);
            DynamicSegmentInfo[] dynamicSegmentInfoArray = DynamicSegmentManager.getDynamicSegmentInfos((DatasetVector)eventTable);
            if (dynamicSegmentInfoArray == null) {
                String string = InternalResourceSpatialanalyst.loadString("EventTable", "Relation_Has_Not_Exist", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl2 = LinearReferencing.a();
            boolean bl3 = bl = LinearReferencingNative.jni_RebuildSpatialData(l, null, bl2);
            return bl3;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    static boolean a(DatasetVector datasetVector, String string) {
        return LinearReferencing.a(datasetVector, string, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean a(DatasetVector datasetVector, String string, SteppedListener ... steppedListenerArray) {
        try {
            boolean bl;
            SteppedHelper.addListeners((SteppedListener[])steppedListenerArray);
            if (datasetVector == null) {
                String string2 = InternalResourceSpatialanalyst.loadString("eventTable", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetVector);
            DynamicSegmentInfo[] dynamicSegmentInfoArray = DynamicSegmentManager.getDynamicSegmentInfos((DatasetVector)datasetVector);
            if (dynamicSegmentInfoArray == null) {
                String string3 = InternalResourceSpatialanalyst.loadString("EventTable", "Relation_Has_Not_Exist", "spatialanalyst_resources");
                throw new IllegalArgumentException(string3);
            }
            boolean bl2 = LinearReferencing.a();
            boolean bl3 = bl = LinearReferencingNative.jni_RebuildSpatialData(l, string, bl2);
            return bl3;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])steppedListenerArray);
        }
    }

    public static DatasetVector createMarkPoints(CreateMarkPointsParameter parameter) {
        return LinearReferencing.createMarkPoints(parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector createMarkPoints(CreateMarkPointsParameter parameter, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DatasetVector datasetVector = parameter.getLineMDataset();
            if (datasetVector == null) {
                String string = InternalResourceSpatialanalyst.loadString("parameter.getLineMDataset()", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetVector);
            if (datasetVector.getFieldInfos().indexOf(parameter.getRouteIDField()) == -1) {
                String string = InternalResourceSpatialanalyst.loadString("routeIDField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            Datasource datasource = parameter.getOutputDatasource();
            if (datasource == null) {
                datasource = datasetVector.getDatasource();
            }
            if (!datasource.getDatasets().isAvailableDatasetName(parameter.getOutputDatasetName())) {
                String string = InternalResourceSpatialanalyst.loadString("datasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            long l3 = LinearReferencingNative.jni_CreateMarkPoints(l, parameter.getRouteIDField(), l2, parameter.getOutputDatasetName(), parameter.getMarkScale());
            DatasetVector datasetVector2 = null;
            if (l3 != 0L) {
                datasetVector2 = InternalDatasetVector.createInstance(l3, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector2);
            }
            DatasetVector datasetVector3 = datasetVector2;
            return datasetVector3;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (a == null) {
            a = new Vector();
        }
        if (!a.contains(l)) {
            a.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (a != null && a.contains(l)) {
            a.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (a != null) {
            Vector vector = a;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "LinearReferencing";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)a, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    private static boolean a() {
        return true;
    }
}

