/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.BandArithmeticMethod;
import com.supermap.analyst.spatialanalyst.ImageAnalystNative;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.util.Collection;
import java.util.Vector;

public class ImageAnalyst {
    private static transient Vector a;

    private ImageAnalyst() {
    }

    public static DatasetGrid NDVI(DatasetImage sourceDataset, int nirIndex, int redIndex, String targetDatasetName, Datasource targetDatasource) {
        return ImageAnalyst.NDVI(sourceDataset, nirIndex, redIndex, targetDatasetName, targetDatasource, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid NDVI(DatasetImage sourceDataset, int nirIndex, int redIndex, String targetDatasetName, Datasource targetDatasource, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (nirIndex < 0) {
                String string = InternalResourceSpatialanalyst.loadString("nirIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!sourceDataset.isOpen()) {
                sourceDataset.open();
            }
            if (nirIndex >= sourceDataset.getBandCount()) {
                String string = InternalResourceSpatialanalyst.loadString("nirIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (redIndex < 0) {
                String string = InternalResourceSpatialanalyst.loadString("redIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (redIndex >= sourceDataset.getBandCount()) {
                String string = InternalResourceSpatialanalyst.loadString("redIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetGrid datasetGrid = null;
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l3 = ImageAnalystNative.jni_NDVI(l2, nirIndex, redIndex, targetDatasetName, l);
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid NDVI(DatasetImage nirDataset, int nirIndex, DatasetImage redDataset, int redIndex, String targetDatasetName, Datasource targetDatasource) {
        return ImageAnalyst.NDVI(nirDataset, nirIndex, redDataset, redIndex, targetDatasetName, targetDatasource, -9999.0, new SteppedListener[]{null});
    }

    public static DatasetGrid NDVI(DatasetImage nirDataset, int nirIndex, DatasetImage redDataset, int redIndex, String targetDatasetName, Datasource targetDatasource, SteppedListener ... listeners) {
        return ImageAnalyst.NDVI(nirDataset, nirIndex, redDataset, redIndex, targetDatasetName, targetDatasource, -9999.0, listeners);
    }

    public static DatasetGrid NDVI(DatasetImage nirDataset, int nirIndex, DatasetImage redDataset, int redIndex, String targetDatasetName, Datasource targetDatasource, double noValue) {
        return ImageAnalyst.NDVI(nirDataset, nirIndex, redDataset, redIndex, targetDatasetName, targetDatasource, noValue, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid NDVI(DatasetImage nirDataset, int nirIndex, DatasetImage redDataset, int redIndex, String targetDatasetName, Datasource targetDatasource, double noValue, SteppedListener ... listeners) {
        try {
            long l;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (nirDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)nirDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("nirDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (redDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)redDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("redDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!nirDataset.isOpen()) {
                nirDataset.open();
            }
            if (!redDataset.isOpen()) {
                redDataset.open();
            }
            if (nirIndex < 0) {
                String string = InternalResourceSpatialanalyst.loadString("nirIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (nirIndex >= nirDataset.getBandCount()) {
                String string = InternalResourceSpatialanalyst.loadString("nirIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (redIndex < 0) {
                String string = InternalResourceSpatialanalyst.loadString("redIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (redIndex >= redDataset.getBandCount()) {
                String string = InternalResourceSpatialanalyst.loadString("redIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetGrid datasetGrid = null;
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)nirDataset);
            long l4 = ImageAnalystNative.jni_NDVITwo(l3, nirIndex, l = InternalHandleSpatialanalyst.getHandle((InternalHandle)redDataset), redIndex, targetDatasetName, l2, noValue);
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid NDWI(DatasetImage sourceDataset, int nirIndex, int greenIndex, String targetDatasetName, Datasource targetDatasource) {
        return ImageAnalyst.NDWI(sourceDataset, nirIndex, greenIndex, targetDatasetName, targetDatasource, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid NDWI(DatasetImage sourceDataset, int nirIndex, int greenIndex, String targetDatasetName, Datasource targetDatasource, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!sourceDataset.isOpen()) {
                sourceDataset.open();
            }
            if (nirIndex < 0) {
                String string = InternalResourceSpatialanalyst.loadString("nirIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (greenIndex < 0) {
                String string = InternalResourceSpatialanalyst.loadString("greenIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (nirIndex >= sourceDataset.getBandCount()) {
                String string = InternalResourceSpatialanalyst.loadString("nirIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (greenIndex >= sourceDataset.getBandCount()) {
                String string = InternalResourceSpatialanalyst.loadString("greenIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetGrid datasetGrid = null;
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l3 = ImageAnalystNative.jni_NDVI(l2, greenIndex, nirIndex, targetDatasetName, l);
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid NDWI(DatasetImage nirDataset, int nirIndex, DatasetImage greenDataset, int greenIndex, String targetDatasetName, Datasource targetDatasource) {
        return ImageAnalyst.NDWI(nirDataset, nirIndex, greenDataset, greenIndex, targetDatasetName, targetDatasource, -9999.0, new SteppedListener[]{null});
    }

    public static DatasetGrid NDWI(DatasetImage nirDataset, int nirIndex, DatasetImage greenDataset, int greenIndex, String targetDatasetName, Datasource targetDatasource, SteppedListener ... listeners) {
        return ImageAnalyst.NDWI(nirDataset, nirIndex, greenDataset, greenIndex, targetDatasetName, targetDatasource, -9999.0, listeners);
    }

    public static DatasetGrid NDWI(DatasetImage nirDataset, int nirIndex, DatasetImage greenDataset, int greenIndex, String targetDatasetName, Datasource targetDatasource, double noValue) {
        return ImageAnalyst.NDWI(nirDataset, nirIndex, greenDataset, greenIndex, targetDatasetName, targetDatasource, noValue, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid NDWI(DatasetImage nirDataset, int nirIndex, DatasetImage greenDataset, int greenIndex, String targetDatasetName, Datasource targetDatasource, double noValue, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (nirDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)nirDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("nirDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (greenDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)greenDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("greenDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!nirDataset.isOpen()) {
                nirDataset.open();
            }
            if (!greenDataset.isOpen()) {
                greenDataset.open();
            }
            if (nirIndex < 0) {
                String string = InternalResourceSpatialanalyst.loadString("nirIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (greenIndex < 0) {
                String string = InternalResourceSpatialanalyst.loadString("greenIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (nirIndex >= nirDataset.getBandCount()) {
                String string = InternalResourceSpatialanalyst.loadString("nirIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (greenIndex >= greenDataset.getBandCount()) {
                String string = InternalResourceSpatialanalyst.loadString("greenIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetGrid datasetGrid = null;
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)nirDataset);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)greenDataset);
            long l4 = ImageAnalystNative.jni_NDVITwo(l3, greenIndex, l2, nirIndex, targetDatasetName, l, noValue);
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetImage bandArithmetic(DatasetImage sourceDataset, BandArithmeticMethod method, String bandIndexs, String targetDatasetName, Datasource targetDatasource, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == bandIndexs) {
                String string = InternalResourceSpatialanalyst.loadString("bandIndexs", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l3 = ImageAnalystNative.jni_BandArithmetic(l2, method.value(), bandIndexs, targetDatasetName, l);
            if (l3 != 0L) {
                DatasetImage datasetImage = InternalDatasetImage.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
                DatasetImage datasetImage2 = datasetImage;
                return datasetImage2;
            }
            DatasetImage datasetImage = null;
            return datasetImage;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetImage bandArithmetic(DatasetImage sourceDataset, BandArithmeticMethod method, String bandIndexs, String targetDatasetName, Datasource targetDatasource) {
        return ImageAnalyst.bandArithmetic(sourceDataset, method, bandIndexs, targetDatasetName, targetDatasource, new SteppedListener[]{null});
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (a == null) {
            a = new Vector();
        }
        if (!a.contains(l)) {
            a.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (a != null && a.contains(l)) {
            a.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (a != null) {
            Vector vector = a;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "Generalization";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)a, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }
}

