/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.DissolveParameter;
import com.supermap.analyst.spatialanalyst.EdgeMatchParameter;
import com.supermap.analyst.spatialanalyst.EliminateMode;
import com.supermap.analyst.spatialanalyst.GeneralizationNative;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalGeometrySpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.RandomPointsParameter;
import com.supermap.analyst.spatialanalyst.StatisticsType;
import com.supermap.analyst.spatialanalyst.VectorPyramidMethod;
import com.supermap.data.AggregatePolygonParameter;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.EngineType;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.RegularizeParameter;
import com.supermap.data.ResampleInformation;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import com.supermap.data.Unit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class Generalization {
    private static License a;
    private static transient Vector b;

    private Generalization() {
    }

    public static DatasetVector dissolve(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, DissolveParameter dissolveParameter) {
        return Generalization.dissolve(sourceDatasetVector, targetDatasource, targetDatasetName, dissolveParameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector dissolve(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, DissolveParameter dissolveParameter, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            Generalization.a();
            if (sourceDatasetVector == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (dissolveParameter == null) {
                String string = InternalResourceSpatialanalyst.loadString("dissolveParameter", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            String[] stringArray = dissolveParameter.getStatisticsFieldNames();
            if (stringArray != null) {
                FieldInfos fieldInfos = sourceDatasetVector.getFieldInfos();
                StatisticsType[] statisticsTypeArray = dissolveParameter.getStatisticsTypes();
                if (statisticsTypeArray != null) {
                    if (stringArray.length != statisticsTypeArray.length) {
                        String string = InternalResourceSpatialanalyst.loadString("dissolveParameter", "DissolveParameterInvalid", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                } else {
                    String string = InternalResourceSpatialanalyst.loadString("statisticsTypes", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    FieldType fieldType;
                    Object object;
                    FieldInfo fieldInfo = fieldInfos.get(stringArray[i]);
                    if (fieldInfo == null) {
                        object = InternalResourceSpatialanalyst.loadString("GlobalSpecifiedNameNotExists", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                        throw new IllegalArgumentException((String)object);
                    }
                    object = statisticsTypeArray[i];
                    if (object == StatisticsType.SUM || object == StatisticsType.MAX || object == StatisticsType.MIN || object == StatisticsType.MEAN) {
                        fieldType = fieldInfo.getType();
                        if (fieldType != FieldType.TEXT && fieldType != FieldType.WTEXT && fieldType != FieldType.JSONB && fieldType != FieldType.CHAR && fieldType != FieldType.BOOLEAN) continue;
                        String string = InternalResourceSpatialanalyst.loadString("StatisticsField: " + stringArray[i] + " unsported statistics type.The type FieldType.INT16\u3001FieldType.INT32\u3001FieldType.INT64\u3001FieldType.DOUBLE", "GlobalUnsportedType", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                    if (object != StatisticsType.CONNECT || (fieldType = fieldInfo.getType()) == FieldType.TEXT || fieldType == FieldType.WTEXT) continue;
                    String string = InternalResourceSpatialanalyst.loadString("StatisticsField: " + stringArray[i] + " unsported statistics type.The type FieldType.TEXT\u3001FieldType.WTEXT", "GlobalUnsportedType", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)dissolveParameter);
            long l4 = GeneralizationNative.jni_Dissolve(l, l2, targetDatasetName, l3);
            DatasetVector datasetVector = null;
            if (l4 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)dissolveParameter));
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static boolean eliminate(DatasetVector sourceDatasetVector, double regionTolerance, double vertexTolerance, EliminateMode eliminateMode, boolean isDeleteSingleRegion) {
        return Generalization.eliminate(sourceDatasetVector, regionTolerance, vertexTolerance, eliminateMode, isDeleteSingleRegion, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean eliminate(DatasetVector sourceDatasetVector, double regionTolerance, double vertexTolerance, EliminateMode eliminateMode, boolean isDeleteSingleRegion, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDatasetVector == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDatasetVector.getType() != DatasetType.REGION) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (regionTolerance < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("regionTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (vertexTolerance < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("vertexTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (eliminateMode == null) {
                String string = InternalResourceSpatialanalyst.loadString("eliminateMode", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector);
            boolean bl = false;
            boolean bl2 = bl = GeneralizationNative.jni_Eliminate(l, regionTolerance, vertexTolerance, eliminateMode.value(), isDeleteSingleRegion);
            return bl2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static boolean eliminateLine(DatasetVector sourceDatasetVector, String newDatasetName, String groupField, double noteLineTolerance) {
        return Generalization.eliminateLine(sourceDatasetVector, newDatasetName, groupField, noteLineTolerance, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean eliminateLine(DatasetVector sourceDatasetVector, String newDatasetName, String groupField, double noteLineTolerance, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDatasetVector == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDatasetVector.getType() != DatasetType.LINE) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (noteLineTolerance < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("noteLineTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            String string = sourceDatasetVector.getAvailableFieldName(groupField);
            if (!sourceDatasetVector.isAvailableFieldName(groupField) || string.equals(groupField)) {
                String string2 = InternalResourceSpatialanalyst.loadString("groupField", "GlobalSpecifiedNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string2);
            }
            String string3 = sourceDatasetVector.getDatasource().getDatasets().getAvailableDatasetName(newDatasetName);
            if (!newDatasetName.equals(string3)) {
                newDatasetName = string3;
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector);
            boolean bl = false;
            boolean bl2 = bl = GeneralizationNative.jni_EliminateLine(l, newDatasetName, groupField, noteLineTolerance);
            return bl2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static boolean eliminate(DatasetVector sourceDatasetVector, String[] groupFields, String[] priorityFields, double regionTolerance, double vertexTolerance, EliminateMode eliminateMode, boolean isDeleteSingleRegion) {
        return Generalization.eliminate(sourceDatasetVector, groupFields, priorityFields, regionTolerance, vertexTolerance, eliminateMode, isDeleteSingleRegion, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean eliminate(DatasetVector sourceDatasetVector, String[] groupFields, String[] priorityFields, double regionTolerance, double vertexTolerance, EliminateMode eliminateMode, boolean isDeleteSingleRegion, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDatasetVector == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDatasetVector.getType() != DatasetType.REGION) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (regionTolerance < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("regionTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (vertexTolerance < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("vertexTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (eliminateMode == null) {
                String string = InternalResourceSpatialanalyst.loadString("eliminateMode", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (groupFields == null || groupFields.length == 0) {
                boolean bl = Generalization.eliminate(sourceDatasetVector, regionTolerance, vertexTolerance, eliminateMode, isDeleteSingleRegion);
                return bl;
            }
            FieldInfos fieldInfos = sourceDatasetVector.getFieldInfos();
            for (String string : groupFields) {
                if (fieldInfos.indexOf(string) != -1) continue;
                String string2 = InternalResourceSpatialanalyst.loadString(String.format("group field `%s` ", string), "FieldInfo_NameIsNotExist", "spatialanalyst_resources");
                throw new IllegalArgumentException(string2);
            }
            if (priorityFields != null) {
                for (String string : priorityFields) {
                    if (fieldInfos.indexOf(string) != -1) continue;
                    String string3 = InternalResourceSpatialanalyst.loadString(String.format("priority field `%s` ", string), "FieldInfo_NameIsNotExist", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string3);
                }
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector);
            int n = 0;
            int n2 = n = (int)(GeneralizationNative.jni_Eliminate2(l, regionTolerance, vertexTolerance, eliminateMode.value(), isDeleteSingleRegion, groupFields, priorityFields) ? 1 : 0);
            return n2 != 0;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static boolean eliminateSpecifiedRegions(DatasetVector sourceDatasetVector, int[] smallRegionIDs, int[] excludeRegionIDs, String[] groupFields, String[] priorityFields, boolean isMaxBorder, double vertexTolerance) {
        return Generalization.eliminateSpecifiedRegions(sourceDatasetVector, smallRegionIDs, excludeRegionIDs, groupFields, priorityFields, isMaxBorder, vertexTolerance, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean eliminateSpecifiedRegions(DatasetVector sourceDatasetVector, int[] smallRegionIDs, int[] excludeRegionIDs, String[] groupFields, String[] priorityFields, boolean isMaxBorder, double vertexTolerance, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDatasetVector == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDatasetVector.getType() != DatasetType.REGION) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (vertexTolerance < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("vertexTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (smallRegionIDs == null) {
                String string = InternalResourceSpatialanalyst.loadString("smallRegionIDs", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (smallRegionIDs.length == 0) {
                String string = InternalResourceSpatialanalyst.loadString("smallRegionIDs", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            FieldInfos fieldInfos = sourceDatasetVector.getFieldInfos();
            if (groupFields != null) {
                for (String string : groupFields) {
                    if (fieldInfos.indexOf(string) != -1) continue;
                    String string2 = InternalResourceSpatialanalyst.loadString(String.format("group field `%s` ", string), "FieldInfo_NameIsNotExist", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string2);
                }
            }
            if (priorityFields != null) {
                for (String string : priorityFields) {
                    if (fieldInfos.indexOf(string) != -1) continue;
                    String string3 = InternalResourceSpatialanalyst.loadString(String.format("priority field `%s` ", string), "FieldInfo_NameIsNotExist", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string3);
                }
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector);
            int n = 0;
            int n2 = n = (int)(GeneralizationNative.jni_Eliminate3(l, smallRegionIDs, excludeRegionIDs, vertexTolerance, groupFields, priorityFields, isMaxBorder) ? 1 : 0);
            return n2 != 0;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector dualLineToCenterLine(Recordset sourceRecordset, double maxWidth, double minWidth, Datasource outputDatasource, String outputDatasetName) {
        return Generalization.dualLineToCenterLine(sourceRecordset, maxWidth, minWidth, outputDatasource, outputDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector dualLineToCenterLine(Recordset sourceRecordset, double maxWidth, double minWidth, Datasource outputDatasource, String outputDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            Generalization.a();
            if (sourceRecordset == null) {
                String string = InternalResourceSpatialanalyst.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceRecordset);
            if (l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceRecordset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (outputDatasource == null) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            if (l2 == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (maxWidth <= 0.0 || minWidth < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("width", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l3 = GeneralizationNative.jni_dualLineToCenterLine(l, maxWidth, minWidth, l2, outputDatasetName);
            DatasetVector datasetVector = null;
            if (l3 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static GeoLine[] dualLineToCenterLine(Recordset sourceRecordset, double maxWidth, double minWidth) {
        return Generalization.dualLineToCenterLine(sourceRecordset, maxWidth, minWidth, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoLine[] dualLineToCenterLine(Recordset sourceRecordset, double maxWidth, double minWidth, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceRecordset == null) {
                String string = InternalResourceSpatialanalyst.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceRecordset);
            if (l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceRecordset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (maxWidth <= 0.0 || minWidth < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("width", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long[] lArray = GeneralizationNative.jni_dualLineToCenterLine(l, maxWidth, minWidth);
            if (lArray == null || lArray.length == 0) {
                GeoLine[] geoLineArray = null;
                return geoLineArray;
            }
            GeoLine[] geoLineArray = new GeoLine[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                geoLineArray[i] = (GeoLine)InternalGeometrySpatialanalyst.createInstance(lArray[i]);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
            GeoLine[] geoLineArray2 = geoLineArray;
            return geoLineArray2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector regionToCenterLine(Recordset regionRecordset, Datasource outputDatasource, String outputDatasetName) {
        return Generalization.regionToCenterLine(regionRecordset, outputDatasource, outputDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector regionToCenterLine(Recordset regionRecordset, Datasource outputDatasource, String outputDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            Generalization.a();
            if (regionRecordset == null) {
                String string = InternalResourceSpatialanalyst.loadString("regionRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)regionRecordset);
            if (l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("regionRecordset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (outputDatasource == null) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            if (l2 == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (regionRecordset.getDataset().getType() != DatasetType.REGION) {
                String string = InternalResourceSpatialanalyst.loadString("regionRecordset", "GlobalUnsportedType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l3 = GeneralizationNative.jni_regionToCenterLine(l, l2, outputDatasetName);
            DatasetVector datasetVector = null;
            if (l3 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)regionRecordset);
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static GeoLine regionToCenterLine(GeoRegion sourceRegion, Point2D pointFrom, Point2D pointTo) {
        Generalization.a();
        if (sourceRegion == null) {
            String string = InternalResourceSpatialanalyst.loadString("region", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceRegion);
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("region", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeneralizationNative.jni_regionToCenterLine(l, pointFrom.getX(), pointFrom.getY(), pointTo.getX(), pointTo.getY());
        GeoLine geoLine = null;
        if (l2 != 0L) {
            geoLine = (GeoLine)InternalGeometrySpatialanalyst.createInstance(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRegion);
        return geoLine;
    }

    public static GeoLine regionToCenterLine(GeoRegion sourceRegion) {
        Generalization.a();
        if (sourceRegion == null) {
            String string = InternalResourceSpatialanalyst.loadString("region", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceRegion);
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("region", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeneralizationNative.jni_regionToCenterLine(l);
        GeoLine geoLine = null;
        if (l2 != 0L) {
            geoLine = (GeoLine)InternalGeometrySpatialanalyst.createInstance(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRegion);
        return geoLine;
    }

    public static GeoRegion[] autoCompletePolygon(DatasetVector regionDataset, Rectangle2D bounds, GeoLine geoLine) {
        long[] lArray;
        Generalization.a();
        if (regionDataset == null) {
            String string = InternalResourceSpatialanalyst.loadString("regionDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)regionDataset);
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("regionDataset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (regionDataset.getType() != DatasetType.REGION) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLine == null) {
            String string = InternalResourceSpatialanalyst.loadString("geoLine", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)geoLine);
        if (l2 == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("geoLineHandle", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        Rectangle2D rectangle2D = new Rectangle2D(0.0, 0.0, 0.0, 0.0);
        if (bounds != null) {
            rectangle2D = bounds;
        }
        if ((lArray = GeneralizationNative.jni_autoCompletePolygon(l, rectangle2D.getLeft(), rectangle2D.getRight(), rectangle2D.getTop(), rectangle2D.getBottom(), l2)) == null || lArray.length == 0) {
            return null;
        }
        GeoRegion[] geoRegionArray = new GeoRegion[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            geoRegionArray[i] = (GeoRegion)InternalGeometrySpatialanalyst.createInstance(lArray[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoLine);
        return geoRegionArray;
    }

    public static boolean aggregatePoints(DatasetVector pointDataset, double distance, Unit unit, int minPilePointCount, Datasource outDatasource, String resultRegionDatasetName, String resultClassFieldName) {
        return Generalization.aggregatePoints(pointDataset, distance, unit, minPilePointCount, outDatasource, resultRegionDatasetName, resultClassFieldName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean aggregatePoints(DatasetVector pointDataset, double distance, Unit unit, int minPilePointCount, Datasource outDatasource, String resultRegionDatasetName, String resultClassFieldName, SteppedListener ... listeners) {
        try {
            boolean bl;
            FieldInfos fieldInfos;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (pointDataset == null) {
                String string = InternalResourceSpatialanalyst.loadString("pointDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)pointDataset);
            if (l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("pointDataset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (pointDataset.getType() != DatasetType.POINT) {
                String string = InternalResourceSpatialanalyst.loadString("pointDataset", "GlobalUnsportedType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (minPilePointCount < 2) {
                String string = InternalResourceSpatialanalyst.loadString("minPilePointCount", "Must_Larger_Than_One", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (distance <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("distance", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            pointDataset.open();
            if (resultClassFieldName != null) {
                fieldInfos = pointDataset.getFieldInfos();
                int n = fieldInfos.indexOf(resultClassFieldName);
                if (n == -1) {
                    String string = InternalResourceSpatialanalyst.loadString("GlobalSpecifiedNameNotExists", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (fieldInfos.get(n).isSystemField()) {
                    String string = InternalResourceSpatialanalyst.loadString("FieldNotSystemField", "FieldNotSystemField", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((fieldInfos = pointDataset.getPrjCoordSys()).getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && (unit == Unit.SECOND || unit == Unit.MINUTE || unit == Unit.DEGREE || unit == Unit.RADIAN)) {
                String string = InternalResourceSpatialanalyst.loadString("unit", "CannotBeAngleUnit", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = 0L;
            if (resultRegionDatasetName != null) {
                if (outDatasource == null) {
                    String string = InternalResourceSpatialanalyst.loadString("outDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (!outDatasource.getDatasets().isAvailableDatasetName(resultRegionDatasetName)) {
                    String string = InternalResourceSpatialanalyst.loadString("resultRegionDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
                datasetVectorInfo.setName(resultRegionDatasetName);
                datasetVectorInfo.setType(DatasetType.REGION);
                DatasetVector datasetVector = outDatasource.getDatasets().create(datasetVectorInfo);
                datasetVector.open();
                datasetVector.setPrjCoordSys(pointDataset.getPrjCoordSys());
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetVector);
            }
            if (!(bl = GeneralizationNative.jni_AggregatePoints(l, distance, unit.value(), minPilePointCount, l2, resultClassFieldName)) && l2 != 0L) {
                outDatasource.getDatasets().delete(resultRegionDatasetName);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    @Deprecated
    public static boolean aggregatePoints(DatasetVector pointDataset, int aggregateCount, String weightFieldName, Datasource outDatasource, String resultRegionDatasetName, String resultClassFieldName) {
        boolean bl;
        if (pointDataset == null) {
            String string = InternalResourceSpatialanalyst.loadString("pointDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)pointDataset);
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("pointDataset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (pointDataset.getType() != DatasetType.POINT) {
            String string = InternalResourceSpatialanalyst.loadString("pointDataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (aggregateCount <= 0) {
            String string = InternalResourceSpatialanalyst.loadString("aggregateCount", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightFieldName != null && !weightFieldName.isEmpty() && pointDataset.getFieldInfos().indexOf(weightFieldName) == -1) {
            String string = InternalResourceSpatialanalyst.loadString("weightFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultClassFieldName == null && resultRegionDatasetName == null) {
            String string = InternalResourceSpatialanalyst.loadString("resultClassFieldName && resultRegionDatasetName", "ResultClassFieldAndResultRegionDatasetNotNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        pointDataset.open();
        if (resultClassFieldName != null) {
            FieldInfos fieldInfos = pointDataset.getFieldInfos();
            int n = fieldInfos.indexOf(resultClassFieldName);
            if (n == -1) {
                String string = InternalResourceSpatialanalyst.loadString("GlobalSpecifiedNameNotExists", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (fieldInfos.get(n).isSystemField()) {
                String string = InternalResourceSpatialanalyst.loadString("FieldNotSystemField", "FieldNotSystemField", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        long l2 = 0L;
        if (resultRegionDatasetName != null) {
            if (outDatasource == null) {
                String string = InternalResourceSpatialanalyst.loadString("outDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!outDatasource.getDatasets().isAvailableDatasetName(resultRegionDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("resultRegionDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
            datasetVectorInfo.setName(resultRegionDatasetName);
            datasetVectorInfo.setType(DatasetType.REGION);
            DatasetVector datasetVector = outDatasource.getDatasets().create(datasetVectorInfo);
            datasetVector.open();
            datasetVector.setPrjCoordSys(pointDataset.getPrjCoordSys());
            l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetVector);
        }
        if (!(bl = GeneralizationNative.jni_AggregatePoints1(l, aggregateCount, weightFieldName, l2, resultClassFieldName)) && l2 != 0L) {
            outDatasource.getDatasets().delete(resultRegionDatasetName);
        }
        return bl;
    }

    public static boolean edgeMatch(DatasetVector sourceDatasetVector, DatasetVector targetDatasetVector, EdgeMatchParameter edgeMatchParameter) {
        return Generalization.edgeMatch(sourceDatasetVector, targetDatasetVector, edgeMatchParameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean edgeMatch(DatasetVector sourceDatasetVector, DatasetVector targetDatasetVector, EdgeMatchParameter edgeMatchParameter, SteppedListener ... listeners) {
        try {
            boolean bl;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            Generalization.a();
            if (sourceDatasetVector == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasetVector == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (edgeMatchParameter == null) {
                String string = InternalResourceSpatialanalyst.loadString("edgeMatchParameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasetVector);
            double d = edgeMatchParameter.getTolerance();
            if (d < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("edgeMatchParameter.getTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            int n = edgeMatchParameter.getEdgeMatchMode().value();
            int n2 = edgeMatchParameter.getEdgeMatchAttributeMethod().value();
            long l3 = 0L;
            GeoLine geoLine = edgeMatchParameter.getEdgeMatchLine();
            if (geoLine != null) {
                if (InternalHandleSpatialanalyst.getHandle((InternalHandle)geoLine) == 0L) {
                    String string = InternalResourceSpatialanalyst.loadString("edgeMatchParameter.getEdgeMatchLine", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)geoLine);
            }
            long l4 = 0L;
            Datasource datasource = edgeMatchParameter.getOutputDatasource();
            if (datasource != null) {
                if (InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                    String string = InternalResourceSpatialanalyst.loadString("edgeMatchParameter.getOutputDatasource", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                long l5 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
                String string = edgeMatchParameter.getOutputDatasetLinkName();
                if (!datasource.getDatasets().isAvailableDatasetName(string)) {
                    String string2 = InternalResourceSpatialanalyst.loadString("edgeMatchParameter.getOutputDatasetLinkName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string2);
                }
                DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
                datasetVectorInfo.setName(string);
                datasetVectorInfo.setType(DatasetType.LINE);
                DatasetVector datasetVector = datasource.getDatasets().create(datasetVectorInfo);
                datasetVector.open();
                datasetVector.setPrjCoordSys(sourceDatasetVector.getPrjCoordSys());
                l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetVector);
            }
            if (!(bl = GeneralizationNative.jni_edgeMatch2(l, l2, d, n, l3, edgeMatchParameter.isUnion(), l4, n2, edgeMatchParameter.getSourceFieldNames(), edgeMatchParameter.getTargetFieldNames(), edgeMatchParameter.getEdgeFields())) && l4 != 0L) {
                datasource.getDatasets().delete(edgeMatchParameter.getOutputDatasetLinkName());
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static boolean lineAttachRegion(GeoLine geoLine, GeoRegion geoRegion, List<GeoRegion> listRegionCompare, double toleranceLineAttachRegion, double toleranceRegionMerge, double toleranceChange, boolean isUsePreProcess) {
        Generalization.a();
        if (geoLine == null) {
            String string = InternalResourceSpatialanalyst.loadString("geoLine", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandleSpatialanalyst.getHandle((InternalHandle)geoLine) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("geoLine", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion == null) {
            String string = InternalResourceSpatialanalyst.loadString("geoRegion", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandleSpatialanalyst.getHandle((InternalHandle)geoRegion) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = null;
        int[] nArray = null;
        if (listRegionCompare != null && listRegionCompare.size() > 0) {
            int n;
            lArray = new long[listRegionCompare.size()];
            for (n = 0; n < listRegionCompare.size(); ++n) {
                if (listRegionCompare.get(n) == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)listRegionCompare.get(n)) == 0L) {
                    String string = InternalResourceSpatialanalyst.loadString(String.format("%s[%d]", "listRegionCompare", n), "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                lArray[n] = InternalHandleSpatialanalyst.getHandle((InternalHandle)listRegionCompare.get(n));
            }
            nArray = new int[lArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = 0;
            }
        }
        if (toleranceLineAttachRegion < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("toleranceLineAttachRegion", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (toleranceRegionMerge < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("toleranceRegionMerge", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)geoRegion);
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)geoLine);
        boolean bl = GeneralizationNative.jni_lineAttachRegion(l2, l, lArray, nArray, toleranceLineAttachRegion, toleranceRegionMerge, toleranceChange, isUsePreProcess);
        if (bl && nArray != null) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] != 0) continue;
                GeoRegion geoRegion2 = listRegionCompare.get(i);
                listRegionCompare.remove(i);
                geoRegion2.dispose();
            }
        }
        return bl;
    }

    @Deprecated
    public static boolean integrate(DatasetVector sourceDatasetVector, double tolerance, Unit unit) {
        return Generalization.integrate(sourceDatasetVector, tolerance, unit, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean integrate(DatasetVector sourceDatasetVector, double tolerance, Unit unit, SteppedListener ... listeners) {
        try {
            boolean bl;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            Generalization.a();
            if (sourceDatasetVector == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE && sourceDatasetVector.getType() != DatasetType.NETWORK) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (tolerance <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("tolerance", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            PrjCoordSys prjCoordSys = sourceDatasetVector.getPrjCoordSys();
            if (prjCoordSys.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && (unit == Unit.SECOND || unit == Unit.MINUTE || unit == Unit.DEGREE || unit == Unit.RADIAN)) {
                String string = InternalResourceSpatialanalyst.loadString("unit", "CannotBeAngleUnit", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector);
            boolean bl2 = bl = GeneralizationNative.jni_integrate(l, tolerance, unit.value());
            return bl2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector featureEnvelope(DatasetVector sourceDataset, String targetDatasetName, Datasource targetDatasource, boolean isSinglePart) {
        return Generalization.featureEnvelope(sourceDataset, targetDatasetName, targetDatasource, isSinglePart, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector featureEnvelope(DatasetVector sourceDataset, String targetDatasetName, Datasource targetDatasource, boolean isSinglePart, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            Generalization.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (sourceDataset.getType() != DatasetType.REGION && sourceDataset.getType() != DatasetType.LINE) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = GeneralizationNative.jni_featureEnvelope(l, targetDatasetName, l2, isSinglePart);
            DatasetVector datasetVector = null;
            if (l3 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector featureEnvelope(DatasetVector sourceDataset, String targetDatasetName, Datasource targetDatasource) {
        return Generalization.featureEnvelope(sourceDataset, targetDatasetName, targetDatasource, true, new SteppedListener[]{null});
    }

    public static DatasetVector featureEnvelope(DatasetVector sourceDataset, String targetDatasetName, Datasource targetDatasource, SteppedListener ... listeners) {
        return Generalization.featureEnvelope(sourceDataset, targetDatasetName, targetDatasource, true, listeners);
    }

    public static boolean isPrjCoordSysIdentical(PrjCoordSys sourcePrjCoordSys, PrjCoordSys targetPrjCoordSys) {
        if (sourcePrjCoordSys == null) {
            String string = InternalResourceSpatialanalyst.loadString("sourcePrjCoordSys", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourcePrjCoordSys);
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourcePrjCoordSys", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetPrjCoordSys == null) {
            String string = InternalResourceSpatialanalyst.loadString("targetPrjCoordSys", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetPrjCoordSys);
        if (l2 == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("targetPrjCoordSys", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return GeneralizationNative.jni_isPrjCoordSysIdentical(l, l2);
    }

    public static DatasetVector createRandomPoints(DatasetVector sourceDatasetVector, RandomPointsParameter randomPointsParameter, Datasource targetDatasource, String targetDatasetName) {
        return Generalization.createRandomPoints(sourceDatasetVector, randomPointsParameter, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector createRandomPoints(DatasetVector sourceDatasetVector, RandomPointsParameter randomPointsParameter, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            String string;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDatasetVector == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector) == 0L) {
                String string2 = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string3 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string4 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string4);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string5 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string5);
            }
            Object object = randomPointsParameter.getRandomNumber();
            Object object2 = randomPointsParameter.getMinDistance();
            Object object3 = randomPointsParameter.getGlobalMinDistance();
            String string6 = null;
            String string7 = null;
            String string8 = null;
            int n = 0;
            double d = 0.0;
            double d2 = 0.0;
            if (object instanceof String) {
                string6 = (String)object;
            } else {
                n = object instanceof Integer ? ((Integer)object).intValue() : Integer.valueOf(object.toString()).intValue();
            }
            if (object2 instanceof String) {
                string7 = (String)object2;
            } else {
                d = InternalToolkitSpatialAnalyst.objectToDouble(object2);
            }
            if (object3 instanceof String) {
                string8 = (String)object3;
            } else {
                d2 = InternalToolkitSpatialAnalyst.objectToDouble(object3);
            }
            if (sourceDatasetVector.getType() == DatasetType.POINT) {
                if (n <= 0) {
                    string = InternalResourceSpatialanalyst.loadString("randomPointsParameter.getRandomNumber()", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
                }
                if (d < 0.0) {
                    string = InternalResourceSpatialanalyst.loadString("randomPointsParameter.getMinDistance()", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                }
            } else {
                if (string6 == null) {
                    if (n <= 0) {
                        string = InternalResourceSpatialanalyst.loadString("randomPointsParameter.getRandomNumber()", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
                    }
                } else if (string6.length() == 0) {
                    string = InternalResourceSpatialanalyst.loadString("randomPointsParameter.getRandomNumber()", "Global_ArgumentNull", "spatialanalyst_resources");
                }
                if (string7 == null) {
                    if (d < 0.0) {
                        string = InternalResourceSpatialanalyst.loadString("randomPointsParameter.getMinDistance()", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                    }
                } else if (string7.length() == 0) {
                    string = InternalResourceSpatialanalyst.loadString("randomPointsParameter.getMinDistance() ", "Global_ArgumentNull", "spatialanalyst_resources");
                }
                if (string8 == null) {
                    if (d2 < 0.0) {
                        string = InternalResourceSpatialanalyst.loadString("randomPointsParameter.getGlobalMinDistance()", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                    }
                } else if (string8.length() == 0) {
                    string = InternalResourceSpatialanalyst.loadString("randomPointsParameter.getGlobalMinDistance() ", "Global_ArgumentNull", "spatialanalyst_resources");
                }
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int n2 = string6 == null ? 1 : 2;
            int n3 = string7 == null ? 1 : 2;
            int n4 = string8 == null ? 1 : 2;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            if (randomPointsParameter.getRectBounds() != null && !randomPointsParameter.getRectBounds().isEmpty()) {
                d3 = randomPointsParameter.getRectBounds().getLeft();
                d4 = randomPointsParameter.getRectBounds().getBottom();
                d5 = randomPointsParameter.getRectBounds().getRight();
                d6 = randomPointsParameter.getRectBounds().getTop();
            }
            long l3 = GeneralizationNative.jni_createRandomPoints(l, targetDatasetName, l2, n2, n, string6, n3, d, string7, n4, d2, string8, d3, d4, d5, d6);
            DatasetVector datasetVector = null;
            if (l3 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector vectorResample(DatasetVector srcDataset, ResampleInformation resampleInformation, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            Generalization.a();
            if (srcDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)srcDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("srcDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            targetDatasetName = targetDatasource.getDatasets().getAvailableDatasetName(targetDatasetName);
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)srcDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)resampleInformation);
            long l4 = GeneralizationNative.jni_vectorResample(l, l3, l2, targetDatasetName);
            if (l4 != 0L) {
                DatasetVector datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
                DatasetVector datasetVector2 = datasetVector;
                return datasetVector2;
            }
            DatasetVector datasetVector = null;
            return datasetVector;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        int n = -1;
        Object object = a;
        synchronized (object) {
            n = a.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (b == null) {
            b = new Vector();
        }
        if (!b.contains(l)) {
            b.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (b != null && b.contains(l)) {
            b.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (b != null) {
            Vector vector = b;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "Generalization";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)b, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector regularizeBuildingFootprint(DatasetVector sourceDataset, Datasource targetDatasource, String targetDatasetName, RegularizeParameter param, boolean isAttributeRetained, SteppedListener ... listeners) {
        try {
            Generalization.a();
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString(targetDatasetName, "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (param == null) {
                String string = InternalResourceSpatialanalyst.loadString("RegularizeParameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            DatasetType datasetType = sourceDataset.getType();
            if (datasetType != DatasetType.REGION) {
                String string = InternalResourceSpatialanalyst.loadString("", "BufferAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DatasetVector datasetVector = null;
            long l3 = GeneralizationNative.jni_RegularizeBuildingFootprint(l2, l, targetDatasetName, param.getOffsetDistance(), param.getOffsetDistanceUnit().value(), param.getMinArea(), param.getMinHoleArea(), param.getRegularizeMethod().value(), isAttributeRetained);
            if (l3 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)l);
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector aggregatePolygons(DatasetVector sourceDataset, Datasource targetDatasource, String targetDatasetName, AggregatePolygonParameter param, SteppedListener ... listeners) {
        try {
            DatasetType datasetType;
            Generalization.a();
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString(targetDatasetName, "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (param == null) {
                String string = InternalResourceSpatialanalyst.loadString("AggregatePolygonParameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (param.getDistance() < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("AggregatePolygonParameter.getTolerance", "OverlayAnalystParameter_ToleranceShouldEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (param.getMinArea() < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("AggregatePolygonParameter.getMinArea", "OverlayAnalystParameter_ToleranceShouldEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (param.getMinHoleArea() < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("AggregatePolygonParameter.getMinHoleArea", "OverlayAnalystParameter_ToleranceShouldEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (param.getAggregateFeild() != null && !param.getAggregateFeild().isEmpty()) {
                datasetType = sourceDataset.getFieldInfos();
                int n = datasetType.indexOf(param.getAggregateFeild());
                if (n == -1) {
                    String string = InternalResourceSpatialanalyst.loadString("GlobalSpecifiedNameNotExists", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (datasetType.get(n).isSystemField()) {
                    String string = InternalResourceSpatialanalyst.loadString("FieldNotSystemField", "FieldNotSystemField", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (datasetType.get(n).getType().value() != FieldType.INT16.value() && datasetType.get(n).getType().value() != FieldType.INT32.value() && datasetType.get(n).getType().value() != FieldType.INT64.value() && datasetType.get(n).getType().value() != FieldType.TEXT.value() && datasetType.get(n).getType().value() != FieldType.WTEXT.value() && datasetType.get(n).getType().value() != FieldType.BYTE.value() && datasetType.get(n).getType().value() != FieldType.BOOLEAN.value() && datasetType.get(n).getType().value() != FieldType.DATE.value() && datasetType.get(n).getType().value() != FieldType.CHAR.value() && datasetType.get(n).getType().value() != FieldType.TIME.value()) {
                    String string = InternalResourceSpatialanalyst.loadString("FieldTypeInvalidType", "InvalidFieldType", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            SteppedHelper.addListeners((SteppedListener[])listeners);
            datasetType = sourceDataset.getType();
            if (datasetType != DatasetType.REGION) {
                String string = InternalResourceSpatialanalyst.loadString("", "BufferAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l3 = GeneralizationNative.jni_aggregatePolygons(l2, l, targetDatasetName, param.getDistance(), param.getDistanceUnit().value(), param.getMinArea(), param.getMinHoleArea(), param.getAggregateFeild());
            DatasetVector datasetVector = null;
            if (l3 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)l);
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector pointsRegionalization(DatasetVector sourceDataset, Datasource targetDatasource, String targetDatasetName, double dDistance, Unit distanceUnit, SteppedListener ... listeners) {
        try {
            Generalization.a();
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString(targetDatasetName, "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (dDistance <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("dDistance", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DatasetType datasetType = sourceDataset.getType();
            if (datasetType != DatasetType.POINT) {
                String string = InternalResourceSpatialanalyst.loadString("", "BufferAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l3 = GeneralizationNative.jni_pointsRegionalization(l2, l, targetDatasetName, dDistance, distanceUnit.value());
            DatasetVector datasetVector = null;
            if (l3 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)l);
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector createStripMapPages(DatasetVector sourceDataset, DatasetVector barriersDataset, Datasource targetDatasource, String outputDatasetName, double aLengthAlongTheLine, double aLengthPerpendicularToTheLine, double dDistanceFromFirstPointOfTheEdge, double dOverlapDistance, SteppedListener ... listeners) {
        try {
            Generalization.a();
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L || sourceDataset.getRecordCount() == 0) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString(outputDatasetName, "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            DatasetType datasetType = sourceDataset.getType();
            if (datasetType != DatasetType.LINE) {
                String string = InternalResourceSpatialanalyst.loadString("", "BufferAnalyst_BufferDatasetTypeShouldBeLine", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            PrjCoordSys prjCoordSys = sourceDataset.getPrjCoordSys();
            PrjCoordSysType prjCoordSysType = prjCoordSys.getType();
            if (aLengthPerpendicularToTheLine == 0.0) {
                aLengthPerpendicularToTheLine = prjCoordSysType != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE ? 1000.0 : 0.01;
            }
            if (aLengthAlongTheLine == 0.0) {
                aLengthAlongTheLine = prjCoordSysType != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE ? 1500.0 : 0.015;
            }
            if (aLengthAlongTheLine <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("dLengthAlongTheLine :", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (aLengthPerpendicularToTheLine <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("dLengthPerpendicularToTheLine :", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (dDistanceFromFirstPointOfTheEdge < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("dDistanceFromFirstPointOfTheEdge: " + dDistanceFromFirstPointOfTheEdge, "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (dOverlapDistance < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("dOverlapDistance: " + dOverlapDistance, "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (dOverlapDistance >= aLengthAlongTheLine / 2.0) {
                String string = InternalResourceSpatialanalyst.loadString("dOverlapDistance: " + dOverlapDistance, "OverlapDistance_Must_Be_Less_Than_Half_Of_LengthAlongTheLine", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = 0L;
            if (barriersDataset != null) {
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)barriersDataset);
            }
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DatasetVector datasetVector = null;
            long l4 = GeneralizationNative.jni_createStripMapPages(l, l2, l3, outputDatasetName, aLengthAlongTheLine, aLengthPerpendicularToTheLine, dDistanceFromFirstPointOfTheEdge, dOverlapDistance);
            if (l4 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)l3);
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector createStripMapPages(DatasetVector sourceDataset, DatasetVector barriersDataset, Datasource targetDatasource, String outputDatasetName, double aLengthAlongTheLine, double aLengthPerpendicularToTheLine, SteppedListener ... listeners) {
        return Generalization.createStripMapPages(sourceDataset, barriersDataset, targetDatasource, outputDatasetName, aLengthAlongTheLine, aLengthPerpendicularToTheLine, 0.0, 0.0, listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector createVectorPyramid(DatasetVector targetDataset, int nMinLevel, int nMaxLevel, int nStep, double weight, VectorPyramidMethod method, SteppedListener ... listeners) {
        try {
            Generalization.a();
            if (targetDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource :", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            DatasetType datasetType = targetDataset.getType();
            if (datasetType != DatasetType.POINT && datasetType != DatasetType.LINE && datasetType != DatasetType.REGION && datasetType != DatasetType.POINT3D && datasetType != DatasetType.LINE3D && datasetType != DatasetType.REGION3D) {
                String string = InternalResourceSpatialanalyst.loadString(targetDataset.getName(), "VectorPyramid_UnsupportedDatasetType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            EngineType engineType = targetDataset.getDatasource().getEngineType();
            if (engineType != EngineType.UDBX && engineType != EngineType.PGGIS && engineType != EngineType.YUKON) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource :" + targetDataset.getName() + " EngineType :" + engineType.name(), "VectorPyramid_SupprotEngineType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (nMinLevel < 0) {
                String string = InternalResourceSpatialanalyst.loadString("nStartLevel: " + nMinLevel, "VectorPyramid_MinLevelShouldBePositive", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (nStep <= 0) {
                String string = InternalResourceSpatialanalyst.loadString("nStep: " + nStep, "VectorPyramid_StepShouldBePositive", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (nMinLevel >= nMaxLevel) {
                String string = InternalResourceSpatialanalyst.loadString("nStartLevel: " + nMinLevel, "VectorPyramid_TheMinLevelMustBeSmallerThanTheEndLevel", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDataset);
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (GeneralizationNative.jni_createVectorPyramid(l, nMinLevel, nMaxLevel, nStep, weight, method.value())) {
                DatasetVector datasetVector = targetDataset;
                return datasetVector;
            }
            DatasetVector datasetVector = null;
            return datasetVector;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    protected static boolean isDistanceUnit(Unit unit) {
        boolean bl = false;
        if (unit == Unit.MILIMETER) {
            bl = true;
        } else if (unit == Unit.CENTIMETER) {
            bl = true;
        } else if (unit == Unit.DECIMETER) {
            bl = true;
        } else if (unit == Unit.METER) {
            bl = true;
        } else if (unit == Unit.KILOMETER) {
            bl = true;
        } else if (unit == Unit.INCH) {
            bl = true;
        } else if (unit == Unit.FOOT) {
            bl = true;
        } else if (unit == Unit.YARD) {
            bl = true;
        } else if (unit == Unit.MILE) {
            bl = true;
        }
        return bl;
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        a = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

