/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.opengis.style.ColorReplacement;

public class AbstractStyleVisitor
implements StyleVisitor {
    public void visit(StyledLayerDescriptor sld) {
        for (StyledLayer sl : sld.getStyledLayers()) {
            if (sl instanceof UserLayer) {
                ((UserLayer)sl).accept((StyleVisitor)this);
                continue;
            }
            if (!(sl instanceof NamedLayer)) continue;
            ((NamedLayer)sl).accept((StyleVisitor)this);
        }
    }

    public void visit(NamedLayer layer) {
        for (Style style : layer.getStyles()) {
            style.accept((StyleVisitor)this);
        }
        for (Style style : layer.getLayerFeatureConstraints()) {
            style.accept((StyleVisitor)this);
        }
    }

    public void visit(UserLayer layer) {
        for (Style style : layer.getUserStyles()) {
            style.accept((StyleVisitor)this);
        }
        for (Style style : layer.getLayerFeatureConstraints()) {
            style.accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeConstraint ftc) {
    }

    public void visit(Style style) {
        for (FeatureTypeStyle fts : style.getFeatureTypeStyles()) {
            fts.accept((StyleVisitor)this);
        }
    }

    public void visit(Rule rule) {
        for (Symbolizer sym : rule.getSymbolizers()) {
            sym.accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeStyle fts) {
        for (Rule r : fts.getRules()) {
            r.accept((StyleVisitor)this);
        }
    }

    public void visit(Fill fill) {
        if (fill.getColor() != null) {
            // empty if block
        }
        if (fill.getGraphicFill() != null) {
            fill.getGraphicFill().accept((StyleVisitor)this);
        }
        if (fill.getOpacity() != null) {
            // empty if block
        }
    }

    public void visit(Stroke stroke) {
        if (stroke.getColor() != null) {
            // empty if block
        }
        if (stroke.getDashOffset() != null) {
            // empty if block
        }
        if (stroke.getGraphicFill() != null) {
            stroke.getGraphicFill().accept((StyleVisitor)this);
        }
        if (stroke.getGraphicStroke() != null) {
            stroke.getGraphicStroke().accept((StyleVisitor)this);
        }
        if (stroke.getLineCap() != null) {
            // empty if block
        }
        if (stroke.getLineJoin() != null) {
            // empty if block
        }
        if (stroke.getOpacity() != null) {
            // empty if block
        }
        if (stroke.getWidth() != null) {
            // empty if block
        }
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        } else if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        } else if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        } else if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        } else if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        } else {
            throw new RuntimeException("visit(Symbolizer) unsupported");
        }
    }

    public void visit(PointSymbolizer ps) {
        if (ps.getDescription() != null) {
            ps.getDescription().accept((StyleVisitor)this);
        }
        if (ps.getGeometry() != null) {
            // empty if block
        }
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept((StyleVisitor)this);
        }
    }

    public void visit(LineSymbolizer line) {
        if (line.getDescription() != null) {
            line.getDescription().accept((StyleVisitor)this);
        }
        if (line.getGeometry() != null) {
            // empty if block
        }
        if (line.getPerpendicularOffset() != null) {
            // empty if block
        }
        if (line.getStroke() != null) {
            line.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        if (poly.getDescription() != null) {
            poly.getDescription().accept((StyleVisitor)this);
        }
        if (poly.getDisplacement() != null) {
            poly.getDisplacement().accept((StyleVisitor)this);
        }
        if (poly.getFill() != null) {
            poly.getFill().accept((StyleVisitor)this);
        }
        if (poly.getGeometry() != null) {
            // empty if block
        }
        if (poly.getPerpendicularOffset() != null) {
            // empty if block
        }
        if (poly.getStroke() != null) {
            poly.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(TextSymbolizer text) {
        if (text.getDescription() != null) {
            text.getDescription().accept((StyleVisitor)this);
        }
        if (text.getFill() != null) {
            text.getFill().accept((StyleVisitor)this);
        }
        if (text.getFont() != null) {
            // empty if block
        }
        if (text.getGeometry() != null) {
            // empty if block
        }
        if (text.getHalo() != null) {
            text.getHalo().accept((StyleVisitor)this);
        }
        if (text.getLabel() != null) {
            // empty if block
        }
        if (text.getLabelPlacement() != null) {
            text.getLabelPlacement().accept((StyleVisitor)this);
        }
        if (text.getPriority() != null) {
            // empty if block
        }
    }

    public void visit(RasterSymbolizer raster) {
        if (raster.getChannelSelection() != null) {
            raster.getChannelSelection().accept((StyleVisitor)this);
        }
        if (raster.getColorMap() != null) {
            raster.getColorMap().accept((StyleVisitor)this);
        }
        if (raster.getContrastEnhancement() != null) {
            raster.getContrastEnhancement().accept((StyleVisitor)this);
        }
        if (raster.getDescription() != null) {
            raster.getDescription().accept((StyleVisitor)this);
        }
        if (raster.getGeometry() != null) {
            // empty if block
        }
        if (raster.getImageOutline() != null) {
            raster.getImageOutline().accept((StyleVisitor)this);
        }
        if (raster.getOpacity() != null) {
            // empty if block
        }
        if (raster.getOverlap() != null) {
            // empty if block
        }
        if (raster.getShadedRelief() != null) {
            raster.getShadedRelief().accept((StyleVisitor)this);
        }
    }

    public void visit(Graphic gr) {
        if (gr.getAnchorPoint() != null) {
            gr.getAnchorPoint().accept((StyleVisitor)this);
        }
        if (gr.getDisplacement() != null) {
            gr.getDisplacement().accept((StyleVisitor)this);
        }
        for (ExternalGraphic externalGraphic : gr.getExternalGraphics()) {
            externalGraphic.accept((StyleVisitor)this);
        }
        if (gr.getGap() != null) {
            // empty if block
        }
        if (gr.getInitialGap() != null) {
            // empty if block
        }
        for (ExternalGraphic externalGraphic : gr.getMarks()) {
            externalGraphic.accept((StyleVisitor)this);
        }
        if (gr.getOpacity() != null) {
            // empty if block
        }
        if (gr.getRotation() != null) {
            // empty if block
        }
        if (gr.getSize() != null) {
            // empty if block
        }
    }

    public void visit(Mark mark) {
        if (mark.getExternalMark() != null) {
            // empty if block
        }
        if (mark.getFill() != null) {
            mark.getFill().accept((StyleVisitor)this);
        }
        if (mark.getStroke() != null) {
            mark.getStroke().accept((StyleVisitor)this);
        }
        if (mark.getWellKnownName() != null) {
            // empty if block
        }
    }

    public void visit(ExternalGraphic exgr) {
        for (ColorReplacement colorReplacement : exgr.getColorReplacements()) {
        }
    }

    public void visit(PointPlacement pp) {
        if (pp.getAnchorPoint() != null) {
            pp.getAnchorPoint().accept((StyleVisitor)this);
        }
        if (pp.getDisplacement() != null) {
            pp.getDisplacement().accept((StyleVisitor)this);
        }
        if (pp.getRotation() != null) {
            // empty if block
        }
    }

    public void visit(AnchorPoint ap) {
        if (ap.getAnchorPointX() != null) {
            // empty if block
        }
        if (ap.getAnchorPointY() != null) {
            // empty if block
        }
    }

    public void visit(Displacement dis) {
        if (dis.getDisplacementX() != null) {
            // empty if block
        }
        if (dis.getDisplacementY() != null) {
            // empty if block
        }
    }

    public void visit(LinePlacement lp) {
        if (lp.getGap() != null) {
            // empty if block
        }
        if (lp.getInitialGap() != null) {
            // empty if block
        }
        if (lp.getPerpendicularOffset() != null) {
            // empty if block
        }
    }

    public void visit(Halo halo) {
        if (halo.getFill() != null) {
            halo.getFill().accept((StyleVisitor)this);
        }
        if (halo.getRadius() != null) {
            // empty if block
        }
    }

    public void visit(ColorMap colorMap) {
        for (ColorMapEntry cme : colorMap.getColorMapEntries()) {
            cme.accept((StyleVisitor)this);
        }
        if (colorMap.getFunction() != null) {
            // empty if block
        }
    }

    public void visit(ColorMapEntry colorMapEntry) {
        if (colorMapEntry.getColor() != null) {
            // empty if block
        }
        if (colorMapEntry.getOpacity() != null) {
            // empty if block
        }
        if (colorMapEntry.getQuantity() != null) {
            // empty if block
        }
    }

    public void visit(ContrastEnhancement contrastEnhancement) {
        if (contrastEnhancement.getGammaValue() != null) {
            // empty if block
        }
    }

    public void visit(ImageOutline outline) {
        if (outline.getSymbolizer() != null) {
            outline.getSymbolizer().accept((StyleVisitor)this);
        }
    }

    public void visit(ChannelSelection cs) {
        if (cs.getGrayChannel() != null) {
            cs.getGrayChannel().accept((StyleVisitor)this);
        }
        for (SelectedChannelType ch : cs.getRGBChannels()) {
            if (ch == null) continue;
            ch.accept((StyleVisitor)this);
        }
    }

    public void visit(OverlapBehavior ob) {
    }

    public void visit(SelectedChannelType sct) {
        if (sct.getContrastEnhancement() != null) {
            sct.getContrastEnhancement().accept((StyleVisitor)this);
        }
    }

    public void visit(ShadedRelief sr) {
        if (sr.getReliefFactor() != null) {
            // empty if block
        }
    }
}

