/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.License;
import com.supermap.ProductSet;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGroup;
import com.supermap.data.DatasetGroupNative;
import com.supermap.data.DatasetGroups;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetNative;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.DatasourceNative;
import com.supermap.data.EncodeType;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.Environment;
import com.supermap.data.ErrorInfo;
import com.supermap.data.FieldDefine;
import com.supermap.data.GeoModel3D;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalBufferImage;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PackageType;
import com.supermap.data.PixelFormat;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.ProductType;
import com.supermap.data.QueryParameter;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Resources;
import com.supermap.data.ToolkitNative;
import com.supermap.data.Workspace;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.imageio.stream.FileImageOutputStream;
import sun.awt.SunToolkit;

public class Toolkit {
    private static final String a = "PRODUCT_LICENSE_TEXT";
    private static final String b = "LICENSE_ISERVER_PRODUCTS";
    private static final String c = "LICENSE_DESKTOP_PRODUCTS";
    private static boolean d;
    private static boolean e;
    private static boolean f;
    private static int g;
    private static ArrayList<com.supermap.ProductType> h;
    private static ArrayList<com.supermap.ProductType> i;
    private static ArrayList<com.supermap.ProductType> j;
    static ArrayList<com.supermap.ProductType> g_addressMatchingProducts;
    static ArrayList<com.supermap.ProductType> g_coreProducts;
    static ArrayList<com.supermap.ProductType> g_layoutProducts;
    static ArrayList<com.supermap.ProductType> g_networkAnalystProducts;
    static ArrayList<com.supermap.ProductType> g_trafficAnalystProducts;
    static ArrayList<com.supermap.ProductType> g_realspaceProducts;
    static ArrayList<com.supermap.ProductType> g_realspaceEffectProducts;
    static ArrayList<com.supermap.ProductType> g_spatialAnalystProducts;
    static ArrayList<com.supermap.ProductType> g_topologyProducts;
    static ArrayList<com.supermap.ProductType> g_conversionProducts;
    static ArrayList<com.supermap.ProductType> g_chartProducts;
    static ArrayList<com.supermap.ProductType> g_realspaceSpatialAnalystProducts;
    static ArrayList<com.supermap.ProductType> g_realspaceThreeDDesignerProducts;
    static ArrayList<com.supermap.ProductType> g_realspaceNetworkAnalystProducts;
    static ArrayList<com.supermap.ProductType> g_imageProcessingProducts;
    static ArrayList<com.supermap.ProductType> g_plot3DProducts;
    static ArrayList<com.supermap.ProductType> g_situationEvolution3DProducts;
    static ArrayList<com.supermap.ProductType> g_plot2DProducts;
    static ArrayList<com.supermap.ProductType> g_situationEvolution2DProducts;
    public static final double DBL_MAX_VALUE = Double.MAX_VALUE;
    public static final double DBL_MIN_VALUE = -1.7976931348623157E308;
    public static final float FLT_MAX_VALUE = Float.MAX_VALUE;
    public static final float FLT_MIN_VALUE = -3.4028235E38f;

    protected Toolkit() {
    }

    private static void a() {
        String string = System.getenv(a);
        if (string != null && !string.isEmpty()) {
            License.setSpecifyLicenseXML(string);
        } else {
            string = System.getProperty(a);
            if (string != null && !string.isEmpty()) {
                License.setSpecifyLicenseXML(string);
            }
        }
    }

    static boolean setUpperProductSetLicenses(String context) {
        boolean bl = false;
        if (context != null && !context.isEmpty() && context.contains("{") && context.contains("}") && context.contains("[") && context.contains("]")) {
            String[] stringArray;
            context = context.replace("{", "").replace("}", "");
            for (String string : stringArray = context.split(",\"")) {
                String[] stringArray2;
                if (string == null || string.isEmpty() || (stringArray2 = (string = string.replace("\"", "")).split(":")).length != 2) continue;
                String string2 = stringArray2[0];
                String string3 = stringArray2[1];
                try {
                    ProductSet productSet = ProductSet.valueOf(string2);
                    string3 = string3.replace("[", "").replace("]", "");
                    String[] stringArray3 = string3.split(",");
                    ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
                    for (String string4 : stringArray3) {
                        arrayList.add(com.supermap.ProductType.newInstance(Integer.valueOf(string4.trim())));
                    }
                    License.setProductSetLicenses(productSet, arrayList);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            bl = true;
        }
        return bl;
    }

    static void getUpperProductsSetLicensesFromEnv(String varName) {
        try {
            String string = System.getenv(varName);
            if (!Toolkit.setUpperProductSetLicenses(string)) {
                string = System.getProperty(varName);
                Toolkit.setUpperProductSetLicenses(string);
            }
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getMessage());
        }
    }

    protected static License verifyLicense(ArrayList<com.supermap.ProductType> products) {
        com.supermap.ProductType productType;
        int n = -1;
        Toolkit.a();
        License license = new License();
        String string = "connect types is: ";
        Object object = products.iterator();
        while (object.hasNext() && (n = license.connect(productType = object.next())) != 0) {
            string = string + productType.getUGCValue();
            string = string + " , ";
        }
        if (n != 0) {
            object = License.getErrorMessage(n);
            throw new IllegalStateException(string + (String)object);
        }
        return license;
    }

    protected static ArrayList<com.supermap.ProductType> managerProducts(ArrayList<com.supermap.ProductType> pros) {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.addAll(pros);
        arrayList.add(com.supermap.ProductType.IOBJECTS_SPARK_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_SPARK_RUNTIME);
        arrayList.add(com.supermap.ProductType.IOBJECTS_PYTHON_DEVELOP);
        arrayList.add(com.supermap.ProductType.IOBJECTS_PYTHON_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProductTypes());
        if (!j.isEmpty()) {
            for (int i = pros.size() - 1; i >= 0; --i) {
                if (j.contains(pros.get(i))) continue;
                pros.remove(i);
            }
        }
        return arrayList;
    }

    @Deprecated
    public static void SetiServerProductTypes(ArrayList<com.supermap.ProductType> pros) {
        h.clear();
        h.addAll(pros);
    }

    @Deprecated
    public static ArrayList<com.supermap.ProductType> GetiServerProductTypes() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.addAll(h);
        return arrayList;
    }

    @Deprecated
    public static void setDesktopProductTypes(ArrayList<com.supermap.ProductType> pros) {
        i.clear();
        i.addAll(pros);
    }

    @Deprecated
    public static ArrayList<com.supermap.ProductType> getDesktopProductTypes() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.addAll(i);
        return arrayList;
    }

    public static void SetSpecifiedProductTypes(ArrayList<com.supermap.ProductType> pros) {
        j.clear();
        for (com.supermap.ProductType productType : pros) {
            j.add(productType);
        }
    }

    public static ArrayList<com.supermap.ProductType> GetSpecifiedProductTypes() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        for (com.supermap.ProductType productType : j) {
            arrayList.add(productType);
        }
        return arrayList;
    }

    public static ArrayList<com.supermap.ProductType> getTrialProductTypes() {
        return License.getDesktopTrialLicenses();
    }

    protected static ArrayList<com.supermap.ProductType> addProductSetLicense(ArrayList<com.supermap.ProductType> innerProducts, ProductSet productSet) {
        ArrayList<com.supermap.ProductType> arrayList = License.getProductSetLicenses(productSet);
        if (arrayList != null && !arrayList.isEmpty()) {
            ArrayList<com.supermap.ProductType> arrayList2 = new ArrayList<com.supermap.ProductType>();
            arrayList2.addAll(arrayList);
            arrayList2.addAll(innerProducts);
            return arrayList2;
        }
        return innerProducts;
    }

    protected static synchronized ArrayList<com.supermap.ProductType> getAddressMatchingProducts() {
        if (g_addressMatchingProducts == null) {
            g_addressMatchingProducts = new ArrayList();
            g_addressMatchingProducts.add(com.supermap.ProductType.IOBJECTS_ADDRESS_MATCHING_RUNTIME);
            g_addressMatchingProducts.add(com.supermap.ProductType.IOBJECTS_ADDRESS_MATCHING_DEVELOP);
        }
        return Toolkit.addProductSetLicense(g_addressMatchingProducts, ProductSet.ADDRESS_MATCHING);
    }

    protected static synchronized ArrayList<com.supermap.ProductType> getDataProducts() {
        if (g_coreProducts == null) {
            g_coreProducts = new ArrayList();
            g_coreProducts.add(com.supermap.ProductType.IOBJECTS_CORE_RUNTIME);
            g_coreProducts.add(com.supermap.ProductType.IOBJECTS_CORE_DEVELOP);
        }
        return Toolkit.addProductSetLicense(g_coreProducts, ProductSet.CORE);
    }

    protected static ArrayList<com.supermap.ProductType> getLayoutProducts() {
        if (g_layoutProducts == null) {
            g_layoutProducts = new ArrayList();
            g_layoutProducts.add(com.supermap.ProductType.IOBJECTS_LAYOUT_RUNTIME);
            g_layoutProducts.add(com.supermap.ProductType.IOBJECTS_LAYOUT_DEVELOP);
        }
        return Toolkit.addProductSetLicense(g_layoutProducts, ProductSet.LAYOUT);
    }

    protected static ArrayList<com.supermap.ProductType> getNetworkAnalystProducts() {
        if (g_networkAnalystProducts == null) {
            g_networkAnalystProducts = new ArrayList();
            g_networkAnalystProducts.add(com.supermap.ProductType.IOBJECTS_NETWORK_RUNTIME);
            g_networkAnalystProducts.add(com.supermap.ProductType.IOBJECTS_NETWORK_DEVELOP);
        }
        return Toolkit.addProductSetLicense(g_networkAnalystProducts, ProductSet.NETWORK_ANALYST);
    }

    protected static ArrayList<com.supermap.ProductType> getTrafficAnalystProducts() {
        if (g_trafficAnalystProducts == null) {
            g_trafficAnalystProducts = new ArrayList();
            g_trafficAnalystProducts.add(com.supermap.ProductType.IOBJECTS_TRAFFIC_ANALYST_RUNTIME);
            g_trafficAnalystProducts.add(com.supermap.ProductType.IOBJECTS_TRAFFIC_ANALYST_DEVELOP);
            g_trafficAnalystProducts.add(com.supermap.ProductType.IOBJECTS_NETWORK_RUNTIME);
            g_trafficAnalystProducts.add(com.supermap.ProductType.IOBJECTS_NETWORK_DEVELOP);
        }
        return Toolkit.addProductSetLicense(g_trafficAnalystProducts, ProductSet.NETWORK_ANALYST);
    }

    protected static ArrayList<com.supermap.ProductType> getSpaceProducts() {
        if (g_realspaceProducts == null) {
            g_realspaceProducts = new ArrayList();
            g_realspaceProducts.add(com.supermap.ProductType.IOBJECTS_SPACE_RUNTIME);
            g_realspaceProducts.add(com.supermap.ProductType.IOBJECTS_SPACE_DEVELOP);
        }
        return Toolkit.addProductSetLicense(g_realspaceProducts, ProductSet.REALSPACE);
    }

    protected static ArrayList<com.supermap.ProductType> getSpace3DEffectProducts() {
        if (g_realspaceEffectProducts == null) {
            g_realspaceEffectProducts = new ArrayList();
            g_realspaceEffectProducts.add(com.supermap.ProductType.IOBJECTS_REALSPACE_EFFECT_RUNTIME);
            g_realspaceEffectProducts.add(com.supermap.ProductType.IOBJECTS_REALSPACE_EFFECT_DEVELOP);
        }
        return Toolkit.addProductSetLicense(g_realspaceEffectProducts, ProductSet.REALSPACE_EFFECT);
    }

    protected static ArrayList<com.supermap.ProductType> getSpatialAnalystProducts() {
        if (g_spatialAnalystProducts == null) {
            g_spatialAnalystProducts = new ArrayList();
            g_spatialAnalystProducts.add(com.supermap.ProductType.IOBJECTS_SPATIAL_RUNTIME);
            g_spatialAnalystProducts.add(com.supermap.ProductType.IOBJECTS_SPATIAL_DEVELOP);
        }
        return Toolkit.addProductSetLicense(g_spatialAnalystProducts, ProductSet.SPATIAL_ANALYST);
    }

    protected static ArrayList<com.supermap.ProductType> getTopologyProducts() {
        if (g_topologyProducts == null) {
            g_topologyProducts = new ArrayList();
            g_topologyProducts.add(com.supermap.ProductType.IOBJECTS_TOPOLOGY_DEVELOP);
            g_topologyProducts.add(com.supermap.ProductType.IOBJECTS_TOPOLOGY_RUNTIME);
        }
        return Toolkit.addProductSetLicense(g_topologyProducts, ProductSet.TOPOLOGY);
    }

    protected static ArrayList<com.supermap.ProductType> getConversionProducts() {
        if (g_conversionProducts == null) {
            g_conversionProducts = new ArrayList();
            g_conversionProducts.add(com.supermap.ProductType.IOBJECTS_SDX_RUNTIME);
            g_conversionProducts.add(com.supermap.ProductType.IOBJECTS_SDX_DEVELOP);
        }
        return Toolkit.addProductSetLicense(g_conversionProducts, ProductSet.SDX);
    }

    protected static ArrayList<com.supermap.ProductType> getChartProducts() {
        if (g_chartProducts == null) {
            g_chartProducts = new ArrayList();
            g_chartProducts.add(com.supermap.ProductType.IOBJECTS_CHART_DEVELOP);
            g_chartProducts.add(com.supermap.ProductType.IOBJECTS_CHART_RUNTIME);
        }
        return Toolkit.addProductSetLicense(g_chartProducts, ProductSet.CHART);
    }

    protected static ArrayList<com.supermap.ProductType> getRealspaceSpatialAnalystProducts() {
        if (g_realspaceSpatialAnalystProducts == null) {
            g_realspaceSpatialAnalystProducts = new ArrayList();
            g_realspaceSpatialAnalystProducts.add(com.supermap.ProductType.IOBJECTS_REALSPACE_SPATIAL_ANALYST_DEVELOP);
            g_realspaceSpatialAnalystProducts.add(com.supermap.ProductType.IOBJECTS_REALSPACE_SPATIAL_ANALYST_RUNTIME);
        }
        return Toolkit.addProductSetLicense(g_realspaceSpatialAnalystProducts, ProductSet.REALSPACE_SPATIAL_ANALYST);
    }

    protected static ArrayList<com.supermap.ProductType> getRealspaceThreeDDesignerProducts() {
        if (g_realspaceThreeDDesignerProducts == null) {
            g_realspaceThreeDDesignerProducts = new ArrayList();
            g_realspaceThreeDDesignerProducts.add(com.supermap.ProductType.IOBJECTS_REALSPACE_BUILDER3D_DEVELOP);
            g_realspaceThreeDDesignerProducts.add(com.supermap.ProductType.IOBJECTS_REALSPACE_BUILDER3D_RUNTIME);
            g_realspaceThreeDDesignerProducts.add(com.supermap.ProductType.newInstance(10521));
        }
        return Toolkit.addProductSetLicense(g_realspaceThreeDDesignerProducts, ProductSet.REALSPACE_BUILDER3D);
    }

    protected static ArrayList<com.supermap.ProductType> getRealspaceNetworkAnalystProducts() {
        if (g_realspaceNetworkAnalystProducts == null) {
            g_realspaceNetworkAnalystProducts = new ArrayList();
            g_realspaceNetworkAnalystProducts.add(com.supermap.ProductType.IOBJECTS_REALSPACE_NETWORK_ANALYST_DEVELOP);
            g_realspaceNetworkAnalystProducts.add(com.supermap.ProductType.IOBJECTS_REALSPACE_NETWORK_ANALYST_RUNTIME);
        }
        return Toolkit.addProductSetLicense(g_realspaceNetworkAnalystProducts, ProductSet.REALSPACE_NETWORK_ANALYST);
    }

    protected static ArrayList<com.supermap.ProductType> getImageProcessingProducts() {
        if (g_imageProcessingProducts == null) {
            g_imageProcessingProducts = new ArrayList();
            g_imageProcessingProducts.add(com.supermap.ProductType.IOBJECTS_IMAGEPROCESSING_DEVELOP);
            g_imageProcessingProducts.add(com.supermap.ProductType.IOBJECTS_IMAGEPROCESSING_RUNTIME);
        }
        return Toolkit.addProductSetLicense(g_imageProcessingProducts, ProductSet.IMAGEPROCESSING);
    }

    protected static ArrayList<com.supermap.ProductType> getFMEVectorProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IOBJECTS_FME_VECTOR);
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getFMEEsriProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IOBJECTS_FME_ESRI);
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getFMERasterProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IOBJECTS_FME_RASTER);
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getFMEOtherProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.IOBJECTS_FME_OTHER);
        return arrayList;
    }

    protected static ArrayList<com.supermap.ProductType> getPlot3DProducts() {
        if (g_plot3DProducts == null) {
            g_plot3DProducts = new ArrayList();
            g_plot3DProducts.add(com.supermap.ProductType.IOBJECTS_PLOT2D_DEVELOP);
            g_plot3DProducts.add(com.supermap.ProductType.IOBJECTS_PLOT3D_DEVELOP);
            g_plot3DProducts.add(com.supermap.ProductType.IOBJECTS_PLOT2D_RUNTIME);
            g_plot3DProducts.add(com.supermap.ProductType.IOBJECTS_PLOT3D_RUNTIME);
        }
        return Toolkit.addProductSetLicense(g_plot3DProducts, ProductSet.PLOT3D);
    }

    protected static ArrayList<com.supermap.ProductType> getSituationEvolution3DProducts() {
        if (g_situationEvolution3DProducts == null) {
            g_situationEvolution3DProducts = new ArrayList();
            g_situationEvolution3DProducts.add(com.supermap.ProductType.IOBJECTS_SITUATIONEVOLUTION3D_DEVELOP);
            g_situationEvolution3DProducts.add(com.supermap.ProductType.IOBJECTS_SITUATIONEVOLUTION3D_RUNTIME);
        }
        return Toolkit.addProductSetLicense(g_situationEvolution3DProducts, ProductSet.SITUATIONEVOLUTION3D);
    }

    protected static ArrayList<com.supermap.ProductType> getPlot2DProducts() {
        if (g_plot2DProducts == null) {
            g_plot2DProducts = new ArrayList();
            g_plot2DProducts.add(com.supermap.ProductType.IOBJECTS_PLOT2D_DEVELOP);
            g_plot2DProducts.add(com.supermap.ProductType.IOBJECTS_PLOT2D_RUNTIME);
        }
        return Toolkit.addProductSetLicense(g_plot2DProducts, ProductSet.PLOT2D);
    }

    protected static ArrayList<com.supermap.ProductType> getSituationEvolution2DProducts() {
        if (g_situationEvolution2DProducts == null) {
            g_situationEvolution2DProducts = new ArrayList();
            g_situationEvolution2DProducts.add(com.supermap.ProductType.IOBJECTS_SITUATIONEVOLUTION2D_DEVELOP);
            g_situationEvolution2DProducts.add(com.supermap.ProductType.IOBJECTS_SITUATIONEVOLUTION2D_RUNTIME);
        }
        return Toolkit.addProductSetLicense(g_situationEvolution2DProducts, ProductSet.SITUATIONEVOLUTION2D);
    }

    protected static ArrayList<com.supermap.ProductType> getJSProducts() {
        ArrayList<com.supermap.ProductType> arrayList = new ArrayList<com.supermap.ProductType>();
        arrayList.add(com.supermap.ProductType.MOBJECTS_CORE);
        arrayList.add(com.supermap.ProductType.MOBJECTS_CORE_DEVELOP);
        arrayList.add(com.supermap.ProductType.MDESKTOPJAVA_STANDARD);
        arrayList.add(com.supermap.ProductType.MDESKTOPJAVA_PROFESSIONAL);
        arrayList.add(com.supermap.ProductType.MDESKTOPJAVA_ENTERPRISE);
        arrayList.add(com.supermap.ProductType.MSERVER_PROFESSIONAL);
        arrayList.add(com.supermap.ProductType.MSERVER_ENTERPRISE);
        return arrayList;
    }

    protected static void setMappingRuntimeLicenseMode(boolean licenseMode) {
        d = licenseMode;
    }

    protected static boolean getMappingRuntimeLicenseMode() {
        return d;
    }

    protected static void setSpaceRuntimeLicenseMode(boolean licenseMode) {
        e = licenseMode;
    }

    protected static boolean getSpaceRuntimeLicenseMode() {
        return e;
    }

    protected static void setLayoutRuntimeLicenseMode(boolean liceseMode) {
        f = liceseMode;
    }

    protected static boolean getLayoutRuntimeLicenseMode() {
        return f;
    }

    protected static int getChartLicenseState() {
        return ToolkitNative.jni_getChartLicenseState();
    }

    protected static void setChartLicenseState(int value) {
        ToolkitNative.jni_setChartLicenseState(value);
    }

    protected static int CheckChartLicenseState() {
        License license = new License();
        ToolkitNative.jni_setDrawChartLayer(false);
        int n = -1;
        if (license.connect(com.supermap.ProductType.IOBJECTS_CHART_DEVELOP) == 0 || license.connect(com.supermap.ProductType.IOBJECTS_CHART_RUNTIME) == 0) {
            n = 2;
        } else {
            ArrayList<com.supermap.ProductType> arrayList = Toolkit.getTrialProductTypes();
            int n2 = -1;
            for (com.supermap.ProductType productType : arrayList) {
                n2 = license.connect(productType);
                if (n2 != 0) continue;
                n = 0;
                ToolkitNative.jni_setDrawChartLayer(true);
                break;
            }
        }
        if (license.connect(com.supermap.ProductType.ISERVER_CHART) == 0 || license.connect(com.supermap.ProductType.ISERVER_CHART_16CORES) == 0 || license.connect(com.supermap.ProductType.ISERVER_CHART_32CORES) == 0 || license.connect(com.supermap.ProductType.ISERVER_CHART_ADDITIONAL_2CORES) == 0) {
            n = 0;
            if (g == 0) {
                ToolkitNative.jni_setDrawChartLayer(true);
            }
        } else if (license.connect(com.supermap.ProductType.IMARITIMEEDITOR_BASIC) == 0 || license.connect(com.supermap.ProductType.IMARITIMEEDITOR_STANDARD) == 0 || license.connect(com.supermap.ProductType.IMARITIMEEDITOR_ADVANCE) == 0 || license.connect(com.supermap.ProductType.IDESKTOPJAVA_NAUTICALCHARTS) == 0) {
            n = 1;
            ToolkitNative.jni_setDrawChartLayer(true);
        }
        license.disconnect();
        license.dispose();
        if (n != -1 && g == 2) {
            ToolkitNative.jni_setDrawChartLayer(true);
        }
        ToolkitNative.jni_setChartLicenseState(n);
        return n;
    }

    protected static void setCurrentProduction(int nType) {
        g = nType;
    }

    protected static int getCurrentProduction() {
        return g;
    }

    protected static void updateStatus() {
        ToolkitNative.jni_updateTrialStatus(Toolkit.getMappingRuntimeLicenseMode(), Toolkit.getLayoutRuntimeLicenseMode(), Toolkit.getSpaceRuntimeLicenseMode());
    }

    public static void freeMemory() {
        ToolkitNative.jni_FreeMemory();
    }

    public static boolean isZero(double value) {
        boolean bl = value >= Environment.getMinEqualZeroPrecision() && value <= Environment.getMaxEqualZeroPrecision();
        return bl;
    }

    public static boolean isZero(double value, double precision) {
        boolean bl = value >= -Math.abs(precision) && value <= Math.abs(precision);
        return bl;
    }

    public static boolean isZero(double value, double minPrecision, double maxPrecision) {
        boolean bl = value >= minPrecision && value <= maxPrecision;
        return bl;
    }

    public static boolean drawToPNG(Geometry geometry, Resources resources, String fileName, Dimension size) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resources == null) {
            String string = InternalResource.loadString("resources", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(resources);
        if (l2 == 0L) {
            String string = InternalResource.loadString("resources", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = ToolkitNative.jni_DrawGeometryToPNG(geometry.getHandle(), l2, fileName, size.width, size.height);
        geometry.makeSureNativeObjectLive();
        resources.makeSureNativeObjectLive();
        return bl;
    }

    public static boolean draw(Geometry geometry, Resources resources, BufferedImage image) {
        InternalBufferImage internalBufferImage;
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resources == null) {
            String string = InternalResource.loadString("resources", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(resources);
        if (l2 == 0L) {
            String string = InternalResource.loadString("resources", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (image == null) {
            String string = InternalResource.loadString("image", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        try {
            internalBufferImage = new InternalBufferImage(image.getWidth(), image.getHeight());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        bl = ToolkitNative.jni_DrawGeometry(geometry.getHandle(), l2, internalBufferImage.getHandle());
        image.getGraphics().drawImage(internalBufferImage.getMemoryImage(), 0, 0, internalBufferImage.getWidth(), internalBufferImage.getHeight(), null);
        geometry.makeSureNativeObjectLive();
        resources.makeSureNativeObjectLive();
        InternalHandleDisposable.makeSureNativeObjectLive(internalBufferImage);
        return bl;
    }

    @Deprecated
    public static boolean draw(Geometry geometry, Resources resources, Graphics graphics) {
        InternalBufferImage internalBufferImage;
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resources == null) {
            String string = InternalResource.loadString("resources", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(resources);
        if (l2 == 0L) {
            String string = InternalResource.loadString("resources", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Rectangle2D rectangle2D = geometry.getBounds();
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = graphics2D.getDeviceConfiguration().getBounds().width;
        int n2 = graphics2D.getDeviceConfiguration().getBounds().height;
        boolean bl = false;
        try {
            internalBufferImage = new InternalBufferImage(n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        bl = ToolkitNative.jni_DrawGeometry(geometry.getHandle(), l2, internalBufferImage.getHandle());
        graphics.drawImage(internalBufferImage.getMemoryImage(), 0, 0, internalBufferImage.getWidth(), internalBufferImage.getHeight(), null);
        geometry.makeSureNativeObjectLive();
        resources.makeSureNativeObjectLive();
        InternalHandleDisposable.makeSureNativeObjectLive(internalBufferImage);
        return bl;
    }

    protected static boolean internalDraw(Geometry geometry, Resources resources, Graphics graphics) {
        InternalBufferImage internalBufferImage;
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resources == null) {
            String string = InternalResource.loadString("resources", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(resources);
        if (l2 == 0L) {
            String string = InternalResource.loadString("resources", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Rectangle2D rectangle2D = geometry.getBounds();
        boolean bl = false;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = graphics2D.getDeviceConfiguration().getBounds().width;
        int n2 = graphics2D.getDeviceConfiguration().getBounds().height;
        try {
            if (geometry.getType().equals(GeometryType.GEOPOINT) && geometry.getStyle() != null) {
                internalBufferImage = new InternalBufferImage((int)geometry.getStyle().getMarkerSize().getWidth() + n * 4, (int)geometry.getStyle().getMarkerSize().getHeight() + n2 * 4);
                geometry.offset(-rectangle2D.getLeft() + (double)(n * 2), -rectangle2D.getBottom() + (double)(n2 * 2));
            } else if (geometry.getType().equals(GeometryType.GEOLINE) && geometry.getStyle() != null) {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + n * 2, (int)rectangle2D.getHeight() + n2 * 2);
                geometry.offset(-rectangle2D.getLeft() + (double)n / 2.0, -rectangle2D.getBottom() + (double)n2 / 2.0);
            } else {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1);
                geometry.offset(-rectangle2D.getLeft(), -rectangle2D.getBottom());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        bl = ToolkitNative.jni_DrawGeometry(geometry.getHandle(), l2, internalBufferImage.getHandle());
        BufferedImage bufferedImage = new BufferedImage(internalBufferImage.getWidth(), internalBufferImage.getHeight(), 2);
        bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(), 0, 0, internalBufferImage.getWidth(), internalBufferImage.getHeight(), null);
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int n3 = bufferedImage.getRGB(i, j);
                if (n3 != -16711423) continue;
                bufferedImage.setRGB(i, j, 65793);
            }
        }
        if (bl) {
            if (geometry.getType().equals(GeometryType.GEOPOINT) && geometry.getStyle() != null) {
                graphics.drawImage(bufferedImage, (int)rectangle2D.getLeft() - n * 2, (int)rectangle2D.getBottom() - n2 * 2, null);
            } else if (geometry.getType().equals(GeometryType.GEOLINE) && geometry.getStyle() != null) {
                graphics.drawImage(bufferedImage, (int)rectangle2D.getLeft() - n / 2, (int)rectangle2D.getBottom() - n2 / 2, null);
            } else {
                graphics.drawImage(bufferedImage, (int)rectangle2D.getLeft(), (int)rectangle2D.getBottom(), null);
            }
        }
        geometry.makeSureNativeObjectLive();
        resources.makeSureNativeObjectLive();
        InternalHandleDisposable.makeSureNativeObjectLive(internalBufferImage);
        return bl;
    }

    public static boolean compactDatasource(Datasource datasource) {
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(datasource);
        if (l == 0L) {
            String string = InternalResource.loadString("datasource", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Datasource.m_senderMethodName = "compactDatasource";
        datasource.m_selfEventHandle = DatasourceNative.jni_NewSelfEventHandle(datasource);
        boolean bl = ToolkitNative.jni_CompactDatasource(l, datasource.m_selfEventHandle);
        datasource.clearSelfEventHandle();
        return bl;
    }

    public static boolean degraRaster(DatasourceConnectionInfo connectionInfo, String strDtName) {
        if (connectionInfo == null || connectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("open()", "Datasources_ConnectionInfoIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return ToolkitNative.jni_DegraUDBRaster(connectionInfo.getHandle(), strDtName);
    }

    public static EncodeType[] getEncodeType(DatasetType type) {
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        ArrayList<EncodeType> arrayList = new ArrayList<EncodeType>();
        switch (type.value()) {
            case 3: 
            case 4: 
            case 5: 
            case 205: 
            case 208: {
                arrayList.add(EncodeType.BYTE);
                arrayList.add(EncodeType.INT16);
                arrayList.add(EncodeType.INT24);
                arrayList.add(EncodeType.INT32);
                arrayList.add(EncodeType.NONE);
                break;
            }
            case 0: 
            case 1: 
            case 7: 
            case 35: 
            case 149: 
            case 153: {
                arrayList.add(EncodeType.NONE);
                break;
            }
            case 81: {
                arrayList.add(EncodeType.LZW);
                arrayList.add(EncodeType.DCT);
                arrayList.add(EncodeType.PNG);
                arrayList.add(EncodeType.COMPOUND);
                arrayList.add(EncodeType.NONE);
                break;
            }
            case 83: 
            case 89: {
                arrayList.add(EncodeType.LZW);
                arrayList.add(EncodeType.SGL);
                arrayList.add(EncodeType.NONE);
                break;
            }
            default: {
                arrayList.add(EncodeType.NONE);
            }
        }
        EncodeType[] encodeTypeArray = new EncodeType[arrayList.size()];
        return arrayList.toArray(encodeTypeArray);
    }

    public static ErrorInfo getLastError2() {
        ErrorInfo[] errorInfoArray = Toolkit.getLastErrors(1);
        if (errorInfoArray != null) {
            if (errorInfoArray.length == 1) {
                return errorInfoArray[0];
            }
            return null;
        }
        return null;
    }

    public static ErrorInfo[] getLastErrors(int count) {
        if (count < 0) {
            return null;
        }
        int n = ToolkitNative.jni_GetErrorCount();
        if (n < 0) {
            return null;
        }
        int n2 = count < n ? count : n;
        ErrorInfo[] errorInfoArray = new ErrorInfo[n2];
        int[] nArray = new int[n2];
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        ToolkitNative.jni_GetErrorInfos(nArray, stringArray, stringArray2, n, count);
        for (int i = 0; i < stringArray2.length; ++i) {
            errorInfoArray[i] = new ErrorInfo(nArray[i], stringArray[i], stringArray2[i]);
        }
        return errorInfoArray;
    }

    public static void clearErrors() {
        ToolkitNative.jni_ClearErrors();
    }

    public static ErrorInfo[] getAllErrors() {
        int n = ToolkitNative.jni_GetErrorCount();
        int[] nArray = new int[n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        ToolkitNative.jni_GetAllErrors(nArray, stringArray, stringArray2);
        ErrorInfo[] errorInfoArray = new ErrorInfo[n];
        for (int i = 0; i < stringArray2.length; ++i) {
            errorInfoArray[i] = new ErrorInfo(nArray[i], stringArray[i], stringArray2[i]);
        }
        return errorInfoArray;
    }

    public static String[] getWarnings() {
        int n = ToolkitNative.jni_GetErrorCount();
        int[] nArray = new int[n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        ToolkitNative.jni_GetAllErrors(nArray, stringArray, stringArray2);
        String[] stringArray3 = new String[n];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = new String(stringArray2[i]);
        }
        return stringArray3;
    }

    @Deprecated
    public static String getLastError() {
        return ToolkitNative.jni_GetLastError();
    }

    public static boolean extractCache2DFile(String sourceFileName, String targetFolderName) {
        boolean bl = false;
        if (Locale.getDefault().getLanguage().equals(Locale.JAPANESE.getLanguage())) {
            sourceFileName = sourceFileName.replaceAll("\\\\", "/");
            targetFolderName = targetFolderName.replaceAll("\\\\", "/");
        }
        bl = ToolkitNative.jni_ExtractCache2DFile(sourceFileName, targetFolderName);
        return bl;
    }

    public static boolean extractCacheFile(String sourceFileName, String targetFolderName) {
        return Toolkit.extractCacheFile(sourceFileName, targetFolderName, "");
    }

    public static boolean extractCacheFile(String sourceFileName, String targetFolderName, String pwd) {
        if (pwd == null) {
            pwd = "";
        }
        boolean bl = false;
        if (Locale.getDefault().getLanguage().equals(Locale.JAPANESE.getLanguage())) {
            sourceFileName = sourceFileName.replaceAll("\\\\", "/");
            targetFolderName = targetFolderName.replaceAll("\\\\", "/");
        }
        bl = ToolkitNative.jni_ExtractCacheFile(sourceFileName, targetFolderName, pwd);
        return bl;
    }

    public static byte[] extractCacheFile2(String sourceFileName, String pwd) {
        if (pwd == null) {
            pwd = "";
        }
        boolean bl = false;
        if (Locale.getDefault().getLanguage().equals(Locale.JAPANESE.getLanguage())) {
            sourceFileName = sourceFileName.replaceAll("\\\\", "/");
        }
        byte[] byArray = ToolkitNative.jni_ExtractCacheFile2(sourceFileName, pwd);
        return byArray;
    }

    public static byte[] extractCacheFiles(String[] sourceFileName, String pwd) {
        if (pwd == null) {
            pwd = "";
        }
        boolean bl = false;
        byte[] byArray = ToolkitNative.jni_ExtractCacheFiles(sourceFileName, pwd);
        return byArray;
    }

    public static byte[] extractCacheFiles2(String sourceFileName, String pwd) {
        if (pwd == null) {
            pwd = "";
        }
        boolean bl = false;
        byte[] byArray = ToolkitNative.jni_ExtractCacheFiles2(sourceFileName, pwd);
        return byArray;
    }

    public static boolean compress(String[] fileNames, String targetFileName, String pwd, PackageType type) {
        boolean bl = false;
        if (fileNames != null && targetFileName != null) {
            if (pwd == null) {
                pwd = "";
            }
            if (type.equals(PackageType.pkg7ZIP)) {
                if (Locale.getDefault().getLanguage().equals(Locale.JAPANESE.getLanguage())) {
                    targetFileName = targetFileName.replaceAll("\\\\", "/");
                }
                bl = ToolkitNative.jni_Compress7Zip(fileNames, targetFileName, pwd);
            }
        }
        return bl;
    }

    public static boolean unCompress(String srcFileName, String targetFolder, String pwd) {
        boolean bl = false;
        if (srcFileName != null && targetFolder != null) {
            if (pwd == null) {
                pwd = "";
            }
            bl = ToolkitNative.jni_UnCompress7Zip(srcFileName, targetFolder, pwd);
        }
        return bl;
    }

    protected static void setHandleBooleanValue(long handle, boolean value) {
        ToolkitNative.jni_SetBooleanHandle(handle, value);
    }

    protected static boolean getHandleBooleanValue(long handle) {
        return ToolkitNative.jni_GetBooleanHandle(handle);
    }

    protected static void setHandleDoubleValue(long handle, double value) {
        ToolkitNative.jni_SetHandleDoubleValue(handle, value);
    }

    protected static double getHandleDoubleValue(long handle) {
        return ToolkitNative.jni_GetHandleDoubleValue(handle);
    }

    protected static void setHandleIntValue(long handle, int value) {
        ToolkitNative.jni_SetHandleIntValue(handle, value);
    }

    protected static int getHandleIntValue(long handle) {
        return ToolkitNative.jni_GetHandleIntValue(handle);
    }

    protected static String joinString(String[] arr, String connectString) {
        if (arr == null || arr.length == 0 || connectString == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arr.length - 1; ++i) {
            stringBuffer.append(arr[i] + connectString);
        }
        stringBuffer.append(arr[arr.length - 1]);
        return stringBuffer.toString();
    }

    protected static String[] splitString(String value, String splitString) {
        if (value == null || value.trim().equals("") || splitString == null) {
            return new String[0];
        }
        return value.split(splitString);
    }

    static Date parseUGCTime(String ugcTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        try {
            return simpleDateFormat.parse(ugcTime);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    static String toUGCTime(Date time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return simpleDateFormat.format(time);
    }

    static boolean isValidEncodeType(boolean isVector, EncodeType encodeType) {
        boolean bl = true;
        if (isVector) {
            if (encodeType.equals(EncodeType.DCT) || encodeType.equals(EncodeType.LZW) || encodeType.equals(EncodeType.SGL) || encodeType.equals(EncodeType.PNG) || encodeType.equals(EncodeType.COMPOUND)) {
                bl = false;
            }
        } else if (encodeType.equals(EncodeType.BYTE) || encodeType.equals(EncodeType.INT16) || encodeType.equals(EncodeType.INT24) || encodeType.equals(EncodeType.INT32)) {
            bl = false;
        }
        return bl;
    }

    protected static Geometry toManageGeometryBySource(long geometryHandle) {
        return Geometry.createInstance(geometryHandle);
    }

    protected static Dataset toManageDatasetBySource(Workspace workspace, long datasetHandle) {
        Datasource datasource = null;
        Dataset dataset = null;
        long l = DatasetNative.jni_GetDatasource(datasetHandle);
        if (l != 0L) {
            datasource = Datasource.createInstance(l, workspace);
        }
        if (datasource != null) {
            int n = DatasetNative.jni_GetType(datasetHandle);
            DatasetType datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, n);
            dataset = Dataset.createInstance(datasetHandle, datasetType, datasource);
        }
        return dataset;
    }

    protected static Dataset toManageDataset(Workspace workspace, long datasetHandle) {
        if (workspace == null || InternalHandle.getHandle(workspace) == 0L || datasetHandle == 0L) {
            return null;
        }
        long l = DatasetNative.jni_GetDatasource(datasetHandle);
        String string = null;
        if (l != 0L) {
            string = DatasourceNative.jni_GetAlias(l);
        }
        Datasource datasource = workspace.getDatasources().get(string);
        Dataset dataset = null;
        if (datasource != null) {
            dataset = Toolkit.a(datasource, datasetHandle);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return dataset;
    }

    private static Dataset a(Datasource datasource, long l) {
        if (datasource == null || InternalHandle.getHandle(datasource) == 0L || l == 0L) {
            return null;
        }
        int n = DatasetNative.jni_GetType(l);
        DatasetType datasetType = datasource.getDatasets().getJavaDatasetType(n);
        Dataset dataset = Dataset.createInstance(l, datasetType, datasource);
        return dataset;
    }

    protected static DatasetGroup toManageDatasetGroup(Workspace workspace, long datasetGroupHandle) {
        if (workspace == null || InternalHandle.getHandle(workspace) == 0L || datasetGroupHandle == 0L) {
            return null;
        }
        long l = DatasetGroupNative.jni_GetDatasource(datasetGroupHandle);
        String string = null;
        if (l != 0L) {
            string = DatasourceNative.jni_GetAlias(l);
        }
        Datasource datasource = workspace.getDatasources().get(string);
        DatasetGroup datasetGroup = null;
        if (datasource != null) {
            datasetGroup = Toolkit.toManageDatasetGroup(datasource, datasetGroupHandle);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return datasetGroup;
    }

    protected static DatasetGroup toManageDatasetGroup(Datasource datasource, long datasetGroupHandle) {
        if (datasource == null || InternalHandle.getHandle(datasource) == 0L || datasetGroupHandle == 0L) {
            return null;
        }
        DatasetGroup datasetGroup = datasource.getRootGroup();
        DatasetGroup datasetGroup2 = Toolkit.a(datasetGroup, datasetGroupHandle);
        return datasetGroup2;
    }

    private static DatasetGroup a(DatasetGroup datasetGroup, long l) {
        if (datasetGroup == null) {
            return null;
        }
        DatasetGroup datasetGroup2 = null;
        DatasetGroups datasetGroups = datasetGroup.getChildGroups();
        int n = datasetGroups.getCount();
        for (int i = 0; i < n; ++i) {
            DatasetGroup datasetGroup3 = datasetGroups.get(i);
            if (datasetGroup3 == null) continue;
            if (datasetGroup3.getHandle() == l) {
                return datasetGroup3;
            }
            datasetGroup2 = Toolkit.a(datasetGroup3, l);
            if (datasetGroup2 == null) continue;
            return datasetGroup2;
        }
        return datasetGroup2;
    }

    protected static boolean isDirectoryExisted(String fileName) {
        File file = new File(fileName);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyPictureToTempFile(String picturePath, String targetPath, String ... pictrueNames) {
        for (String string : pictrueNames) {
            String string2 = picturePath + string;
            URL uRL = Toolkit.class.getResource(string2);
            if (uRL == null) {
                System.out.println("null");
                return;
            }
            String string3 = System.getProperty("os.name");
            String string4 = "";
            string4 = "Windows".indexOf(string3) != -1 ? targetPath + string : targetPath + "/" + string;
            File file = new File(string4);
            InputStream inputStream = null;
            try (FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);){
                int n;
                inputStream = uRL.openStream();
                while ((n = inputStream.read()) != -1) {
                    fileImageOutputStream.write(n);
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("IO close Error:" + iOException.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyFileToTempFile(String srcPath, String targetPath, String ... fileNames) {
        for (String string : fileNames) {
            String string2 = srcPath + string;
            URL uRL = Class.class.getResource(string2);
            if (null == uRL) {
                return;
            }
            String string3 = targetPath + string;
            File file = new File(string3);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                 InputStream inputStream = uRL.openStream();
                 LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));){
                String string4;
                while ((string4 = lineNumberReader.readLine()) != null) {
                    fileOutputStream.write(string4.getBytes());
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
    }

    public static boolean isEscape(int action, boolean isCursorInMapcontrol) {
        return Toolkit.isEscape(action, isCursorInMapcontrol, true);
    }

    public static boolean isEscape(int action, boolean isCursorInMapcontrol, boolean isCancelMapDrawingByEscKey) {
        return ToolkitNative.jni_IsEscape(action, isCursorInMapcontrol, isCancelMapDrawingByEscKey) || Toolkit.isMouseWheelOrKeyPress(isCancelMapDrawingByEscKey);
    }

    public static boolean isMouseWheelOrKeyPress(boolean isCancelMapDrawingByEscKey) {
        EventQueue eventQueue = java.awt.Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (eventQueue != null) {
            SunToolkit.flushPendingEvents();
            return eventQueue.peekEvent(507) != null || isCancelMapDrawingByEscKey && eventQueue.peekEvent(401) != null || eventQueue.peekEvent(501) != null;
        }
        return false;
    }

    static void dumpExceptionCallBack(String msg) {
        if (msg != null && !msg.trim().equals("")) {
            throw new RuntimeException(msg);
        }
    }

    public static String ConvertDateTimeToString(Date dateValue, EngineType engineType) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(dateValue);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        return ToolkitNative.jni_ConvertDateTimeToString(n, n2, n3, n4, n5, n6, engineType.getUGCValue());
    }

    public static Date ConvertStringToDate(String strDateTime) {
        String string;
        Date date = null;
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        if (pattern.matcher(string = strDateTime).matches()) {
            String string2 = System.getProperty("os.name").toLowerCase();
            if (string2.equals("aix")) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    date = simpleDateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        date = simpleDateFormat.parse(string);
                    }
                    catch (ParseException parseException2) {}
                }
            } else {
                try {
                    date = DateFormat.getDateInstance().parse(string);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return date;
    }

    public static boolean CombineBand(String strName, Datasource datasource, Dataset RedDR, Dataset GreenDR, Dataset BlueDR) {
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(datasource);
        if (l == 0L) {
            String string = InternalResource.loadString("datasource", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (RedDR == null) {
            String string = InternalResource.loadString("RedDR", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandleDisposable.getHandle(RedDR);
        if (l2 == 0L) {
            String string = InternalResource.loadString("RedDR", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (GreenDR == null) {
            String string = InternalResource.loadString("GreenDR", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandleDisposable.getHandle(GreenDR);
        if (l3 == 0L) {
            String string = InternalResource.loadString("GreenDR", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (BlueDR == null) {
            String string = InternalResource.loadString("BlueDR", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l4 = InternalHandleDisposable.getHandle(BlueDR);
        if (l4 == 0L) {
            String string = InternalResource.loadString("BlueDR", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l5 = ToolkitNative.jni_CombineBand(strName, l, l2, l3, l4);
        if (l5 != 0L) {
            DatasetImage datasetImage = new DatasetImage(l5, datasource);
            if (datasetImage != null) {
                datasource.getDatasets().a(datasetImage);
            }
            return true;
        }
        return false;
    }

    public static String[] GetMongoDBNames(String strServer, String strAdminUser, String strAdminPwd) {
        String[] stringArray = null;
        stringArray = ToolkitNative.jni_GetMongoDBNames(strServer, strAdminUser, strAdminPwd);
        return stringArray;
    }

    public static boolean deleteDataSource(DatasourceConnectionInfo connectionInfo) {
        if (connectionInfo == null || connectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteDataSource(DatasourceConnectionInfo)", "Datasources_ConnectionInfoIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return ToolkitNative.jni_DeleteDataSource(connectionInfo.getHandle());
    }

    public static boolean deleteDatabase(String strServer, EngineType engineType, String strAdminDB, String strAdminUser, String strAdminPassword, String strDeleteDB) {
        return ToolkitNative.jni_DeleteDatabase(strServer, engineType.getUGCValue(), strAdminDB, strAdminUser, strAdminPassword, strDeleteDB);
    }

    public static String[] GetUserTable(Datasource datasource) {
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(datasource);
        if (l == 0L) {
            String string = InternalResource.loadString("datasource", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        stringArray = ToolkitNative.jni_GetUserTable(l);
        if (stringArray == null) {
            String string = InternalResource.loadString("GetUserTable", "Invalid_ArgumentValue", "data_resources");
            throw new RuntimeException(string);
        }
        return stringArray;
    }

    @Deprecated
    public static Geometry WKTToGemetry(String strWKT) {
        long l = ToolkitNative.jni_WKTToUGGemetry(strWKT);
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        geometry.setIsDisposable(true);
        return geometry;
    }

    public static Geometry WKTToGeometry(String strWKT) {
        long l = ToolkitNative.jni_WKTToUGGemetry(strWKT);
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        geometry.setIsDisposable(true);
        return geometry;
    }

    @Deprecated
    public static String GemetryToWKT(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = ToolkitNative.jni_UGGeometryToWKT(geometry.getHandle());
        return string;
    }

    public static String GeometryToWKT(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = ToolkitNative.jni_UGGeometryToWKT(geometry.getHandle());
        return string;
    }

    @Deprecated
    public static Geometry GeoJsonToGemetry(String strGeoJson) {
        long l = ToolkitNative.jni_GeoJsonToUGGeometry(strGeoJson);
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        geometry.setIsDisposable(true);
        return geometry;
    }

    public static Geometry GeoJsonToGeometry(String strGeoJson) {
        long l = ToolkitNative.jni_GeoJsonToUGGeometry(strGeoJson);
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        geometry.setIsDisposable(true);
        return geometry;
    }

    @Deprecated
    public static String GemetryToGeoJson(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = ToolkitNative.jni_UGGeometryToGeoJson(geometry.getHandle());
        return string;
    }

    public static String GeometryToGeoJson(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = ToolkitNative.jni_UGGeometryToGeoJson(geometry.getHandle());
        return string;
    }

    @Deprecated
    public static Geometry WKBToGemetry(byte[] value) {
        long l = ToolkitNative.jni_WKBToUGGemetry(value);
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        geometry.setIsDisposable(true);
        return geometry;
    }

    public static Geometry WKBToGeometry(byte[] value) {
        long l = ToolkitNative.jni_WKBToUGGemetry(value);
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        geometry.setIsDisposable(true);
        return geometry;
    }

    @Deprecated
    public static byte[] GemetryToWKB(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        byte[] byArray = ToolkitNative.jni_UGGeometryToWKB(geometry.getHandle());
        return byArray;
    }

    public static byte[] GeometryToWKB(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        byte[] byArray = ToolkitNative.jni_UGGeometryToWKB(geometry.getHandle());
        return byArray;
    }

    public static void SetIsUseCloudLicense(boolean value) {
        ToolkitNative.jni_SetIsUseCloudLicense(value);
    }

    public static void SetCloudLicenseText(String value) {
        ToolkitNative.jni_SetCloudLicenseText(value);
    }

    public static void setWatermarkMode(int value) {
        ToolkitNative.jni_SetWatermarkMode(value);
    }

    public static void setUserTrademark(String value) {
        ToolkitNative.jni_SetUserTrademark(value);
    }

    public static String FormatWKT(String wkt) {
        return ToolkitNative.jni_FormatWKT(wkt);
    }

    public static PrjCoordSys FromWKT(String str) {
        long l = ToolkitNative.jni_FromWKT(str);
        if (l == 0L) {
            return null;
        }
        return PrjCoordSys.createInstance(l, true);
    }

    public static String ToWKT(PrjCoordSys prjCoordSys) {
        if (prjCoordSys == null) {
            String string = InternalResource.loadString("PrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("PrjCoordSys", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return ToolkitNative.jni_ToWKT(prjCoordSys.getHandle());
    }

    public static boolean IdxTileSplitCell(DatasetVector datasetVector, int totalCount) {
        if (datasetVector == null) {
            String string = InternalResource.loadString("datasetVector", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return ToolkitNative.jni_IdxTileSplitCell(l, totalCount);
    }

    public static boolean isValidFieldName(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return false;
        }
        return ToolkitNative.jni_IsValidFieldName(fieldName);
    }

    public static boolean Grid2Image(Dataset dt) {
        if (dt == null) {
            String string = InternalResource.loadString("RedDR", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(dt);
        if (l == 0L) {
            String string = InternalResource.loadString("RedDR", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        dt.m_bTypeChanged = true;
        return ToolkitNative.jni_Grid2Image(l);
    }

    public static boolean Image2Grid(Dataset dt) {
        if (dt == null) {
            String string = InternalResource.loadString("RedDR", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(dt);
        if (l == 0L) {
            String string = InternalResource.loadString("RedDR", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        dt.m_bTypeChanged = true;
        return ToolkitNative.jni_Image2Grid(l);
    }

    public static DatasetGrid image2Grid(DatasetImage image) {
        if (image == null) {
            String string = InternalResource.loadString("image2Grid", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(image);
        if (l == 0L) {
            String string = InternalResource.loadString("image2Grid", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (image.getBandCount() > 1) {
            String string = InternalResource.loadString("image2Grid", "DatasetImage_ThisOperationIsAvailableForSingleBandsDataOnly", "data_resources");
            throw new RuntimeException(string);
        }
        if (image.getPixelFormat(0) == PixelFormat.RGB || image.getPixelFormat(0) == PixelFormat.RGBA) {
            String string = InternalResource.loadString("image2Grid", "DatasetGridInfo_UnSupportedPixelFormat", "data_resources");
            throw new RuntimeException(string);
        }
        DatasetGrid datasetGrid = (DatasetGrid)Dataset.createInstance(l, DatasetType.GRID, image.getDatasource());
        if (null != datasetGrid) {
            datasetGrid.m_datasetType = DatasetType.GRID;
            datasetGrid.setNeedDispose(false);
        }
        return datasetGrid;
    }

    public static String GetCachePath(Dataset dt) {
        if (dt == null) {
            String string = InternalResource.loadString("RedDR", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(dt);
        if (l == 0L) {
            String string = InternalResource.loadString("RedDR", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return ToolkitNative.jni_GetCachePath(l);
    }

    public static boolean geoMode3DsToKMZ(ArrayList<GeoModel3D> listGeo, String kmlFullPath) {
        boolean bl = false;
        if (listGeo == null) {
            String string = InternalResource.loadString("listGeo", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (kmlFullPath == null || kmlFullPath.isEmpty()) {
            String string = InternalResource.loadString("kmlFullPath", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(kmlFullPath);
        if (!file.isFile()) {
            String string = InternalResource.loadString("kmlFullPath", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[listGeo.size()];
        for (int i = 0; i < listGeo.size(); ++i) {
            lArray[i] = InternalHandle.getHandle(listGeo.get(i));
        }
        bl = ToolkitNative.jni_GeoMode3DsToKMZ(lArray, kmlFullPath);
        return bl;
    }

    public static boolean convertDatasetCAD2Model(DatasetVector datasetVectorCAD, Datasource datasourceDes, String name) {
        if (datasetVectorCAD == null) {
            String string = InternalResource.loadString("datasetVectorCAD", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(datasetVectorCAD);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetVectorCAD", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasourceDes == null) {
            String string = InternalResource.loadString("datasourceDes", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(datasourceDes);
        if (l2 == 0L) {
            String string = InternalResource.loadString("datasourceDes", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        DatasetVector.m_senderMethodName = "convertDatasetCAD2Model";
        datasetVectorCAD.m_selfEventHandle = DatasetNative.jni_NewSelfEventHandle(datasetVectorCAD);
        long l3 = ToolkitNative.jni_ConvertDatasetCAD2Model(l, l2, name, datasetVectorCAD.m_selfEventHandle);
        datasetVectorCAD.clearSelfEventHandle();
        if (l3 != 0L) {
            datasourceDes.getDatasets().a(new DatasetVector(l3, datasourceDes));
            bl = true;
        }
        return bl;
    }

    public static byte[] encodeStream(byte[] stream, String pwd) {
        if (pwd == null || pwd.trim().length() == 0) {
            String string = InternalResource.loadString("password", "Global_StringIsNullOrEmpty", "data_resources");
            throw new NullPointerException(string);
        }
        return ToolkitNative.jni_AddRandomStream(stream, pwd);
    }

    public static byte[] decodeStream(byte[] stream, String pwd) {
        if (pwd == null || pwd.trim().length() == 0) {
            String string = InternalResource.loadString("password", "Global_StringIsNullOrEmpty", "data_resources");
            throw new NullPointerException(string);
        }
        return ToolkitNative.jni_AddRandomStream(stream, pwd);
    }

    public static void setDtNameAsTableName(boolean value) {
        ToolkitNative.jni_SetDtNameAsTableName(value);
    }

    public static boolean getDtNameAsTableName() {
        return ToolkitNative.jni_GetDtNameAsTableName();
    }

    public static void setDSAutoVacuum(boolean value) {
        ToolkitNative.jni_SetDSAutoVacuum(value);
    }

    public static boolean getDSAutoVacuum() {
        return ToolkitNative.jni_GetDSAutoVacuum();
    }

    public static void setCalcAreaLength(boolean value) {
        ToolkitNative.jni_SetCalcAreaLength(value);
    }

    public static boolean getCalcAreaLength() {
        return ToolkitNative.jni_GetCalcAreaLength();
    }

    public static boolean vectorReSample(Dataset dataset, QueryParameter queryParameter, Datasource datasource, String[] datasetNames, double[] resolutions, boolean value) {
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = dataset.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (queryParameter == null) {
            String string = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = queryParameter.getHandle();
        if (l2 == 0L) {
            String string = InternalResource.loadString("queryParameter", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            datasource = dataset.getDatasource();
        }
        long l3 = datasource.getHandle();
        return ToolkitNative.jni_VectorReSample(l, l2, l3, datasetNames, resolutions, value);
    }

    public static byte[] extractAttributeValue(String attributeFile, ArrayList<FieldDefine> fieldDefine, String[] fieldsName, String pwd) {
        if (attributeFile == null || attributeFile.length() == 0 || fieldsName == null || fieldsName.length == 0 || fieldDefine == null || fieldDefine.size() == 0) {
            return null;
        }
        String[] stringArray = new String[fieldDefine.size()];
        int[] nArray = new int[fieldDefine.size()];
        boolean[] blArray = new boolean[fieldDefine.size()];
        int[] nArray2 = new int[fieldDefine.size()];
        for (int i = 0; i < fieldDefine.size(); ++i) {
            stringArray[i] = fieldDefine.get(i).getFieldName();
            nArray[i] = fieldDefine.get(i).getFieldLength();
            blArray[i] = fieldDefine.get(i).isRequires();
            nArray2[i] = fieldDefine.get(i).getFieldType().value();
        }
        return ToolkitNative.jni_ExtractSelectedAttribute(attributeFile, stringArray, nArray2, nArray, blArray, fieldsName, pwd);
    }

    public static String[] getExtendAttributeList(EngineType engineType) {
        return ToolkitNative.jni_GetExAttributeList(engineType.value());
    }

    public static boolean isPathExists(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        return ToolkitNative.jni_IsPathExists(path);
    }

    @Deprecated
    public static void SetiServerProducts(ArrayList<ProductType> pros) {
        h.clear();
        for (ProductType productType : pros) {
            h.add(com.supermap.ProductType.newInstance(productType.getUGCValue()));
        }
    }

    @Deprecated
    public static ArrayList<ProductType> GetiServerProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        for (com.supermap.ProductType productType : h) {
            arrayList.add(ProductType.newInstance(productType.getUGCValue()));
        }
        return arrayList;
    }

    @Deprecated
    public static void SetSpecifiedProducts(ArrayList<ProductType> pros) {
        j.clear();
        for (ProductType productType : pros) {
            j.add(com.supermap.ProductType.newInstance(productType.getUGCValue()));
        }
    }

    @Deprecated
    public static ArrayList<ProductType> GetSpecifiedProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        for (com.supermap.ProductType productType : j) {
            arrayList.add(ProductType.newInstance(productType.getUGCValue()));
        }
        return arrayList;
    }

    @Deprecated
    public static ArrayList<ProductType> getTrialProducts() {
        return null;
    }

    static {
        Environment.LoadWrapJ();
        d = true;
        e = true;
        f = true;
        g = 2;
        h = new ArrayList();
        i = new ArrayList();
        j = new ArrayList();
        License.setUGOBasePath(Environment.getUGOBasePath());
        Toolkit.getUpperProductsSetLicensesFromEnv(b);
        Toolkit.getUpperProductsSetLicensesFromEnv(c);
    }
}

