/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.TextureDataNative;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class TextureData
extends InternalHandleDisposable {
    private String a = "";
    private boolean b = false;

    protected TextureData(long srchandle) {
        if (srchandle != 0L) {
            long l = TextureDataNative.jni_New2(srchandle);
            this.setHandle(l, true);
        }
    }

    public TextureData() {
        long l = TextureDataNative.jni_New();
        this.setHandle(l, true);
    }

    public TextureData(boolean isExternal) {
        this.b = isExternal;
        if (!isExternal) {
            long l = TextureDataNative.jni_New();
            this.setHandle(l, true);
        } else {
            this.setHandle(0L, true);
        }
    }

    protected void setExternal(boolean value) {
        this.b = value;
    }

    public boolean isExternal() {
        return this.b;
    }

    public TextureData(String name) {
        long l = TextureDataNative.jni_New();
        TextureDataNative.jni_setName(l, name);
        this.setHandle(l, true);
    }

    @Override
    public void dispose() {
        if (this.getHandle() != 0L) {
            TextureDataNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public boolean fromFile(String filepath) {
        if (this.getHandle() == 0L) {
            return false;
        }
        return TextureDataNative.jni_FromFile(this.getHandle(), filepath);
    }

    public boolean fromStream(String fileExt, byte[] stream) {
        if (this.getHandle() == 0L) {
            return false;
        }
        return TextureDataNative.jni_FromStream(this.getHandle(), fileExt, stream);
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            this.a = value;
        } else {
            TextureDataNative.jni_setName(this.getHandle(), value);
        }
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            return this.a;
        }
        return TextureDataNative.jni_getName(this.getHandle());
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            return 0;
        }
        return TextureDataNative.jni_GetWidth(this.getHandle());
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            return 0;
        }
        return TextureDataNative.jni_GetHeight(this.getHandle());
    }

    public void setData(BufferedImage value) {
        if (this.getHandle() == 0L) {
            long l = TextureDataNative.jni_New();
            this.setHandle(l, true);
            this.setName(this.a);
            this.a = "";
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = value.getWidth();
        int n2 = value.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = value.getRGB(j, i);
            }
        }
        TextureDataNative.jni_SetData(this.getHandle(), nArray, n, n2);
    }

    public BufferedImage getData() {
        if (this.getHandle() == 0L) {
            return null;
        }
        int[] nArray = new int[3];
        byte[] byArray = TextureDataNative.jni_GetData(this.getHandle(), nArray);
        BufferedImage bufferedImage = null;
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        BufferedImage bufferedImage2 = null;
        if (byArray != null && n > 0 && n2 > 0) {
            bufferedImage = n3 == 3 ? new BufferedImage(n, n2, 1) : new BufferedImage(n, n2, 2);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n4;
                    int n5;
                    int n6;
                    int n7 = 0;
                    int n8 = i * n * n3 + j * n3;
                    if (n3 == 3) {
                        n6 = byArray[n8 + 2] & 0xFF;
                        n5 = byArray[n8 + 1] & 0xFF;
                        n4 = byArray[n8] & 0xFF;
                        Color color = new Color(n6, n5, n4, 255);
                        n7 = color.getRGB();
                    } else {
                        n6 = byArray[n8 + 3] & 0xFF;
                        n5 = byArray[n8 + 2] & 0xFF;
                        n4 = byArray[n8 + 1] & 0xFF;
                        int n9 = byArray[n8] & 0xFF;
                        Color color = new Color(n5, n4, n9, n6);
                        n7 = color.getRGB();
                    }
                    bufferedImage.setRGB(j, i, n7);
                }
            }
            bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getColorModel().getTransparency());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, n, n2, 0, 0, n, 0, 0, n2, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    protected static TextureData internalCreateInstance(long handle) {
        return new TextureData(handle);
    }
}

