/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolGroupNative;
import com.supermap.data.SymbolGroups;
import com.supermap.data.SymbolLibrary;
import java.util.ArrayList;

public class SymbolGroup
extends InternalHandleDisposable {
    private SymbolLibrary a;
    private SymbolGroup b;
    private SymbolGroups c;
    private ArrayList d;

    SymbolGroup(SymbolLibrary symbolLibrary, long handle) {
        this.a = symbolLibrary;
        this.setHandle(handle, false);
        this.d = new ArrayList();
        this.reset();
        InternalHandleDisposable.makeSureNativeObjectLive(symbolLibrary);
    }

    SymbolGroup(long handle, SymbolGroup symbolGroup) {
        this.a = symbolGroup.b();
        this.setHandle(handle, false);
        this.a(symbolGroup);
        this.d = new ArrayList();
        this.reset();
        InternalHandleDisposable.makeSureNativeObjectLive(symbolGroup);
    }

    public SymbolGroup getParent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParent()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.b;
    }

    public SymbolGroups getChildGroups() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChildGroups()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.c == null) {
            this.c = new SymbolGroups(this);
        }
        return this.c;
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolGroupNative.jni_GetName(this.getHandle());
    }

    public void setName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getParent() != null && this.getParent().getChildGroups().contains(name)) {
            String string = InternalResource.loadString("value", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolGroupNative.jni_SetName(this.getHandle(), name);
    }

    public Symbol get(int index) {
        Symbol symbol = null;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index >= 0 && index < this.d.size()) {
            symbol = (Symbol)this.d.get(index);
        }
        return symbol;
    }

    public SymbolLibrary getLibrary() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolGroupNative.jni_GetCount(this.getHandle());
    }

    public int indexOf(int id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolGroupNative.jni_IndexOf(this.getHandle(), id);
    }

    protected boolean moveTo(int index, SymbolGroup group) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveTo(int index, SymbolGroup group)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (group == null) {
            String string = InternalResource.loadString("group", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(group);
        if (l == 0L) {
            String string = InternalResource.loadString("group", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = SymbolGroupNative.jni_moveTo(this.getHandle(), index, l);
        if (bl) {
            group.a().add(this.get(index));
            this.get(index).setGroup(group);
            this.a().remove(index);
        }
        group.makeSureNativeObjectLive();
        return bl;
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
    }

    @Override
    protected void clearHandle() {
        this.a = null;
        this.a = null;
        this.b = null;
        if (this.c != null) {
            this.c.clearHandle();
            this.c = null;
        }
        if (this.d != null) {
            for (int i = 0; i < this.d.size(); ++i) {
                ((Symbol)this.d.get(i)).clearHandle();
            }
            this.d.clear();
            this.d = null;
        }
        this.setHandle(0L);
    }

    void a(SymbolGroup symbolGroup) {
        this.b = symbolGroup;
    }

    public void reset() {
        int n;
        for (n = 0; n < this.d.size(); ++n) {
            ((Symbol)this.d.get(n)).clearHandle();
        }
        this.d.clear();
        n = this.getCount();
        if (n > 0) {
            long[] lArray = new long[n];
            SymbolGroupNative.jni_GetSymbols(this.getHandle(), lArray);
            for (int i = 0; i < n; ++i) {
                Symbol symbol = Symbol.createInstance(lArray[i]);
                if (symbol == null) continue;
                symbol.setIsDisposable(false);
                symbol.a(this.a);
                symbol.setGroup(this);
                this.d.add(symbol);
            }
        }
        if (this.c != null) {
            this.c.a();
        }
    }

    ArrayList a() {
        return this.d;
    }

    SymbolLibrary b() {
        return this.a;
    }

    boolean a(int n) {
        int n2 = this.indexOf(n);
        boolean bl = false;
        if (n2 != -1) {
            this.a().remove(n2);
            bl = SymbolGroupNative.jni_RemoveByID(this.getHandle(), n);
        } else {
            for (int i = 0; i < this.getChildGroups().getCount(); ++i) {
                if (bl) {
                    this.c.get(i).a(n);
                    continue;
                }
                bl = this.c.get(i).a(n);
            }
        }
        return bl;
    }

    SymbolGroup b(int n) {
        SymbolGroup symbolGroup = null;
        if (this.indexOf(n) != -1) {
            return this;
        }
        for (int i = 0; i < this.getChildGroups().getCount(); ++i) {
            symbolGroup = this.getChildGroups().get(i).b(n);
            if (symbolGroup == null) continue;
            return symbolGroup;
        }
        return symbolGroup;
    }

    Symbol c(int n) {
        int n2;
        Symbol symbol = null;
        for (n2 = 0; n2 < this.getCount(); ++n2) {
            symbol = this.get(n2);
            if (symbol == null || symbol.getID() != n) continue;
            return symbol;
        }
        for (n2 = 0; n2 < this.getChildGroups().getCount(); ++n2) {
            symbol = this.getChildGroups().get(n2).c(n);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    Symbol a(String string) {
        int n;
        Symbol symbol = null;
        for (n = 0; n < this.getCount(); ++n) {
            symbol = this.get(n);
            if (symbol == null || !symbol.getName().equals(string)) continue;
            return symbol;
        }
        for (n = 0; n < this.getChildGroups().getCount(); ++n) {
            symbol = this.getChildGroups().get(n).a(string);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }
}

