/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalBufferImage;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolFillBase;
import com.supermap.data.SymbolFillLibrary;
import com.supermap.data.SymbolFillNative;
import com.supermap.data.SymbolLibrary;
import com.supermap.data.SymbolType;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class SymbolFill
extends Symbol {
    private ArrayList<SymbolFillBase> a;

    public SymbolFill() {
        this.setHandle(SymbolFillNative.jni_New(), true);
        this.a(null);
        this.a = new ArrayList();
    }

    public SymbolFill(SymbolFill symbolFill) {
        if (symbolFill.getHandle() == 0L) {
            String string = InternalResource.loadString("SymbolFill", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = SymbolFillNative.jni_Clone(symbolFill.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(symbolFill);
        this.a(l);
    }

    SymbolFill(long handle) {
        this.setHandle(handle, false);
        this.a(handle);
    }

    private void a(long l) {
        if (this.a != null) {
            this.clearFillBaseList();
        } else {
            this.a = new ArrayList();
        }
        int n = SymbolFillNative.jni_GetCount(l);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                long l2 = SymbolFillNative.jni_Get(l, i);
                SymbolFillBase symbolFillBase = new SymbolFillBase(l2);
                this.a.add(symbolFillBase);
            }
        }
    }

    @Override
    public boolean draw(Graphics graphics, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        GeometryType geometryType = geometry.getType();
        if (geometryType.equals(GeometryType.GEOREGION) || geometryType.equals(GeometryType.GEOPIE) || geometryType.equals(GeometryType.GEOROUNDRECTANGLE) || geometryType.equals(GeometryType.GEOCIRCLE) || geometryType.equals(GeometryType.GEOELLIPSE) || geometryType.equals(GeometryType.GEORECTANGLE)) {
            InternalBufferImage internalBufferImage;
            Rectangle2D rectangle2D = geometry.getBounds();
            try {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            geometry.offset(-rectangle2D.getLeft(), -rectangle2D.getBottom());
            SymbolLibrary symbolLibrary = this.getLibrary();
            long l2 = 0L;
            if (symbolLibrary != null) {
                l2 = symbolLibrary.getHandle();
            }
            if (bl = SymbolFillNative.jni_Draw(this.getHandle(), internalBufferImage.getHandle(), geometry.getHandle(), l2)) {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft(), (int)rectangle2D.getBottom(), null);
            }
            if (symbolLibrary != null) {
                symbolLibrary.makeSureNativeObjectLive();
            }
            internalBufferImage.makeSureNativeObjectLive();
        }
        geometry.makeSureNativeObjectLive();
        return bl;
    }

    @Override
    public boolean draw(BufferedImage image, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.draw(image.getGraphics(), geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    @Override
    public boolean draw(Graphics graphics, Point2Ds points, GeoStyle style) {
        InternalBufferImage internalBufferImage;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString(" draw(Graphics graphics, Point2Ds points, GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion geoRegion = new GeoRegion(points);
        Rectangle2D rectangle2D = geoRegion.getBounds();
        boolean bl = false;
        try {
            internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        geoRegion.offset(-rectangle2D.getLeft(), -rectangle2D.getBottom());
        Point2Ds point2Ds = geoRegion.getPart(0);
        int n = point2Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        SymbolLibrary symbolLibrary = this.getLibrary();
        long l = 0L;
        if (symbolLibrary != null) {
            l = symbolLibrary.getHandle();
        }
        if (bl = style == null ? SymbolFillNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), dArray, dArray2, 0L, l) : SymbolFillNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), dArray, dArray2, style.getHandle(), l)) {
            graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft(), (int)rectangle2D.getBottom(), null);
        }
        if (symbolLibrary != null) {
            symbolLibrary.makeSureNativeObjectLive();
        }
        internalBufferImage.makeSureNativeObjectLive();
        if (style != null) {
            style.makeSureNativeObjectLive();
        }
        return bl;
    }

    @Override
    public boolean draw(BufferedImage image, Point2Ds points, GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Point2Ds points, GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.draw(image.getGraphics(), points, style);
        InternalHandleDisposable.makeSureNativeObjectLive(style);
        return bl;
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolFillNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public SymbolType getType() {
        return SymbolType.FILL;
    }

    public boolean saveTilingImage(String filename, SymbolFillLibrary library, int index, Color front, Color back) {
        if (this.getHandle() == 0L || library == null || library.getHandle() == 0L) {
            String string = InternalResource.loadString("saveTilingImage()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolFillNative.jni_SaveTilingImage(this.getHandle(), filename, library.getHandle(), index, front.getRGB(), back.getRGB());
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolFillNative.jni_GetCount(this.getHandle());
    }

    public int add(SymbolFillBase fillBase) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(SymbolFillBase fillBase)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fillBase == null || fillBase.getHandle() == 0L) {
            String string = InternalResource.loadString("fillBase", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = SymbolFillNative.jni_Add(this.getHandle(), fillBase.getHandle());
        if (l != 0L) {
            SymbolFillBase symbolFillBase = new SymbolFillBase(l);
            this.a.add(symbolFillBase);
            return this.getCount() - 1;
        }
        return -1;
    }

    public boolean insert(int index, SymbolFillBase fillBase) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, SymbolFillBase fillBase", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (fillBase == null || fillBase.getHandle() == 0L) {
            String string = InternalResource.loadString("fillBase", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = SymbolFillNative.jni_Insert(this.getHandle(), index, fillBase.getHandle());
        if (l != 0L) {
            SymbolFillBase symbolFillBase = new SymbolFillBase(l);
            this.a.add(index, symbolFillBase);
            return true;
        }
        return false;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a.get(index).clearHandle();
        this.a.remove(index);
        return SymbolFillNative.jni_Remove(this.getHandle(), index);
    }

    public SymbolFillBase getItem(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.a.get(index);
    }

    protected void clearFillBaseList() {
        for (int i = 0; i < this.a.size(); ++i) {
            SymbolFillBase symbolFillBase = this.a.get(i);
            symbolFillBase.clearHandle();
        }
        this.a.clear();
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.clearFillBaseList();
        }
        super.clearHandle();
    }

    public static SymbolFill createSolidSymbolFill(Color color) {
        long l = SymbolFillNative.jni_CreateSolidSymbolFill(color.getRGB());
        if (l != 0L) {
            SymbolFill symbolFill = new SymbolFill(l);
            return symbolFill;
        }
        return null;
    }

    public boolean isSolidFill() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(SymbolFillBase fillBase)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = SymbolFillNative.jni_IsSolid(this.getHandle());
        return bl;
    }

    public Color getSolidColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(SymbolFillBase fillBase)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isSolidFill()) {
            int n = SymbolFillNative.jni_GetSolidColor(this.getHandle());
            Color color = new Color(n, true);
            return color;
        }
        return null;
    }

    public void setSolidColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(SymbolFillBase fillBase)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isSolidFill()) {
            SymbolFillNative.jni_SetSolidColor(this.getHandle(), color.getRGB());
        }
    }
}

