/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.MosaicToolkit;
import com.supermap.data.PyramidResampleType;
import com.supermap.data.TiffCompressType;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.Paths;

public class MosaicRebuildPyramidMain {
    public static void main(String[] args) {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        System.out.print("MosaicRebuildPyramidMain process id is: ");
        System.out.println(Integer.parseInt(runtimeMXBean.getName().split("@")[0]));
        if (args.length < 3) {
            System.out.println("MosaicRebuildPyramidMain args length less than 3");
            return;
        }
        String string = args[0];
        String string2 = args[1];
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            System.out.println("args[1] must be resample type, 0(NONE), 1(NEAREST), 2(AVERAGE), 3(BILINEAR)");
            return;
        }
        String string3 = args[2];
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (Throwable throwable) {
            System.out.println("args[2] must be compression type, 0(NONE), 1(LZW), 2(JPEG), 3(DEFLATE)");
            return;
        }
        try {
            Files.deleteIfExists(Paths.get(string + ".ovr", new String[0]));
        }
        catch (IOException iOException) {
            System.out.println(string + " ovr file delete failed.");
        }
        boolean bl = MosaicToolkit.forceRebuildPyramid(string, new PyramidResampleType(n, n), new TiffCompressType(n2, n2));
        if (!bl) {
            System.out.println(string + " rebuild pyramid failure");
        }
    }
}

