/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.MatrixNative;
import com.supermap.data.Point3D;

public class Matrix
extends InternalHandleDisposable {
    public Matrix() {
        long l = MatrixNative.jni_New();
        this.setHandle(l, true);
    }

    protected Matrix(long handle) {
        long l = MatrixNative.jni_New2(handle);
        this.setHandle(l, true);
    }

    public double[] getArrayValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Matrix", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[16];
        MatrixNative.jni_GetArrayValue(this.getHandle(), dArray);
        return dArray;
    }

    public void setArrayValue(double[] matrix) {
        if (matrix.length == 16) {
            MatrixNative.jni_SetArrayValue(this.getHandle(), matrix);
        }
    }

    public Matrix multipy(Matrix mat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Matrix", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (mat == null) {
            String string = InternalResource.loadString("mat", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = MatrixNative.jni_Multipy(this.getHandle(), mat.getHandle());
        return new Matrix(l);
    }

    public static Point3D multiply(Point3D pnt, Matrix mat) {
        if (pnt == null) {
            String string = InternalResource.loadString("pnt", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (mat == null) {
            String string = InternalResource.loadString("mat", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        MatrixNative.jni_Multipy2(pnt.getX(), pnt.getY(), pnt.getZ(), mat.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public boolean toAnglesXYZ(double[] anglesXYZ) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Matrix", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (anglesXYZ == null) {
            String string = InternalResource.loadString("anglesXYZ", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (anglesXYZ.length != 3) {
            String string = InternalResource.loadString("anglesXYZ", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalStateException(string);
        }
        return MatrixNative.jni_ToAnglesXYZ(this.getHandle(), anglesXYZ);
    }

    public boolean toAnglesXZY(double[] anglesXYZ) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Matrix", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (anglesXYZ == null) {
            String string = InternalResource.loadString("anglesXYZ", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (anglesXYZ.length != 3) {
            String string = InternalResource.loadString("anglesXYZ", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalStateException(string);
        }
        return MatrixNative.jni_ToAnglesXZY(this.getHandle(), anglesXYZ);
    }

    public boolean toAnglesYXZ(double[] anglesXYZ) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Matrix", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (anglesXYZ == null) {
            String string = InternalResource.loadString("anglesXYZ", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (anglesXYZ.length != 3) {
            String string = InternalResource.loadString("anglesXYZ", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalStateException(string);
        }
        return MatrixNative.jni_ToAnglesYXZ(this.getHandle(), anglesXYZ);
    }

    public boolean toAnglesYZX(double[] anglesXYZ) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Matrix", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (anglesXYZ == null) {
            String string = InternalResource.loadString("anglesXYZ", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (anglesXYZ.length != 3) {
            String string = InternalResource.loadString("anglesXYZ", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalStateException(string);
        }
        return MatrixNative.jni_ToAnglesYZX(this.getHandle(), anglesXYZ);
    }

    public boolean toAnglesZXY(double[] anglesXYZ) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Matrix", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (anglesXYZ == null) {
            String string = InternalResource.loadString("anglesXYZ", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (anglesXYZ.length != 3) {
            String string = InternalResource.loadString("anglesXYZ", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalStateException(string);
        }
        return MatrixNative.jni_ToAnglesZXY(this.getHandle(), anglesXYZ);
    }

    public boolean toAnglesZYX(double[] anglesXYZ) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Matrix", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (anglesXYZ == null) {
            String string = InternalResource.loadString("anglesXYZ", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (anglesXYZ.length != 3) {
            String string = InternalResource.loadString("anglesXYZ", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalStateException(string);
        }
        return MatrixNative.jni_ToAnglesZYX(this.getHandle(), anglesXYZ);
    }

    public static Matrix translate(double x, double y, double z) {
        long l = MatrixNative.jni_Translate(x, y, z);
        return new Matrix(l);
    }

    public static Matrix scale(double x, double y, double z) {
        long l = MatrixNative.jni_Scale(x, y, z);
        return new Matrix(l);
    }

    public static Matrix rotateXYZ(double rotationX, double rotationY, double rotationZ) {
        long l = MatrixNative.jni_RotateXYZ(rotationX, rotationY, rotationZ);
        return new Matrix(l);
    }

    public static Matrix rotateX(double angle) {
        long l = MatrixNative.jni_RotateX(angle);
        return new Matrix(l);
    }

    public static Matrix rotateY(double angle) {
        long l = MatrixNative.jni_RotateY(angle);
        return new Matrix(l);
    }

    public static Matrix rotateZ(double angle) {
        long l = MatrixNative.jni_RotateZ(angle);
        return new Matrix(l);
    }

    public Matrix invert() {
        long l = MatrixNative.jni_Invert(this.getHandle());
        return new Matrix(l);
    }

    public Matrix transpose() {
        long l = MatrixNative.jni_Transpose(this.getHandle());
        return new Matrix(l);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("Matrix", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MatrixNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

