/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.LayoutAddedEvent;
import com.supermap.data.LayoutAddedListener;
import com.supermap.data.LayoutClearedEvent;
import com.supermap.data.LayoutClearedListener;
import com.supermap.data.LayoutClearingEvent;
import com.supermap.data.LayoutClearingListener;
import com.supermap.data.LayoutRemovedEvent;
import com.supermap.data.LayoutRemovedListener;
import com.supermap.data.LayoutRemovingEvent;
import com.supermap.data.LayoutRemovingListener;
import com.supermap.data.LayoutRenamedEvent;
import com.supermap.data.LayoutRenamedListener;
import com.supermap.data.LayoutRenamingEvent;
import com.supermap.data.LayoutRenamingListener;
import com.supermap.data.LayoutsNative;
import com.supermap.data.Workspace;
import java.util.concurrent.CopyOnWriteArrayList;

public class Layouts {
    private Workspace h;
    transient CopyOnWriteArrayList<LayoutRenamingListener> a;
    transient CopyOnWriteArrayList<LayoutRenamedListener> b;
    transient CopyOnWriteArrayList<LayoutRemovingListener> c;
    transient CopyOnWriteArrayList<LayoutRemovedListener> d;
    transient CopyOnWriteArrayList<LayoutAddedListener> e;
    transient CopyOnWriteArrayList<LayoutClearingListener> f;
    transient CopyOnWriteArrayList<LayoutClearedListener> g;

    Layouts(Workspace workspace) {
        this.h = workspace;
    }

    public int getCount() {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return LayoutsNative.jni_GetCount(this.h.getHandle());
    }

    public String get(int index) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return LayoutsNative.jni_GetItem(this.h.getHandle(), index);
    }

    public int add(String name, String xml) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Layouts_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        n = LayoutsNative.jni_Add(this.h.getHandle(), name, xml);
        if (n > -1) {
            LayoutAddedEvent layoutAddedEvent = new LayoutAddedEvent(this, name);
            this.fireAdded(layoutAddedEvent);
        }
        return n;
    }

    public boolean insert(int index, String name, String xml) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Layouts_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return LayoutsNative.jni_Insert(this.h.getHandle(), index, name, xml);
    }

    public boolean setLayoutXML(int index, String xml) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (xml == null) {
            xml = "";
        }
        return LayoutsNative.jni_SetLayoutXML(this.h.getHandle(), index, xml);
    }

    public boolean setLayoutXML(String name, String xml) {
        int n;
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if ((n = this.indexOf(name)) == -1) {
            String string = InternalResource.loadString("name", "Layouts_NameIsNotInLayouts", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.setLayoutXML(n, xml);
    }

    public String getLayoutXML(int index) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return LayoutsNative.jni_GetLayoutXML(this.h.getHandle(), index);
    }

    public String getLayoutXML(String name) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.indexOf(name);
        if (n == -1) {
            String string = InternalResource.loadString("name", "Layouts_NameIsNotInLayouts", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return LayoutsNative.jni_GetLayoutXML(this.h.getHandle(), n);
    }

    public boolean remove(int index) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = this.get(index);
        LayoutRemovingEvent layoutRemovingEvent = new LayoutRemovingEvent(this, string);
        this.fireRemoving(layoutRemovingEvent);
        if (layoutRemovingEvent.isCancel()) {
            return false;
        }
        boolean bl = false;
        bl = LayoutsNative.jni_Remove(this.h.getHandle(), index);
        if (bl) {
            LayoutRemovedEvent layoutRemovedEvent = new LayoutRemovedEvent(this, string);
            this.fireRemoved(layoutRemovedEvent);
        }
        return bl;
    }

    public boolean remove(String name) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = this.indexOf(name);
        if (n != -1) {
            bl = this.remove(n);
        }
        return bl;
    }

    public void clear() {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        LayoutClearingEvent layoutClearingEvent = new LayoutClearingEvent(this);
        this.fireClearing(layoutClearingEvent);
        if (layoutClearingEvent.isCancel()) {
            return;
        }
        int n = this.getCount();
        LayoutsNative.jni_Clear(this.h.getHandle());
        LayoutClearedEvent layoutClearedEvent = new LayoutClearedEvent(this, n);
        this.fireCleared(layoutClearedEvent);
    }

    public int indexOf(String name) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            n = LayoutsNative.jni_IndexOf(this.h.getHandle(), name);
        }
        return n;
    }

    public String getAvailableLayoutName(String name) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        return LayoutsNative.jni_GetUnoccupiedLayoutName(this.h.getHandle(), name);
    }

    public boolean rename(String oldName, String newName) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (oldName == null || oldName.trim().length() == 0) {
            String string = InternalResource.loadString("oldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName == null || newName.trim().length() == 0) {
            String string = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(oldName) == -1) {
            String string = InternalResource.loadString("oldName", "Layouts_NameIsNotInLayouts", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName.equalsIgnoreCase(oldName)) {
            return false;
        }
        if (this.indexOf(newName) >= 0) {
            String string = InternalResource.loadString("newName", "Layouts_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        LayoutRenamingEvent layoutRenamingEvent = new LayoutRenamingEvent(this, oldName, newName);
        this.fireRenaming(layoutRenamingEvent);
        if (layoutRenamingEvent.isCancel()) {
            return false;
        }
        boolean bl = false;
        bl = LayoutsNative.jni_Rename(this.h.getHandle(), oldName, newName);
        if (bl) {
            LayoutRenamedEvent layoutRenamedEvent = new LayoutRenamedEvent(this, oldName, newName);
            this.fireRenamed(layoutRenamedEvent);
        }
        return bl;
    }

    protected void clearHandle() {
        this.h = null;
    }

    public synchronized void addRenamingListener(LayoutRenamingListener l) {
        if (this.a == null) {
            this.a = new CopyOnWriteArrayList();
        }
        if (!this.a.contains(l)) {
            this.a.add(l);
        }
    }

    public void removeRenamingListener(LayoutRenamingListener l) {
        if (this.a != null && this.a.contains(l)) {
            this.a.remove(l);
        }
    }

    protected void fireRenaming(LayoutRenamingEvent event) {
        if (this.a != null) {
            CopyOnWriteArrayList<LayoutRenamingListener> copyOnWriteArrayList = this.a;
            for (LayoutRenamingListener layoutRenamingListener : copyOnWriteArrayList) {
                layoutRenamingListener.layoutRenaming(event);
            }
        }
    }

    public synchronized void addRenamedListener(LayoutRenamedListener l) {
        if (this.b == null) {
            this.b = new CopyOnWriteArrayList();
        }
        if (!this.b.contains(l)) {
            this.b.add(l);
        }
    }

    public void removeRenamedListener(LayoutRenamedListener l) {
        if (this.b != null && this.b.contains(l)) {
            this.b.remove(l);
        }
    }

    protected void fireRenamed(LayoutRenamedEvent event) {
        if (this.b != null) {
            CopyOnWriteArrayList<LayoutRenamedListener> copyOnWriteArrayList = this.b;
            for (LayoutRenamedListener layoutRenamedListener : copyOnWriteArrayList) {
                layoutRenamedListener.layoutRenamed(event);
            }
        }
    }

    public synchronized void addRemovingListener(LayoutRemovingListener l) {
        if (this.c == null) {
            this.c = new CopyOnWriteArrayList();
        }
        if (!this.c.contains(l)) {
            this.c.add(l);
        }
    }

    public void removeRemovingListener(LayoutRemovingListener l) {
        if (this.c != null && this.c.contains(l)) {
            this.c.remove(l);
        }
    }

    protected void fireRemoving(LayoutRemovingEvent event) {
        if (this.c != null) {
            CopyOnWriteArrayList<LayoutRemovingListener> copyOnWriteArrayList = this.c;
            for (LayoutRemovingListener layoutRemovingListener : copyOnWriteArrayList) {
                layoutRemovingListener.layoutRemoving(event);
            }
        }
    }

    public synchronized void addRemovedListener(LayoutRemovedListener l) {
        if (this.d == null) {
            this.d = new CopyOnWriteArrayList();
        }
        if (!this.d.contains(l)) {
            this.d.add(l);
        }
    }

    public void removeRemovedListener(LayoutRemovedListener l) {
        if (this.d != null && this.d.contains(l)) {
            this.d.remove(l);
        }
    }

    protected void fireRemoved(LayoutRemovedEvent event) {
        if (this.d != null) {
            CopyOnWriteArrayList<LayoutRemovedListener> copyOnWriteArrayList = this.d;
            for (LayoutRemovedListener layoutRemovedListener : copyOnWriteArrayList) {
                layoutRemovedListener.layoutRemoved(event);
            }
        }
    }

    public synchronized void addAddedListener(LayoutAddedListener l) {
        if (this.e == null) {
            this.e = new CopyOnWriteArrayList();
        }
        if (!this.e.contains(l)) {
            this.e.add(l);
        }
    }

    public void removeAddedListener(LayoutAddedListener l) {
        if (this.e != null && this.e.contains(l)) {
            this.e.remove(l);
        }
    }

    protected void fireAdded(LayoutAddedEvent event) {
        if (this.e != null) {
            CopyOnWriteArrayList<LayoutAddedListener> copyOnWriteArrayList = this.e;
            for (LayoutAddedListener layoutAddedListener : copyOnWriteArrayList) {
                layoutAddedListener.layoutAdded(event);
            }
        }
    }

    public synchronized void addClearingListener(LayoutClearingListener l) {
        if (this.f == null) {
            this.f = new CopyOnWriteArrayList();
        }
        if (!this.f.contains(l)) {
            this.f.add(l);
        }
    }

    public void removeClearingListener(LayoutClearingListener l) {
        if (this.f != null && this.f.contains(l)) {
            this.f.remove(l);
        }
    }

    protected void fireClearing(LayoutClearingEvent event) {
        if (this.f != null) {
            CopyOnWriteArrayList<LayoutClearingListener> copyOnWriteArrayList = this.f;
            for (LayoutClearingListener layoutClearingListener : copyOnWriteArrayList) {
                layoutClearingListener.layoutClearing(event);
            }
        }
    }

    public synchronized void addClearedListener(LayoutClearedListener l) {
        if (this.g == null) {
            this.g = new CopyOnWriteArrayList();
        }
        if (!this.g.contains(l)) {
            this.g.add(l);
        }
    }

    public void removeClearedListener(LayoutClearedListener l) {
        if (this.g != null && this.g.contains(l)) {
            this.g.remove(l);
        }
    }

    protected void fireCleared(LayoutClearedEvent event) {
        if (this.g != null) {
            CopyOnWriteArrayList<LayoutClearedListener> copyOnWriteArrayList = this.g;
            for (LayoutClearedListener layoutClearedListener : copyOnWriteArrayList) {
                layoutClearedListener.layoutCleared(event);
            }
        }
    }
}

