/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoWedgeNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoWedge
extends Geometry3D {
    public GeoWedge() {
        long l = GeoWedgeNative.jni_New1();
        this.setHandle(l, true);
    }

    public GeoWedge(GeoWedge geoWedge) {
        if (geoWedge == null) {
            String string = InternalResource.loadString("GeoWedge", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoWedge.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoWedge", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoWedgeNative.jni_Clone(geoWedge.getHandle(), this.getHandle());
    }

    public GeoWedge(Point3D position, double bottomLength, double bottomWidth, double ratio, double height) {
        double[] dArray = new double[]{position.getX(), position.getY(), position.getZ()};
        long l = GeoWedgeNative.jni_New3(dArray, bottomLength, bottomWidth, ratio, height);
        this.setHandle(l, true);
    }

    @Override
    public GeoWedge clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoWedge(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("GeoWedge", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoWedgeNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getBottomLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBottomLength", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoWedgeNative.jni_GetBottomLength(this.getHandle());
    }

    public void setBottomLength(double bottomLength) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBottomLength", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoWedgeNative.jni_SetBottomLength(this.getHandle(), bottomLength);
    }

    public double getBottomWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBottomWidth", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoWedgeNative.jni_GetBottomWidth(this.getHandle());
    }

    public void setBottomWidth(double bottomWidth) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBottomWidth", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoWedgeNative.jni_SetBottomWidth(this.getHandle(), bottomWidth);
    }

    public double getTopWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTopWidth", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoWedgeNative.jni_GetTopWidth(this.getHandle());
    }

    public void setTopWidth(double topWidth) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTopWidth", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoWedgeNative.jni_SetTopWidth(this.getHandle(), topWidth);
    }

    public double getTopLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTopLength", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoWedgeNative.jni_GetTopLength(this.getHandle());
    }

    public void setTopLength(double topLength) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTopLength", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoWedgeNative.jni_SetTopLength(this.getHandle(), topLength);
    }

    public double getRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRatio", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoWedgeNative.jni_GetRatio(this.getHandle());
    }

    public void setRatio(double ratio) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRatio", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoWedgeNative.jni_SetRatio(this.getHandle(), ratio);
    }

    public double getHeigth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeigth", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoWedgeNative.jni_GetHeight(this.getHandle());
    }

    public void setHeigth(double height) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeigth", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoWedgeNative.jni_SetHeight(this.getHandle(), height);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoWedgeNative.jni_GetCenter(this.getHandle());
        if (dArray != null && dArray.length == 3) {
            Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
            return point3D;
        }
        return null;
    }

    public double getTopXOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTopXOffset", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoWedgeNative.jni_GetTopXOffset(this.getHandle());
    }

    public void setTopXOffset(double topXOffset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTopXOffset", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoWedgeNative.jni_SetTopXOffset(this.getHandle(), topXOffset);
    }

    public double getTopYOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTopYOffset", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoWedgeNative.jni_GetTopYOffset(this.getHandle());
    }

    public void setTopYOffset(double topYOffset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTopYOffset", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoWedgeNative.jni_SetTopYOffset(this.getHandle(), topYOffset);
    }
}

