/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoPieNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;

public class GeoPie
extends Geometry {
    public GeoPie() {
        this.setHandle(GeoPieNative.jni_New(), true);
        this.a(0.0, 0.0, 1.0, 1.0, 0.0, 180.0, 0.0);
    }

    public GeoPie(GeoPie geoPie) {
        if (geoPie == null) {
            String string = InternalResource.loadString("geoPie", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoPie);
        if (l == 0L) {
            String string = InternalResource.loadString("geoPie", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoPieNative.jni_Clone(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoPie);
    }

    public GeoPie(Point2D center, double semimajorAxis, double semiminorAxis, double startAngle, double sweepAngle, double angle) {
        this();
        if (semimajorAxis <= 0.0) {
            String string = InternalResource.loadString("semimajorAxis", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (semiminorAxis <= 0.0) {
            String string = InternalResource.loadString("semiminorAxis", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sweepAngle <= -360.0 || sweepAngle >= 360.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoPie_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalStateException(string);
        }
        if (sweepAngle == 0.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoPie_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalStateException(string);
        }
        this.a(center.getX(), center.getY(), semimajorAxis, semiminorAxis, startAngle, startAngle + sweepAngle, angle);
    }

    GeoPie(long handle) {
        this.setHandle(handle, false);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoPieNative.jni_GetCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPieNative.jni_SetCenter(this.getHandle(), value.getX(), value.getY());
    }

    public double getSemimajorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSemimajorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetSemimajorAxis(this.getHandle());
    }

    public void setSemimajorAxis(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSemimajorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPieNative.jni_SetSemimajorAxis(this.getHandle(), value);
    }

    public double getSemiminorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSemiminorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetSemiminorAxis(this.getHandle());
    }

    public void setSemiminorAxis(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSemiminorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPieNative.jni_SetSemiminorAxis(this.getHandle(), value);
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetStartAngle(this.getHandle());
    }

    public void setStartAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPieNative.jni_SetStartAngle(this.getHandle(), value);
    }

    public double getSweepAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSweepAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetSweepAngle(this.getHandle());
    }

    public void setSweepAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSweepAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= -360.0 || value >= 360.0) {
            String string = InternalResource.loadString("value", "GeoPie_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (value == 0.0) {
            String string = InternalResource.loadString("value", "GeoPie_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPieNative.jni_SetSweepAngle(this.getHandle(), value);
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetAngle(this.getHandle());
    }

    public void setRotation(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPieNative.jni_SetAngle(this.getHandle(), value);
    }

    public GeoLine convertToLine(int segmentCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (segmentCount < 2) {
            String string = InternalResource.loadString("segmentCount", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new NullPointerException(string);
        }
        long l = GeoPieNative.jni_ConvertToLine(this.getHandle(), segmentCount);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    public GeoRegion convertToRegion(int segmentCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToRegion(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (segmentCount < 2) {
            String string = InternalResource.loadString("segmentCount", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new NullPointerException(string);
        }
        long l = GeoPieNative.jni_ConvertToRegion(this.getHandle(), segmentCount);
        GeoRegion geoRegion = null;
        if (l != 0L) {
            geoRegion = new GeoRegion(l);
            geoRegion.setIsDisposable(true);
        }
        return geoRegion;
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetArea(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPieNative.jni_GetPerimeter(this.getHandle());
    }

    @Override
    public GeoPie clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPie(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPieNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    void a(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        GeoPieNative.jni_Reset(this.getHandle(), d2, d3, d4, d5, d6, d7, d8);
    }
}

