/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoMapScaleDisplayType;
import com.supermap.data.GeoMapScaleNative;
import com.supermap.data.GeoMapScaleType;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.TextStyle;
import com.supermap.data.Unit;

public class GeoMapScale
extends Geometry {
    private TextStyle a;
    private int b;
    private GeoStyle c;

    public GeoMapScale() {
        long l = GeoMapScaleNative.jni_New();
        this.setHandle(l, true);
        this.b = -1;
    }

    public GeoMapScale(GeoMapScale geoMapScale) {
        if (geoMapScale == null) {
            String string = InternalResource.loadString("geoMapScale", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoMapScale);
        if (l == 0L) {
            String string = InternalResource.loadString("geoMapScale", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoMapScaleNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.b = geoMapScale.getBindingGeoMapID();
        InternalHandleDisposable.makeSureNativeObjectLive(geoMapScale);
    }

    public GeoMapScale(Point2D leftBottom, double width, double height) {
        this(-1, leftBottom, width, height);
    }

    public GeoMapScale(int geoMapID, Point2D leftBottom, double width, double height) {
        if (width <= 0.0) {
            String string = InternalResource.loadString("width", "GeoMapScale_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (height <= 0.0) {
            String string = InternalResource.loadString("height", "GeoMapScale_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoMapScaleNative.jni_New2(leftBottom.getX(), leftBottom.getY(), width, height);
        this.setHandle(l, true);
        this.b = geoMapID;
    }

    GeoMapScale(long handle) {
        this.setHandle(handle, false);
    }

    public int getBindingGeoMapID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBindingGeoMapID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.b;
    }

    public void setBindingGeoMapID(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBindingGeoMapID(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.b = value;
    }

    public GeoMapScaleType getScaleType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapScaleNative.jni_GetScaleType(this.getHandle());
        return (GeoMapScaleType)Enum.parse(GeoMapScaleType.class, n);
    }

    public void setScaleType(GeoMapScaleType geoMapScaleType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleType(GeoMapScaleType geoMapScaleType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoMapScaleType == null) {
            String string = InternalResource.loadString("geoMapScaleType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = geoMapScaleType.value();
        GeoMapScaleNative.jni_SetScaleType(this.getHandle(), n);
    }

    public double getScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetScale(this.getHandle());
    }

    public void setScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "GeoMapScale_ScaleShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapScaleNative.jni_SetScale(this.getHandle(), value);
    }

    public int getDivisions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDivisions()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetDivisions(this.getHandle());
    }

    public void setDivisions(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDivisions(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0 || value > 20) {
            String string = InternalResource.loadString("value", "GeoMapScale_SegmentCountOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapScaleNative.jni_SetDivisions(this.getHandle(), value);
    }

    public GeoMapScaleDisplayType getNumberDisplayType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNumberDisplayType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapScaleNative.jni_GetNumberDisplayType(this.getHandle());
        return (GeoMapScaleDisplayType)Enum.parse(GeoMapScaleDisplayType.class, n);
    }

    public void setNumberDisplayType(GeoMapScaleDisplayType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNumberDisplayType(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value.value() < 0) {
            String string = InternalResource.loadString("value", "GeoMapScale_SegmentCountOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapScaleNative.jni_SetNumberDisplayType(this.getHandle(), value.value());
    }

    public GeoMapScaleDisplayType getDivisionDisplayType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSegmentCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapScaleNative.jni_GetDivisionDisplayType(this.getHandle());
        return (GeoMapScaleDisplayType)Enum.parse(GeoMapScaleDisplayType.class, n);
    }

    public void setDivisionDisplayType(GeoMapScaleDisplayType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSegmentCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value.value() < 0) {
            String string = InternalResource.loadString("value", "GeoMapScale_SegmentCountOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapScaleNative.jni_SetDivisionDisplayType(this.getHandle(), value.value());
    }

    public int getSegmentCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSegmentCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetSegmentCount(this.getHandle());
    }

    public void setSegmentCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSegmentCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 2 || value > 20) {
            String string = InternalResource.loadString("value", "GeoMapScale_SegmentCountOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapScaleNative.jni_SetSegmentCount(this.getHandle(), value);
    }

    public double getMainDivisionHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMainDivisionHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetMainDivisionHeight(this.getHandle());
    }

    public void setMainDivisionHeight(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMainDivisionHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "GeoMapScale_ScaleShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapScaleNative.jni_SetMainDivisionHeight(this.getHandle(), value);
    }

    public double getShortDivisionHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShortDivisionHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetShortDivisionHeight(this.getHandle());
    }

    public void setShortDivisionHeight(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShortDivisionHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "GeoMapScale_ScaleShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapScaleNative.jni_SetShortDivisionHeight(this.getHandle(), value);
    }

    public boolean getIsDrawLeftDivision() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsDrawLeftDivision()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_IsDrawLeftDivision(this.getHandle());
    }

    public void setIsDrawLeftDivision(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsDrawLeftDivision()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapScaleNative.jni_SetIsDrawLeftDivision(this.getHandle(), value);
    }

    public double getSegmentLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSegmentLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetSegmentLength(this.getHandle());
    }

    public void setSegmentLength(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSegmentLength(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "GeoMapScale_SegmentLengthShouldNotBeNegative", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapScaleNative.jni_SetSegmentLength(this.getHandle(), value);
    }

    public int getLeftDivisionCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLeftDivisionCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetLeftDivisionCount(this.getHandle());
    }

    public void setLeftDivisionCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLeftDivisionCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            value = 0;
        }
        GeoMapScaleNative.jni_SetLeftDivisionCount(this.getHandle(), value);
    }

    public Unit getScaleUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapScaleNative.jni_GetScaleUnit(this.getHandle());
        return (Unit)Enum.parse(Unit.class, n);
    }

    public void setScaleUnit(Unit unit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleUnit(Unit unit)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (unit == null) {
            String string = InternalResource.loadString("unit", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = unit.value();
        GeoMapScaleNative.jni_SetScaleUnit(this.getHandle(), n);
    }

    public Unit getScaleShowUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleShowUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapScaleNative.jni_GetScaleShowUnit(this.getHandle());
        return (Unit)Enum.parse(Unit.class, n);
    }

    public void setScaleShowUnit(Unit unit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleShowUnit(Unit unit)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (unit == null) {
            String string = InternalResource.loadString("unit", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = unit.value();
        GeoMapScaleNative.jni_SetScaleShowUnit(this.getHandle(), n);
    }

    public TextStyle getTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l = GeoMapScaleNative.jni_GetTextStyle(this.getHandle())) != 0L) {
            this.a = new TextStyle(l);
        }
        return this.a;
    }

    public void setTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapScaleNative.jni_SetTextStyle(this.getHandle(), textStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetWidth(this.getHandle());
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapScaleNative.jni_setHeight(this.getHandle(), value);
    }

    public Point2D getLeftBottom() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLeftBottom()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoMapScaleNative.jni_getLeftBottom(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    @Override
    public GeoMapScale clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoMapScale(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoMapScaleNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    public GeoStyle getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.c == null && (l = GeoMapScaleNative.jni_GetStyle(this.getHandle())) != 0L) {
            this.c = GeoStyle.createInstance(l);
        }
        return this.c;
    }

    @Override
    public void setStyle(GeoStyle value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            if (this.c != null) {
                this.c.clearHandle();
                this.c = null;
            }
            GeoMapScaleNative.jni_SetStyle(this.getHandle(), 0L);
        } else {
            if (value.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            GeoStyle geoStyle = value.clone();
            GeoMapScaleNative.jni_SetStyle(this.getHandle(), geoStyle.getHandle());
            InternalHandleDisposable.makeSureNativeObjectLive(value);
        }
    }

    public boolean getDrawFromRightToLeft() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDrawFromRightToLeft()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetDrawFromRightToLeft(this.getHandle());
    }

    public void setDrawFromRightToLeft(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDrawFromRightToLeft()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapScaleNative.jni_SetDrawFromRightToLeft(this.getHandle(), value);
    }

    public boolean getIsHaveBeenSplited() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsHaveBeenSplited()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetIsHaveBeenSplited(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.c != null) {
            this.c.clearHandle();
            this.c = null;
        }
        this.setHandle(0L);
    }
}

