/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoMapBorder;
import com.supermap.data.GeoMapGrid;
import com.supermap.data.GeoMapNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;

public class GeoMap
extends Geometry {
    private Geometry a;
    private GeoMapBorder b;
    private GeoMapGrid c;
    private Rectangle2D d;

    public GeoMap() {
        long l = GeoMapNative.jni_New();
        this.setHandle(l, true);
        this.d = null;
    }

    public GeoMap(GeoMap geoMap) {
        if (geoMap == null) {
            String string = InternalResource.loadString("geoMap", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoMap);
        if (l == 0L) {
            String string = InternalResource.loadString("geoMap", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoMapNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.d = geoMap.getMapViewBounds();
        InternalHandleDisposable.makeSureNativeObjectLive(geoMap);
    }

    public GeoMap(String mapName, Geometry shape) {
        if (shape == null) {
            String string = InternalResource.loadString("shape", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        int n = shape.getType().value();
        boolean bl = false;
        switch (n) {
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 21: {
                bl = true;
                break;
            }
        }
        if (!bl) {
            String string = InternalResource.loadString("shape", "GeoMap_UnsupprotGeometryType", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l = GeoMapNative.jni_New();
        this.setHandle(l, true);
        this.setMapName(mapName);
        this.setShape(shape);
        this.d = null;
        InternalHandleDisposable.makeSureNativeObjectLive(shape);
    }

    public GeoMap(String mapXML) {
        long l = GeoMapNative.jni_New();
        this.setHandle(l, true);
        this.setMapXML(mapXML);
    }

    GeoMap(long handle) {
        this.setHandle(handle, false);
    }

    public Geometry getShape() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShape()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null) {
            long l = GeoMapNative.jni_GetShape(this.getHandle());
            if (l != 0L) {
                this.a = Geometry.createInstance(l);
                InternalHandleDisposable.setIsDisposable(this.a, false);
            }
        } else {
            long l = GeoMapNative.jni_GetShape(this.getHandle());
            this.a.clearHandle();
            this.a.refreshHandle(l);
        }
        return this.a;
    }

    public void setShape(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShape(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = geometry.getType().value();
        boolean bl = false;
        switch (n) {
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 21: {
                bl = true;
                break;
            }
        }
        if (!bl) {
            String string = InternalResource.loadString("geometry", "GeoMap_UnsupprotGeometryType", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l = InternalHandleDisposable.getHandle(geometry);
        GeoMapNative.jni_SetShape(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
    }

    public String getMapName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_GetMapName(this.getHandle());
    }

    public void setMapName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapName(String mapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapNative.jni_SetMapName(this.getHandle(), name);
    }

    public GeoMapBorder getMapBorder() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapBorder()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.b == null && (l = GeoMapNative.jni_GetMapBorder(this.getHandle())) != 0L) {
            this.b = new GeoMapBorder(l);
        }
        return this.b;
    }

    public void setMapBorder(GeoMapBorder geoMapBorder) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapBorder(GeoMapBorder geoMapBorder)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoMapBorder == null) {
            String string = InternalResource.loadString("geoMapBorder", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoMapBorder.getHandle() == 0L) {
            String string = InternalResource.loadString("geoMapBorder", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapNative.jni_SetMapBorder(this.getHandle(), geoMapBorder.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoMapBorder);
    }

    public boolean isBorderVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isBorderVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_IsBorderVisible(this.getHandle());
    }

    public void setBorderVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBorderVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapNative.jni_SetBorderVisible(this.getHandle(), value);
    }

    public boolean isGridVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMarginVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_IsGridVisible(this.getHandle());
    }

    public void setGridVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarginVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapNative.jni_SetGridVisible(this.getHandle(), value);
    }

    public GeoMapGrid getMapGrid() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapGrid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.c == null && (l = GeoMapNative.jni_GetMapGrid(this.getHandle())) != 0L) {
            this.c = new GeoMapGrid(l);
        }
        return this.c;
    }

    public void setMapGrid(GeoMapGrid geoMapMargin) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapMargin(GeoMapMargin geoMapMargin)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoMapMargin == null) {
            String string = InternalResource.loadString("geoMapMargin", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoMapMargin.getHandle() == 0L) {
            String string = InternalResource.loadString("geoMapMargin", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapNative.jni_SetMapGrid(this.getHandle(), geoMapMargin.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoMapMargin);
    }

    @Override
    public GeoMap clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoMap(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoMapNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public double getMapScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_GetMapScale(this.getHandle());
    }

    public void setMapScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapScale(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "ValueShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapNative.jni_SetMapScale(this.getHandle(), value);
    }

    public double getMapAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_GetMapAngle(this.getHandle());
    }

    public void setMapAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapNative.jni_SetMapAngle(this.getHandle(), value);
    }

    public Point2D getMapCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoMapNative.jni_GetMapCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setMapCenter(Point2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapNative.jni_SetMapCenter(this.getHandle(), value.getX(), value.getY());
    }

    public String getMapXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_GetMapXML(this.getHandle());
    }

    public void setMapXML(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapXML(String mapXML)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapNative.jni_SetMapXML(this.getHandle(), name);
    }

    public boolean isUserScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isUserScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_IsUserScale(this.getHandle());
    }

    public void setUserScale(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUserScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapNative.jni_SetUserScale(this.getHandle(), value);
    }

    public Rectangle2D getMapViewBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapViewBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.d;
    }

    public boolean addMapGrid(GeoMapGrid geoGrid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddMapGrid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoGrid == null) {
            String string = InternalResource.loadString("geoGrid", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoGrid.getHandle() == 0L) {
            String string = InternalResource.loadString("geoGrid", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeoMapNative.jni_AddMapGrid(this.getHandle(), geoGrid.getHandle());
        return bl;
    }

    public boolean removeGrid(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGrid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getMapGridCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoMapNative.jni_RemoveGrid(this.getHandle(), index);
    }

    public GeoMapGrid getMapGrid(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapGrid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getMapGridCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGrid geoMapGrid = null;
        long l = GeoMapNative.jni_GetMapGridWithIndex(this.getHandle(), index);
        if (l != 0L) {
            geoMapGrid = new GeoMapGrid(l);
        }
        return geoMapGrid;
    }

    public int getMapGridCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapGridCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_GetMapGridCount(this.getHandle());
    }

    public boolean insertMapGrid(int index, GeoMapGrid geoGrid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertMapGrid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoGrid == null) {
            String string = InternalResource.loadString("geoGrid", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoGrid.getHandle() == 0L) {
            String string = InternalResource.loadString("geoGrid", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.getMapGridCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoMapNative.jni_InsertMapGrid(this.getHandle(), index, geoGrid.getHandle());
    }

    public boolean setMapGrid(int index, GeoMapGrid geoGrid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapGrid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoGrid == null) {
            String string = InternalResource.loadString("geoGrid", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoGrid.getHandle() == 0L) {
            String string = InternalResource.loadString("geoGrid", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.getMapGridCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoMapNative.jni_SetMappGridWithIndex(this.getHandle(), index, geoGrid.getHandle());
    }

    @Deprecated
    public void setMapViewBounds(Rectangle2D mapViewBounds) {
        this.d = mapViewBounds;
    }

    protected static void clearHandle(GeoMap geoMap) {
        geoMap.clearHandle();
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.b != null) {
            this.b.clearHandle();
            this.b = null;
        }
        if (this.c != null) {
            this.c.clearHandle();
            this.c = null;
        }
        this.setHandle(0L);
    }
}

