/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoBSplineNative;
import com.supermap.data.GeoCardinalNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;

public class GeoBSpline
extends Geometry {
    private Point2Ds a = null;

    public GeoBSpline() {
        long l = GeoBSplineNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoBSpline(GeoBSpline geoBSpline) {
        if (geoBSpline == null) {
            String string = InternalResource.loadString("geoBSpline", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoBSpline);
        if (l == 0L) {
            String string = InternalResource.loadString("geoBSpline", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoBSplineNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.a = new Point2Ds(geoBSpline.getControlPoints(), this);
        InternalHandleDisposable.makeSureNativeObjectLive(geoBSpline);
    }

    public GeoBSpline(Point2Ds controlPoints) {
        int n = controlPoints.getCount();
        if (n < 4) {
            String string = InternalResource.loadString("controlPoints", "GeoBSpline_ControlPointsLengthShouldNotLessThanFour", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = controlPoints.getItem(i).getX();
            dArray2[i] = controlPoints.getItem(i).getY();
        }
        long l = GeoBSplineNative.jni_New2(dArray, dArray2);
        this.setHandle(l, true);
        this.a = new Point2Ds(controlPoints, this);
    }

    GeoBSpline(long handle) {
        this.setHandle(handle, false);
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoBSplineNative.jni_GetLength(this.getHandle());
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoBSplineNative.jni_IsEmpty(this.getHandle());
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.a.clear();
        this.a = null;
        GeoBSplineNative.jni_SetEmpty(this.getHandle());
    }

    public Point2Ds getControlPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getControlPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoBSplineNative.jni_GetPartPointCount(this.getHandle());
        if (n >= 4) {
            int n2;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            GeoBSplineNative.jni_GetControlPoints(this.getHandle(), dArray, dArray2);
            Point2Ds point2Ds = new Point2Ds();
            for (n2 = 0; n2 < n; ++n2) {
                point2Ds.add(new Point2D(dArray[n2], dArray2[n2]));
            }
            if (this.a == null) {
                this.a = new Point2Ds(point2Ds, this);
            } else {
                for (n2 = 0; n2 < n; ++n2) {
                    this.a.add(new Point2D(dArray[n2], dArray2[n2]));
                }
                n2 = this.a.getCount();
                this.a.removeRange(0, n2 - n);
            }
        }
        return this.a;
    }

    public void setControlPoints(Point2Ds controlPoints) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setControlPoints(Point2Ds controlPoints)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = controlPoints.getCount();
        if (n < 4) {
            String string = InternalResource.loadString("controlPoints", "GeoBSpline_ControlPointsLengthShouldNotLessThanFour", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = controlPoints.getItem(i).getX();
            dArray2[i] = controlPoints.getItem(i).getY();
        }
        GeoBSplineNative.jni_SetControlPoints(this.getHandle(), dArray, dArray2);
    }

    public GeoLine convertToLine(int pointCountPerSegment) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoBSplineNative.jni_ConvertToLine(this.getHandle(), pointCountPerSegment);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    @Override
    public GeoBSpline clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoBSpline(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoCardinalNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }
}

