/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.ColorGradientType;
import com.supermap.data.ColorsNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.awt.Color;

public class Colors
extends InternalHandleDisposable {
    private boolean a = false;

    public Colors() {
        this.setHandle(ColorsNative.jni_New(), true);
    }

    public Colors(Color[] colors) {
        if (colors == null) {
            String string = InternalResource.loadString("colors", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        this.setHandle(ColorsNative.jni_New(), true);
        this.addRange(colors);
    }

    public Colors(Colors colors) {
        if (colors == null) {
            throw new NullPointerException("colors");
        }
        if (colors.getHandle() == 0L) {
            String string = InternalResource.loadString("colors", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(ColorsNative.jni_New(), true);
        this.addRange(colors.toArray());
        InternalHandleDisposable.makeSureNativeObjectLive(colors);
    }

    Colors(long handle, boolean isForDataset) {
        this.a = isForDataset;
        this.setHandle(handle, false);
    }

    Colors(long handle, boolean disposable, boolean isForDataset) {
        this.a = isForDataset;
        this.setHandle(handle, disposable);
    }

    public Color get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = ColorsNative.jni_GetItem(this.getHandle(), index);
        Color color = new Color(n);
        if (this.a) {
            color = this.a(color);
        }
        return color;
    }

    public void set(int index, Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(int index, Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        Color color = value;
        if (this.a) {
            color = this.a(value);
        }
        ColorsNative.jni_Set(this.getHandle(), index, color.getRGB());
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ColorsNative.jni_GetCount(this.getHandle());
    }

    public int add(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Color color)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        Color color2 = color;
        if (this.a) {
            color2 = this.a(color);
        }
        return ColorsNative.jni_Add(this.getHandle(), color2.getRGB());
    }

    public int addRange(Color[] colors) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addRange(Color[] colors)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (colors == null) {
            throw new NullPointerException("colors");
        }
        int n = colors.length;
        int[] nArray = new int[n];
        if (this.a) {
            for (int i = 0; i < n; ++i) {
                Color color = this.a(colors[i]);
                nArray[i] = color.getRGB();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                nArray[i] = colors[i].getRGB();
            }
        }
        return ColorsNative.jni_AddRange(this.getHandle(), nArray);
    }

    public boolean insert(int index, Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, Color color)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_InvalidInsertPosition", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (index == this.getCount()) {
            return this.add(color) != -1;
        }
        Color color2 = color;
        if (this.a) {
            color2 = this.a(color);
        }
        boolean bl = ColorsNative.jni_Insert(this.getHandle(), index, color2.getRGB());
        return bl;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return ColorsNative.jni_Remove(this.getHandle(), index);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ColorsNative.jni_Clear(this.getHandle());
    }

    public static Colors makeRandom(int count) {
        if (count <= 0) {
            String string = InternalResource.loadString("count", "Colors_CountShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ColorsNative.jni_MakeRandom(count);
        if (l == 0L) {
            return null;
        }
        return new Colors(l, true, false);
    }

    public static Colors makeGradient(int count, Color[] gradientColors) {
        if (count <= 0) {
            String string = InternalResource.loadString("count", "Colors_CountShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (gradientColors == null) {
            String string = InternalResource.loadString("intervalColors", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (gradientColors.length < 2) {
            String string = InternalResource.loadString("intervalColors", "Colors_IntervalColorsLengthInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = gradientColors.length;
        int[] nArray = new int[n];
        for (int i = 0; i < gradientColors.length; ++i) {
            nArray[i] = gradientColors[i].getRGB();
        }
        long l = ColorsNative.jni_MakeGradient1(count, nArray);
        if (l == 0L) {
            return null;
        }
        return new Colors(l, true, false);
    }

    public static Colors makeGradient(int count, ColorGradientType type, boolean reverse) {
        if (count <= 0) {
            String string = InternalResource.loadString("count", "Colors_CountShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = ColorsNative.jni_MakeGradient2(count, type.getUGCValue(), reverse);
        if (l == 0L) {
            return null;
        }
        return new Colors(l, true, false);
    }

    public Color[] toArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toArray()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray[i] = this.get(i);
        }
        return colorArray;
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count=");
        stringBuffer.append(this.getCount());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        this.dispose(ColorsNative::jni_Delete);
    }

    protected static Colors createInstance(long handle, boolean isForDataset) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new Colors(handle, isForDataset);
    }

    protected static void clearHandle(Colors colors) {
        colors.clearHandle();
    }

    protected static void changeHandle(Colors colors, long handle) {
        colors.a(handle);
    }

    private void a(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            ColorsNative.jni_Delete(this.getHandle());
        }
        this.setHandle(l, false);
    }

    private Color a(Color color) {
        Color color2 = new Color(color.getBlue(), color.getGreen(), color.getRed());
        return color2;
    }

    public Colors makeRandom(int count, Color[] color) {
        if (count < 2) {
            String string = InternalResource.loadString("count", "Colors_CountShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (color.length < 2) {
            String string = InternalResource.loadString("color", "Colors_IntervalColorsLengthInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (color.length > count) {
            String string = InternalResource.loadString("count", "Colors_IntervalColorsLengthInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = color.length;
        int[] nArray = new int[n];
        for (int i = 0; i < color.length; ++i) {
            nArray[i] = color[i].getRGB();
        }
        long l = ColorsNative.jni_MakeRandom1(count, nArray);
        if (l == 0L) {
            return null;
        }
        return new Colors(l, true, false);
    }
}

