/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.ColorDictNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.awt.Color;

public class ColorDictionary
extends InternalHandleDisposable {
    public ColorDictionary() {
        this.setHandle(ColorDictNative.jni_New(), true);
    }

    public ColorDictionary(ColorDictionary clrDict) {
        if (clrDict == null) {
            throw new NullPointerException("ColorDict");
        }
        if (clrDict.getHandle() == 0L) {
            String string = InternalResource.loadString("ColorDict", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(ColorDictNative.jni_New(), true);
        int n = clrDict.getCount();
        double[] dArray = clrDict.getKeys();
        Color[] colorArray = clrDict.getColors();
        for (int i = 0; i < n; ++i) {
            this.setColor(dArray[i], colorArray[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(clrDict);
    }

    ColorDictionary(long handle) {
        this.setHandle(handle, false);
    }

    ColorDictionary(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
    }

    public double[] getKeys() {
        int n = this.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[1];
        int[] nArray = new int[1];
        for (int i = 0; i < n; ++i) {
            ColorDictNative.jni_GetItem(this.getHandle(), i, dArray2, nArray);
            dArray[i] = dArray2[0];
        }
        return dArray;
    }

    public Color[] getColors() {
        int n = this.getCount();
        Color[] colorArray = new Color[n];
        double[] dArray = new double[1];
        int[] nArray = new int[1];
        for (int i = 0; i < n; ++i) {
            Color color;
            ColorDictNative.jni_GetItem(this.getHandle(), i, dArray, nArray);
            colorArray[i] = color = new Color(nArray[0], true);
        }
        return colorArray;
    }

    public Color getColor(double key) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColor(double key)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!ColorDictNative.jni_IsExist(this.getHandle(), key)) {
            String string = InternalResource.loadString("key", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = ColorDictNative.jni_GetColor(this.getHandle(), key);
        Color color = new Color(n, true);
        return color;
    }

    public void setColor(double key, Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColor(int key, Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        Color color = value;
        if (!ColorDictNative.jni_IsExist(this.getHandle(), key)) {
            ColorDictNative.jni_Add(this.getHandle(), key, color.getRGB());
        }
        ColorDictNative.jni_SetColor(this.getHandle(), key, color.getRGB());
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ColorDictNative.jni_GetCount(this.getHandle());
    }

    public void removeKey(double key) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(double dValue)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!ColorDictNative.jni_IsExist(this.getHandle(), key)) {
            String string = InternalResource.loadString("key", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        ColorDictNative.jni_Remove(this.getHandle(), key);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ColorDictNative.jni_Clear(this.getHandle());
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        this.dispose(ColorDictNative::jni_Delete);
    }

    protected static ColorDictionary createInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new ColorDictionary(handle);
    }

    protected static void clearHandle(ColorDictionary clrDict) {
        clrDict.clearHandle();
    }

    protected static void changeHandle(ColorDictionary clrDict, long handle) {
        clrDict.a(handle);
    }

    private void a(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            ColorDictNative.jni_Delete(this.getHandle());
        }
        this.setHandle(l, false);
    }
}

