/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BoundingBox;
import com.supermap.data.CSGBooleanNode;
import com.supermap.data.CSGEntity;
import com.supermap.data.CSGNodeNative;
import com.supermap.data.CSGNodeType;
import com.supermap.data.CSGSimpleNode;
import com.supermap.data.Enum;
import com.supermap.data.InternalCSGNode;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Matrix;
import com.supermap.data.Point3D;

public abstract class CSGNode
extends InternalHandleDisposable {
    private static final int[] a = Enum.getPredefineValues(CSGNodeType.class);
    protected CSGNodeType m_nodeType;

    protected CSGNode() {
    }

    protected CSGNode(CSGNode csgNode) {
    }

    public BoundingBox getBoundingBox() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBoundingBox", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[6];
        CSGNodeNative.jni_GetBoundingBox(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        Point3D point3D2 = new Point3D(dArray[3], dArray[4], dArray[5]);
        BoundingBox boundingBox = new BoundingBox(point3D, point3D2);
        return boundingBox;
    }

    public Matrix getMatrix() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMatrix", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = CSGNodeNative.jni_GetMatrix(this.getHandle());
        return new Matrix(l);
    }

    public CSGNodeType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCsgNodeType", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = CSGNodeNative.jni_GetCsgNodeType(this.getHandle());
        return new CSGNodeType(n, n);
    }

    protected static void clearHandle(CSGNode csgNode) {
        csgNode.clearHandle();
    }

    protected static CSGNode internalCreateInstance(long geoHandle) {
        return CSGNode.createInstance(geoHandle);
    }

    static CSGNode createInstance(long nodeHandle) {
        if (nodeHandle == 0L) {
            return null;
        }
        InternalHandleDisposable internalHandleDisposable = null;
        int n = CSGNodeNative.jni_GetCsgNodeType(nodeHandle);
        boolean bl = true;
        for (int i = 0; i < a.length; ++i) {
            if (n != a[i]) continue;
            bl = false;
            break;
        }
        if (!bl) {
            CSGNodeType cSGNodeType = CSGNodeType.parseUGCValue(n);
            if (cSGNodeType.equals(CSGNodeType.BOOLEANNODE)) {
                internalHandleDisposable = new CSGBooleanNode(nodeHandle);
            } else if (cSGNodeType.equals(CSGNodeType.SIMPLENODE)) {
                internalHandleDisposable = new CSGSimpleNode(nodeHandle);
            }
            if (internalHandleDisposable != null) {
                ((CSGNode)internalHandleDisposable).m_nodeType = cSGNodeType;
            }
        }
        if (internalHandleDisposable != null) {
            internalHandleDisposable.setIsDisposable(true);
        }
        return internalHandleDisposable;
    }

    public String toJson() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("saveToJson", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return CSGNodeNative.jni_SaveToJson(this.getHandle());
    }

    public static CSGNode fromJson(String strJson) {
        if (strJson == "") {
            String string = InternalResource.loadString("fromJson", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = CSGNodeNative.jni_FromJson(strJson);
        CSGNode cSGNode = null;
        if (l != 0L) {
            cSGNode = InternalCSGNode.createInstance(l);
            InternalHandleDisposable.setIsDisposable(cSGNode, false);
        }
        return cSGNode;
    }

    public CSGBooleanNode union(CSGNode csgNode) {
        if (csgNode == null) {
            return null;
        }
        long l = CSGNodeNative.jni_OperationUnion(this.getHandle(), csgNode.getHandle());
        return new CSGBooleanNode(l);
    }

    public CSGBooleanNode union(CSGEntity csgEntity) {
        if (csgEntity == null) {
            return null;
        }
        long l = CSGNodeNative.jni_OperationUnion1(this.getHandle(), csgEntity.getHandle());
        return new CSGBooleanNode(l);
    }

    public CSGBooleanNode intersect(CSGNode csgNode) {
        if (csgNode == null) {
            return null;
        }
        long l = CSGNodeNative.jni_OperationIntersect(this.getHandle(), csgNode.getHandle());
        return new CSGBooleanNode(l);
    }

    public CSGBooleanNode intersect(CSGEntity csgEntity) {
        if (csgEntity == null) {
            return null;
        }
        long l = CSGNodeNative.jni_OperationIntersect1(this.getHandle(), csgEntity.getHandle());
        return new CSGBooleanNode(l);
    }

    public void translate(Point3D point3D) {
        if (point3D == null) {
            String string = InternalResource.loadString("translate", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        CSGNodeNative.jni_Translate(this.getHandle(), point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public void multiply(Matrix matrix) {
        if (matrix == null) {
            String string = InternalResource.loadString("multiply", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        CSGNodeNative.jni_Multiply(this.getHandle(), matrix.getHandle());
    }

    public CSGBooleanNode difference(CSGNode csgNode) {
        if (csgNode == null) {
            return null;
        }
        long l = CSGNodeNative.jni_OperationDifference(this.getHandle(), csgNode.getHandle());
        return new CSGBooleanNode(l);
    }

    public CSGBooleanNode difference(CSGEntity csgEntity) {
        if (csgEntity == null) {
            return null;
        }
        long l = CSGNodeNative.jni_OperationDifference1(this.getHandle(), csgEntity.getHandle());
        return new CSGBooleanNode(l);
    }

    public void scale(Point3D point3D) {
        if (point3D == null) {
            String string = InternalResource.loadString("scale", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        CSGNodeNative.jni_Scale(this.getHandle(), point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public void rotate(Point3D point3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rotate", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        CSGNodeNative.jni_Rotate(this.getHandle(), point3D.getX(), point3D.getY(), point3D.getZ());
    }

    @Override
    public void dispose() {
    }

    public CSGNode clone() {
        if (this == null) {
            String string = InternalResource.loadString("clone", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = CSGNodeNative.jni_Clone(this.getHandle());
        CSGNode cSGNode = null;
        if (l != 0L) {
            cSGNode = InternalCSGNode.createInstance(l);
            InternalHandleDisposable.setIsDisposable(cSGNode, false);
        }
        return cSGNode;
    }
}

