/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BoundingBoxNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class BoundingBox
extends InternalHandleDisposable {
    public BoundingBox() {
        long l = BoundingBoxNative.jni_New();
        this.setHandle(l, true);
    }

    public BoundingBox(BoundingBox boundingBox) {
        if (boundingBox == null) {
            String string = InternalResource.loadString("boundingBox", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(boundingBox);
        if (l == 0L) {
            String string = InternalResource.loadString("boundingBox", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = BoundingBoxNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(boundingBox);
    }

    public BoundingBox(Point3D lower, Point3D upper) {
        double d2 = lower.getX();
        double d3 = lower.getY();
        double d4 = lower.getZ();
        double d5 = upper.getX();
        double d6 = upper.getY();
        double d7 = upper.getZ();
        long l = BoundingBoxNative.jni_New2(d2, d3, d4, d5, d6, d7);
        this.setHandle(l, true);
    }

    BoundingBox(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle, false);
    }

    public static BoundingBox getEMPTY() {
        Point3D point3D = Point3D.getEMPTY();
        Point3D point3D2 = Point3D.getEMPTY();
        return new BoundingBox(point3D, point3D2);
    }

    public boolean isEmpty() {
        boolean bl = false;
        Point3D point3D = this.getLower();
        Point3D point3D2 = this.getUpper();
        Point3D point3D3 = Point3D.getEMPTY();
        if (point3D3.equals(point3D) && point3D3.equals(point3D2)) {
            bl = true;
        }
        return bl;
    }

    public Point3D getLower() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLower()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        BoundingBoxNative.jni_GetLower(this.getHandle(), dArray);
        Point3D point3D = new Point3D();
        point3D.setX(dArray[0]);
        point3D.setY(dArray[1]);
        point3D.setZ(dArray[2]);
        return point3D;
    }

    public void setLower(Point3D lower) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLower(Point3D lower)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = lower.getX();
        double d3 = lower.getY();
        double d4 = lower.getZ();
        BoundingBoxNative.jni_SetLower(this.getHandle(), d2, d3, d4);
    }

    public Point3D getUpper() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUpper()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        BoundingBoxNative.jni_GetUpper(this.getHandle(), dArray);
        Point3D point3D = new Point3D();
        point3D.setX(dArray[0]);
        point3D.setY(dArray[1]);
        point3D.setZ(dArray[2]);
        return point3D;
    }

    public void setUpper(Point3D upper) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUpper(Point3D upper)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = upper.getX();
        double d3 = upper.getY();
        double d4 = upper.getZ();
        BoundingBoxNative.jni_SetUpper(this.getHandle(), d2, d3, d4);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        BoundingBoxNative.jni_GetCenter(this.getHandle(), dArray);
        Point3D point3D = new Point3D();
        point3D.setX(dArray[0]);
        point3D.setY(dArray[1]);
        point3D.setZ(dArray[2]);
        return point3D;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BoundingBox boundingBox = (BoundingBox)obj;
        return boundingBox.getLower().equals(this.getLower()) && boundingBox.getUpper().equals(this.getUpper()) && boundingBox.getCenter().equals(this.getCenter());
    }

    public int hashCode() {
        return this.getLower().hashCode() + this.getUpper().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(lower={x=");
        stringBuffer.append(this.getLower().getX());
        stringBuffer.append(",y=");
        stringBuffer.append(this.getLower().getY());
        stringBuffer.append(",z=");
        stringBuffer.append(this.getLower().getZ());
        stringBuffer.append("},upper={x=");
        stringBuffer.append(this.getUpper().getX());
        stringBuffer.append(",y=");
        stringBuffer.append(this.getUpper().getY());
        stringBuffer.append(",z=");
        stringBuffer.append(this.getUpper().getZ());
        stringBuffer.append("})");
        return stringBuffer.toString();
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            BoundingBoxNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }
}

