/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.BufferEndType;
import com.supermap.analyst.spatialanalyst.BufferRadiusUnit;
import com.supermap.analyst.spatialanalyst.InternalResource;

public class BufferAnalystParameter {
    public static final String FIELD_BUFFER_END_TYPE = "bufferEndType";
    public static final String FIELD_SEMICIRCLE_LINE_SEGMENT = "semicircleLineSegment";
    public static final String FIELD_LEFT_DISTANCE = "leftDistance";
    public static final String FIELD_RIGHT_DISTANCE = "rightDistance";
    public static final String FIELD_BUFFER_RADIUS_UNIT = "bufferRadiusUnit";
    private BufferEndType a;
    private int b;
    private Object c;
    private Object d;
    private BufferRadiusUnit e;

    public BufferAnalystParameter() {
        this.a = BufferEndType.ROUND;
        this.b = 12;
        this.c = null;
        this.d = null;
        this.e = BufferRadiusUnit.Meter;
    }

    public BufferAnalystParameter(BufferAnalystParameter bufferAnalystParameter) {
        this.a = bufferAnalystParameter.getEndType();
        this.b = bufferAnalystParameter.getSemicircleLineSegment();
        this.c = bufferAnalystParameter.getLeftDistance();
        this.d = bufferAnalystParameter.getRightDistance();
        this.e = bufferAnalystParameter.getRadiusUnit();
    }

    public BufferEndType getEndType() {
        return this.a;
    }

    public void setEndType(BufferEndType bufferEndType) {
        if (bufferEndType == null) {
            String string = InternalResource.loadString(FIELD_BUFFER_END_TYPE, "Global_ArgumentNull", "geometryspatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.a = bufferEndType;
    }

    public BufferRadiusUnit getRadiusUnit() {
        return this.e;
    }

    public void setRadiusUnit(BufferRadiusUnit bufferRadiusUnit) {
        if (bufferRadiusUnit == null) {
            String string = InternalResource.loadString(FIELD_BUFFER_RADIUS_UNIT, "Global_ArgumentNull", "geometryspatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.e = bufferRadiusUnit;
    }

    public int getSemicircleLineSegment() {
        return this.b;
    }

    public void setSemicircleLineSegment(int value) {
        if (value < 4 || value > 200) {
            String string = InternalResource.loadString(FIELD_SEMICIRCLE_LINE_SEGMENT, "BufferAnalyst_SemicircleLineSegmentShouldEqualsOrGreaterThanFour", "geometryspatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.b = value;
    }

    public Object getLeftDistance() {
        return this.c;
    }

    public void setLeftDistance(Object leftDistance) {
        if (leftDistance == null) {
            this.c = null;
            return;
        }
        if (!this.a(leftDistance)) {
            String string = InternalResource.loadString(FIELD_LEFT_DISTANCE, "BufferAnalystParameter_InvalidObject", "geometryspatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.c = leftDistance;
    }

    public Object getRightDistance() {
        return this.d;
    }

    public void setRightDistance(Object rightDistance) {
        if (rightDistance == null) {
            this.d = null;
            return;
        }
        if (!this.a(rightDistance)) {
            String string = InternalResource.loadString(FIELD_RIGHT_DISTANCE, "BufferAnalystParameter_InvalidObject", "geometryspatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.d = rightDistance;
    }

    private boolean a(Object object) {
        boolean bl = false;
        if (object instanceof String || object instanceof Double) {
            bl = true;
        } else {
            try {
                Double.parseDouble(object.toString());
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }
}

