/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.CAFlushedEvent;
import com.supermap.analyst.spatialanalyst.CAFlushedListener;
import com.supermap.analyst.spatialanalyst.CellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.PCACellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.PCAEigenResult;
import com.supermap.analyst.spatialanalyst.PCAEigenValue;
import com.supermap.analyst.spatialanalyst.PrincipalComponentAnalysisCANative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;

public class PCACellularAutomata
extends InternalHandleDisposable {
    private static License b;
    private static transient Vector c;
    private static transient Vector d;
    PCAEigenResult a;

    public PCACellularAutomata() {
        long l = PrincipalComponentAnalysisCANative.jni_New();
        this.setHandle(l, true);
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            // empty if block
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            PrincipalComponentAnalysisCANative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    private void a(CellularAutomataParameter cellularAutomataParameter) {
        long l = super.getHandle();
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)cellularAutomataParameter.getCellGrid());
        DatasetGrid[] datasetGridArray = cellularAutomataParameter.getSpatialVariableGrids();
        long[] lArray = new long[datasetGridArray.length];
        for (int i = 0; i < datasetGridArray.length; ++i) {
            lArray[i] = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetGridArray[i]);
        }
        long l3 = 0L;
        if (cellularAutomataParameter.getOutputDataSource() != null) {
            l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)cellularAutomataParameter.getOutputDataSource());
        }
        PrincipalComponentAnalysisCANative.jni_setCellularAutomataParameter(l, l2, lArray, l3, cellularAutomataParameter.getOutputDatasetName(), cellularAutomataParameter.IsSave(), cellularAutomataParameter.getSaveFrequency(), cellularAutomataParameter.getFlushFrequency(), cellularAutomataParameter.getSimulationCount(), cellularAutomataParameter.getFlushFilePathName(), cellularAutomataParameter.getIterations());
    }

    private PCAEigenResult a() {
        return this.a;
    }

    public PCAEigenResult pca(DatasetGrid[] spatialVariableGrids, int nSampleCount, double dComponentRatio) {
        return this.pca(spatialVariableGrids, nSampleCount, dComponentRatio, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCAEigenResult pca(DatasetGrid[] spatialVariableGrids, int nSampleCount, double dComponentRatio, SteppedListener ... listeners) {
        try {
            int n;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            PCACellularAutomata.b();
            if (this.getHandle() == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("PCACellularAutomata", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (dComponentRatio <= 0.0 || dComponentRatio > 1.0) {
                String string = InternalResourceSpatialanalyst.loadString("dComponentRatio", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (nSampleCount < 100) {
                String string = InternalResourceSpatialanalyst.loadString("nSampleCount", "GlobalGreaterThanHundred", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (spatialVariableGrids == null || spatialVariableGrids.length == 0) {
                String string = InternalResourceSpatialanalyst.loadString("spatialVariableGrids", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            for (n = 0; n < spatialVariableGrids.length; ++n) {
                if (spatialVariableGrids[n] != null && 0L != InternalHandleSpatialanalyst.getHandle((InternalHandle)spatialVariableGrids[n])) continue;
                String string = InternalResourceSpatialanalyst.loadString("spatialVariableGrids[" + n + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            n = spatialVariableGrids.length;
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = InternalHandleSpatialanalyst.getHandle((InternalHandle)spatialVariableGrids[i]);
            }
            String[] stringArray = new String[n];
            double[] dArray = new double[3 * n];
            String[] stringArray2 = new String[n];
            double[] dArray2 = new double[n * n];
            String[] stringArray3 = new String[1];
            int n2 = PrincipalComponentAnalysisCANative.jni_principalComponentAnalysis(super.getHandle(), lArray, nSampleCount, dComponentRatio, stringArray, dArray, stringArray2, dArray2, stringArray3);
            this.a = null;
            if (n2 > 0) {
                int n3 = n2;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray2.length; ++i) {
                    arrayList.add(stringArray2[i]);
                }
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                for (int i = 0; i < n3 * n; ++i) {
                    arrayList2.add(dArray2[i]);
                }
                ArrayList<PCAEigenValue> arrayList3 = new ArrayList<PCAEigenValue>();
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList3.add(new PCAEigenValue(dArray[i * 3 + 0], stringArray[i], dArray[i * 3 + 1], dArray[i * 3 + 2]));
                }
                this.a = new PCAEigenResult(n3, arrayList, arrayList3, arrayList2, PrincipalComponentAnalysisCANative.jni_getPCASpatialVariableNames(super.getHandle()));
            } else if (stringArray3[0] != null && !stringArray3[0].isEmpty()) {
                throw new RuntimeException(stringArray3[0]);
            }
            PCAEigenResult pCAEigenResult = this.a;
            return pCAEigenResult;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public DatasetGrid pcaCellularAutomata(Datasource outputDatasource, String outputDatasetName, PCACellularAutomataParameter parameter) {
        return this.pcaCellularAutomata(outputDatasource, outputDatasetName, parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetGrid pcaCellularAutomata(Datasource outputDatasource, String outputDatasetName, PCACellularAutomataParameter parameter, SteppedListener ... listeners) {
        try {
            Object object;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            PCACellularAutomata.b();
            if (parameter == null) {
                String string = InternalResourceSpatialanalyst.loadString("PCACellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (this.a == null) {
                String string = InternalResourceSpatialanalyst.loadString("Please execute 'pca()' method first.", "Global_EnumValueIsError", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            this.a(parameter);
            if (null == outputDatasource || 0L == InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (outputDatasetName == null || outputDatasetName.trim().equalsIgnoreCase("")) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            this.a(parameter.getCellularAutomataParameter());
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            Map<Integer, Boolean> map = parameter.getConversionRules();
            Object[] objectArray = map.keySet().toArray();
            int[] nArray = new int[map.size()];
            boolean[] blArray = new boolean[map.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                nArray[i] = (Integer)objectArray[i];
                blArray[i] = map.get(objectArray[i]);
            }
            String[] stringArray = new String[1];
            long l2 = PrincipalComponentAnalysisCANative.jni_pcaCA(super.getHandle(), l, outputDatasetName, parameter.getComponentWeights(), parameter.getIndexK(), parameter.getAlpha(), nArray, blArray, parameter.getConversionTarget(), stringArray);
            DatasetGrid datasetGrid = null;
            if (l2 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l2, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetGrid);
                object = PrincipalComponentAnalysisCANative.jni_getIterationResults(super.getHandle());
                if (object != null && ((DatasetGrid)object).length != 0) {
                    for (int i = 0; i < ((DatasetGrid)object).length; ++i) {
                        DatasetGrid datasetGrid2 = InternalDatasetGrid.createInstance((long)object[i], parameter.getCellularAutomataParameter().getOutputDataSource());
                        InternalDatasets.add(parameter.getCellularAutomataParameter().getOutputDataSource().getDatasets(), (Dataset)datasetGrid2);
                    }
                }
            } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
                throw new RuntimeException(stringArray[0]);
            }
            object = datasetGrid;
            return object;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public boolean saveModel(String modelFile) {
        if (this.a == null) {
            String string = InternalResourceSpatialanalyst.loadString("Please execute 'pca()' method first.", "Global_EnumValueIsError", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (modelFile == null || modelFile.trim().equalsIgnoreCase("")) {
            String string = InternalResourceSpatialanalyst.loadString("modelFile", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(modelFile);
        if (file.exists()) {
            String string = InternalResourceSpatialanalyst.loadString("modelFile", "Global_FileAlreadyExist", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return PrincipalComponentAnalysisCANative.jni_savePCAModel(super.getHandle(), modelFile);
    }

    public PCAEigenResult loadModel(String modelFile) {
        if (modelFile == null || modelFile.trim().equalsIgnoreCase("")) {
            String string = InternalResourceSpatialanalyst.loadString("modelFile", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(modelFile);
        if (!file.exists()) {
            String string = InternalResourceSpatialanalyst.loadString("modelFile", "Global_FileNotFound", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = PrincipalComponentAnalysisCANative.jni_loadPCAModel(super.getHandle(), modelFile);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            int n2 = Integer.parseInt(stringArray[n]);
            ArrayList<String> arrayList = new ArrayList<String>();
            int n3 = Integer.parseInt(stringArray[++n]);
            ++n;
            for (int i = 0; i < n3; ++i) {
                arrayList.add(stringArray[i + n]);
            }
            n += n3;
            ArrayList<PCAEigenValue> arrayList2 = new ArrayList<PCAEigenValue>();
            n3 = Integer.parseInt(stringArray[n]);
            ++n;
            int n4 = n3 / 4;
            for (int i = 0; i < n4; ++i) {
                arrayList2.add(new PCAEigenValue(Double.parseDouble(stringArray[i * 4 + n]), stringArray[i * 4 + 3 + n], Double.parseDouble(stringArray[i * 4 + 1 + n]), Double.parseDouble(stringArray[i * 4 + 2 + n])));
            }
            n += n3;
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            n3 = Integer.parseInt(stringArray[n]);
            ++n;
            for (int i = 0; i < n3; ++i) {
                arrayList3.add(Double.parseDouble(stringArray[i + n]));
            }
            this.a = new PCAEigenResult(n2, arrayList, arrayList2, arrayList3, PrincipalComponentAnalysisCANative.jni_getPCASpatialVariableNames(super.getHandle()));
            return this.a;
        }
        return null;
    }

    private void a(PCACellularAutomataParameter pCACellularAutomataParameter) {
        if (pCACellularAutomataParameter == null) {
            String string = InternalResourceSpatialanalyst.loadString("PCACellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        CellularAutomataParameter.CheckParameter(pCACellularAutomataParameter.getCellularAutomataParameter());
        if (null == pCACellularAutomataParameter.getComponentWeights() || 0 == pCACellularAutomataParameter.getComponentWeights().length) {
            String string = InternalResourceSpatialanalyst.loadString("PCACellularAutomataParameter.getComponentWeights()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (this.a.getComponentCount() != pCACellularAutomataParameter.getComponentWeights().length) {
            String string = InternalResourceSpatialanalyst.loadString("PCACellularAutomataParameter.getComponentWeights() and PrimaryComponentEigenResult.getComponentCount() must be the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        double[] dArray = pCACellularAutomataParameter.getComponentWeights();
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] <= 0.0) && !(dArray[i] > 1.0)) continue;
            String string = InternalResourceSpatialanalyst.loadString("PCACellularAutomataParameter.getComponentWeights()[" + i + "]", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (pCACellularAutomataParameter.getIndexK() <= 0.0 || pCACellularAutomataParameter.getIndexK() >= 100.0) {
            String string = InternalResourceSpatialanalyst.loadString("PCACellularAutomataParameter.getIndexK()", "ShouldBetweenZeroAndHundred", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (pCACellularAutomataParameter.getConversionRules() == null || pCACellularAutomataParameter.getConversionRules().size() == 0) {
            String string = InternalResourceSpatialanalyst.loadString("PCACellularAutomataParameter.getConversionRules()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b() {
        int n = -1;
        Object object = b;
        synchronized (object) {
            n = b.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (c == null) {
            c = new Vector();
        }
        if (!c.contains(l)) {
            c.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (c != null && c.contains(l)) {
            c.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (c != null) {
            Vector vector = c;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "PCACellularAutomata";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)c, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    public static synchronized void addCAFlushedListener(CAFlushedListener l) {
        if (d == null) {
            d = new Vector();
        }
        if (!d.contains(l)) {
            d.add(l);
        }
    }

    public static synchronized void removeCAFlushedListener(CAFlushedListener l) {
        if (d != null && d.contains(l)) {
            d.remove(l);
        }
    }

    protected static void fireCAFlushed(CAFlushedEvent event) {
        if (d != null) {
            Vector vector = d;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CAFlushedListener)vector.elementAt(i)).CAFlushed(event);
            }
        }
    }

    static void CAFlushedCallBack(String strFlushFilePathName) {
        Object object = new Object();
        CAFlushedEvent cAFlushedEvent = new CAFlushedEvent(object, strFlushFilePathName);
        PCACellularAutomata.fireCAFlushed(cAFlushedEvent);
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        b = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

