/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import asposewobfuscated.zz37;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintException;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzU;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConstraintCollection
implements Iterable<Constraint> {
    private final List<Constraint> zzXR1;
    private final DataTable zzYL2;
    private final AtomicInteger zzXR0;

    ConstraintCollection(DataTable table) {
        this.zzYL2 = table;
        this.zzXR0 = new AtomicInteger(1);
        this.zzXR1 = new ArrayList<Constraint>();
    }

    public Constraint get(String constraintName) {
        if (zz37.zzWZ(constraintName)) {
            return null;
        }
        for (Constraint constraint : this.zzXR1) {
            if (!constraint.getConstraintName().equals(constraintName)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint get(int idx) {
        return this.zzXR1.get(idx);
    }

    public void add(Constraint constraint) throws DataException, InvalidConstraintException {
        if (constraint == null) {
            return;
        }
        if (this == constraint.zzZ9C()) {
            throw new IllegalArgumentException("Constraint already belongs to this collection.");
        }
        if (null != constraint.zzZ9C()) {
            throw new IllegalArgumentException("Constraint already belongs to another collection.");
        }
        for (Constraint constraint2 : this) {
            if (!constraint2.equals(constraint)) continue;
            throw new DataException("Constraint matches contraint named '" + constraint2.getConstraintName() + "' already in collection");
        }
        if (this.zzZ(constraint.getConstraintName(), null)) {
            throw new DataException("Constraint name already exists.");
        }
        constraint.addToConstraintCollectionSetup(this);
        if (constraint.getConstraintName() == null || "".equals(constraint.getConstraintName())) {
            ConstraintCollection constraintCollection = this;
            constraint.setConstraintName("Constraint" + constraintCollection.zzXR0.getAndIncrement());
        }
        constraint.zzZ(this);
        this.zzXR1.add(constraint);
        if (constraint instanceof UniqueConstraint && ((UniqueConstraint)constraint).isPrimaryKey()) {
            this.zzYL2.setPrimaryKey(((UniqueConstraint)constraint).getColumns());
        }
    }

    public void remove(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.zzXR1.remove(constraint);
    }

    public boolean contains(Constraint cc) {
        if (cc != null) {
            return false;
        }
        return this.zzXR1.contains(cc);
    }

    public int getCount() {
        return this.zzXR1.size();
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.zzXR1.iterator();
    }

    final DataTable getTable() {
        return this.zzYL2;
    }

    final List<ForeignKeyConstraint> zzZ9B() {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Constraint constraint : this.zzXR1) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            arrayList.add((ForeignKeyConstraint)constraint);
        }
        return arrayList;
    }

    final void zzZ(DataRow dataRow) throws ConstraintException, InvalidConstraintException {
        for (Constraint constraint : this.zzXR1) {
            if (constraint instanceof UniqueConstraint) {
                DataRow dataRow2 = dataRow;
                UniqueConstraint uniqueConstraint = (UniqueConstraint)constraint;
                ConstraintCollection constraintCollection = this;
                zzU zzU10 = constraintCollection.zzYL2.zzZ9t().zzX(uniqueConstraint.getColumns());
                Map<String, Object> map = zzU10.zzV(dataRow2);
                if (map != null && !map.isEmpty()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        stringBuilder.append(zz37.format("Column '{0}' is constrained to be unique.  Value '{1}' is already present.", entry.getKey(), entry.getValue()));
                    }
                    throw new ConstraintException(stringBuilder.toString());
                }
            }
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            this.zzZ((ForeignKeyConstraint)constraint, dataRow);
        }
    }

    private boolean zzZ(String string, Constraint constraint) {
        for (Constraint constraint2 : this.zzXR1) {
            if (constraint2.equals(null) || zz37.zzU(string, constraint2.getConstraintName(), false) != 0) continue;
            return true;
        }
        return false;
    }

    private void zzZ(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) throws InvalidConstraintException {
        if (this.zzYL2.getDataSet() == null) {
            return;
        }
        DataRelationCollection dataRelationCollection = this.zzYL2.getDataSet().getRelations();
        if (dataRelationCollection.getCount() == 0) {
            return;
        }
        ConstraintCollection constraintCollection = this;
        if (foreignKeyConstraint.getRelatedTable().getTableName().equals(constraintCollection.zzYL2.getTableName())) {
            return;
        }
        constraintCollection = this;
        if (!foreignKeyConstraint.getTable().getTableName().equals(constraintCollection.zzYL2.getTableName())) {
            return;
        }
        DataTable dataTable = foreignKeyConstraint.getRelatedTable();
        if (!dataTable.zzZ(foreignKeyConstraint.getRelatedColumns(), foreignKeyConstraint.getColumns(), dataRow)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
                stringBuilder.append(zz37.format("ForeignKeyConstraint '{0}' requires the child key values ('{1}') to exist in the parent table.", foreignKeyConstraint.getConstraintName(), dataRow.get(dataColumn)));
            }
            throw new InvalidConstraintException(stringBuilder.toString());
        }
    }
}

