/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.License;
import com.supermap.LicenseFeatureInfo;
import com.supermap.ProductType;
import com.supermap.data.AboutBox;
import com.supermap.data.Datasources;
import com.supermap.data.Enum;
import com.supermap.data.Environment;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Layouts;
import com.supermap.data.Maps;
import com.supermap.data.Resources;
import com.supermap.data.Scenes;
import com.supermap.data.Toolkit;
import com.supermap.data.WorkspaceCaptionChangedEvent;
import com.supermap.data.WorkspaceCaptionChangedListener;
import com.supermap.data.WorkspaceClosedEvent;
import com.supermap.data.WorkspaceClosedListener;
import com.supermap.data.WorkspaceClosingEvent;
import com.supermap.data.WorkspaceClosingListener;
import com.supermap.data.WorkspaceConnectionInfo;
import com.supermap.data.WorkspaceConnectionInfoNative;
import com.supermap.data.WorkspaceCreatedEvent;
import com.supermap.data.WorkspaceCreatedListener;
import com.supermap.data.WorkspaceNative;
import com.supermap.data.WorkspaceOpenedEvent;
import com.supermap.data.WorkspaceOpenedListener;
import com.supermap.data.WorkspaceSavedAsEvent;
import com.supermap.data.WorkspaceSavedAsListener;
import com.supermap.data.WorkspaceSavedEvent;
import com.supermap.data.WorkspaceSavedListener;
import com.supermap.data.WorkspaceType;
import com.supermap.data.WorkspaceVersion;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;

public class Workspace
extends InternalHandleDisposable {
    private static final long a = 8858435636L;
    private static final long b = 8858435637L;
    private WorkspaceConnectionInfo c;
    private Datasources d;
    private Maps e;
    private Scenes f;
    private transient CopyOnWriteArrayList<WorkspaceOpenedListener> g;
    private transient CopyOnWriteArrayList<WorkspaceCreatedListener> h;
    private transient CopyOnWriteArrayList<WorkspaceClosingListener> i;
    private transient CopyOnWriteArrayList<WorkspaceClosedListener> j;
    private transient CopyOnWriteArrayList<WorkspaceSavedAsListener> k;
    private transient CopyOnWriteArrayList<WorkspaceSavedListener> l;
    private transient CopyOnWriteArrayList<WorkspaceCaptionChangedListener> m;
    private License n;
    private Resources o;
    private Layouts p;
    private boolean q;

    public Workspace() {
        this.b(true);
    }

    public Workspace(boolean loadDefaultResource) {
        this.b(loadDefaultResource);
    }

    private void b(boolean bl) {
        this.c();
        this.q = bl;
        long l = WorkspaceNative.jni_New2(this.q);
        this.setHandle(l, true);
        this.a(this.q);
        l = WorkspaceNative.jni_GetConnectionInfo(this.getHandle());
        this.c = new WorkspaceConnectionInfo(l, false, true);
        this.c.a();
        this.e = new Maps(this);
        this.d = new Datasources(this);
        this.f = new Scenes(this);
        this.p = new Layouts(this);
    }

    private void c() {
        ArrayList<ProductType> arrayList = Toolkit.managerProducts(Toolkit.getDataProducts());
        this.n = Toolkit.verifyLicense(arrayList);
        LicenseFeatureInfo licenseFeatureInfo = this.n.getFeatureInfo();
        if (licenseFeatureInfo != null) {
            Toolkit.setMappingRuntimeLicenseMode(licenseFeatureInfo.isTrial());
            Toolkit.updateStatus();
            Toolkit.setWatermarkMode(licenseFeatureInfo.getWatermarkMode());
            Toolkit.setUserTrademark(licenseFeatureInfo.getUserTrademark());
            if (this.n.isCloudLicense().booleanValue()) {
                Toolkit.SetIsUseCloudLicense(this.n.isCloudLicense());
                Toolkit.SetCloudLicenseText(this.n.getCompany());
            }
        } else {
            Toolkit.setMappingRuntimeLicenseMode(true);
            Toolkit.updateStatus();
        }
    }

    private void d() {
        if (this.n != null) {
            this.n.disconnect();
            this.n.dispose();
            this.n = null;
        }
    }

    public WorkspaceConnectionInfo getConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getConnectionInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.c;
    }

    public String getCaption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetCaption(this.getHandle());
    }

    public void setCaption(String caption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCaption()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getCaption();
        WorkspaceNative.jni_SetCaption(this.getHandle(), caption);
        WorkspaceCaptionChangedEvent workspaceCaptionChangedEvent = new WorkspaceCaptionChangedEvent(this, this, string, caption);
        this.fireCaptionChanged(workspaceCaptionChangedEvent);
    }

    public Datasources getDatasources() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDatasources()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.d;
    }

    public Maps getMaps() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaps()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.e;
    }

    public boolean isModified() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isModified()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetIsModified(this.getHandle());
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String description) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDescription()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (description == null) {
            description = "";
        }
        WorkspaceNative.jni_SetDescription(this.getHandle(), description);
    }

    public WorkspaceType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = WorkspaceNative.jni_GetType(this.getHandle());
        WorkspaceType workspaceType = (WorkspaceType)Enum.parseUGCValue(WorkspaceType.class, n);
        return workspaceType;
    }

    public WorkspaceVersion getVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVersion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = WorkspaceNative.jni_GetVersion(this.getHandle());
        return (WorkspaceVersion)Enum.parseUGCValue(WorkspaceVersion.class, n);
    }

    public Date getLastUpdateTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLastUpdateTime()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = WorkspaceNative.jni_GetLastUpdateTime(this.getHandle());
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
                date = simpleDateFormat2.parse(string);
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
        return date;
    }

    public void aboutBox() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("aboutBox()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        AboutBox aboutBox = new AboutBox();
    }

    public boolean create(WorkspaceConnectionInfo connectionInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("create()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (connectionInfo == null) {
            String string = InternalResource.loadString("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (connectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.e.clear();
        this.d.b();
        boolean bl = WorkspaceNative.jni_Create(this.getHandle(), connectionInfo.getHandle());
        if (bl) {
            WorkspaceCreatedEvent workspaceCreatedEvent = new WorkspaceCreatedEvent(this, this, connectionInfo);
            this.fireCreated(workspaceCreatedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(connectionInfo);
        return bl;
    }

    public boolean open(WorkspaceConnectionInfo connectionInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("open()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = this.open2(connectionInfo);
        return l == 0L || l == 8858435636L || l == 8858435637L;
    }

    public long open2(WorkspaceConnectionInfo connectionInfo) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("open2()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (connectionInfo == null) {
            String string = InternalResource.loadString("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (connectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.c();
        this.close();
        long l = WorkspaceNative.jni_Open2(this.getHandle(), connectionInfo.getHandle());
        boolean bl2 = bl = l != 0L && l != 8858435636L && l != 8858435637L;
        if (bl) {
            this.getConnectionInfo().setReadOnly(false);
            this.getConnectionInfo().setVersion(WorkspaceVersion.UGC20);
            this.getConnectionInfo().setReadOnly(true);
        }
        this.getDatasources().d();
        WorkspaceVersion workspaceVersion = this.getConnectionInfo().getVersion();
        this.a(connectionInfo);
        WorkspaceConnectionInfoNative.jni_SetVersion(this.getConnectionInfo().getHandle(), workspaceVersion.getUGCValue());
        if (!bl) {
            WorkspaceOpenedEvent workspaceOpenedEvent = new WorkspaceOpenedEvent(this, this);
            this.fireOpened(workspaceOpenedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(connectionInfo);
        return l;
    }

    public boolean saveAs(WorkspaceConnectionInfo connectionInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("saveAs()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (connectionInfo == null) {
            String string = InternalResource.loadString("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (connectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a(connectionInfo);
        boolean bl = WorkspaceNative.jni_SaveAs(this.getHandle(), connectionInfo.getHandle());
        if (bl) {
            WorkspaceSavedAsEvent workspaceSavedAsEvent = new WorkspaceSavedAsEvent(this, this);
            this.fireSavedAs(workspaceSavedAsEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(connectionInfo);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("close()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        WorkspaceClosingEvent workspaceClosingEvent = new WorkspaceClosingEvent(this, this);
        this.fireClosing(workspaceClosingEvent);
        if (workspaceClosingEvent.getCancel()) {
            return;
        }
        Object object = this;
        synchronized (object) {
            this.getMaps().clear();
            this.getScenes().clear();
            WorkspaceNative.jni_Close(this.getHandle());
            this.getDatasources().b();
            if (this.o != null) {
                this.o.clearHandle();
                this.o = null;
            }
            this.getConnectionInfo().a();
            this.a(this.q);
        }
        object = new WorkspaceClosedEvent(this, this);
        this.fireClosed((WorkspaceClosedEvent)object);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            this.close();
            WorkspaceNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
        this.d();
    }

    protected static void refresh(Workspace ws) {
        ws.getDatasources().e();
    }

    public boolean save() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("save()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = WorkspaceNative.jni_Save(this.getHandle());
        if (bl) {
            WorkspaceSavedEvent workspaceSavedEvent = new WorkspaceSavedEvent(this, this);
            this.fireSaved(workspaceSavedEvent);
        }
        return bl;
    }

    public static boolean deleteWorkspace(WorkspaceConnectionInfo connectionInfo) {
        if (connectionInfo == null) {
            String string = InternalResource.loadString("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = connectionInfo.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = WorkspaceNative.jni_DeleteWorkspace(l);
        if (bl) {
            connectionInfo.clearHandle();
        }
        InternalHandleDisposable.makeSureNativeObjectLive(connectionInfo);
        return bl;
    }

    public static String[] getWorkspaceName(WorkspaceConnectionInfo connectionInfo) {
        if (connectionInfo == null) {
            String string = InternalResource.loadString("getWorkspaceName()", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = connectionInfo.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        if (connectionInfo.getType().equals(WorkspaceType.DEFAULT)) {
            stringArray = null;
        } else if (connectionInfo.getType().equals(WorkspaceType.SXW) || connectionInfo.getType().equals(WorkspaceType.SMW) || connectionInfo.getType().equals(WorkspaceType.SXWU) || connectionInfo.getType().equals(WorkspaceType.SMWU)) {
            String string = connectionInfo.getServer();
            stringArray = new String[]{string};
            if (string.toLowerCase().endsWith(".sxw")) {
                int n = string.toLowerCase().lastIndexOf(".sxw");
                stringArray[0] = string.substring(0, n);
            } else if (string.toLowerCase().endsWith(".smw")) {
                int n = string.toLowerCase().lastIndexOf(".smw");
                stringArray[0] = string.substring(0, n);
            } else if (string.toLowerCase().endsWith(".sxwu")) {
                int n = string.toLowerCase().lastIndexOf(".sxwu");
                stringArray[0] = string.substring(0, n);
            } else if (string.toLowerCase().endsWith(".smwu")) {
                int n = string.toLowerCase().lastIndexOf(".smwu");
                stringArray[0] = string.substring(0, n);
            }
        } else {
            stringArray = WorkspaceNative.jni_GetWorkspaceName(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(connectionInfo);
        return stringArray;
    }

    public Resources getResources() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getResources()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.o == null && (l = WorkspaceNative.jni_GetResources(this.getHandle())) != 0L) {
            this.o = new Resources(this, l);
        }
        return this.o;
    }

    public Scenes getScenes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScenes()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.f;
    }

    public Layouts getLayouts() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLayouts()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.p;
    }

    public boolean changePassword(String oldPassword, String newPassword) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("changePassword(String oldPassword, String newPassword)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (oldPassword == null || newPassword == null) {
            String string = InternalResource.loadString("password", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        return WorkspaceNative.jni_ChangePassword(this.getHandle(), oldPassword, newPassword);
    }

    void a(boolean bl) {
        WorkspaceNative.jni_Reset(this.getHandle(), bl);
    }

    @Override
    protected void clearHandle() {
        if (this.d != null) {
            this.d.c();
            this.d = null;
        }
        if (this.e != null) {
            this.e.clearHandle();
            this.e = null;
        }
        if (this.p != null) {
            this.p.clearHandle();
            this.p = null;
        }
        if (this.c != null) {
            this.c.clearHandle();
            this.c = null;
        }
        if (this.o != null) {
            this.o.clearHandle();
            this.o = null;
        }
        if (this.f != null) {
            this.f.clearHandle();
            this.f = null;
        }
        this.setHandle(0L);
    }

    License a() {
        return this.n;
    }

    private void a(WorkspaceConnectionInfo workspaceConnectionInfo) {
        WorkspaceConnectionInfoNative.jni_SetValue(this.getConnectionInfo().getHandle(), workspaceConnectionInfo.getHandle());
    }

    public synchronized void addOpenedListener(WorkspaceOpenedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setConnectionInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.g == null) {
            this.g = new CopyOnWriteArrayList();
        }
        if (!this.g.contains(listener)) {
            this.g.add(listener);
        }
    }

    public void removeOpenedListener(WorkspaceOpenedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeOpenedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.g != null && this.g.contains(listener)) {
            this.g.remove(listener);
        }
    }

    public synchronized void addCreatedListener(WorkspaceCreatedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addCreatedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.h == null) {
            this.h = new CopyOnWriteArrayList();
        }
        if (!this.h.contains(listener)) {
            this.h.add(listener);
        }
    }

    public void removeCreatedListener(WorkspaceCreatedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeCreatedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.h != null && this.h.contains(listener)) {
            this.h.remove(listener);
        }
    }

    public synchronized void addClosingListener(WorkspaceClosingListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addClosingListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i == null) {
            this.i = new CopyOnWriteArrayList();
        }
        if (!this.i.contains(listener)) {
            this.i.add(listener);
        }
    }

    public void removeClosingListener(WorkspaceClosingListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeClosingListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i != null && this.i.contains(listener)) {
            this.i.remove(listener);
        }
    }

    protected void fireOpened(WorkspaceOpenedEvent event) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireOpened()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.g != null) {
            CopyOnWriteArrayList<WorkspaceOpenedListener> copyOnWriteArrayList = this.g;
            for (WorkspaceOpenedListener workspaceOpenedListener : copyOnWriteArrayList) {
                workspaceOpenedListener.workspaceOpened(event);
            }
        }
    }

    protected void fireCreated(WorkspaceCreatedEvent event) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireCreated()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.h != null) {
            CopyOnWriteArrayList<WorkspaceCreatedListener> copyOnWriteArrayList = this.h;
            for (WorkspaceCreatedListener workspaceCreatedListener : copyOnWriteArrayList) {
                workspaceCreatedListener.workspaceCreated(event);
            }
        }
    }

    protected void fireClosing(WorkspaceClosingEvent event) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireClosing()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i != null) {
            CopyOnWriteArrayList<WorkspaceClosingListener> copyOnWriteArrayList = this.i;
            for (WorkspaceClosingListener workspaceClosingListener : copyOnWriteArrayList) {
                workspaceClosingListener.workspaceClosing(event);
            }
        }
    }

    public synchronized void addClosedListener(WorkspaceClosedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addClosedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.j == null) {
            this.j = new CopyOnWriteArrayList();
        }
        if (!this.j.contains(listener)) {
            this.j.add(listener);
        }
    }

    public void removeClosedListener(WorkspaceClosedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeClosedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.j != null && this.j.contains(listener)) {
            this.j.remove(listener);
        }
    }

    protected void fireClosed(WorkspaceClosedEvent event) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireClosed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.j != null) {
            CopyOnWriteArrayList<WorkspaceClosedListener> copyOnWriteArrayList = this.j;
            for (WorkspaceClosedListener workspaceClosedListener : copyOnWriteArrayList) {
                workspaceClosedListener.workspaceClosed(event);
            }
        }
    }

    public synchronized void addSavedAsListener(WorkspaceSavedAsListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addSavedAsListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.k == null) {
            this.k = new CopyOnWriteArrayList();
        }
        if (!this.k.contains(listener)) {
            this.k.add(listener);
        }
    }

    public void removeSavedAsListener(WorkspaceSavedAsListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeSavedAsListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.k != null && this.k.contains(listener)) {
            this.k.remove(listener);
        }
    }

    protected void fireSavedAs(WorkspaceSavedAsEvent event) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireClosed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.k != null) {
            CopyOnWriteArrayList<WorkspaceSavedAsListener> copyOnWriteArrayList = this.k;
            for (WorkspaceSavedAsListener workspaceSavedAsListener : copyOnWriteArrayList) {
                workspaceSavedAsListener.workspaceSavedAs(event);
            }
        }
    }

    public synchronized void addSavedListener(WorkspaceSavedListener listener) {
        if (this.l == null) {
            this.l = new CopyOnWriteArrayList();
        }
        if (!this.l.contains(listener)) {
            this.l.add(listener);
        }
    }

    public void removeSavedListener(WorkspaceSavedListener listener) {
        if (this.l != null && this.l.contains(listener)) {
            this.l.remove(listener);
        }
    }

    protected void fireSaved(WorkspaceSavedEvent event) {
        if (this.l != null) {
            CopyOnWriteArrayList<WorkspaceSavedListener> copyOnWriteArrayList = this.l;
            for (WorkspaceSavedListener workspaceSavedListener : copyOnWriteArrayList) {
                workspaceSavedListener.workspaceSaved(event);
            }
        }
    }

    public synchronized void addCaptionChangedListener(WorkspaceCaptionChangedListener listener) {
        if (this.m == null) {
            this.m = new CopyOnWriteArrayList();
        }
        if (!this.m.contains(listener)) {
            this.m.add(listener);
        }
    }

    public void removeCaptionChangedListener(WorkspaceCaptionChangedListener listener) {
        if (this.m != null && this.m.contains(listener)) {
            this.m.remove(listener);
        }
    }

    protected void fireCaptionChanged(WorkspaceCaptionChangedEvent event) {
        if (this.m != null) {
            CopyOnWriteArrayList<WorkspaceCaptionChangedListener> copyOnWriteArrayList = this.m;
            for (WorkspaceCaptionChangedListener workspaceCaptionChangedListener : copyOnWriteArrayList) {
                workspaceCaptionChangedListener.workspaceCaptionChanged(event);
            }
        }
    }

    static void b() {
        WorkspaceNative.jni_InitPlugins();
    }

    public String getDesktopInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDesktopInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetDesktopInfo(this.getHandle());
    }

    public void setDesktopInfo(String desktopInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDesktopInfo(String desktopInfo)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (desktopInfo == null) {
            desktopInfo = "";
        }
        WorkspaceNative.jni_SetDesktopInfo(this.getHandle(), desktopInfo);
    }

    static {
        Environment.LoadWrapJ();
        Workspace.b();
        License.setUGOBasePath(Environment.getUGOBasePath());
    }
}

