/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoPointEPSNative;
import com.supermap.data.GeometryEPS;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PointEPS;

public class GeoPointEPS
extends GeometryEPS {
    public GeoPointEPS() {
        long l = GeoPointEPSNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoPointEPS(PointEPS point) {
        this();
        this.add(point);
    }

    public GeoPointEPS(GeoPointEPS geoPoint) {
        if (geoPoint.getHandle() == 0L) {
            String string = InternalResource.loadString("geoPoint", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoPointEPSNative.jni_Clone(geoPoint.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoPoint);
    }

    GeoPointEPS(long handle) {
        this.setHandle(handle, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPointEPSNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            super.clearHandle();
        }
    }

    @Override
    public GeoPointEPS clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPointEPS(this);
    }
}

