/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CornerTextPositionType;
import com.supermap.data.Direction;
import com.supermap.data.Enum;
import com.supermap.data.GeoMapGridLineType;
import com.supermap.data.GeoMapGridNative;
import com.supermap.data.GeoMapGridType;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.GridShowWayType;
import com.supermap.data.HorizontalTextPositionType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.MapGridTextType;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.TextStyle;
import com.supermap.data.VerticalTextPositionType;

public class GeoMapGrid
extends Geometry {
    private GeoStyle a;
    private GeoStyle b;
    private GeoStyle c;
    private GeoStyle d;
    private TextStyle e;
    private PrjCoordSys f = null;

    public GeoMapGrid() {
        long l = GeoMapGridNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoMapGrid(GeoMapGrid geoMapGrid) {
        if (geoMapGrid == null) {
            String string = InternalResource.loadString("GeoMapGrid", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoMapGrid);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoMapGrid", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoMapGridNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoMapGrid);
    }

    GeoMapGrid(long handle) {
        this.setHandle(handle, false);
    }

    public GeoMapGridType getGridType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetGridType(this.getHandle());
        return (GeoMapGridType)Enum.parseUGCValue(GeoMapGridType.class, n);
    }

    public void setGridType(GeoMapGridType gridType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridType(GeoMapGridType gridType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (gridType == null) {
            String string = InternalResource.loadString("gridType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = gridType.value();
        GeoMapGridNative.jni_SetGridType(this.getHandle(), n);
    }

    public double getVerticalGridDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVerticalGridDistance()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetVerticalGridDistance(this.getHandle());
    }

    public void setVerticalGridDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVerticalGridDistance(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoMapGrid_VerticalDistanceShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getGridType() == GeoMapGridType.REFERENCEGRID) {
            String string = InternalResource.loadString("Type should not be REFERENCEGRID", "GeoMapGrid_TypeForbidden", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        GeoMapGridNative.jni_SetVerticalGridDistance(this.getHandle(), value);
    }

    public double getHorizontalGridDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHorizontalGridDistance()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetHorizontalGridDistance(this.getHandle());
    }

    public void setHorizontalGridDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHorizontalGridDistance(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoMapGrid_HorizontalDistanceShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getGridType() == GeoMapGridType.REFERENCEGRID) {
            String string = InternalResource.loadString("Type should not be REFERENCEGRID", "GeoMapGrid_TypeForbidden", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        GeoMapGridNative.jni_SetHorizontalGridDistance(this.getHandle(), value);
    }

    public GeoStyle getGridLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridLineStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l = GeoMapGridNative.jni_GetGridLineStyle(this.getHandle())) != 0L) {
            this.a = new GeoStyle(l);
        }
        return this.a;
    }

    public void setGridLineStyle(GeoStyle lineStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridLineStyle(GeoStyle lineStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (lineStyle == null) {
            String string = InternalResource.loadString("lineStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (lineStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("lineStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetGridLineStyle(this.getHandle(), lineStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(lineStyle);
    }

    public GeoStyle getBorderLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBorderLineStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.b == null && (l = GeoMapGridNative.jni_GetBorderLineStyle(this.getHandle())) != 0L) {
            this.b = new GeoStyle(l);
        }
        return this.b;
    }

    public void setBorderLineStyle(GeoStyle lineStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBorderLineStyle(GeoStyle lineStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (lineStyle == null) {
            String string = InternalResource.loadString("lineStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (lineStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("lineStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetBorderLineStyle(this.getHandle(), lineStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(lineStyle);
    }

    public GeoMapGridLineType getGridLineType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridLineType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetGridLineType(this.getHandle());
        return (GeoMapGridLineType)Enum.parseUGCValue(GeoMapGridLineType.class, n);
    }

    public void setGridLineType(GeoMapGridLineType gridLineType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridLineType(GeoMapGridLineType gridLineType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (gridLineType == null) {
            String string = InternalResource.loadString("GeoMapGridLineType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = gridLineType.value();
        GeoMapGridNative.jni_SetGridLineType(this.getHandle(), n);
    }

    public boolean isMajorDivisionTicksVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMajorDivisionTicksVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_IsMajorDivisionTicksVisible(this.getHandle());
    }

    public void setMajorDivisionTicksVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMajorDivisionTicksVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetMajorDivisionTicksVisible(this.getHandle(), value);
    }

    public GeoStyle getMajorDivisionTicksStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMajorDivisionTicksStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.c == null && (l = GeoMapGridNative.jni_GetMajorDivisionTicksStyle(this.getHandle())) != 0L) {
            this.c = new GeoStyle(l);
        }
        return this.c;
    }

    public void setMajorDivisionTicksStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMajorDivisionTicksStyle(GeoStyle geoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("geoStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetMajorDivisionTicksStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public boolean isMinorDivisionTicksVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMinorDivisionTicksVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_IsMinorDivisionTicksVisible(this.getHandle());
    }

    public void setMinorDivisionTicksVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinorDivisionTicksVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetMinorDivisionTicksVisible(this.getHandle(), value);
    }

    public GeoStyle getMinorDivisionTicksStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinorDivisionTicksStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.d == null && (l = GeoMapGridNative.jni_GetMinorDivisionTicksStyle(this.getHandle())) != 0L) {
            this.d = new GeoStyle(l);
        }
        return this.d;
    }

    public void setMinorDivisionTicksStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinorDivisionTicksStyle(GeoStyle geoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("geoStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetMinorDivisionTicksStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public double getMinorDivisionTicksCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinorDivisionTicksCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetMinorDivisionTicksCount(this.getHandle());
    }

    public void setMinorDivisionTicksCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinorDivisionTicksCount(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "GeoMapGrid_MinorDivisionTicksCountShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetMinorDivisionTicksCount(this.getHandle(), value);
    }

    public HorizontalTextPositionType getHorizontalTextPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHorizontalTextPositionType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetHorizontalTextPositionType(this.getHandle());
        return (HorizontalTextPositionType)Enum.parseUGCValue(HorizontalTextPositionType.class, n);
    }

    public void setHorizontalTextPosition(HorizontalTextPositionType positionType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHorizontalTextPositionType(HorizontalTextPositionType positionType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (positionType == null) {
            String string = InternalResource.loadString("positionType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = positionType.value();
        GeoMapGridNative.jni_SetHorizontalTextPositionType(this.getHandle(), n);
    }

    public VerticalTextPositionType getVerticalTextPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVerticalTextPositionType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetVerticalTextPositionType(this.getHandle());
        return (VerticalTextPositionType)Enum.parseUGCValue(VerticalTextPositionType.class, n);
    }

    public void setVerticalTextPosition(VerticalTextPositionType positionType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVerticalTextPositionType(VerticalTextPositionType positionType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (positionType == null) {
            String string = InternalResource.loadString("positionType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = positionType.value();
        GeoMapGridNative.jni_SetVerticalTextPositionType(this.getHandle(), n);
    }

    public TextStyle getGridLineTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridLineTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.e == null && (l = GeoMapGridNative.jni_GetGridLineTextStyle(this.getHandle())) != 0L) {
            this.e = new TextStyle(l);
        }
        return this.e;
    }

    public void setGridLineTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridLineTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetGridLineTextStyle(this.getHandle(), textStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    @Override
    public GeoMapGrid clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoMapGrid(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoMapGridNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public PrjCoordSys getPrjCoordSys() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.f == null && (l = GeoMapGridNative.jni_GetPrjCoordSys(this.getHandle())) != 0L) {
            this.f = PrjCoordSys.createInstance(l, false);
        }
        return this.f;
    }

    public void setPrjCoordSys(PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys prjCoordSys)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (prjCoordSys == null || InternalHandle.getHandle(prjCoordSys) == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetPrjCoordSys(this.getHandle(), prjCoordSys.getHandle());
    }

    public boolean getIsVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetIsVisible(this.getHandle());
    }

    public void setIsVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetIsVisible(this.getHandle(), value);
    }

    public MapGridTextType getMapGridTextType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapGridTextType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetMapGridTextType(this.getHandle());
        return (MapGridTextType)Enum.parseUGCValue(MapGridTextType.class, n);
    }

    public void setMapGridTextType(MapGridTextType mapGridTextType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapGridTextType(MapGridTextType mapGridTextType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (mapGridTextType == null) {
            String string = InternalResource.loadString("mapGridTextType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = mapGridTextType.value();
        GeoMapGridNative.jni_SetMapGridTextType(this.getHandle(), n);
    }

    public boolean getIsOnlyShowNote() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsOnlyShowNote()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetIsOnlyShowNote(this.getHandle());
    }

    public void setIsOnlyShowNote(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsOnlyShowNote(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetIsOnlyShowNote(this.getHandle(), value);
    }

    public int getNoteMaxLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNoteMaxLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetNoteMaxLength(this.getHandle());
    }

    public void setNoteMaxLength(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNoteMaxLength(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "ValueShouldNotBeNeagtive", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetNoteMaxLength(this.getHandle(), value);
    }

    public int getLabelTextOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabelTextOffset()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetLabelTextOffset(this.getHandle());
    }

    public void setLabelTextOffset(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLabelTextOffset(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "ValueShouldNotBeNeagtive", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetLabelTextOffset(this.getHandle(), value);
    }

    public boolean getIsAutoAdjustGridDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsAutoAdjustGridDistance()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetIsAutoAdjustGridDistance(this.getHandle());
    }

    public void setIsAutoAdjustGridDistance(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsAutoAdjustGridDistance(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetIsAutoAdjustGridDistance(this.getHandle(), value);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetName(this.getHandle());
    }

    public void setName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetName(this.getHandle(), name);
    }

    public Direction[] getLabelVisibleDirections() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabelVisibleDirections()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetLabelVisibleDirections(this.getHandle());
        return Direction.getDirections(n);
    }

    public void setLabelVisibleDirections(Direction[] directions) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLabelVisibleDirections(Direction direction)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (directions == null || directions.length > 4) {
            String string = InternalResource.loadString("directions", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = directions.length;
        int n2 = 0;
        for (Direction direction : directions) {
            n2 |= direction.value();
        }
        GeoMapGridNative.jni_SetLabelVisibleDirections(this.getHandle(), n2);
    }

    public Direction[] getVerticalLabelDirections() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVerticalLabelDirections()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetVerticalLabelDirections(this.getHandle());
        return Direction.getDirections(n);
    }

    public void setVerticalLabelDirections(Direction[] directions) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVerticalLabelDirections(Direction direction)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (directions == null || directions.length > 4) {
            String string = InternalResource.loadString("directions", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = directions.length;
        int n2 = 0;
        for (Direction direction : directions) {
            n2 |= direction.value();
        }
        GeoMapGridNative.jni_SetVerticalLabelDirections(this.getHandle(), n2);
    }

    public int getMaxDisplayDecimalLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxDisplayDecimalLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetMaxDisplayDecimalLength(this.getHandle());
    }

    public void setMaxDisplayDecimalLength(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxDisplayDecimalLength(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "ValueShouldNotBeNeagtive", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetMaxDisplayDecimalLength(this.getHandle(), value);
    }

    public int getCornerTextOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCornerTextOffsetX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetCornerTextOffsetX(this.getHandle());
    }

    public void setCornerTextOffsetX(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CornerTextOffsetX(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "ValueShouldNotBeNeagtive", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetCornerTextOffsetX(this.getHandle(), value);
    }

    public int getCornerTextOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCornerTextOffsetY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetCornerTextOffsetY(this.getHandle());
    }

    public void setCornerTextOffsetY(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCornerTextOffsetY(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "ValueShouldNotBeNeagtive", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetCornerTextOffsetY(this.getHandle(), value);
    }

    public CornerTextPositionType getCornerTextPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCornerTextPosition()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetCornerTextPosition(this.getHandle());
        return (CornerTextPositionType)Enum.parseUGCValue(CornerTextPositionType.class, n);
    }

    public void setCornerTextPosition(CornerTextPositionType cornerTextPosition) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCornerTextPosition(CornerTextPositionType value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (cornerTextPosition == null) {
            String string = InternalResource.loadString("cornerTextPosition", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = cornerTextPosition.value();
        GeoMapGridNative.jni_SetCornerTextPosition(this.getHandle(), n);
    }

    @Override
    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_toXML(this.getHandle());
    }

    public boolean FromXML(String gridXML) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (gridXML == null || gridXML.trim().length() == 0) {
            String string = InternalResource.loadString("gridXML", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoMapGridNative.jni_fromXML(this.getHandle(), gridXML);
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.b != null) {
            this.b.clearHandle();
            this.b = null;
        }
        if (this.c != null) {
            this.c.clearHandle();
            this.c = null;
        }
        if (this.d != null) {
            this.d.clearHandle();
            this.d = null;
        }
        if (this.e != null) {
            this.e.clearHandle();
            this.e = null;
        }
        if (this.f != null) {
            this.f.clearHandle();
            this.f = null;
        }
        this.setHandle(0L);
    }

    public void setGridShowWay(GridShowWayType showWayType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShowWay(ShowWayType showWayType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (showWayType == null) {
            String string = InternalResource.loadString("showWayType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = showWayType.value();
        GeoMapGridNative.jni_SetGridShowWayType(this.getHandle(), n);
    }

    public GridShowWayType getGridShowWay() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShowWay()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetGridShowWayType(this.getHandle());
        return (GridShowWayType)Enum.parseUGCValue(GridShowWayType.class, n);
    }
}

