/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.conversion.ExportSetting;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.InternalResource;
import java.io.File;

public class ExportSettingJPG
extends ExportSetting {
    private String h;
    private int i;

    public ExportSettingJPG() {
        this.h = "";
        this.d = FileType.JPG;
        this.i = 75;
    }

    public ExportSettingJPG(ExportSettingJPG exportSettingJPG) {
        super(exportSettingJPG);
        this.setWorldFilePath(exportSettingJPG.getWorldFilePath());
        this.setCompression(exportSettingJPG.getCompression());
        this.d = FileType.JPG;
    }

    public ExportSettingJPG(Object sourceData, String targetFilePath, FileType targetFileType) {
        super(sourceData, targetFilePath, targetFileType);
        this.h = "";
        this.d = FileType.JPG;
        this.i = 75;
    }

    public String getWorldFilePath() {
        return this.h;
    }

    public void setWorldFilePath(String path) {
        File file;
        File file2 = new File(path);
        if (file2.isDirectory()) {
            String string = this.getTargetFilePath();
            File file3 = new File(string);
            path = path + file3.getName() + ".tga";
        } else if (file2.getParent() != null && !(file = new File(file2.getParent())).exists()) {
            String string = InternalResource.loadString("", "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        this.h = path;
    }

    public int getCompression() {
        return this.i;
    }

    public void setCompression(int value) {
        if (value < 0 || value > 100) {
            String string = InternalResource.loadString("transparentColor", "ExportSettingJPG_TheCompressionShouldBetweenZeroAndHundred", "conversion_resources");
            throw new NullPointerException(string);
        }
        this.i = value;
    }

    @Override
    public FileType getTargetFileType() {
        return this.d;
    }

    @Override
    public void setTargetFileType(FileType type) {
        if (FileType.JPG != type) {
            String string = InternalResource.loadString("setTargetFileType(FileType type)", "SetTargetFileTypeIsNotAllowed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.d = FileType.JPG;
    }
}

