/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2Ds;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolPipeNodeNative;
import com.supermap.data.SymbolType;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class SymbolPipeNode
extends Symbol {
    SymbolPipeNode(long handle) {
        this.setHandle(handle, false);
    }

    public SymbolPipeNode() {
        long l = SymbolPipeNodeNative.jni_New();
        this.setHandle(l, true);
        this.a(null);
    }

    public SymbolPipeNode(BufferedImage thumbnail) {
        int n = thumbnail.getWidth();
        int n2 = thumbnail.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = thumbnail.getRGB(j, i);
            }
        }
        long l = SymbolPipeNodeNative.jni_New3(nArray, n, n2);
        this.setHandle(l, true);
    }

    public SymbolPipeNode(SymbolPipeNode symbolPipeNode) {
        if (symbolPipeNode == null) {
            String string = InternalResource.loadString("symbolPipeNode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(symbolPipeNode);
        if (l == 0L) {
            String string = InternalResource.loadString("symbolMarker3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = SymbolPipeNodeNative.jni_Clone(l);
        this.setHandle(l2, true);
    }

    @Override
    public boolean draw(Graphics graphics, Geometry geometry) {
        return false;
    }

    @Override
    public boolean draw(BufferedImage bitmap, Geometry geometry) {
        return false;
    }

    @Override
    public boolean draw(Graphics graphics, Point2Ds points, GeoStyle style) {
        return false;
    }

    @Override
    public boolean draw(BufferedImage bitmap, Point2Ds points, GeoStyle style) {
        return false;
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            SymbolPipeNodeNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    @Override
    public SymbolType getType() {
        return SymbolType.PIPENODE;
    }

    public void setThumbnail(BufferedImage image) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setThumnnail(image)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = image.getWidth();
        int n2 = image.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = image.getRGB(j, i);
            }
        }
        SymbolPipeNodeNative.jni_SetImage(this.getHandle(), nArray, n, n2);
    }

    public BufferedImage getThumbnail() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getThumnnail()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        int[] nArray2 = SymbolPipeNodeNative.jni_GetImage(this.getHandle(), nArray);
        BufferedImage bufferedImage = null;
        int n = nArray[0];
        int n2 = nArray[1];
        if (nArray2 != null && n > 0 && n2 > 0) {
            bufferedImage = new BufferedImage(n, n2, 4);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    bufferedImage.setRGB(j, i, nArray2[i * n + j]);
                }
            }
        }
        return bufferedImage;
    }

    public double getCoverLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoverLength", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolPipeNodeNative.jni_GetCoverLength(this.getHandle());
    }

    public void setCoverLength(double coverLength) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCoverLength", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolPipeNodeNative.jni_SetCoverLength(this.getHandle(), coverLength);
    }

    public int getSliceNum() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSliceNum", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolPipeNodeNative.jni_GetSliceNum(this.getHandle());
    }

    public void setSliceNum(int sliceNum) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSliceNum", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolPipeNodeNative.jni_SetSliceNum(this.getHandle(), sliceNum);
    }
}

