/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoPointNative;
import com.supermap.data.GeoUserDefinedNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Rectangle2D;

public class GeoUserDefined
extends Geometry {
    public GeoUserDefined() {
        long l = GeoUserDefinedNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoUserDefined(GeoUserDefined geoUser) {
        if (geoUser.getHandle() == 0L) {
            String string = InternalResource.loadString("geoUserDefined", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoPointNative.jni_Clone(geoUser.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoUser);
    }

    GeoUserDefined(long handle) {
        this.setHandle(handle, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoUserDefinedNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            super.clearHandle();
        }
    }

    @Override
    public GeoUserDefined clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoUserDefined(this);
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoUserDefinedNative.jni_SetEmpty(this.getHandle());
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoUserDefinedNative.jni_IsEmpty(this.getHandle());
    }

    public boolean setGeoData(Rectangle2D rcBounds, byte[] geoData) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGeoData()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{rcBounds.getLeft(), rcBounds.getBottom(), rcBounds.getRight(), rcBounds.getTop()};
        return GeoUserDefinedNative.jni_SetGeoData(this.getHandle(), dArray, geoData);
    }

    public byte[] getGeoData() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGeoData()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoUserDefinedNative.jni_GetGeoData(this.getHandle());
    }
}

