/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLineNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import java.util.ArrayList;

public class GeoLine
extends Geometry {
    private ArrayList a;

    public GeoLine() {
        long l = GeoLineNative.jni_New();
        this.setHandle(l, true);
        this.a = new ArrayList();
    }

    public GeoLine(GeoLine geoLine) {
        if (geoLine == null) {
            String string = InternalResource.loadString("geoLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLine.getHandle() == 0L) {
            String string = InternalResource.loadString("geoLine", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoLineNative.jni_Clone(geoLine.getHandle());
        this.setHandle(l, true);
        this.a = new ArrayList();
        for (int i = 0; i < geoLine.a().size(); ++i) {
            Point2Ds point2Ds = (Point2Ds)geoLine.a().get(i);
            this.a.add(point2Ds.clone());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLine);
    }

    public GeoLine(Point2Ds points) {
        this();
        this.addPart(points);
    }

    GeoLine(long handle) {
        this.setHandle(handle, false);
        this.a = new ArrayList();
        this.b();
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public GeoLine clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoLine(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoLineNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineNative.jni_GetLength(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineNative.jni_GetPartCount(this.getHandle());
    }

    public int addPart(Point2Ds points) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = points.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("points", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = points.getItem(n).getX();
            dArray2[n] = points.getItem(n).getY();
        }
        n = GeoLineNative.jni_AddPart(this.getHandle(), dArray, dArray2);
        Point2Ds point2Ds = new Point2Ds(points, this);
        this.a.add(point2Ds);
        return n;
    }

    public boolean removePart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoLineNative.jni_RemovePart(this.getHandle(), index);
        if (bl) {
            this.a.remove(index);
        }
        return bl;
    }

    public GeoRegion convertToRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToRegion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoLineNative.jni_ConvertToRegion(this.getHandle());
        GeoRegion geoRegion = new GeoRegion(l);
        geoRegion.setIsDisposable(true);
        if (this.getPartCount() != geoRegion.getPartCount()) {
            String string = InternalResource.loadString("convertToRegion", "GeoLine_UnsupportOperation", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return geoRegion;
    }

    public Point2D findPointOnLineByDistance(double distance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPointOnLineByDistance(double distance)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (distance < 0.0) {
            String string = InternalResource.loadString("distance", "GeoLine_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2D point2D = new Point2D();
        if (this.getPartCount() > 0) {
            double[] dArray = new double[2];
            GeoLineNative.jni_FindPointOnLineByDistance(this.getHandle(), distance, dArray);
            point2D.setX(dArray[0]);
            point2D.setY(dArray[1]);
        }
        return point2D;
    }

    public Point2Ds getPart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (Point2Ds)this.a.get(index);
    }

    public boolean insertPart(int index, Point2Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = points.getCount();
        if (n < 2) {
            String string = InternalResource.loadString("Point2Ds", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int n2 = this.getPartCount();
        if (n2 == index) {
            int n3 = this.addPart(points);
            boolean bl2 = bl = n3 == index;
            if (bl) {
                Point2Ds point2Ds = new Point2Ds(points, this);
                this.a.add(index, point2Ds);
            }
            return bl;
        }
        if (index < 0 || index > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        bl = GeoLineNative.jni_InsertPart(this.getHandle(), index, dArray, dArray2);
        if (bl) {
            Point2Ds point2Ds = new Point2Ds(points, this);
            this.a.add(index, point2Ds);
        }
        return bl;
    }

    public boolean reverse() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverse()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = GeoLineNative.jni_Reverse(this.getHandle());
        this.c();
        return bl;
    }

    public boolean setPart(int index, Point2Ds points) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = points.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("Point2Ds", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = points.getItem(n).getX();
            dArray2[n] = points.getItem(n).getY();
        }
        n = GeoLineNative.jni_SetPart(this.getHandle(), index, dArray, dArray2) ? 1 : 0;
        if (n == 1) {
            Point2Ds point2Ds = (Point2Ds)this.a.get(index);
            Point2Ds point2Ds2 = new Point2Ds(points, this);
            this.a.set(index, point2Ds2);
            point2Ds.a(Point2Ds.a.a);
        }
        return n != 0;
    }

    boolean a(int n, Point2Ds point2Ds) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPartJustToUGC(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = point2Ds.getCount();
        if (n3 < 2) {
            String string = InternalResource.loadString("Point2Ds", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = point2Ds.getItem(n2).getX();
            dArray2[n2] = point2Ds.getItem(n2).getY();
        }
        n2 = GeoLineNative.jni_SetPart(this.getHandle(), n, dArray, dArray2) ? 1 : 0;
        return n2 != 0;
    }

    public int indexOf(Point2Ds part) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(Point2Ds part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.indexOf(part);
    }

    @Override
    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = super.fromXML(xml);
        if (bl) {
            this.b();
        }
        return bl;
    }

    @Override
    public Geometry mirror(Point2D startPoint, Point2D endPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mirror(Point2D startPoint, Point2D endPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLine geoLine = (GeoLine)super.mirror(startPoint, endPoint);
        int n = geoLine.getPartCount();
        geoLine.a = new ArrayList();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = new Point2Ds(geoLine.a(i));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, geoLine);
            geoLine.a.add(point2Ds2);
        }
        return geoLine;
    }

    @Override
    public void offset(double dx, double dy) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.offset(dx, dy);
        this.c();
    }

    @Override
    public void resize(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("resize(Rectangle2D bounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.resize(bounds);
        this.c();
    }

    @Override
    public void rotate(Point2D basePoint, double angle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.rotate(basePoint, angle);
        this.c();
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineNative.jni_Clear(this.getHandle());
        this.a.clear();
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
    }

    ArrayList a() {
        return this.a;
    }

    private Point2D[] a(int n) {
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = GeoLineNative.jni_GetPartPointCount(this.getHandle(), n);
        if (n2 > 1) {
            Point2D[] point2DArray = new Point2D[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            GeoLineNative.jni_GetPart(this.getHandle(), n, dArray, dArray2);
            for (int i = 0; i < n2; ++i) {
                point2DArray[i] = new Point2D(dArray[i], dArray2[i]);
            }
            return point2DArray;
        }
        return null;
    }

    private void c() {
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = (Point2Ds)this.a.get(i);
            point2Ds.a(Point2Ds.a.a);
            point2Ds.clear();
            point2Ds.addRange(this.a(i));
            point2Ds.a(Point2Ds.a.b);
        }
    }

    void b() {
        int n = this.getPartCount();
        this.a.clear();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = new Point2Ds(this.a(i));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
            this.a.add(point2Ds2);
        }
    }
}

