/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetClosedEvent;
import com.supermap.data.DatasetClosedListener;
import com.supermap.data.DatasetClosingEvent;
import com.supermap.data.DatasetClosingListener;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridCollection;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetImageCollection;
import com.supermap.data.DatasetImageNative;
import com.supermap.data.DatasetLockChangedEvent;
import com.supermap.data.DatasetLockChangedListener;
import com.supermap.data.DatasetMosaic;
import com.supermap.data.DatasetNative;
import com.supermap.data.DatasetTopology;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVolume;
import com.supermap.data.Datasource;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.GeoStoreType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;
import com.supermap.data.LockStateType;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import com.supermap.data.ToolkitNative;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Dataset
extends InternalHandle {
    private transient ReentrantLock e = new ReentrantLock();
    private boolean f = true;
    protected Datasource m_datasource = null;
    protected DatasetType m_datasetType = null;
    protected boolean m_bTypeChanged = false;
    protected long m_ugcRawPointerHandle = 0L;
    private boolean g = true;
    transient CopyOnWriteArrayList<DatasetClosingListener> a;
    transient CopyOnWriteArrayList<DatasetClosedListener> b;
    transient CopyOnWriteArrayList<DatasetLockChangedListener> c;
    transient CopyOnWriteArrayList<SteppedListener> d;
    protected long m_selfEventHandle;
    protected static String m_senderMethodName;
    private PrjCoordSys h;

    protected Dataset() {
        m_senderMethodName = "PJConvert";
    }

    public void setPrjCoordSys(PrjCoordSys value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            DatasetNative.jni_UnSetPrjCoordSys(this.getHandle());
            if (this.h != null) {
                this.h.clearHandle();
                this.h = null;
            }
        } else {
            long l = InternalHandle.getHandle(value);
            if (l == 0L) {
                String string = InternalResource.loadString("value", "Global_InvalidConstructorArgument", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetNative.jni_Open(this.getHandle());
            boolean bl = DatasetNative.jni_setPrjCoordSys(this.getHandle(), l);
            if (bl) {
                this.h = value.clone();
            }
            InternalHandleDisposable.makeSureNativeObjectLive(value);
        }
    }

    public PrjCoordSys getPrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DatasetNative.jni_getPrjCoordSys(this.getHandle());
        if (l != 0L) {
            this.h = PrjCoordSys.createInstance(l, false);
        }
        return this.h;
    }

    public boolean isVersioned() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hasVersion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_hasVersion(this.getHandle());
    }

    public boolean hasPrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_HasSetPrjCoordSys(this.getHandle());
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DatasetNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{value.getLeft(), value.getBottom(), value.getRight(), value.getTop()};
        DatasetNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public boolean isReadOnly() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = this.m_datasource.isReadOnly();
        boolean bl2 = DatasetNative.jni_GetIsReadOnly(this.getHandle());
        return bl || bl2;
    }

    public boolean isOpen() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetIsOpen(this.getHandle());
    }

    public Datasource getDatasource() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasource;
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        DatasetNative.jni_SetDescription(this.getHandle(), value);
    }

    public String getExtInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetExtInfo(this.getHandle());
    }

    public void setExtInfo(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        if (value.length() > 2047) {
            throw new IllegalStateException("The length is outof range");
        }
        DatasetNative.jni_SetExtInfo(this.getHandle(), value);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetName(this.getHandle());
    }

    public String getSchema() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetSchema(this.getHandle());
    }

    public String getTableName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetTableName(this.getHandle());
    }

    public int getID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetID(this.getHandle());
    }

    public DatasetType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetType == null || this.m_bTypeChanged) {
            int n = DatasetNative.jni_GetType(this.getHandle());
            try {
                this.m_datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, n);
                this.m_bTypeChanged = false;
            }
            catch (RuntimeException runtimeException) {
                if (n == DatasetType.a.getUGCValue()) {
                    this.m_datasetType = DatasetType.GRID;
                }
                throw runtimeException;
            }
        }
        return this.m_datasetType;
    }

    public GeoStoreType getGeoStoreType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetNative.jni_GetGeoStoreType(this.getHandle());
        return (GeoStoreType)Enum.parseUGCValue(GeoStoreType.class, n);
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n);
    }

    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetClosingEvent datasetClosingEvent = new DatasetClosingEvent(this, this);
        this.fireClosing(datasetClosingEvent);
        if (datasetClosingEvent.getCancel()) {
            return;
        }
        DatasetNative.jni_Close(this.getHandle());
        DatasetClosedEvent datasetClosedEvent = new DatasetClosedEvent(this, this);
        this.fireClosed(datasetClosedEvent);
    }

    public boolean open() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_Open(this.getHandle());
    }

    boolean a(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (!this.m_datasource.getDatasets().isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("newName", "Dataset_NameIsNotAvailabe", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        boolean bl = DatasetNative.jni_Rename(this.getHandle(), string);
        return bl;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetNative.jni_SetReadOnly(this.getHandle(), readOnly);
    }

    @Override
    protected void clearHandle() {
        this.m_datasource = null;
        this.h = null;
        this.setHandle(0L);
    }

    static InternalInvalidState b(String string) {
        int n = ToolkitNative.jni_IsValidDatasetName(string);
        if (n == -1) {
            return null;
        }
        return (InternalInvalidState)Enum.parseUGCValue(InternalInvalidState.class, n);
    }

    protected static Dataset createInstance(long dtHandle, DatasetType javaType, Datasource datasource) {
        if (dtHandle == 0L) {
            String string = InternalResource.loadString("", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalStateException(string);
        }
        Dataset dataset = null;
        dataset = javaType.equals(DatasetType.IMAGE) || javaType.equals(DatasetType.WCS) || javaType.equals(DatasetType.WMS) ? new DatasetImage(dtHandle, datasource) : (javaType.equals(DatasetType.GRID) || javaType.equals(DatasetType.a) ? new DatasetGrid(dtHandle, datasource) : (javaType.equals(DatasetType.VOLUME) ? new DatasetVolume(dtHandle, datasource) : (javaType.equals(DatasetType.CAD) || javaType.equals(DatasetType.LINE) || javaType.equals(DatasetType.POINT) || javaType.equals(DatasetType.REGION) || javaType.equals(DatasetType.TABULAR) || javaType.equals(DatasetType.LINEM) || javaType.equals(DatasetType.NETWORK) || javaType.equals(DatasetType.LINKTABLE) || javaType.equals(DatasetType.TEXT) || javaType.equals(DatasetType.POINT3D) || javaType.equals(DatasetType.LINE3D) || javaType.equals(DatasetType.REGION3D) || javaType.equals(DatasetType.PARAMETRICLINE) || javaType.equals(DatasetType.PARAMETRICREGION) || javaType.equals(DatasetType.PARAMETRICPOINT) || javaType.equals(DatasetType.PARAMETRICTEXT) || javaType.equals(DatasetType.MODEL) || javaType.equals(DatasetType.NETWORK3D) || javaType.equals(DatasetType.POINTEPS) || javaType.equals(DatasetType.LINEEPS) || javaType.equals(DatasetType.REGIONEPS) || javaType.equals(DatasetType.TEXTEPS) || javaType.equals(DatasetType.ENTITY) || javaType.equals(DatasetType.VECTORCOLLECTION) || javaType.equals(DatasetType.VIDEO) ? new DatasetVector(dtHandle, datasource) : (javaType.equals(DatasetType.TOPOLOGY) ? new DatasetTopology(dtHandle, datasource) : (javaType.equals(DatasetType.GRIDCOLLECTION) ? new DatasetGridCollection(dtHandle, datasource) : (javaType.equals(DatasetType.IMAGECOLLECTION) ? new DatasetImageCollection(dtHandle, datasource) : (javaType.equals(DatasetType.MOSAIC) ? new DatasetMosaic(dtHandle, datasource) : null)))))));
        return dataset;
    }

    protected static boolean isVector(Dataset dataset) {
        boolean bl = true;
        bl = dataset == null || dataset.getHandle() == 0L ? false : dataset.a();
        return bl;
    }

    private boolean a() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetIsVector(this.getHandle());
    }

    public synchronized void addClosingListener(DatasetClosingListener l) {
        if (this.a == null) {
            this.a = new CopyOnWriteArrayList();
        }
        if (!this.a.contains(l)) {
            this.a.add(l);
        }
    }

    public void removeClosingListener(DatasetClosingListener l) {
        if (this.a != null && this.a.contains(l)) {
            this.a.remove(l);
        }
    }

    protected void fireClosing(DatasetClosingEvent event) {
        if (this.a != null) {
            CopyOnWriteArrayList<DatasetClosingListener> copyOnWriteArrayList = this.a;
            for (DatasetClosingListener datasetClosingListener : copyOnWriteArrayList) {
                datasetClosingListener.datasetClosing(event);
            }
        }
    }

    protected void fireLockChanged(DatasetLockChangedEvent event) {
        if (this.c != null) {
            CopyOnWriteArrayList<DatasetLockChangedListener> copyOnWriteArrayList = this.c;
            for (DatasetLockChangedListener datasetLockChangedListener : copyOnWriteArrayList) {
                datasetLockChangedListener.datasetLockChanged(event);
            }
        }
    }

    public synchronized void addLockChangedListener(DatasetLockChangedListener l) {
        if (this.c == null) {
            this.c = new CopyOnWriteArrayList();
        }
        if (!this.c.contains(l)) {
            this.c.add(l);
        }
    }

    public void removeLockChangedListener(DatasetLockChangedListener l) {
        if (this.c != null && this.c.contains(l)) {
            this.c.remove(l);
        }
    }

    public synchronized void addClosedListener(DatasetClosedListener l) {
        if (this.b == null) {
            this.b = new CopyOnWriteArrayList();
        }
        if (!this.b.contains(l)) {
            this.b.add(l);
        }
    }

    public void removeClosedListener(DatasetClosedListener l) {
        if (this.b != null && this.b.contains(l)) {
            this.b.remove(l);
        }
    }

    protected void fireClosed(DatasetClosedEvent event) {
        if (this.b != null) {
            CopyOnWriteArrayList<DatasetClosedListener> copyOnWriteArrayList = this.b;
            for (DatasetClosedListener datasetClosedListener : copyOnWriteArrayList) {
                datasetClosedListener.datasetClosed(event);
            }
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.d == null) {
            this.d = new CopyOnWriteArrayList();
        }
        if (!this.d.contains(l)) {
            this.d.add(l);
        }
    }

    public void removeSteppedListener(SteppedListener l) {
        if (this.d != null && this.d.contains(l)) {
            this.d.remove(l);
        }
    }

    public LockStateType getLockState() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetNative.jni_GetLockState(this.getHandle());
        LockStateType lockStateType = null;
        try {
            lockStateType = (LockStateType)Enum.parseUGCValue(LockStateType.class, n);
        }
        catch (Exception exception) {
            lockStateType = LockStateType.LOCKNONE;
        }
        return lockStateType;
    }

    public synchronized boolean setLockState(LockStateType lockType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = lockType.getUGCValue();
        boolean bl = DatasetNative.jni_SetLockState(this.getHandle(), n);
        if (bl) {
            DatasetLockChangedEvent datasetLockChangedEvent = new DatasetLockChangedEvent(this, this);
            this.fireLockChanged(datasetLockChangedEvent);
        }
        return bl;
    }

    public void refresh() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetNative.jni_Refresh(this.getHandle());
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.d != null) {
            CopyOnWriteArrayList<SteppedListener> copyOnWriteArrayList = this.d;
            for (SteppedListener steppedListener : copyOnWriteArrayList) {
                steppedListener.stepped(event);
            }
        }
    }

    static void steppedCallBack(Dataset source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            boolean bl = Toolkit.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent(source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            Toolkit.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DatasetImageNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public boolean isDisposed() {
        return this.m_datasource == null || this.m_datasource.getHandle() == 0L || this.getHandle() == 0L;
    }

    protected boolean getIsDisposable() {
        return this.f;
    }

    protected void setIsDisposable(boolean disposable) {
        this.f = disposable;
    }

    protected boolean isNeedDispose() {
        return this.g;
    }

    protected void setNeedDispose(boolean bNeedDispose) {
        this.g = bNeedDispose;
    }

    protected void finalize() {
        if (this.getIsDisposable() && this.getHandle() != 0L) {
            this.dispose();
        }
    }

    public void dispose() {
        this.e.lock();
        try {
            if (!this.getIsDisposable()) {
                String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (this.getHandle() != 0L && this.isNeedDispose()) {
                DatasetNative.jni_Delete(this.getHandle());
                this.clearHandle();
            }
        }
        finally {
            this.e.unlock();
        }
    }

    protected long getRawPointerHandle() {
        return DatasetNative.jni_GetRawPointerHandle(this.getHandle());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().toString().equals(obj.getClass().toString())) {
            return false;
        }
        Dataset dataset = (Dataset)obj;
        return this.m_ugcRawPointerHandle == dataset.m_ugcRawPointerHandle;
    }

    public int hashCode() {
        return (int)(this.m_ugcRawPointerHandle ^ this.m_ugcRawPointerHandle >>> 32);
    }
}

