/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CodeInfoNative;
import com.supermap.data.Enum;
import com.supermap.data.FieldType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Pattern;

public class CodeInfo
extends InternalHandleDisposable {
    public CodeInfo() {
        long l = CodeInfoNative.jni_New();
        this.setHandle(l, true);
    }

    protected CodeInfo(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle, true);
    }

    public CodeInfo(FieldType fieldtype, Object value, String desc) {
        if (null == value || null == desc || desc.isEmpty()) {
            String string = InternalResource.loadString("codeinfo", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        String string = value.toString();
        if (fieldtype.equals(FieldType.INT16)) {
            l = CodeInfoNative.jni_New1(Short.valueOf(string), desc);
        } else if (fieldtype.equals(FieldType.INT32)) {
            l = CodeInfoNative.jni_New2(Integer.valueOf(string), desc);
        } else if (fieldtype.equals(FieldType.INT64)) {
            l = CodeInfoNative.jni_New7(Long.valueOf(string), desc);
        } else if (fieldtype.equals(FieldType.SINGLE)) {
            l = CodeInfoNative.jni_New3(Float.valueOf(string).floatValue(), desc);
        } else if (fieldtype.equals(FieldType.DOUBLE)) {
            l = CodeInfoNative.jni_New4(Double.valueOf(string), desc);
        } else if (fieldtype.equals(FieldType.TEXT)) {
            l = CodeInfoNative.jni_New6(String.valueOf(string), desc);
        } else if (fieldtype.equals(FieldType.WTEXT)) {
            l = CodeInfoNative.jni_New8(String.valueOf(string), desc);
        } else if (fieldtype.equals(FieldType.BYTE)) {
            l = CodeInfoNative.jni_New8(String.valueOf(string), desc);
        } else if (fieldtype.equals(FieldType.CHAR)) {
            l = CodeInfoNative.jni_New8(String.valueOf(string), desc);
        } else if (fieldtype.equals(FieldType.DATETIME)) {
            Serializable serializable;
            Date date = null;
            if (value instanceof String) {
                String string2;
                serializable = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s((([0-1]?[0-9])|(2?[0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
                if (((Pattern)serializable).matcher(string2 = (String)value).matches()) {
                    String string3 = System.getProperty("os.name").toLowerCase();
                    if (string3.equals("aix")) {
                        try {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            date = simpleDateFormat.parse(string2);
                        }
                        catch (ParseException parseException) {
                            try {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                date = simpleDateFormat.parse(string2);
                            }
                            catch (ParseException parseException2) {}
                        }
                    } else {
                        try {
                            date = DateFormat.getDateInstance().parse(string2);
                        }
                        catch (ParseException parseException) {}
                    }
                }
            } else {
                date = (Date)value;
            }
            serializable = new GregorianCalendar(Locale.getDefault());
            ((Calendar)serializable).setTime(date);
            int n = ((Calendar)serializable).get(1);
            int n2 = ((Calendar)serializable).get(2) + 1;
            int n3 = ((Calendar)serializable).get(5);
            int n4 = ((Calendar)serializable).get(11);
            int n5 = ((Calendar)serializable).get(12);
            int n6 = ((Calendar)serializable).get(13);
            l = CodeInfoNative.jni_New5(n, n2, n3, n4, n5, n6, desc);
        }
        this.setHandle(l, true);
    }

    public CodeInfo(CodeInfo codeinfo) {
        if (codeinfo.getHandle() == 0L) {
            String string = InternalResource.loadString("codeinfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = CodeInfoNative.jni_Clone(codeinfo.getHandle());
        this.setHandle(l, true);
    }

    public FieldType getValueType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = CodeInfoNative.jni_GetValueType(this.getHandle());
        return (FieldType)Enum.parseUGCValue(FieldType.class, n);
    }

    public void setValueType(FieldType fieldType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeInfoNative.jni_SetValueType(this.getHandle(), fieldType.value());
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String desc) {
        if (null == desc || desc.isEmpty()) {
            String string = InternalResource.loadString("codeinfo", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        CodeInfoNative.jni_SetDescription(this.getHandle(), desc);
    }

    public Object getValue() {
        FieldType fieldType = this.getValueType();
        if (fieldType.equals(FieldType.INT16)) {
            Short s = this.getInt16();
            return s;
        }
        if (fieldType.equals(FieldType.INT32)) {
            Integer n = this.getInt32();
            return n;
        }
        if (fieldType.equals(FieldType.INT64)) {
            return this.getInt64();
        }
        if (fieldType.equals(FieldType.SINGLE)) {
            Float f2 = Float.valueOf(this.getSingle());
            return f2;
        }
        if (fieldType.equals(FieldType.DOUBLE)) {
            Double d2 = this.getDouble();
            return d2;
        }
        if (fieldType.equals(FieldType.DATETIME)) {
            Date date = this.getDateTime();
            return date;
        }
        if (fieldType.equals(FieldType.TEXT)) {
            String string = this.getString();
            return string;
        }
        if (fieldType.equals(FieldType.WTEXT)) {
            String string = this.getString();
            return string;
        }
        if (fieldType.equals(FieldType.BYTE)) {
            Byte by = this.getString().getBytes()[0];
            return by;
        }
        if (fieldType.equals(FieldType.CHAR)) {
            char c2 = this.getString().charAt(0);
            return Character.valueOf(c2);
        }
        return null;
    }

    public void setValue(Object value) {
        FieldType fieldType = this.getValueType();
        if (fieldType.equals(FieldType.INT16)) {
            this.setInt16(Short.valueOf(value.toString()));
        } else if (fieldType.equals(FieldType.INT32)) {
            this.setInt32(Integer.valueOf(value.toString()));
        } else if (fieldType.equals(FieldType.INT64)) {
            this.setInt64(Long.valueOf(value.toString()));
        } else if (fieldType.equals(FieldType.SINGLE)) {
            this.setSingle(Float.valueOf(value.toString()).floatValue());
        } else if (fieldType.equals(FieldType.DOUBLE)) {
            this.setDouble(Double.valueOf(value.toString()));
        } else if (fieldType.equals(FieldType.TEXT)) {
            this.setString(value.toString());
        } else if (fieldType.equals(FieldType.WTEXT)) {
            this.setString(value.toString());
        } else if (fieldType.equals(FieldType.BYTE)) {
            this.setString(value.toString());
        } else if (fieldType.equals(FieldType.CHAR)) {
            this.setString(value.toString());
        } else if (fieldType.equals(FieldType.DATETIME)) {
            Date date = null;
            if (value instanceof String) {
                String string;
                Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s((([0-1]?[0-9])|(2?[0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
                if (pattern.matcher(string = (String)value).matches()) {
                    String string2 = System.getProperty("os.name").toLowerCase();
                    if (string2.equals("aix")) {
                        try {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            date = simpleDateFormat.parse(string);
                        }
                        catch (ParseException parseException) {
                            try {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                date = simpleDateFormat.parse(string);
                            }
                            catch (ParseException parseException2) {}
                        }
                    } else {
                        try {
                            date = DateFormat.getDateInstance().parse(string);
                        }
                        catch (ParseException parseException) {}
                    }
                }
            } else {
                date = (Date)value;
            }
            this.setDateTime(date);
        }
    }

    public short getInt16() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetInt16(this.getHandle());
    }

    public int getInt32() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetInt32(this.getHandle());
    }

    public long getInt64() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetInt64(this.getHandle());
    }

    public float getSingle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetSingle(this.getHandle());
    }

    public double getDouble() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetDouble(this.getHandle());
    }

    public Date getDateTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s((([0-1]?[0-9])|(2?[0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        String string = CodeInfoNative.jni_GetDateTime(this.getHandle());
        Date date = null;
        if (pattern.matcher(string).matches()) {
            try {
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                ((SimpleDateFormat)dateFormat).applyPattern("yyyy-MM-dd HH:mm:ss");
                date = dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public String getString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetString(this.getHandle());
    }

    public void setInt16(short value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeInfoNative.jni_SetInt16(this.getHandle(), value);
    }

    public void setInt32(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeInfoNative.jni_SetInt32(this.getHandle(), value);
    }

    public void setInt64(long value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeInfoNative.jni_SetInt64(this.getHandle(), value);
    }

    public void setSingle(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeInfoNative.jni_SetSingle(this.getHandle(), value);
    }

    public void setDouble(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeInfoNative.jni_SetDouble(this.getHandle(), value);
    }

    public void setDateTime(Date value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
        gregorianCalendar.setTime(value);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        CodeInfoNative.jni_SetDateTime(this.getHandle(), n, n2, n3, n4, n5, n6);
    }

    public void setString(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeInfoNative.jni_SetString(this.getHandle(), value);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            CodeInfoNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }
}

