/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.BufferAnalystGeometryNative;
import com.supermap.analyst.spatialanalyst.BufferAnalystParameter;
import com.supermap.analyst.spatialanalyst.BufferEndType;
import com.supermap.analyst.spatialanalyst.BufferRadiusUnit;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkit;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Toolkit;

public class BufferAnalystGeometry {
    private BufferAnalystGeometry() {
    }

    public static GeoRegion createBuffer(Geometry geometry, BufferAnalystParameter bufferAnalystParameter) {
        GeoRegion geoRegion = BufferAnalystGeometry.createBuffer(geometry, bufferAnalystParameter, null);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(bufferAnalystParameter);
        return geoRegion;
    }

    public static GeoRegion createBuffer(Geometry geometry, BufferAnalystParameter bufferAnalystParameter, PrjCoordSys prjCoordSys) {
        double d2;
        BufferEndType bufferEndType = bufferAnalystParameter.getEndType();
        int n = bufferAnalystParameter.getSemicircleLineSegment();
        Object object = bufferAnalystParameter.getLeftDistance();
        Object object2 = bufferAnalystParameter.getRightDistance();
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "geometryspatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "geometryspatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        long l2 = 0L;
        if (prjCoordSys != null && (l2 = InternalHandle.getHandle(prjCoordSys)) == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Handle_ObjectHasBeenDisposed", "geometryspatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n2 = -1;
        GeoRegion geoRegion = null;
        GeometryType geometryType = geometry.getType();
        if (bufferEndType.equals(BufferEndType.FLAT)) {
            long l3;
            if (object == null && object2 == null) {
                String string = InternalResource.loadString("objLeftDistance and objRightDistance", "Global_ArgumentNull", "geometryspatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (geometryType != GeometryType.GEOLINE) {
                String string = InternalResource.loadString("geometry", "BufferAnalyst_BufferGeometryTypeShouldBeLine", "geometryspatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (object instanceof String || object2 instanceof String) {
                String string = InternalResource.loadString("LeftDistance and RightDistance", "BufferAnalyst_DistenceOfStringTypeIsInvalidForGeometryBuffer", "geometryspatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            d2 = InternalToolkit.objectToDouble(object);
            double d3 = InternalToolkit.objectToDouble(object2);
            if (object != null && d2 <= 0.0) {
                String string = InternalResource.loadString("leftDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "geometryspatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (object2 != null && d3 <= 0.0) {
                String string = InternalResource.loadString("rightDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "geometryspatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (object == null) {
                n2 = InternalToolkit.BufferSideType.RIGHT.value();
            } else if (object2 == null) {
                n2 = InternalToolkit.BufferSideType.LEFT.value();
            } else if (d2 == d3) {
                n2 = InternalToolkit.BufferSideType.FULL.value();
            } else if (d2 != d3) {
                n2 = InternalToolkit.BufferSideType.FULLDIFFR.value();
            }
            if (geometry.isEmpty()) {
                return new GeoRegion();
            }
            int n3 = BufferEndType.FLAT.value();
            int n4 = BufferRadiusUnit.Meter.value();
            if (bufferAnalystParameter.getRadiusUnit() != null) {
                n4 = bufferAnalystParameter.getRadiusUnit().value();
            }
            geoRegion = (l3 = BufferAnalystGeometryNative.jni_CreateLineBuffer(l, d2, d3, n, n2, n3, l2, n4)) != 0L ? (GeoRegion)InternalGeometry.createInstance(l3) : new GeoRegion();
        }
        if (bufferEndType.equals(BufferEndType.ROUND)) {
            long l4;
            if (geometryType != GeometryType.GEOPOINT && geometryType != GeometryType.GEOLINE && geometryType != GeometryType.GEOREGION) {
                String string = InternalResource.loadString("geometry", "BufferAnalyst_BufferGeometryTypeInvalid", "geometryspatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (object instanceof String) {
                String string = InternalResource.loadString("LeftDistance", "BufferAnalyst_DistenceOfStringTypeIsInvalidForGeometryBuffer", "geometryspatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            d2 = InternalToolkit.objectToDouble(object);
            if (object == null) {
                String string = InternalResource.loadString("objLeftDistance", "Global_ArgumentNull", "geometryspatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!geometryType.equals(GeometryType.GEOREGION) && d2 <= 0.0) {
                String string = InternalResource.loadString("", "BufferAnalyst_BufferDistanceShouldBePositive", "geometryspatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometryType.equals(GeometryType.GEOREGION) && Toolkit.isZero(d2)) {
                String string = InternalResource.loadString("", "BufferAnalyst_BufferDistanceShouldNotBeZero", "geometryspatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometryType.equals(GeometryType.GEOLINE)) {
                n2 = InternalToolkit.BufferSideType.FULL.value();
            }
            if (geometry.isEmpty()) {
                return new GeoRegion();
            }
            int n5 = BufferEndType.ROUND.value();
            int n6 = BufferRadiusUnit.Meter.value();
            if (bufferAnalystParameter.getRadiusUnit() != null) {
                n6 = bufferAnalystParameter.getRadiusUnit().value();
            }
            geoRegion = (l4 = BufferAnalystGeometryNative.jni_CreateGeometryBuffer(l, d2, n, n2, n5, l2, n6)) != 0L ? (GeoRegion)InternalGeometry.createInstance(l4) : new GeoRegion();
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(bufferAnalystParameter);
        return geoRegion;
    }
}

