/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.metadata.iso.quality.PositionalAccuracyImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;

public class AbstractCoordinateOperation
extends AbstractIdentifiedObject
implements CoordinateOperation {
    private static final long serialVersionUID = 1237358357729193885L;
    public static final PositionalAccuracy[] EMPTY_ACCURACY_ARRAY = new PositionalAccuracy[0];
    private static final String[] LOCALIZABLES = new String[]{"scope"};
    protected final CoordinateReferenceSystem sourceCRS;
    protected final CoordinateReferenceSystem targetCRS;
    final String operationVersion;
    private final Collection<PositionalAccuracy> coordinateOperationAccuracy;
    protected final Extent domainOfValidity;
    private final InternationalString scope;
    protected final MathTransform transform;

    AbstractCoordinateOperation(Conversion definition, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super((IdentifiedObject)definition);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.operationVersion = definition.getOperationVersion();
        this.coordinateOperationAccuracy = definition.getCoordinateOperationAccuracy();
        this.domainOfValidity = definition.getDomainOfValidity();
        this.scope = definition.getScope();
        this.transform = transform;
    }

    public AbstractCoordinateOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        this(properties, new HashMap<String, Object>(), sourceCRS, targetCRS, transform);
    }

    private AbstractCoordinateOperation(Map<String, ?> properties, Map<String, Object> subProperties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super(properties, subProperties, LOCALIZABLES);
        this.domainOfValidity = (Extent)subProperties.get("domainOfValidity");
        this.scope = (InternationalString)subProperties.get("scope");
        this.operationVersion = (String)subProperties.get("operationVersion");
        Object[] positionalAccuracy = (PositionalAccuracy[])subProperties.get("coordinateOperationAccuracy");
        if (positionalAccuracy == null || positionalAccuracy.length == 0) {
            positionalAccuracy = null;
        } else {
            positionalAccuracy = (PositionalAccuracy[])positionalAccuracy.clone();
            for (int i = 0; i < positionalAccuracy.length; ++i) {
                AbstractCoordinateOperation.ensureNonNull("coordinateOperationAccuracy", positionalAccuracy, i);
            }
        }
        this.coordinateOperationAccuracy = AbstractCoordinateOperation.asSet(positionalAccuracy);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.transform = transform;
        this.validate();
    }

    void validate() throws IllegalArgumentException {
        AbstractCoordinateOperation.ensureNonNull("sourceCRS", this.transform);
        AbstractCoordinateOperation.ensureNonNull("targetCRS", this.transform);
        AbstractCoordinateOperation.ensureNonNull("transform", this.transform);
        AbstractCoordinateOperation.checkDimension("sourceCRS", this.sourceCRS, this.transform.getSourceDimensions());
        AbstractCoordinateOperation.checkDimension("targetCRS", this.targetCRS, this.transform.getTargetDimensions());
    }

    private static void checkDimension(String name, CoordinateReferenceSystem crs, int expected) {
        int actual = crs.getCoordinateSystem().getDimension();
        if (actual != expected) {
            throw new IllegalArgumentException(Errors.format((int)94, (Object)name, (Object)actual, (Object)expected));
        }
    }

    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    public String getOperationVersion() {
        return this.operationVersion;
    }

    public Collection<PositionalAccuracy> getCoordinateOperationAccuracy() {
        if (this.coordinateOperationAccuracy == null) {
            return Collections.emptySet();
        }
        return this.coordinateOperationAccuracy;
    }

    public Collection<PositionalAccuracy> getPositionalAccuracy() {
        if (this.coordinateOperationAccuracy == null) {
            return Collections.emptySet();
        }
        return this.coordinateOperationAccuracy;
    }

    public double getAccuracy() {
        return AbstractCoordinateOperation.getAccuracy0(this);
    }

    public static double getAccuracy(CoordinateOperation operation) {
        if (operation instanceof AbstractCoordinateOperation) {
            return ((AbstractCoordinateOperation)operation).getAccuracy();
        }
        return AbstractCoordinateOperation.getAccuracy0(operation);
    }

    private static double getAccuracy0(CoordinateOperation operation) {
        Collection accuracies = operation.getCoordinateOperationAccuracy();
        if (accuracies != null) {
            for (PositionalAccuracy accuracy : accuracies) {
                if (accuracy == null) continue;
                for (Result result : accuracy.getResults()) {
                    Unit unit;
                    QuantitativeResult quantity;
                    Collection records;
                    if (!(result instanceof QuantitativeResult) || (records = (quantity = (QuantitativeResult)result).getValues()) == null || (unit = quantity.getValueUnit()) == null || !SI.METER.isCompatible(unit)) continue;
                    for (Record record : records) {
                        for (Object value : record.getAttributes().values()) {
                            if (!(value instanceof Number)) continue;
                            double v = ((Number)value).doubleValue();
                            v = unit.getConverterTo(SI.METER).convert(v);
                            return v;
                        }
                    }
                }
            }
        }
        if (operation instanceof Conversion) {
            return 0.0;
        }
        if (operation instanceof Transformation) {
            if (!accuracies.contains(PositionalAccuracyImpl.DATUM_SHIFT_OMITTED) && accuracies.contains(PositionalAccuracyImpl.DATUM_SHIFT_APPLIED)) {
                return 25.0;
            }
            return 1000.0;
        }
        double accuracy = Double.NaN;
        if (operation instanceof ConcatenatedOperation) {
            List components = ((ConcatenatedOperation)operation).getOperations();
            Iterator it = components.iterator();
            while (it.hasNext()) {
                double candidate = Math.abs(AbstractCoordinateOperation.getAccuracy((CoordinateOperation)it.next()));
                if (Double.isNaN(candidate)) continue;
                if (Double.isNaN(accuracy)) {
                    accuracy = candidate;
                    continue;
                }
                accuracy += candidate;
            }
        }
        return accuracy;
    }

    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    public Extent getValidArea() {
        return this.domainOfValidity;
    }

    public InternationalString getScope() {
        return this.scope;
    }

    public MathTransform getMathTransform() {
        return this.transform;
    }

    public static Class<? extends CoordinateOperation> getType(CoordinateOperation object) {
        if (object instanceof Transformation) {
            return Transformation.class;
        }
        if (object instanceof ConicProjection) {
            return ConicProjection.class;
        }
        if (object instanceof CylindricalProjection) {
            return CylindricalProjection.class;
        }
        if (object instanceof PlanarProjection) {
            return PlanarProjection.class;
        }
        if (object instanceof Projection) {
            return Projection.class;
        }
        if (object instanceof Conversion) {
            return Conversion.class;
        }
        if (object instanceof Operation) {
            return Operation.class;
        }
        return CoordinateOperation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            AbstractCoordinateOperation that = (AbstractCoordinateOperation)object;
            if (AbstractCoordinateOperation.equals((IdentifiedObject)this.sourceCRS, (IdentifiedObject)that.sourceCRS, compareMetadata) && Utilities.equals((Object)this.transform, (Object)that.transform)) {
                if (!(!compareMetadata || Utilities.equals((Object)this.domainOfValidity, (Object)that.domainOfValidity) && Utilities.equals((Object)this.scope, (Object)that.scope) && Utilities.equals(this.coordinateOperationAccuracy, that.coordinateOperationAccuracy))) {
                    return false;
                }
                Boolean comparing = AbstractDerivedCRS._COMPARING.get();
                if (comparing != null && comparing.booleanValue()) {
                    return true;
                }
                try {
                    AbstractDerivedCRS._COMPARING.set(Boolean.TRUE);
                    boolean bl = AbstractCoordinateOperation.equals((IdentifiedObject)this.targetCRS, (IdentifiedObject)that.targetCRS, compareMetadata);
                    return bl;
                }
                finally {
                    AbstractDerivedCRS._COMPARING.set(Boolean.FALSE);
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = -598790243;
        if (this.sourceCRS != null) {
            code ^= this.sourceCRS.hashCode();
        }
        if (this.targetCRS != null) {
            code ^= this.targetCRS.hashCode();
        }
        if (this.transform != null) {
            code ^= this.transform.hashCode();
        }
        return code;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        AbstractCoordinateOperation.append(formatter, (IdentifiedObject)this.sourceCRS, "SOURCE");
        AbstractCoordinateOperation.append(formatter, (IdentifiedObject)this.targetCRS, "TARGET");
        return super.formatWKT(formatter);
    }

    static void append(Formatter formatter, IdentifiedObject object, final String type) {
        if (object != null) {
            HashMap<String, String> properties = new HashMap<String, String>(4);
            properties.put("name", formatter.getName(object));
            properties.put("identifiers", (String)formatter.getIdentifier(object));
            formatter.append(new AbstractIdentifiedObject(properties){

                @Override
                protected String formatWKT(Formatter formatter) {
                    return type;
                }
            });
        }
    }
}

