/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.BasicStatisticsAnalystResult;
import com.supermap.analyst.spatialanalyst.FunctionType;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.GridHistogram;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsAnnulusParameter;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsCircleParameter;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsParameter;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsParameterNative;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsRectangleParameter;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsWedgeParameter;
import com.supermap.analyst.spatialanalyst.NeighbourUnitType;
import com.supermap.analyst.spatialanalyst.StatisticsAnalystNative;
import com.supermap.analyst.spatialanalyst.StatisticsCompareType;
import com.supermap.analyst.spatialanalyst.ZonalStatisticsAnalystParameter;
import com.supermap.analyst.spatialanalyst.ZonalStatisticsAnalystResult;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandle;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class StatisticsAnalyst {
    private static License a;
    private static transient Vector b;
    private static GridAnalystSetting c;

    private StatisticsAnalyst() {
    }

    private static GridAnalystSetting a() {
        return c;
    }

    private static void a(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            c = null;
            return;
        }
        if (c == null) {
            c = new GridAnalystSetting();
        }
        c.setBounds(gridAnalystSetting.getBounds());
        c.setBoundsType(gridAnalystSetting.getBoundsType());
        c.setCellSizeType(gridAnalystSetting.getCellSizeType());
        c.setCellSize(gridAnalystSetting.getCellSize());
        c.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        c.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        c.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        c.setValidRegion(gridAnalystSetting.getValidRegion());
        c.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static GridHistogram createHistogram(DatasetGrid statisticsGrid, int groupCount) {
        GridHistogram gridHistogram = StatisticsAnalyst.createHistogram(statisticsGrid, groupCount, new SteppedListener[]{null});
        return gridHistogram;
    }

    public static GridHistogram createHistogram(DatasetGrid statisticsGrid, int groupCount, SteppedListener ... listeners) {
        GridHistogram gridHistogram = StatisticsAnalyst.createHistogram(statisticsGrid, groupCount, FunctionType.NONE, listeners);
        return gridHistogram;
    }

    public static GridHistogram createHistogram(DatasetGrid statisticsGrid, int groupCount, FunctionType functionType) {
        return StatisticsAnalyst.createHistogram(statisticsGrid, groupCount, functionType, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridHistogram createHistogram(DatasetGrid statisticsGrid, int groupCount, FunctionType functionType, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            StatisticsAnalyst.b();
            if (statisticsGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (groupCount <= 0) {
                String string = InternalResourceSpatialanalyst.loadString("groupCount", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (functionType == FunctionType.LOG && statisticsGrid.getMinValue() <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (functionType == FunctionType.ARCSIN && (statisticsGrid.getMinValue() < -1.0 || statisticsGrid.getMaxValue() > 1.0)) {
                String string = InternalResourceSpatialanalyst.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsGrid);
            long l2 = StatisticsAnalystNative.jni_CreateHistogram(l, groupCount, InternalEnum.getUGCValue(functionType));
            GridHistogram gridHistogram = null;
            if (0L != l2) {
                gridHistogram = new GridHistogram(l2);
            }
            GridHistogram gridHistogram2 = gridHistogram;
            return gridHistogram2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static GridHistogram createImageHistogram(DatasetImage statisticsImage, int groupCount, FunctionType functionType, int bandIndex) {
        return StatisticsAnalyst.createImageHistogram(statisticsImage, groupCount, functionType, bandIndex, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridHistogram createImageHistogram(DatasetImage statisticsImage, int groupCount, FunctionType functionType, int bandIndex, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (statisticsImage == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsImage) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (groupCount <= 0) {
                String string = InternalResourceSpatialanalyst.loadString("groupCount", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            int n = statisticsImage.getBandCount();
            if (bandIndex >= n || bandIndex < 0) {
                String string = InternalResourceSpatialanalyst.loadString("bandIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (functionType == FunctionType.LOG && statisticsImage.getMinValue(bandIndex) <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (functionType == FunctionType.ARCSIN && (statisticsImage.getMinValue(bandIndex) < -1.0 || statisticsImage.getMaxValue(bandIndex) > 1.0)) {
                String string = InternalResourceSpatialanalyst.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsImage);
            long l2 = StatisticsAnalystNative.jni_CreateImageHistogram(l, groupCount, InternalEnum.getUGCValue(functionType), bandIndex);
            GridHistogram gridHistogram = null;
            if (0L != l2) {
                gridHistogram = new GridHistogram(l2);
            }
            GridHistogram gridHistogram2 = gridHistogram;
            return gridHistogram2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static GridHistogram[] createImageHistogram(DatasetImage statisticsImage, int groupCount, FunctionType functionType) {
        return StatisticsAnalyst.createImageHistogram(statisticsImage, groupCount, functionType, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridHistogram[] createImageHistogram(DatasetImage statisticsImage, int groupCount, FunctionType functionType, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (statisticsImage == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsImage) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (groupCount <= 0) {
                String string = InternalResourceSpatialanalyst.loadString("groupCount", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsImage);
            int n = statisticsImage.getBandCount();
            GridHistogram[] gridHistogramArray = new GridHistogram[n];
            for (int i = 0; i < n; ++i) {
                if (functionType == FunctionType.LOG && statisticsImage.getMinValue(i) <= 0.0) {
                    String string = InternalResourceSpatialanalyst.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (functionType == FunctionType.ARCSIN && (statisticsImage.getMinValue(i) < -1.0 || statisticsImage.getMaxValue(i) > 1.0)) {
                    String string = InternalResourceSpatialanalyst.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                long l2 = StatisticsAnalystNative.jni_CreateImageHistogram(l, groupCount, InternalEnum.getUGCValue(functionType), i);
                GridHistogram gridHistogram = null;
                if (0L != l2) {
                    gridHistogram = new GridHistogram(l2);
                }
                gridHistogramArray[i] = gridHistogram;
            }
            GridHistogram[] gridHistogramArray2 = gridHistogramArray;
            return gridHistogramArray2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static BasicStatisticsAnalystResult basicStatistics(DatasetGrid statisticsGrid) {
        BasicStatisticsAnalystResult basicStatisticsAnalystResult = StatisticsAnalyst.basicStatistics(statisticsGrid, new SteppedListener[]{null});
        return basicStatisticsAnalystResult;
    }

    public static BasicStatisticsAnalystResult basicStatistics(DatasetGrid statisticsGrid, SteppedListener ... listeners) {
        BasicStatisticsAnalystResult basicStatisticsAnalystResult = StatisticsAnalyst.basicStatistics(statisticsGrid, FunctionType.NONE, listeners);
        return basicStatisticsAnalystResult;
    }

    public static BasicStatisticsAnalystResult basicStatistics(DatasetGrid statisticsGrid, FunctionType functionType) {
        return StatisticsAnalyst.basicStatistics(statisticsGrid, functionType, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasicStatisticsAnalystResult basicStatistics(DatasetGrid statisticsGrid, FunctionType functionType, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            StatisticsAnalyst.b();
            if (statisticsGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (functionType == FunctionType.LOG && statisticsGrid.getMinValue() <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (functionType == FunctionType.ARCSIN && (statisticsGrid.getMinValue() < -1.0 || statisticsGrid.getMaxValue() > 1.0)) {
                String string = InternalResourceSpatialanalyst.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsGrid);
            double[] dArray = StatisticsAnalystNative.jni_BasicStatistics(l, InternalEnum.getUGCValue(functionType));
            BasicStatisticsAnalystResult basicStatisticsAnalystResult = null;
            if (null != dArray && dArray.length > 0) {
                basicStatisticsAnalystResult = new BasicStatisticsAnalystResult(dArray);
            }
            BasicStatisticsAnalystResult basicStatisticsAnalystResult2 = basicStatisticsAnalystResult;
            return basicStatisticsAnalystResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static BasicStatisticsAnalystResult imageBasicStatistics(DatasetImage statisticsImage, FunctionType functionType, int bandIndex) {
        return StatisticsAnalyst.imageBasicStatistics(statisticsImage, functionType, bandIndex, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasicStatisticsAnalystResult imageBasicStatistics(DatasetImage statisticsImage, FunctionType functionType, int bandIndex, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            StatisticsAnalyst.b();
            if (statisticsImage == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsImage) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("statisticsImage", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            int n = statisticsImage.getBandCount();
            if (bandIndex >= n || bandIndex < 0) {
                String string = InternalResourceSpatialanalyst.loadString("bandIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (functionType == FunctionType.LOG && statisticsImage.getMinValue(bandIndex) <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (functionType == FunctionType.ARCSIN && (statisticsImage.getMinValue(bandIndex) < -1.0 || statisticsImage.getMaxValue(bandIndex) > 1.0)) {
                String string = InternalResourceSpatialanalyst.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsImage);
            double[] dArray = StatisticsAnalystNative.jni_ImageBasicStatistics(l, InternalEnum.getUGCValue(functionType), bandIndex);
            BasicStatisticsAnalystResult basicStatisticsAnalystResult = null;
            if (null != dArray && dArray.length > 0) {
                basicStatisticsAnalystResult = new BasicStatisticsAnalystResult(dArray);
            }
            BasicStatisticsAnalystResult basicStatisticsAnalystResult2 = basicStatisticsAnalystResult;
            return basicStatisticsAnalystResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasicStatisticsAnalystResult[] imageBasicStatistics(DatasetImage statisticsImage, FunctionType functionType, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            StatisticsAnalyst.b();
            if (statisticsImage == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsImage) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("statisticsImage", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            int n = statisticsImage.getBandCount();
            for (int i = 0; i < n; ++i) {
                if (functionType == FunctionType.LOG && statisticsImage.getMinValue(i) <= 0.0) {
                    String string = InternalResourceSpatialanalyst.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (functionType != FunctionType.ARCSIN || !(statisticsImage.getMinValue(i) < -1.0) && !(statisticsImage.getMaxValue(i) > 1.0)) continue;
                String string = InternalResourceSpatialanalyst.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            BasicStatisticsAnalystResult[] basicStatisticsAnalystResultArray = new BasicStatisticsAnalystResult[n];
            for (int i = 0; i < n; ++i) {
                long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsImage);
                double[] dArray = StatisticsAnalystNative.jni_ImageBasicStatistics(l, InternalEnum.getUGCValue(functionType), i);
                BasicStatisticsAnalystResult basicStatisticsAnalystResult = null;
                if (null != dArray && dArray.length > 0) {
                    basicStatisticsAnalystResult = new BasicStatisticsAnalystResult(dArray);
                }
                basicStatisticsAnalystResultArray[i] = basicStatisticsAnalystResult;
            }
            BasicStatisticsAnalystResult[] basicStatisticsAnalystResultArray2 = basicStatisticsAnalystResultArray;
            return basicStatisticsAnalystResultArray2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid commonStatistics(DatasetGrid statisticsGrid, double comparedValue, StatisticsCompareType type, boolean isIgnoreNoValue, Datasource targetDatasource, String targetDatasetName) {
        return StatisticsAnalyst.commonStatistics(statisticsGrid, comparedValue, type, isIgnoreNoValue, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid commonStatistics(DatasetGrid statisticsGrid, double comparedValue, StatisticsCompareType type, boolean isIgnoreNoValue, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            StatisticsAnalyst.b();
            Datasource datasource = targetDatasource;
            String string = targetDatasetName;
            if (statisticsGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsGrid) == 0L) {
                String string2 = InternalResourceSpatialanalyst.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                if (c == null || c.getOutputDatasource() == null) {
                    String string3 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new NullPointerException(string3);
                }
                datasource = c.getOutputDatasource();
            }
            if (string == null) {
                String string4 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string4);
            }
            if (c != null && c.getVectorOutputNamePrefix() != null) {
                string = c.getVectorOutputNamePrefix() + string;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string)) {
                String string5 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            long l3 = 0L;
            l3 = StatisticsAnalystNative.jni_CommonStatistics(l, comparedValue, InternalEnum.getUGCValue(type), isIgnoreNoValue, l2, string);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid commonStatistics(DatasetGrid statisticsGrid, DatasetGrid[] compareDatasets, StatisticsCompareType compareType, boolean isIgnoreNoValue, Datasource targetDatasource, String targetDatasetName) {
        return StatisticsAnalyst.commonStatistics(statisticsGrid, compareDatasets, compareType, isIgnoreNoValue, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid commonStatistics(DatasetGrid statisticsGrid, DatasetGrid[] compareDatasets, StatisticsCompareType compareType, boolean isIgnoreNoValue, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            StatisticsAnalyst.b();
            Datasource datasource = targetDatasource;
            String string = targetDatasetName;
            if (statisticsGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsGrid) == 0L) {
                String string2 = InternalResourceSpatialanalyst.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                if (c == null || c.getOutputDatasource() == null) {
                    String string3 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new NullPointerException(string3);
                }
                datasource = c.getOutputDatasource();
            }
            if (string == null) {
                String string4 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string4);
            }
            if (c != null && c.getGridOutputNamePrefix() != null) {
                string = c.getGridOutputNamePrefix() + string;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string)) {
                String string5 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            long[] lArray = new long[compareDatasets.length];
            for (int i = 0; i < compareDatasets.length; ++i) {
                long l;
                lArray[i] = l = InternalHandleSpatialanalyst.getHandle((InternalHandle)compareDatasets[i]);
                if (l != 0L) continue;
                String string6 = InternalResourceSpatialanalyst.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)statisticsGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            long l3 = 0L;
            l3 = StatisticsAnalystNative.jni_CommonStatistics2(l, lArray, InternalEnum.getUGCValue(compareType), isIgnoreNoValue, l2, string);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    private static long a(NeighbourStatisticsParameter neighbourStatisticsParameter) {
        long l = NeighbourStatisticsParameterNative.jni_New();
        int n = InternalEnum.getUGCValue(neighbourStatisticsParameter.getUnitType());
        NeighbourStatisticsParameterNative.jni_SetUnitType(l, n);
        int n2 = InternalEnum.getUGCValue(neighbourStatisticsParameter.getShapeType());
        NeighbourStatisticsParameterNative.jni_SetShapeType(l, n2);
        int n3 = neighbourStatisticsParameter.getSourceDataset().getHeight();
        int n4 = neighbourStatisticsParameter.getSourceDataset().getWidth();
        double d = Math.min(neighbourStatisticsParameter.getSourceDataset().getBounds().getHeight(), neighbourStatisticsParameter.getSourceDataset().getBounds().getWidth()) / 2.0;
        int n5 = Math.min(n3, n4) / 2;
        double d2 = Math.max(neighbourStatisticsParameter.getSourceDataset().getBounds().getHeight() / (double)n3, neighbourStatisticsParameter.getSourceDataset().getBounds().getWidth() / (double)n3);
        switch (n2) {
            case 1: {
                NeighbourStatisticsRectangleParameter neighbourStatisticsRectangleParameter = (NeighbourStatisticsRectangleParameter)neighbourStatisticsParameter;
                if (neighbourStatisticsRectangleParameter.getUnitType() == NeighbourUnitType.CELL) {
                    if (neighbourStatisticsRectangleParameter.getHeight() < 1.0 || neighbourStatisticsRectangleParameter.getWidth() < 1.0) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooSmall", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                    if (neighbourStatisticsRectangleParameter.getHeight() > (double)n3 && neighbourStatisticsRectangleParameter.getWidth() > (double)n4) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                } else {
                    if (neighbourStatisticsRectangleParameter.getHeight() < d2 || neighbourStatisticsRectangleParameter.getWidth() < d2) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooSmall", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                    if (neighbourStatisticsRectangleParameter.getHeight() > neighbourStatisticsParameter.getSourceDataset().getBounds().getHeight() && neighbourStatisticsRectangleParameter.getWidth() > neighbourStatisticsParameter.getSourceDataset().getBounds().getWidth()) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                }
                NeighbourStatisticsParameterNative.jni_SetWidthHeight(l, neighbourStatisticsRectangleParameter.getWidth(), neighbourStatisticsRectangleParameter.getHeight());
                break;
            }
            case 2: {
                NeighbourStatisticsCircleParameter neighbourStatisticsCircleParameter = (NeighbourStatisticsCircleParameter)neighbourStatisticsParameter;
                if (neighbourStatisticsCircleParameter.getUnitType() == NeighbourUnitType.CELL) {
                    if (neighbourStatisticsCircleParameter.getRadius() < 1.0) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooSmall", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                    if (neighbourStatisticsCircleParameter.getRadius() > (double)n5) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                } else {
                    if (neighbourStatisticsCircleParameter.getRadius() < d2) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooSmall", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                    if (neighbourStatisticsCircleParameter.getRadius() > d) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                }
                NeighbourStatisticsParameterNative.jni_SetRadius(l, neighbourStatisticsCircleParameter.getRadius());
                break;
            }
            case 3: {
                NeighbourStatisticsAnnulusParameter neighbourStatisticsAnnulusParameter = (NeighbourStatisticsAnnulusParameter)neighbourStatisticsParameter;
                if (neighbourStatisticsAnnulusParameter.getUnitType() == NeighbourUnitType.CELL) {
                    if (neighbourStatisticsAnnulusParameter.getInnerRadius() < 1.0) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooSmall", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                    if (neighbourStatisticsAnnulusParameter.getInnerRadius() > (double)n5 || neighbourStatisticsAnnulusParameter.getOuterRadius() > (double)n5) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                } else {
                    if (neighbourStatisticsAnnulusParameter.getInnerRadius() < d2) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooSmall", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                    if (neighbourStatisticsAnnulusParameter.getInnerRadius() > d || neighbourStatisticsAnnulusParameter.getOuterRadius() > d) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                }
                NeighbourStatisticsParameterNative.jni_SetAnnulusRadius(l, neighbourStatisticsAnnulusParameter.getInnerRadius(), neighbourStatisticsAnnulusParameter.getOuterRadius());
                break;
            }
            case 4: {
                NeighbourStatisticsWedgeParameter neighbourStatisticsWedgeParameter = (NeighbourStatisticsWedgeParameter)neighbourStatisticsParameter;
                if (neighbourStatisticsWedgeParameter.getUnitType() == NeighbourUnitType.CELL) {
                    if (neighbourStatisticsWedgeParameter.getRadius() < 1.0) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooSmall", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                    if (neighbourStatisticsWedgeParameter.getRadius() > (double)n5) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                } else {
                    if (neighbourStatisticsWedgeParameter.getRadius() < d2) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooSmall", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                    if (neighbourStatisticsWedgeParameter.getRadius() > d) {
                        String string = InternalResourceSpatialanalyst.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                }
                NeighbourStatisticsParameterNative.jni_SetRadius(l, neighbourStatisticsWedgeParameter.getRadius());
                NeighbourStatisticsParameterNative.jni_SetWedgeAngle(l, neighbourStatisticsWedgeParameter.getStartAngle(), neighbourStatisticsWedgeParameter.getEndAngle());
                break;
            }
        }
        return l;
    }

    public static DatasetGrid neighbourStatistics(NeighbourStatisticsParameter parameter) {
        return StatisticsAnalyst.neighbourStatistics(parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid neighbourStatistics(NeighbourStatisticsParameter parameter, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            StatisticsAnalyst.b();
            if (parameter == null) {
                String string = InternalResourceSpatialanalyst.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            Datasource datasource = parameter.getTargetDatasource();
            String string = parameter.getTargetDatasetName();
            if (parameter.getSourceDataset() == null) {
                String string2 = InternalResourceSpatialanalyst.loadString("SourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            if (parameter.getTargetDatasource() == null) {
                if (c == null || c.getOutputDatasource() == null) {
                    String string3 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new NullPointerException(string3);
                }
                datasource = c.getOutputDatasource();
            }
            if (string == null) {
                String string4 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string4);
            }
            if (c != null && c.getGridOutputNamePrefix() != null) {
                string = c.getGridOutputNamePrefix() + string;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string)) {
                String string5 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            long l = StatisticsAnalyst.a(parameter);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getSourceDataset());
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            int n = InternalEnum.getUGCValue(parameter.getStatisticsMode());
            long l4 = StatisticsAnalystNative.jni_NeighbourStatistics(l2, l, n, parameter.isIgnoreNoValue(), l3, string);
            NeighbourStatisticsParameterNative.jni_Dispose(l);
            DatasetGrid datasetGrid = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid blockStatistics(NeighbourStatisticsParameter parameter) {
        return StatisticsAnalyst.blockStatistics(parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid blockStatistics(NeighbourStatisticsParameter parameter, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            StatisticsAnalyst.b();
            if (parameter == null) {
                String string = InternalResourceSpatialanalyst.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            Datasource datasource = parameter.getTargetDatasource();
            String string = parameter.getTargetDatasetName();
            if (parameter.getSourceDataset() == null) {
                String string2 = InternalResourceSpatialanalyst.loadString("SourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            if (parameter.getTargetDatasource() == null) {
                if (c == null || c.getOutputDatasource() == null) {
                    String string3 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new NullPointerException(string3);
                }
                datasource = c.getOutputDatasource();
            }
            if (string == null) {
                String string4 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string4);
            }
            if (c != null && c.getGridOutputNamePrefix() != null) {
                string = c.getGridOutputNamePrefix() + string;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string)) {
                String string5 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            long l = StatisticsAnalyst.a(parameter);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getSourceDataset());
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            int n = InternalEnum.getUGCValue(parameter.getStatisticsMode());
            long l4 = 0L;
            l4 = StatisticsAnalystNative.jni_BlockStatistics(l2, l, n, parameter.isIgnoreNoValue(), l3, string);
            NeighbourStatisticsParameterNative.jni_Dispose(l);
            DatasetGrid datasetGrid = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static ZonalStatisticsAnalystResult zonalStatisticsOnRasterValue(ZonalStatisticsAnalystParameter parameter) {
        return StatisticsAnalyst.zonalStatisticsOnRasterValue(parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZonalStatisticsAnalystResult zonalStatisticsOnRasterValue(ZonalStatisticsAnalystParameter parameter, SteppedListener ... listeners) {
        try {
            DatasetGrid datasetGrid;
            String string;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            StatisticsAnalyst.b();
            if (parameter == null) {
                String string2 = InternalResourceSpatialanalyst.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            Datasource datasource = parameter.getTargetDatasource();
            if (parameter.getTargetDatasource() == null) {
                if (c == null || c.getOutputDatasource() == null) {
                    String string3 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new NullPointerException(string3);
                }
                datasource = c.getOutputDatasource();
            }
            if ((string = parameter.getTargetDatasetName()) == null) {
                String string4 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string4);
            }
            if (c != null && c.getGridOutputNamePrefix() != null) {
                string = c.getGridOutputNamePrefix() + string;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string)) {
                String string5 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getZonalDataset());
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getValueDataset());
            int n = InternalEnum.getUGCValue(parameter.getStatisticsMode());
            long[] lArray = StatisticsAnalystNative.jni_ZonalStatisticsOnRasterValue(l2, parameter.getZonalFieldName(), l3, n, l, string, l, parameter.getTargetTableName(), parameter.isIgnoreNoValue());
            Object object = null;
            if (null != lArray && lArray.length == 2) {
                datasetGrid = InternalDatasetGrid.createInstance(lArray[0], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
                DatasetVector datasetVector = null;
                datasetVector = InternalDatasetVector.createInstance(lArray[1], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
                object = new ZonalStatisticsAnalystResult(datasetGrid, datasetVector);
            }
            datasetGrid = object;
            return datasetGrid;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    private static boolean a(ZonalStatisticsAnalystParameter zonalStatisticsAnalystParameter) {
        StatisticsAnalyst.b();
        if (zonalStatisticsAnalystParameter == null) {
            String string = InternalResourceSpatialanalyst.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (zonalStatisticsAnalystParameter.getTargetDatasource() == null) {
            String string = InternalResourceSpatialanalyst.loadString("TargetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!zonalStatisticsAnalystParameter.getTargetDatasource().getDatasets().isAvailableDatasetName(zonalStatisticsAnalystParameter.getTargetDatasetName())) {
            String string = InternalResourceSpatialanalyst.loadString("TargetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)zonalStatisticsAnalystParameter.getZonalDataset());
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)zonalStatisticsAnalystParameter.getValueDataset());
        int n = InternalEnum.getUGCValue((Enum)zonalStatisticsAnalystParameter.getPixelFormat());
        int n2 = InternalEnum.getUGCValue(zonalStatisticsAnalystParameter.getStatisticsMode());
        return StatisticsAnalystNative.jni_ZonalStatisticVectorOnVector(l, zonalStatisticsAnalystParameter.getZonalFieldName(), null, l2, null, 0.0, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b() {
        int n = -1;
        Object object = a;
        synchronized (object) {
            n = a.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (b == null) {
            b = new Vector();
        }
        if (!b.contains(l)) {
            b.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (b != null && b.contains(l)) {
            b.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (b != null) {
            Vector vector = b;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "StatisticsAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)b, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        a = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

